/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.quick.invoke.inline;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.nodes.quick.invoke.InvokeQuickNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.InvokeSpecialQuickNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.InvokeStaticQuickNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.InvokeVirtualQuickNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.inline.GuardedInlinedMethodNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.inline.InlinedMethodNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.inline.InlinedMethodPredicate;

public class ConditionalInlinedMethodNode
extends InlinedMethodNode {
    private final Recipes recipes;
    @Node.Child
    protected InvokeQuickNode fallbackNode;
    private final InlinedMethodPredicate condition;

    public ConditionalInlinedMethodNode(Method.MethodVersion inlinedMethod, int top, int opcode, int callerBCI, int statementIndex, Recipes recipes, InlinedMethodPredicate condition) {
        super(inlinedMethod, top, opcode, callerBCI, statementIndex, null);
        this.fallbackNode = ConditionalInlinedMethodNode.getFallback(inlinedMethod.getMethod(), top, callerBCI, opcode);
        this.condition = condition;
        this.recipes = recipes;
    }

    @Override
    public final int execute(VirtualFrame frame, boolean isContinuationResume) {
        this.preludeChecks(frame);
        if (this.condition.isValid(this.getContext(), this.method, frame, this)) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            InlinedMethodNode replacement = ConditionalInlinedMethodNode.getDefinitiveNode(this.recipes, this.inlinedMethod(), this.top, this.opcode, this.getCallerBCI(), this.statementIndex);
            return this.getBytecodeNode().replaceQuickAt(frame, this.opcode, this.getCallerBCI(), this, replacement);
        }
        return this.fallbackNode.execute(frame, false);
    }

    public static InlinedMethodNode getDefinitiveNode(Recipes recipes, Method.MethodVersion inlinedMethod, int top, int opcode, int callerBci, int statementIndex) {
        InlinedMethodNode.BodyNode newBody = recipes.cookBody();
        InlinedMethodPredicate guard = recipes.cookGuard();
        InlinedMethodNode replacement = guard == null ? new InlinedMethodNode(inlinedMethod, top, opcode, callerBci, statementIndex, newBody) : new GuardedInlinedMethodNode(inlinedMethod, top, opcode, callerBci, statementIndex, newBody, guard);
        return replacement;
    }

    static InvokeQuickNode getFallback(Method inlinedMethod, int top, int callerBCI, int opcode) {
        switch (opcode) {
            case 184: {
                return new InvokeStaticQuickNode(inlinedMethod, top, callerBCI);
            }
            case 183: {
                return new InvokeSpecialQuickNode(inlinedMethod, top, callerBCI);
            }
            case 182: {
                return new InvokeVirtualQuickNode(inlinedMethod, top, callerBCI);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw EspressoError.unimplemented("Conditional bytecode-level inlining only available for invokestatic, invokespecial and invokevirtual");
    }

    public static interface Recipes {
        public InlinedMethodNode.BodyNode cookBody();

        public InlinedMethodPredicate cookGuard();
    }
}

