/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.quick.invoke.inline.bodies;

import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.nodes.EspressoFrame;
import com.oracle.truffle.espresso.nodes.helper.AbstractSetFieldNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.inline.InlinedFrameAccess;
import com.oracle.truffle.espresso.nodes.quick.invoke.inline.bodies.InlinedFieldAccessNode;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

class InlinedSetterNode
extends InlinedFieldAccessNode {
    @Node.Child
    AbstractSetFieldNode setFieldNode;
    private final int slotCount;

    InlinedSetterNode(Method.MethodVersion method, char fieldCpi) {
        super(method, fieldCpi);
        this.setFieldNode = (AbstractSetFieldNode)this.insert(AbstractSetFieldNode.create(this.field));
        this.slotCount = this.field.getKind().getSlotCount();
    }

    @Override
    public void execute(VirtualFrame frame, InlinedFrameAccess frameAccess) {
        assert (!this.field.needsReResolution());
        StaticObject receiver = InlinedSetterNode.getReceiver(frame, this.field, frameAccess.top(), this.slotCount);
        this.setFieldNode.setField(frame, frameAccess.getBytecodeNode(), receiver, frameAccess.top(), frameAccess.statementIndex());
    }

    private static StaticObject getReceiver(VirtualFrame frame, Field field, int top, int slotCount) {
        return field.isStatic() ? field.getDeclaringKlass().tryInitializeAndGetStatics() : EspressoFrame.popObject((Frame)frame, top - 1 - slotCount);
    }
}

