/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.redefinition;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.espresso.bytecode.BytecodeStream;
import com.oracle.truffle.espresso.bytecode.Bytecodes;
import com.oracle.truffle.espresso.classfile.ClassfileParser;
import com.oracle.truffle.espresso.classfile.ClassfileStream;
import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.classfile.attributes.CodeAttribute;
import com.oracle.truffle.espresso.classfile.attributes.LineNumberTableAttribute;
import com.oracle.truffle.espresso.classfile.attributes.Local;
import com.oracle.truffle.espresso.classfile.attributes.LocalVariableTable;
import com.oracle.truffle.espresso.classfile.constantpool.PoolConstant;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.descriptors.Types;
import com.oracle.truffle.espresso.impl.ClassRegistry;
import com.oracle.truffle.espresso.impl.EspressoClassLoadingException;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.impl.ParserField;
import com.oracle.truffle.espresso.impl.ParserKlass;
import com.oracle.truffle.espresso.impl.ParserMethod;
import com.oracle.truffle.espresso.impl.RedefineAddedField;
import com.oracle.truffle.espresso.jdwp.api.Ids;
import com.oracle.truffle.espresso.jdwp.api.RedefineInfo;
import com.oracle.truffle.espresso.jdwp.impl.DebuggerController;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.redefinition.ChangePacket;
import com.oracle.truffle.espresso.redefinition.ClassInfo;
import com.oracle.truffle.espresso.redefinition.DetectedChange;
import com.oracle.truffle.espresso.redefinition.HotSwapClassInfo;
import com.oracle.truffle.espresso.redefinition.InnerClassRedefiner;
import com.oracle.truffle.espresso.redefinition.RedefinitionNotSupportedException;
import com.oracle.truffle.espresso.redefinition.plugins.impl.RedefineListener;
import com.oracle.truffle.espresso.runtime.Attribute;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.vm.InterpreterToVM;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;

public final class ClassRedefinition {
    private final Object redefineLock = new Object();
    private volatile boolean locked = false;
    private Thread redefineThread = null;
    private final EspressoContext context;
    private final Ids<Object> ids;
    private final DebuggerController controller;
    private final RedefineListener redefineListener;
    private volatile Assumption missingFieldAssumption = Truffle.getRuntime().createAssumption();
    private ArrayList<Field> currentDelegationFields;
    private AtomicInteger nextAvailableFieldSlot = new AtomicInteger(-1);

    public Assumption getMissingFieldAssumption() {
        return this.missingFieldAssumption;
    }

    public void invalidateMissingFields() {
        this.missingFieldAssumption.invalidate();
        this.missingFieldAssumption = Truffle.getRuntime().createAssumption();
    }

    public ClassRedefinition(EspressoContext context, Ids<Object> ids, RedefineListener listener, DebuggerController controller) {
        this.context = context;
        this.ids = ids;
        this.redefineListener = listener;
        this.controller = controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin() {
        Object object = this.redefineLock;
        synchronized (object) {
            while (this.locked) {
                try {
                    this.redefineLock.wait();
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
            }
            this.redefineThread = Thread.currentThread();
            this.locked = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end() {
        Object object = this.redefineLock;
        synchronized (object) {
            this.locked = false;
            this.redefineThread = null;
            this.redefineLock.notifyAll();
        }
    }

    public boolean isRedefineThread() {
        return this.redefineThread == Thread.currentThread();
    }

    public void addExtraReloadClasses(List<RedefineInfo> redefineInfos, List<RedefineInfo> additional) {
        this.redefineListener.collectExtraClassesToReload(redefineInfos, additional);
    }

    public void runPostRedefinitionListeners(ObjectKlass[] changedKlasses) {
        this.redefineListener.postRedefinition(changedKlasses, this.controller);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check() {
        CompilerAsserts.neverPartOfCompilation();
        if (this.locked) {
            if (this.redefineThread == Thread.currentThread()) {
                return;
            }
            Object object = this.redefineLock;
            synchronized (object) {
                while (this.locked) {
                    try {
                        this.redefineLock.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                    }
                }
            }
        }
    }

    public synchronized Field createDelegationFrom(Field field) {
        Field delegationField = RedefineAddedField.createDelegationField(field);
        if (this.currentDelegationFields == null) {
            this.currentDelegationFields = new ArrayList(1);
        }
        this.currentDelegationFields.add(delegationField);
        return delegationField;
    }

    public synchronized void clearDelegationFields() {
        if (this.currentDelegationFields != null) {
            for (Field field : this.currentDelegationFields) {
                field.removeByRedefinition();
            }
            this.currentDelegationFields.clear();
        }
    }

    public List<ChangePacket> detectClassChanges(HotSwapClassInfo[] classInfos) throws RedefinitionNotSupportedException {
        ArrayList<ChangePacket> result = new ArrayList<ChangePacket>(classInfos.length);
        EconomicMap temp = EconomicMap.create((int)1);
        EconomicSet superClassChanges = EconomicSet.create((int)1);
        for (HotSwapClassInfo hotSwapInfo : classInfos) {
            ClassChange classChange;
            ObjectKlass klass = hotSwapInfo.getKlass();
            if (klass == null) {
                result.add(new ChangePacket(hotSwapInfo, ClassChange.NEW_CLASS));
                continue;
            }
            byte[] bytes = hotSwapInfo.getBytes();
            ParserKlass newParserKlass = null;
            DetectedChange detectedChange = new DetectedChange();
            StaticObject loader = klass.getDefiningClassLoader();
            Types types = klass.getContext().getTypes();
            ParserKlass parserKlass = ClassfileParser.parse(this.context.getClassLoadingEnv(), new ClassfileStream(bytes, null), loader, types.fromName(hotSwapInfo.getName()));
            if (hotSwapInfo.isPatched()) {
                byte[] patched = hotSwapInfo.getPatchedBytes();
                newParserKlass = parserKlass;
                parserKlass = ClassfileParser.parse(this.context.getClassLoadingEnv(), new ClassfileStream(patched, null), loader, types.fromName(hotSwapInfo.getNewName()));
            }
            if ((classChange = ClassRedefinition.detectClassChanges(parserKlass, klass, detectedChange, newParserKlass)) == ClassChange.CLASS_HIERARCHY_CHANGED && detectedChange.getSuperKlass() != null) {
                ObjectKlass superKlass;
                ObjectKlass oldSuperKlass = klass.getSuperKlass();
                ObjectKlass commonSuperKlass = (ObjectKlass)oldSuperKlass.findLeastCommonAncestor(superKlass);
                for (superKlass = detectedChange.getSuperKlass(); superKlass != commonSuperKlass; superKlass = superKlass.getSuperKlass()) {
                    superClassChanges.add((Object)superKlass);
                }
            }
            ChangePacket packet = new ChangePacket(hotSwapInfo, newParserKlass != null ? newParserKlass : parserKlass, classChange, detectedChange);
            result.add(packet);
            temp.put((Object)klass, (Object)packet);
        }
        for (ObjectKlass superKlass : superClassChanges) {
            ChangePacket packet = (ChangePacket)temp.get((Object)superKlass);
            if (packet != null) {
                packet.detectedChange.markChangedSuperClass();
                continue;
            }
            DetectedChange change = new DetectedChange();
            change.markChangedSuperClass();
            packet = new ChangePacket(HotSwapClassInfo.createForSuperClassChanged(superKlass), null, ClassChange.CLASS_HIERARCHY_CHANGED, change);
            result.add(packet);
        }
        return result;
    }

    public int redefineClass(ChangePacket packet, List<ObjectKlass> invalidatedClasses, List<ObjectKlass> redefinedClasses) {
        try {
            switch (packet.classChange.ordinal()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    this.doRedefineClass(packet, invalidatedClasses, redefinedClasses);
                    return 0;
                }
                case 8: {
                    this.context.markChangedHierarchy();
                    this.doRedefineClass(packet, invalidatedClasses, redefinedClasses);
                    return 0;
                }
                case 6: {
                    HotSwapClassInfo classInfo = packet.info;
                    Symbol<Symbol.Type> type = this.context.getTypes().fromName(((ClassInfo)classInfo).getName());
                    ClassRegistry classRegistry = this.context.getRegistries().getClassRegistry(((ClassInfo)classInfo).getClassLoader());
                    Klass loadedKlass = classRegistry.findLoadedKlass(this.context.getClassLoadingEnv(), type);
                    if (loadedKlass != null) {
                        classRegistry.onInnerClassRemoved(type);
                        ObjectKlass newKlass = classRegistry.defineKlass(this.context, type, ((ClassInfo)classInfo).getBytes());
                        assert (newKlass != loadedKlass && newKlass == classRegistry.findLoadedKlass(this.context.getClassLoadingEnv(), type));
                        packet.info.setKlass(newKlass);
                    } else if (classInfo.isNewInnerTestKlass()) {
                        classRegistry.defineKlass(this.context, type, ((ClassInfo)classInfo).getBytes());
                    }
                    return 0;
                }
            }
            return 0;
        }
        catch (EspressoException ex) {
            return 60;
        }
        catch (EspressoClassLoadingException e) {
            throw e.asGuestException(this.context.getMeta());
        }
    }

    private static ClassChange detectClassChanges(ParserKlass newParserKlass, ObjectKlass oldKlass, DetectedChange collectedChanges, ParserKlass finalParserKlass) throws RedefinitionNotSupportedException {
        if (oldKlass.getSuperKlass() == oldKlass.getMeta().java_lang_Enum) {
            ClassRedefinition.detectInvalidEnumConstantChanges(newParserKlass, oldKlass);
        }
        ClassChange result = ClassChange.NO_CHANGE;
        ParserKlass oldParserKlass = oldKlass.getLinkedKlass().getParserKlass();
        boolean isPatched = finalParserKlass != null;
        ParserMethod[] newParserMethods = newParserKlass.getMethods();
        ArrayList<Method> oldMethods = new ArrayList<Method>(Arrays.asList(oldKlass.getDeclaredMethods()));
        ArrayList<ParserMethod> newMethods = new ArrayList<ParserMethod>(Arrays.asList(newParserMethods));
        HashMap<Method, ParserMethod> bodyChanges = new HashMap<Method, ParserMethod>();
        ArrayList<ParserMethod> newSpecialMethods = new ArrayList<ParserMethod>(1);
        boolean constantPoolChanged = false;
        if (!Arrays.equals(oldParserKlass.getConstantPool().getRawBytes(), newParserKlass.getConstantPool().getRawBytes())) {
            constantPoolChanged = true;
        }
        Iterator oldIt = oldMethods.iterator();
        block4: while (oldIt.hasNext()) {
            Method oldMethod = (Method)oldIt.next();
            Iterator oldParserMethod = oldMethod.getLinkedMethod().getParserMethod();
            Iterator newIt = newMethods.iterator();
            while (newIt.hasNext()) {
                ParserMethod parserMethod = (ParserMethod)newIt.next();
                if (!ClassRedefinition.isSameMethod(oldParserMethod, parserMethod)) continue;
                ClassChange change = ClassRedefinition.detectMethodChanges(oldParserMethod, parserMethod);
                switch (change.ordinal()) {
                    case 0: {
                        if (isPatched) {
                            ClassRedefinition.checkForSpecialConstructor(collectedChanges, bodyChanges, newSpecialMethods, oldMethod, oldParserMethod, parserMethod);
                            break;
                        }
                        if (constantPoolChanged) {
                            if (ClassRedefinition.isObsolete(oldParserMethod, parserMethod, oldParserKlass.getConstantPool(), newParserKlass.getConstantPool())) {
                                result = ClassChange.CONSTANT_POOL_CHANGE;
                                collectedChanges.addMethodBodyChange(oldMethod, parserMethod);
                                break;
                            }
                            collectedChanges.addUnchangedMethod(oldMethod);
                            break;
                        }
                        collectedChanges.addUnchangedMethod(oldMethod);
                        break;
                    }
                    case 2: {
                        result = change;
                        if (isPatched) {
                            ClassRedefinition.checkForSpecialConstructor(collectedChanges, bodyChanges, newSpecialMethods, oldMethod, oldParserMethod, parserMethod);
                            break;
                        }
                        collectedChanges.addMethodBodyChange(oldMethod, parserMethod);
                        break;
                    }
                    default: {
                        return change;
                    }
                }
                newIt.remove();
                oldIt.remove();
                continue block4;
            }
        }
        if (isPatched) {
            ParserMethod[] finalMethods = finalParserKlass.getMethods();
            block6: for (Map.Entry entry : bodyChanges.entrySet()) {
                Method oldMethod = (Method)entry.getKey();
                ParserMethod changed = (ParserMethod)entry.getValue();
                for (int i = 0; i < newParserMethods.length; ++i) {
                    if (newParserMethods[i] != changed) continue;
                    collectedChanges.addMethodBodyChange(oldMethod, (ParserMethod)finalMethods[i]);
                    continue block6;
                }
            }
            newMethods.addAll(newSpecialMethods);
            block8: for (ParserMethod parserMethod : newMethods) {
                for (int i = 0; i < newParserMethods.length; ++i) {
                    if (newParserMethods[i] != parserMethod) continue;
                    collectedChanges.addNewMethod((ParserMethod)finalMethods[i]);
                    continue block8;
                }
            }
        } else {
            collectedChanges.addNewMethods(newMethods);
        }
        for (Method oldMethod : oldMethods) {
            collectedChanges.addRemovedMethod(oldMethod.getMethodVersion());
        }
        if (!oldMethods.isEmpty()) {
            result = ClassChange.REMOVE_METHOD;
        } else if (!newMethods.isEmpty()) {
            result = ClassChange.ADD_METHOD;
        }
        if (isPatched) {
            result = ClassChange.CLASS_NAME_CHANGED;
        }
        Field[] oldFields = oldKlass.getDeclaredFields();
        ParserField[] newFields = newParserKlass.getFields();
        ArrayList<Field> arrayList = new ArrayList<Field>(Arrays.asList(oldFields));
        ArrayList<ParserField> newFieldsList = new ArrayList<ParserField>(Arrays.asList(newFields));
        HashMap<ParserField, Field> compatibleFields = new HashMap<ParserField, Field>();
        Iterator<Field> oldFieldsIt = arrayList.iterator();
        block11: while (oldFieldsIt.hasNext()) {
            Field oldField = oldFieldsIt.next();
            Iterator<ParserField> newFieldsIt = newFieldsList.iterator();
            while (newFieldsIt.hasNext()) {
                ParserField newField = newFieldsIt.next();
                if (!ClassRedefinition.isUnchangedField(oldField, newField, compatibleFields)) continue;
                Matcher matcher = InnerClassRedefiner.ANON_INNER_CLASS_PATTERN.matcher(oldField.getType().toString());
                if (isPatched && matcher.matches()) continue block11;
                oldFieldsIt.remove();
                newFieldsIt.remove();
                continue block11;
            }
        }
        if (!newFieldsList.isEmpty()) {
            if (isPatched) {
                ParserField[] finalFields = finalParserKlass.getFields();
                block13: for (ParserField parserField : newFieldsList) {
                    for (int i = 0; i < newFields.length; ++i) {
                        if (parserField != newFields[i]) continue;
                        collectedChanges.addNewField(finalFields[i]);
                        continue block13;
                    }
                }
            } else {
                collectedChanges.addNewFields(newFieldsList);
            }
            result = ClassChange.SCHEMA_CHANGE;
        }
        if (!arrayList.isEmpty()) {
            collectedChanges.addRemovedFields(arrayList);
            result = ClassChange.SCHEMA_CHANGE;
        }
        if (newParserKlass.getFlags() != oldParserKlass.getFlags()) {
            result = ClassChange.SCHEMA_CHANGE;
        }
        collectedChanges.addCompatibleFields(compatibleFields);
        Klass superKlass = oldKlass.getSuperKlass();
        if (!newParserKlass.getSuperKlass().equals(oldParserKlass.getSuperKlass())) {
            result = ClassChange.CLASS_HIERARCHY_CHANGED;
            superKlass = ClassRedefinition.getLoadedKlass(newParserKlass.getSuperKlass(), oldKlass);
        }
        collectedChanges.addSuperKlass((ObjectKlass)superKlass);
        ObjectKlass[] newSuperInterfaces = oldKlass.getSuperInterfaces();
        if (!Arrays.equals(newParserKlass.getSuperInterfaces(), oldParserKlass.getSuperInterfaces())) {
            result = ClassChange.CLASS_HIERARCHY_CHANGED;
            newSuperInterfaces = new ObjectKlass[newParserKlass.getSuperInterfaces().length];
            for (int i = 0; i < newParserKlass.getSuperInterfaces().length; ++i) {
                newSuperInterfaces[i] = (ObjectKlass)ClassRedefinition.getLoadedKlass(newParserKlass.getSuperInterfaces()[i], oldKlass);
            }
        }
        collectedChanges.addSuperInterfaces(newSuperInterfaces);
        return result;
    }

    private static void detectInvalidEnumConstantChanges(ParserKlass newParserKlass, ObjectKlass oldKlass) throws RedefinitionNotSupportedException {
        ParserField[] newEnumFields;
        Field[] oldEnumFields = oldKlass.getDeclaredFields();
        LinkedList<Symbol<Symbol.Name>> oldEnumConstants = new LinkedList<Symbol<Symbol.Name>>();
        for (Field oldEnumField : oldEnumFields) {
            if (oldEnumField.getType() != oldKlass.getType()) continue;
            oldEnumConstants.addLast(oldEnumField.getName());
        }
        LinkedList<Symbol<Symbol.Name>> newEnumConstants = new LinkedList<Symbol<Symbol.Name>>();
        for (ParserField newEnumField : newEnumFields = newParserKlass.getFields()) {
            if (newEnumField.getType() != oldKlass.getType()) continue;
            newEnumConstants.addLast(newEnumField.getName());
        }
        if (oldEnumConstants.size() > newEnumConstants.size()) {
            throw new RedefinitionNotSupportedException(64);
        }
        for (int i = 0; i < oldEnumConstants.size(); ++i) {
            if (oldEnumConstants.get(i) == newEnumConstants.get(i)) continue;
            throw new RedefinitionNotSupportedException(64);
        }
    }

    private static Klass getLoadedKlass(Symbol<Symbol.Type> klassType, ObjectKlass oldKlass) throws RedefinitionNotSupportedException {
        Klass klass = oldKlass.getContext().getRegistries().findLoadedClass(klassType, oldKlass.getDefiningClassLoader());
        if (klass == null) {
            StaticObject resourceGuestString = oldKlass.getMeta().toGuestString(Types.binaryName(klassType));
            try {
                StaticObject loadedClass = (StaticObject)oldKlass.getMeta().java_lang_ClassLoader_loadClass.invokeDirect(oldKlass.getDefiningClassLoader(), resourceGuestString);
                klass = loadedClass.getMirrorKlass();
            }
            catch (Throwable t) {
                throw new RedefinitionNotSupportedException(101);
            }
        }
        return klass;
    }

    private static void checkForSpecialConstructor(DetectedChange collectedChanges, Map<Method, ParserMethod> bodyChanges, List<ParserMethod> newSpecialMethods, Method oldMethod, ParserMethod oldParserMethod, ParserMethod newMethod) {
        if (Symbol.Name._init_.equals(oldParserMethod.getName()) && Symbol.Signature._void != oldParserMethod.getSignature()) {
            Matcher matcher = InnerClassRedefiner.ANON_INNER_CLASS_PATTERN.matcher(oldParserMethod.getSignature().toString());
            if (matcher.matches()) {
                newSpecialMethods.add(newMethod);
                collectedChanges.addRemovedMethod(oldMethod.getMethodVersion());
            } else {
                bodyChanges.put(oldMethod, newMethod);
            }
        } else {
            bodyChanges.put(oldMethod, newMethod);
        }
    }

    private static boolean isObsolete(ParserMethod oldMethod, ParserMethod newMethod, ConstantPool oldPool, ConstantPool newPool) {
        BytecodeStream newCode;
        CodeAttribute oldCodeAttribute = (CodeAttribute)oldMethod.getAttribute(Symbol.Name.Code);
        CodeAttribute newCodeAttribute = (CodeAttribute)newMethod.getAttribute(Symbol.Name.Code);
        if (oldCodeAttribute == null) {
            return newCodeAttribute != null;
        }
        if (newCodeAttribute == null) {
            return oldCodeAttribute != null;
        }
        BytecodeStream oldCode = new BytecodeStream(oldCodeAttribute.getOriginalCode());
        return !ClassRedefinition.isSame(oldCode, oldPool, newCode = new BytecodeStream(newCodeAttribute.getOriginalCode()), newPool);
    }

    private static boolean isSame(BytecodeStream oldCode, ConstantPool oldPool, BytecodeStream newCode, ConstantPool newPool) {
        int nextBCI = 0;
        while (nextBCI < oldCode.endBCI()) {
            int bci = nextBCI;
            int opcode = oldCode.currentBC(bci);
            nextBCI = oldCode.nextBCI(bci);
            if (opcode != 18 && opcode != 20 && opcode != 19 && opcode != 187 && opcode != 186 && opcode != 180 && opcode != 178 && opcode != 181 && opcode != 179 && !Bytecodes.isInvoke(opcode)) continue;
            char oldCPI = oldCode.readCPI(bci);
            PoolConstant oldConstant = oldPool.at(oldCPI);
            char newCPI = newCode.readCPI(bci);
            PoolConstant newConstant = newPool.at(newCPI);
            if (oldConstant.toString(oldPool).equals(newConstant.toString(newPool))) continue;
            return false;
        }
        return true;
    }

    private static ClassChange detectMethodChanges(ParserMethod oldMethod, ParserMethod newMethod) {
        CodeAttribute oldCodeAttribute = (CodeAttribute)oldMethod.getAttribute(Symbol.Name.Code);
        CodeAttribute newCodeAttribute = (CodeAttribute)newMethod.getAttribute(Symbol.Name.Code);
        if (oldCodeAttribute == null) {
            return newCodeAttribute != null ? ClassChange.METHOD_BODY_CHANGE : ClassChange.NO_CHANGE;
        }
        if (newCodeAttribute == null) {
            return oldCodeAttribute != null ? ClassChange.METHOD_BODY_CHANGE : ClassChange.NO_CHANGE;
        }
        if (!Arrays.equals(oldCodeAttribute.getOriginalCode(), newCodeAttribute.getOriginalCode())) {
            return ClassChange.METHOD_BODY_CHANGE;
        }
        if (ClassRedefinition.checkLineNumberTable(oldCodeAttribute.getLineNumberTableAttribute(), newCodeAttribute.getLineNumberTableAttribute())) {
            return ClassChange.METHOD_BODY_CHANGE;
        }
        if (ClassRedefinition.checkLocalVariableTable(oldCodeAttribute.getLocalvariableTable(), newCodeAttribute.getLocalvariableTable())) {
            return ClassChange.METHOD_BODY_CHANGE;
        }
        if (ClassRedefinition.checkLocalVariableTable(oldCodeAttribute.getLocalvariableTypeTable(), newCodeAttribute.getLocalvariableTypeTable())) {
            return ClassChange.METHOD_BODY_CHANGE;
        }
        return ClassChange.NO_CHANGE;
    }

    private static boolean checkLineNumberTable(LineNumberTableAttribute table1, LineNumberTableAttribute table2) {
        List<LineNumberTableAttribute.Entry> oldEntries = table1.getEntries();
        List<LineNumberTableAttribute.Entry> newEntries = table2.getEntries();
        if (oldEntries.size() != newEntries.size()) {
            return true;
        }
        for (int i = 0; i < oldEntries.size(); ++i) {
            LineNumberTableAttribute.Entry oldEntry = oldEntries.get(i);
            LineNumberTableAttribute.Entry newEntry = newEntries.get(i);
            if (oldEntry.getLineNumber() == newEntry.getLineNumber() && oldEntry.getBCI() == newEntry.getBCI()) continue;
            return true;
        }
        return false;
    }

    private static boolean checkLocalVariableTable(LocalVariableTable table1, LocalVariableTable table2) {
        Local[] newLocals;
        Local[] oldLocals = table1.getLocals();
        if (oldLocals.length != (newLocals = table2.getLocals()).length) {
            return true;
        }
        for (int i = 0; i < oldLocals.length; ++i) {
            Local oldLocal = oldLocals[i];
            Local newLocal = newLocals[i];
            if (oldLocal.getNameAsString().equals(newLocal.getNameAsString()) && oldLocal.getSlot() == newLocal.getSlot() && oldLocal.getStartBCI() == newLocal.getStartBCI() && oldLocal.getEndBCI() == newLocal.getEndBCI()) continue;
            return true;
        }
        return false;
    }

    private static boolean attrChanged(ParserMethod oldMethod, ParserMethod newMethod, Symbol<Symbol.Name> name) {
        Attribute oldAttribute = oldMethod.getAttribute(name);
        Attribute newAttribute = newMethod.getAttribute(name);
        return oldAttribute == null || newAttribute == null ? oldAttribute != null || newAttribute != null : !oldAttribute.sameAs(newAttribute);
    }

    private static boolean isSameMethod(ParserMethod oldMethod, ParserMethod newMethod) {
        boolean same;
        boolean bl = same = oldMethod.getName().equals(newMethod.getName()) && oldMethod.getSignature().equals(newMethod.getSignature()) && oldMethod.getFlags() == newMethod.getFlags();
        if (same) {
            if (ClassRedefinition.attrChanged(oldMethod, newMethod, Symbol.Name.RuntimeVisibleTypeAnnotations)) {
                return false;
            }
            if (ClassRedefinition.attrChanged(oldMethod, newMethod, Symbol.Name.RuntimeInvisibleTypeAnnotations)) {
                return false;
            }
            if (ClassRedefinition.attrChanged(oldMethod, newMethod, Symbol.Name.RuntimeVisibleAnnotations)) {
                return false;
            }
            if (ClassRedefinition.attrChanged(oldMethod, newMethod, Symbol.Name.RuntimeInvisibleAnnotations)) {
                return false;
            }
            if (ClassRedefinition.attrChanged(oldMethod, newMethod, Symbol.Name.RuntimeInvisibleParameterAnnotations)) {
                return false;
            }
            if (ClassRedefinition.attrChanged(oldMethod, newMethod, Symbol.Name.RuntimeVisibleParameterAnnotations)) {
                return false;
            }
            if (ClassRedefinition.attrChanged(oldMethod, newMethod, Symbol.Name.Exceptions)) {
                return false;
            }
            if (ClassRedefinition.attrChanged(oldMethod, newMethod, Symbol.Name.Signature)) {
                return false;
            }
            if (ClassRedefinition.attrChanged(oldMethod, newMethod, Symbol.Name.Exceptions)) {
                return false;
            }
        }
        return same;
    }

    private static boolean isUnchangedField(Field oldField, ParserField newField, Map<ParserField, Field> compatibleFields) {
        boolean sameFlags;
        boolean sameName = oldField.getName() == newField.getName();
        boolean sameType = oldField.getType() == newField.getType();
        boolean bl = sameFlags = oldField.getModifiers() == (newField.getFlags() & 0x50DF);
        if (sameName && sameType) {
            if (sameFlags) {
                Attribute[] newAttributes;
                Attribute[] oldAttributes = oldField.getAttributes();
                if (oldAttributes.length != (newAttributes = newField.getAttributes()).length) {
                    return false;
                }
                for (Attribute oldAttribute : oldAttributes) {
                    boolean found = false;
                    for (Attribute newAttribute : newAttributes) {
                        if (oldAttribute.getName() != newAttribute.getName() || !oldAttribute.sameAs(newAttribute)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    return false;
                }
                return true;
            }
            if (Modifier.isStatic(oldField.getModifiers()) == Modifier.isStatic(newField.getFlags())) {
                compatibleFields.put(newField, oldField);
            }
            return false;
        }
        return false;
    }

    private void doRedefineClass(ChangePacket packet, List<ObjectKlass> invalidatedClasses, List<ObjectKlass> redefinedClasses) {
        ObjectKlass oldKlass = packet.info.getKlass();
        if (packet.info.isRenamed()) {
            Symbol<Symbol.Name> newName = packet.info.getName();
            Symbol<Symbol.Type> newType = this.context.getTypes().fromName(newName);
            oldKlass.patchClassName(newName, newType);
            ClassRegistry classRegistry = this.context.getRegistries().getClassRegistry(packet.info.getClassLoader());
            classRegistry.onClassRenamed(oldKlass);
            InterpreterToVM.setFieldObject(StaticObject.NULL, oldKlass.mirror(), this.context.getMeta().java_lang_Class_name);
        }
        if (packet.classChange == ClassChange.CLASS_HIERARCHY_CHANGED) {
            oldKlass.removeAsSubType();
        }
        oldKlass.redefineClass(packet, invalidatedClasses, this.ids);
        redefinedClasses.add(oldKlass);
        if (this.redefineListener.shouldRerunClassInitializer(oldKlass, packet.detectedChange.clinitChanged(), this.controller)) {
            this.context.rerunclinit(oldKlass);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public Method handleRemovedMethod(Method resolutionSeed, Klass receiverKlass) {
        this.check();
        Method replacementMethod = receiverKlass.lookupMethod(resolutionSeed.getName(), resolutionSeed.getRawSignature());
        Meta meta = resolutionSeed.getMeta();
        if (replacementMethod == null) {
            throw meta.throwExceptionWithMessage(meta.java_lang_NoSuchMethodError, String.valueOf(meta.toGuestString(resolutionSeed.getDeclaringKlass().getNameAsString() + "." + String.valueOf(resolutionSeed.getName()) + String.valueOf(resolutionSeed.getRawSignature()))) + " was removed by class redefinition");
        }
        if (resolutionSeed.isStatic() != replacementMethod.isStatic()) {
            String message = resolutionSeed.isStatic() ? "expected static method: " : "expected non-static method:" + String.valueOf(replacementMethod.getName());
            throw meta.throwExceptionWithMessage(meta.java_lang_IncompatibleClassChangeError, message);
        }
        return replacementMethod;
    }

    public int getNextAvailableFieldSlot() {
        return this.nextAvailableFieldSlot.getAndDecrement();
    }

    public DebuggerController getController() {
        return this.controller;
    }

    public static enum ClassChange {
        NO_CHANGE,
        CONSTANT_POOL_CHANGE,
        METHOD_BODY_CHANGE,
        CLASS_NAME_CHANGED,
        ADD_METHOD,
        REMOVE_METHOD,
        NEW_CLASS,
        SCHEMA_CHANGE,
        CLASS_HIERARCHY_CHANGED,
        INVALID;

    }
}

