/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime;

import com.oracle.truffle.espresso.runtime.PlatformBuilder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.graalvm.home.HomeFinder;

final class DarwinBuilder
extends PlatformBuilder {
    private static final Path ROOT = Paths.get("/", new String[0]);
    private static final Path SYS_EXTENSIONS_DIR = Paths.get("Library", "Java", "Extensions");
    private static final List<Path> SYS_EXTENSIONS_DIRS = Collections.unmodifiableList(Arrays.asList(ROOT.resolve(SYS_EXTENSIONS_DIR), Paths.get("/Network", new String[0]).resolve(SYS_EXTENSIONS_DIR), Paths.get("/System", new String[0]).resolve(SYS_EXTENSIONS_DIR), Paths.get("/usr/lib/java", new String[0])));

    DarwinBuilder(Path espressoLibs) {
        super(espressoLibs);
    }

    private static Path userHomeDir() {
        return Paths.get(System.getProperty("user.home"), new String[0]);
    }

    @Override
    List<Path> defaultJavaLibraryPath() {
        ArrayList<Path> paths = new ArrayList<Path>();
        DarwinBuilder.expandEnvToPath("DYLD_LIBRARY_PATH", paths);
        DarwinBuilder.expandEnvToPath("JAVA_LIBRARY_PATH", paths);
        paths.add(DarwinBuilder.userHomeDir().resolve(SYS_EXTENSIONS_DIR));
        paths.addAll(SYS_EXTENSIONS_DIRS);
        paths.add(Paths.get(".", new String[0]));
        return paths;
    }

    @Override
    List<Path> defaultBootLibraryPath() {
        return Collections.singletonList(this.javaHome().resolve("lib"));
    }

    @Override
    List<Path> defaultJvmLibraryPath() {
        ArrayList<Path> paths = new ArrayList<Path>();
        Path graalvmHome = HomeFinder.getInstance().getHomeFolder();
        if (graalvmHome != null && Files.isDirectory(graalvmHome, new LinkOption[0])) {
            paths.add(graalvmHome.resolve("lib").resolve("truffle"));
        }
        paths.add(this.espressoLibs());
        return paths;
    }

    @Override
    List<Path> defaultExtDirs() {
        ArrayList<Path> paths = new ArrayList<Path>();
        paths.add(DarwinBuilder.userHomeDir().resolve(SYS_EXTENSIONS_DIR));
        paths.add(this.javaHome().resolve(EXTENSIONS_DIR));
        paths.addAll(SYS_EXTENSIONS_DIRS);
        return paths;
    }
}

