/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.espresso.EspressoBindings;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.EspressoOptions;
import com.oracle.truffle.espresso.analysis.hierarchy.ClassHierarchyOracle;
import com.oracle.truffle.espresso.blocking.BlockingSupport;
import com.oracle.truffle.espresso.blocking.EspressoLock;
import com.oracle.truffle.espresso.descriptors.Names;
import com.oracle.truffle.espresso.descriptors.Signatures;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.descriptors.Types;
import com.oracle.truffle.espresso.ffi.NativeAccess;
import com.oracle.truffle.espresso.ffi.NativeAccessCollector;
import com.oracle.truffle.espresso.impl.ClassLoadingEnv;
import com.oracle.truffle.espresso.impl.ClassRegistries;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.jdwp.api.Ids;
import com.oracle.truffle.espresso.jdwp.impl.DebuggerController;
import com.oracle.truffle.espresso.jni.JniEnv;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.interop.EspressoForeignProxyGenerator;
import com.oracle.truffle.espresso.nodes.interop.PolyglotTypeMappings;
import com.oracle.truffle.espresso.perf.DebugCloseable;
import com.oracle.truffle.espresso.perf.DebugTimer;
import com.oracle.truffle.espresso.perf.TimerCollection;
import com.oracle.truffle.espresso.preinit.ContextPatchingException;
import com.oracle.truffle.espresso.preinit.EspressoLanguageCache;
import com.oracle.truffle.espresso.redefinition.ClassRedefinition;
import com.oracle.truffle.espresso.redefinition.plugins.api.InternalRedefinitionPlugin;
import com.oracle.truffle.espresso.redefinition.plugins.impl.RedefinitionPluginHandler;
import com.oracle.truffle.espresso.ref.FinalizationSupport;
import com.oracle.truffle.espresso.runtime.AgentLibraries;
import com.oracle.truffle.espresso.runtime.Classpath;
import com.oracle.truffle.espresso.runtime.EspressoEnv;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.EspressoExitException;
import com.oracle.truffle.espresso.runtime.EspressoProperties;
import com.oracle.truffle.espresso.runtime.EspressoShutdownHandler;
import com.oracle.truffle.espresso.runtime.GuestAllocator;
import com.oracle.truffle.espresso.runtime.JImageHelper;
import com.oracle.truffle.espresso.runtime.JImageLibrary;
import com.oracle.truffle.espresso.runtime.JavaJImageHelper;
import com.oracle.truffle.espresso.runtime.JavaVersion;
import com.oracle.truffle.espresso.runtime.LazyContextCaches;
import com.oracle.truffle.espresso.runtime.MethodHandleIntrinsics;
import com.oracle.truffle.espresso.runtime.NativeJImageHelper;
import com.oracle.truffle.espresso.runtime.OS;
import com.oracle.truffle.espresso.runtime.StringTable;
import com.oracle.truffle.espresso.runtime.jimage.BasicImageReader;
import com.oracle.truffle.espresso.runtime.panama.DowncallStubs;
import com.oracle.truffle.espresso.runtime.panama.Platform;
import com.oracle.truffle.espresso.runtime.panama.UpcallStubs;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.Substitutions;
import com.oracle.truffle.espresso.threads.ThreadsAccess;
import com.oracle.truffle.espresso.vm.InterpreterToVM;
import com.oracle.truffle.espresso.vm.UnsafeAccess;
import com.oracle.truffle.espresso.vm.VM;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.ReferenceQueue;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.graalvm.options.OptionMap;
import sun.misc.SignalHandler;

public final class EspressoContext {
    public static final int DEFAULT_STACK_SIZE = 32;
    public static final StackTraceElement[] EMPTY_STACK = new StackTraceElement[0];
    private static final DebugTimer SPAWN_VM = DebugTimer.create("spawnVM");
    private static final DebugTimer SYSTEM_INIT = DebugTimer.create("system init", SPAWN_VM);
    private static final DebugTimer KNOWN_CLASS_INIT = DebugTimer.create("known class init", SPAWN_VM);
    private static final DebugTimer META_INIT = DebugTimer.create("meta init", SPAWN_VM);
    private static final DebugTimer VM_INIT = DebugTimer.create("vm init", SPAWN_VM);
    private static final DebugTimer SYSTEM_CLASSLOADER = DebugTimer.create("system classloader", SPAWN_VM);
    private final TruffleLogger logger = TruffleLogger.getLogger((String)"java");
    private final EspressoLanguage language;
    @CompilerDirectives.CompilationFinal
    private EspressoEnv espressoEnv;
    private String[] mainArguments;
    private long startupClockNanos = 0L;
    private final StringTable strings;
    @CompilerDirectives.CompilationFinal
    private ClassRegistries registries;
    private final Substitutions substitutions;
    private final MethodHandleIntrinsics methodHandleIntrinsics;
    @CompilerDirectives.CompilationFinal
    private ThreadsAccess threads;
    @CompilerDirectives.CompilationFinal
    private BlockingSupport<StaticObject> blockingSupport;
    @CompilerDirectives.CompilationFinal
    private EspressoShutdownHandler shutdownManager;
    @CompilerDirectives.CompilationFinal
    private long bootClassLoaderID;
    public long initDoneTimeNanos;
    @CompilerDirectives.CompilationFinal
    private boolean modulesInitialized = false;
    @CompilerDirectives.CompilationFinal
    private boolean metaInitialized = false;
    private boolean initialized = false;
    private boolean disposeCalled = false;
    private Classpath bootClasspath;
    @CompilerDirectives.CompilationFinal
    private ClassLoadingEnv classLoadingEnv;
    private ClassRedefinition classRedefinition;
    private final Assumption anyHierarchyChanges = Truffle.getRuntime().createAssumption();
    @CompilerDirectives.CompilationFinal
    private volatile LazyContextCaches lazyCaches;
    private Map<Class<? extends InternalRedefinitionPlugin>, InternalRedefinitionPlugin> redefinitionPlugins;
    private volatile boolean isFinalized;
    @CompilerDirectives.CompilationFinal
    private Meta meta;
    @CompilerDirectives.CompilationFinal
    private VM vm;
    @CompilerDirectives.CompilationFinal
    private JniEnv jniEnv;
    @CompilerDirectives.CompilationFinal
    private InterpreterToVM interpreterToVM;
    @CompilerDirectives.CompilationFinal
    private JImageLibrary jimageLibrary;
    @CompilerDirectives.CompilationFinal
    private EspressoProperties vmProperties;
    @CompilerDirectives.CompilationFinal
    private AgentLibraries agents;
    @CompilerDirectives.CompilationFinal
    private NativeAccess nativeAccess;
    @CompilerDirectives.CompilationFinal
    private EspressoException stackOverflow;
    @CompilerDirectives.CompilationFinal
    private EspressoException outOfMemory;
    @CompilerDirectives.CompilationFinal
    private EspressoBindings topBindings;
    @CompilerDirectives.CompilationFinal
    private StaticObject bindingsLoader;
    private final WeakHashMap<StaticObject, SignalHandler> hostSignalHandlers = new WeakHashMap();
    @CompilerDirectives.CompilationFinal
    private DowncallStubs downcallStubs;
    @CompilerDirectives.CompilationFinal
    private UpcallStubs upcallStubs;
    private static final TruffleLanguage.ContextReference<EspressoContext> REFERENCE = TruffleLanguage.ContextReference.create(EspressoLanguage.class);

    public TruffleLogger getLogger() {
        return this.logger;
    }

    public long getBootClassLoaderID() {
        return this.bootClassLoaderID;
    }

    public EspressoContext(TruffleLanguage.Env env, EspressoLanguage language) {
        this.language = language;
        this.strings = new StringTable(this);
        this.substitutions = new Substitutions(this);
        this.methodHandleIntrinsics = new MethodHandleIntrinsics();
        this.espressoEnv = new EspressoEnv(this, env);
        this.classLoadingEnv = new ClassLoadingEnv(this.getLanguage(), this.getLogger(), this.getTimers());
        this.bootClassLoaderID = this.classLoadingEnv.getNewLoaderId();
    }

    public ClassRegistries getRegistries() {
        return this.registries;
    }

    public InputStream in() {
        return this.getEnv().in();
    }

    public OutputStream out() {
        return this.getEnv().out();
    }

    public OutputStream err() {
        return this.getEnv().err();
    }

    public StringTable getStrings() {
        return this.strings;
    }

    public TruffleLanguage.Env getEnv() {
        return this.espressoEnv.env();
    }

    public EspressoEnv getEspressoEnv() {
        return this.espressoEnv;
    }

    public EspressoLanguage getLanguage() {
        return this.language;
    }

    public boolean multiThreadingEnabled() {
        return this.espressoEnv.multiThreadingEnabled();
    }

    public String getMultiThreadingDisabledReason() {
        return this.espressoEnv.getMultiThreadingDisabledReason();
    }

    public String[] getMainArguments() {
        return this.mainArguments;
    }

    public void setMainArguments(String[] mainArguments) {
        this.mainArguments = mainArguments;
    }

    public String[] getVmArguments() {
        return this.espressoEnv.getVmArguments();
    }

    public long getStartupClockNanos() {
        return this.startupClockNanos;
    }

    public EspressoLanguageCache getLanguageCache() {
        return this.getLanguage().getLanguageCache();
    }

    public Classpath getBootClasspath() {
        if (this.bootClasspath == null) {
            CompilerAsserts.neverPartOfCompilation();
            this.bootClasspath = new Classpath(this.getVmProperties().bootClasspath().stream().map(new Function<Path, String>(){

                @Override
                public String apply(Path path) {
                    return path.toString();
                }
            }).collect(Collectors.joining(File.pathSeparator)));
        }
        return this.bootClasspath;
    }

    public ClassLoadingEnv getClassLoadingEnv() {
        return this.classLoadingEnv;
    }

    public void setBootClassPath(Classpath classPath) {
        this.bootClasspath = classPath;
    }

    public EspressoProperties getVmProperties() {
        assert (this.vmProperties != null);
        return this.vmProperties;
    }

    public void initializeContext() throws ContextPatchingException {
        EspressoError.guarantee(this.getEnv().isNativeAccessAllowed(), "Native access is not allowed by the host environment but it's required to load Espresso/Java native libraries. Allow native access on context creation e.g. contextBuilder.allowNativeAccess(true). If you are attempting to pre-initialize an Espresso context, allow native access for pre-initialized languages through Truffle's image-build-time options.");
        assert (!this.initialized);
        this.startupClockNanos = System.nanoTime();
        FinalizationSupport.ensureInitialized();
        this.spawnVM();
        this.getEspressoEnv().getPolyglotTypeMappings().resolve(this);
        this.initialized = true;
        this.getEspressoEnv().getReferenceDrainer().startReferenceDrain();
        if (this.espressoEnv.JDWPOptions != null) {
            this.espressoEnv.getJdwpContext().jdwpInit(this.getEnv(), this.getMainThread(), this.espressoEnv.getEventListener());
        }
    }

    public void patchContext(TruffleLanguage.Env newEnv) {
        this.espressoEnv = new EspressoEnv(this, newEnv);
    }

    @CompilerDirectives.TruffleBoundary
    public Source findOrCreateSource(ObjectKlass klass) {
        Symbol<Symbol.Name> runtimePackage;
        Object sourceFile = klass.getSourceFile();
        if (sourceFile == null) {
            return null;
        }
        if (!((String)sourceFile).contains("/") && !((String)sourceFile).contains("\\") && (runtimePackage = klass.getRuntimePackage()) != null && runtimePackage.length() > 0) {
            sourceFile = String.valueOf(runtimePackage) + "/" + (String)sourceFile;
        }
        TruffleFile file = this.getEnv().getInternalTruffleFile((String)sourceFile);
        return Source.newBuilder((String)"java", (TruffleFile)file).content(Source.CONTENT_NONE).build();
    }

    public Meta getMeta() {
        return this.meta;
    }

    public GuestAllocator getAllocator() {
        return this.getLanguage().getAllocator();
    }

    public NativeAccess getNativeAccess() {
        return this.nativeAccess;
    }

    private void spawnVM() throws ContextPatchingException {
        try (DebugCloseable spawn = SPAWN_VM.scope(this.espressoEnv.getTimers());){
            long initStartTimeNanos = System.nanoTime();
            this.nativeAccess = this.spawnNativeAccess();
            this.initVmProperties();
            JavaVersion contextJavaVersion = this.javaVersionFromReleaseFile(this.vmProperties.javaHome());
            if (contextJavaVersion == null) {
                contextJavaVersion = JavaVersion.latestSupported();
                this.getLogger().warning(() -> "Couldn't find Java version for %s / %s: defaulting to %s".formatted(this.vmProperties.javaHome(), this.vmProperties.bootLibraryPath(), JavaVersion.latestSupported()));
            } else if (contextJavaVersion.compareTo(JavaVersion.latestSupported()) > 0) {
                throw EspressoError.fatal("Unsupported Java version: " + String.valueOf(contextJavaVersion));
            }
            JavaVersion languageJavaVersion = this.getLanguage().getJavaVersion();
            if (languageJavaVersion != null) {
                if (!contextJavaVersion.equals(languageJavaVersion)) {
                    throw ContextPatchingException.javaVersionMismatch(languageJavaVersion, contextJavaVersion);
                }
            } else {
                this.getLanguage().tryInitializeJavaVersion(contextJavaVersion);
            }
            if (!contextJavaVersion.java21OrLater() && this.getEspressoEnv().RegexSubstitutions) {
                this.logger.warning("UseTRegex is not available for context running Java version < 21");
            }
            try (DebugCloseable vmInit = VM_INIT.scope(this.espressoEnv.getTimers());){
                this.jniEnv = JniEnv.create(this);
                this.vm = VM.create(this.jniEnv);
                this.vm.attachThread(Thread.currentThread());
                this.vm.loadJavaLibrary(this.vmProperties.bootLibraryPath());
                this.downcallStubs = new DowncallStubs(Platform.getHostPlatform());
                this.upcallStubs = new UpcallStubs(Platform.getHostPlatform(), this.nativeAccess, this.language);
                this.vm.initializeJavaLibrary();
                EspressoError.guarantee(this.getJavaVersion() != null, "Java version");
            }
            this.registries = new ClassRegistries(this);
            if (this.getJavaVersion().modulesEnabled()) {
                this.registries.initJavaBaseModule();
                this.registries.getBootClassRegistry().initUnnamedModule(StaticObject.NULL);
            }
            this.initializeAgents();
            try (DebugCloseable metaInit = META_INIT.scope(this.espressoEnv.getTimers());){
                this.meta = new Meta(this);
            }
            this.classLoadingEnv.setMeta(this.meta);
            this.metaInitialized = true;
            this.threads = new ThreadsAccess(this.meta);
            this.blockingSupport = BlockingSupport.create(this.threads);
            this.shutdownManager = new EspressoShutdownHandler(this, this.espressoEnv.getThreadRegistry(), this.espressoEnv.getReferenceDrainer(), this.espressoEnv.SoftExit);
            this.interpreterToVM = new InterpreterToVM(this);
            this.lazyCaches = new LazyContextCaches(this);
            try (DebugCloseable knownClassInit = KNOWN_CLASS_INIT.scope(this.espressoEnv.getTimers());){
                this.initializeKnownClass(Symbol.Type.java_lang_Object);
                for (Symbol type : Arrays.asList(Symbol.Type.java_lang_String, Symbol.Type.java_lang_System, Symbol.Type.java_lang_Class, Symbol.Type.java_lang_ThreadGroup, Symbol.Type.java_lang_Thread)) {
                    this.initializeKnownClass(type);
                }
            }
            if (this.meta.jdk_internal_misc_UnsafeConstants != null) {
                this.initializeKnownClass(Symbol.Type.jdk_internal_misc_UnsafeConstants);
                UnsafeAccess.initializeGuestUnsafeConstants(this.meta);
            }
            this.espressoEnv.getThreadRegistry().createMainThread(this.meta);
            knownClassInit = KNOWN_CLASS_INIT.scope(this.espressoEnv.getTimers());
            try {
                for (Symbol type : Arrays.asList(Symbol.Type.java_lang_reflect_Method, Symbol.Type.java_lang_ref_Finalizer)) {
                    this.initializeKnownClass(type);
                }
            }
            finally {
                if (knownClassInit != null) {
                    knownClassInit.close();
                }
            }
            this.espressoEnv.getReferenceDrainer().initReferenceDrain();
            try (DebugCloseable systemInit = SYSTEM_INIT.scope(this.espressoEnv.getTimers());){
                if (this.getJavaVersion().java8OrEarlier()) {
                    this.meta.java_lang_System_initializeSystemClass.invokeDirect(null, new Object[0]);
                } else {
                    assert (this.getJavaVersion().java9OrLater());
                    this.meta.java_lang_System_initPhase1.invokeDirect(null, new Object[0]);
                    for (Symbol type : Arrays.asList(Symbol.Type.java_lang_invoke_MethodHandle, Symbol.Type.java_lang_invoke_MemberName, Symbol.Type.java_lang_invoke_MethodHandleNatives)) {
                        this.initializeKnownClass(type);
                    }
                    int e = (Integer)this.meta.java_lang_System_initPhase2.invokeDirect(null, false, this.logger.isLoggable(Level.FINE));
                    if (e != 0) {
                        throw EspressoError.shouldNotReachHere();
                    }
                    this.getVM().getJvmti().postVmStart();
                    this.modulesInitialized = true;
                    this.meta.java_lang_System_initPhase3.invokeDirect(null, new Object[0]);
                }
            }
            this.getVM().getJvmti().postVmInit();
            this.meta.postSystemInit();
            knownClassInit = KNOWN_CLASS_INIT.scope(this.espressoEnv.getTimers());
            try {
                for (Symbol type : Arrays.asList(Symbol.Type.java_lang_OutOfMemoryError, Symbol.Type.java_lang_NullPointerException, Symbol.Type.java_lang_ClassCastException, Symbol.Type.java_lang_ArrayStoreException, Symbol.Type.java_lang_ArithmeticException, Symbol.Type.java_lang_StackOverflowError, Symbol.Type.java_lang_IllegalMonitorStateException, Symbol.Type.java_lang_IllegalArgumentException)) {
                    this.initializeKnownClass(type);
                }
            }
            finally {
                if (knownClassInit != null) {
                    knownClassInit.close();
                }
            }
            StaticObject stackOverflowErrorInstance = this.meta.java_lang_StackOverflowError.allocateInstance(this);
            StaticObject outOfMemoryErrorInstance = this.meta.java_lang_OutOfMemoryError.allocateInstance(this);
            this.meta.HIDDEN_FRAMES.setHiddenObject(stackOverflowErrorInstance, VM.StackTrace.EMPTY_STACK_TRACE);
            this.meta.java_lang_Throwable_backtrace.setObject(stackOverflowErrorInstance, stackOverflowErrorInstance);
            this.meta.HIDDEN_FRAMES.setHiddenObject(outOfMemoryErrorInstance, VM.StackTrace.EMPTY_STACK_TRACE);
            this.meta.java_lang_Throwable_backtrace.setObject(outOfMemoryErrorInstance, outOfMemoryErrorInstance);
            this.stackOverflow = EspressoException.wrap(stackOverflowErrorInstance, this.meta);
            this.outOfMemory = EspressoException.wrap(outOfMemoryErrorInstance, this.meta);
            this.meta.java_lang_StackOverflowError.lookupDeclaredMethod(Symbol.Name._init_, Symbol.Signature._void_String).invokeDirect(stackOverflowErrorInstance, this.meta.toGuestString("VM StackOverFlow"));
            this.meta.java_lang_OutOfMemoryError.lookupDeclaredMethod(Symbol.Name._init_, Symbol.Signature._void_String).invokeDirect(outOfMemoryErrorInstance, this.meta.toGuestString("VM OutOfMemory"));
            StaticObject systemClassLoader = null;
            try (DebugCloseable systemLoader = SYSTEM_CLASSLOADER.scope(this.espressoEnv.getTimers());){
                systemClassLoader = (StaticObject)this.meta.java_lang_ClassLoader_getSystemClassLoader.invokeDirect(null, new Object[0]);
            }
            this.bindingsLoader = this.createBindingsLoader(systemClassLoader);
            this.topBindings = new EspressoBindings((Boolean)this.getEnv().getOptions().get(EspressoOptions.ExposeNativeJavaVM), this.bindingsLoader != systemClassLoader);
            this.initDoneTimeNanos = System.nanoTime();
            long elapsedNanos = this.initDoneTimeNanos - initStartTimeNanos;
            this.getLogger().log(Level.FINE, "VM booted in {0} ms", (Object)TimeUnit.NANOSECONDS.toMillis(elapsedNanos));
        }
    }

    private JavaVersion javaVersionFromReleaseFile(Path javaHome) {
        Path releaseFilePath = javaHome.resolve("release");
        if (!Files.isRegularFile(releaseFilePath, new LinkOption[0])) {
            Path maybeJre = javaHome.getFileName();
            if (maybeJre == null || !"jre".equals(maybeJre.toString())) {
                return null;
            }
            Path parent = javaHome.getParent();
            if (parent == null) {
                return null;
            }
            releaseFilePath = parent.resolve("release");
            if (!Files.isRegularFile(releaseFilePath, new LinkOption[0])) {
                return null;
            }
        }
        try {
            for (String line : Files.readAllLines(releaseFilePath)) {
                if (!line.startsWith("JAVA_VERSION=")) continue;
                String version = line.substring("JAVA_VERSION=".length()).trim();
                if (version.length() > 2 && version.startsWith("\"") && version.endsWith("\"")) {
                    version = version.substring(1, version.length() - 1);
                }
                return JavaVersion.forVersion(version);
            }
        }
        catch (IOException | NumberFormatException e) {
            this.getLogger().log(Level.WARNING, "Error while trying to read Java version from release file", (Throwable)e);
        }
        return null;
    }

    public void preInitializeContext() {
        assert (this.isInitialized());
        long initStartTimeNanos = System.nanoTime();
        this.getLogger().fine("Loading classes from lib/classlist");
        Path classlistPath = this.getVmProperties().javaHome().resolve("lib").resolve("classlist");
        List<Symbol<Symbol.Type>> classlist = this.readClasslist(classlistPath);
        for (Symbol<Symbol.Type> type : classlist) {
            this.getMeta().loadKlassOrFail(type, StaticObject.NULL, StaticObject.NULL);
        }
        long elapsedNanos = System.nanoTime() - initStartTimeNanos;
        this.getLogger().log(Level.FINE, "Loaded lib/classlist in {0} ms", (Object)TimeUnit.NANOSECONDS.toMillis(elapsedNanos));
        Path userClasslistPath = (Path)this.getEnv().getOptions().get(EspressoOptions.PreInitializationClasslist);
        if (!userClasslistPath.toString().isEmpty()) {
            this.getLanguageCache().logCacheStatus();
            this.getLogger().fine(() -> "Loading classes from user-specified classlist: " + String.valueOf(userClasslistPath));
            initStartTimeNanos = System.nanoTime();
            List<Symbol<Symbol.Type>> additionalClasslist = this.readClasslist(userClasslistPath);
            StaticObject systemClassLoader = (StaticObject)this.meta.java_lang_ClassLoader_getSystemClassLoader.invokeDirect(null, new Object[0]);
            for (Symbol<Symbol.Type> type : additionalClasslist) {
                Klass klass = this.getMeta().loadKlassOrNull(type, systemClassLoader, StaticObject.NULL);
                if (!Objects.isNull(klass)) continue;
                this.getLogger().warning(() -> "Failed to load class from user-specified classlist: " + String.valueOf(type));
            }
            elapsedNanos = System.nanoTime() - initStartTimeNanos;
            this.getLogger().log(Level.FINE, "Loaded user-specified classlist in {0} ms", (Object)TimeUnit.NANOSECONDS.toMillis(elapsedNanos));
        }
    }

    private List<Symbol<Symbol.Type>> readClasslist(Path classlistFilePath) {
        try {
            List<Symbol<Symbol.Type>> classlist = Files.readAllLines(classlistFilePath).stream().filter(line -> !line.isBlank() && !line.startsWith("#") && !line.startsWith("@")).map(Types::internalFromClassName).map(t -> this.getTypes().getOrCreate((String)t)).filter(Objects::nonNull).collect(Collectors.toList());
            return classlist;
        }
        catch (IOException e) {
            this.getLogger().log(Level.WARNING, "Failed to read classlist", (Throwable)e);
            return List.of();
        }
    }

    private StaticObject createBindingsLoader(StaticObject systemClassLoader) {
        if (!this.getEspressoEnv().UseBindingsLoader) {
            return systemClassLoader;
        }
        Klass k = this.getMeta().loadKlassOrNull(Symbol.Type.java_net_URLClassLoader, StaticObject.NULL, StaticObject.NULL);
        if (k == null) {
            return systemClassLoader;
        }
        Method init = k.lookupDeclaredMethod(Symbol.Name._init_, Symbol.Signature._void_URL_array_ClassLoader);
        if (init == null) {
            return systemClassLoader;
        }
        StaticObject loader = k.allocateInstance();
        init.invokeDirect(loader, this.getMeta().java_net_URL.allocateReferenceArray(0), systemClassLoader);
        return loader;
    }

    private NativeAccess spawnNativeAccess() {
        boolean isInPreInit;
        String nativeBackend = this.getEnv().getOptions().hasBeenSet(EspressoOptions.NativeBackend) ? (String)this.getEnv().getOptions().get(EspressoOptions.NativeBackend) : ((isInPreInit = this.getEnv().getConfig().getOrDefault("preinit", false).booleanValue()) || !EspressoOptions.RUNNING_ON_SVM ? (OS.getCurrent() == OS.Linux ? "nfi-dlmopen" : "nfi-llvm") : "nfi-native");
        ArrayList<String> available = new ArrayList<String>();
        for (NativeAccess.Provider provider : NativeAccessCollector.getInstances(NativeAccess.Provider.class)) {
            available.add(provider.id());
            if (!nativeBackend.equals(provider.id())) continue;
            this.getLogger().fine("Native backend: " + nativeBackend);
            return provider.create(this.getEnv());
        }
        throw this.abort("Cannot find native backend '" + nativeBackend + "'. Available backends: " + String.valueOf(available));
    }

    private void initializeAgents() {
        this.agents = new AgentLibraries(this);
        if (this.getEnv().getOptions().hasBeenSet(EspressoOptions.AgentLib)) {
            this.agents.registerAgents((OptionMap<String>)((OptionMap)this.getEnv().getOptions().get(EspressoOptions.AgentLib)), false);
        }
        if (this.getEnv().getOptions().hasBeenSet(EspressoOptions.AgentPath)) {
            this.agents.registerAgents((OptionMap<String>)((OptionMap)this.getEnv().getOptions().get(EspressoOptions.AgentPath)), true);
        }
        if (this.getEnv().getOptions().hasBeenSet(EspressoOptions.JavaAgent)) {
            this.agents.registerAgent("instrument", (String)this.getEnv().getOptions().get(EspressoOptions.JavaAgent), false);
        }
        if (this.espressoEnv.EnableAgents) {
            this.agents.initialize();
        } else if (!this.agents.isEmpty()) {
            this.getLogger().warning("Agents support is currently disabled in Espresso. Ignoring passed agent options.");
        }
    }

    private void initVmProperties() {
        EspressoProperties.Builder builder = EspressoProperties.newPlatformBuilder(this.getEspressoLibs());
        builder.javaHome(this.getEspressoRuntime());
        EspressoProperties.processOptions(builder, this.getEnv().getOptions(), this);
        this.getNativeAccess().updateEspressoProperties(builder, this.getEnv().getOptions());
        this.vmProperties = builder.build();
    }

    private void initializeKnownClass(Symbol<Symbol.Type> type) {
        Klass klass = this.getMeta().loadKlassOrFail(type, StaticObject.NULL, StaticObject.NULL);
        klass.safeInitialize();
    }

    public boolean metaInitialized() {
        return this.metaInitialized;
    }

    public boolean modulesInitialized() {
        return this.modulesInitialized;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public InterpreterToVM getInterpreterToVM() {
        return this.interpreterToVM;
    }

    public VM getVM() {
        return this.vm;
    }

    private JImageLibrary jimageLibrary() {
        if (this.jimageLibrary == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            EspressoError.guarantee(this.getJavaVersion().modulesEnabled(), "Jimage available for java >= 9");
            this.jimageLibrary = new JImageLibrary(this);
        }
        return this.jimageLibrary;
    }

    public JImageHelper createJImageHelper(String jimagePath) {
        if (this.espressoEnv.JImageMode == EspressoOptions.JImageMode.NATIVE) {
            JImageLibrary library = this.jimageLibrary();
            TruffleObject image = library.open(jimagePath);
            if (InteropLibrary.getUncached().isNull((Object)image)) {
                return null;
            }
            return new NativeJImageHelper(library, image);
        }
        assert (this.espressoEnv.JImageMode == EspressoOptions.JImageMode.JAVA);
        try {
            return new JavaJImageHelper(BasicImageReader.open(Paths.get(jimagePath, new String[0])), this);
        }
        catch (BasicImageReader.NotAnImageFile e) {
            return null;
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "failed to open jimage", (Throwable)e);
            return null;
        }
    }

    public JavaVersion getJavaVersion() {
        return this.getLanguage().getJavaVersion();
    }

    public boolean advancedRedefinitionEnabled() {
        return this.espressoEnv.JDWPOptions != null;
    }

    public Types getTypes() {
        return this.getLanguage().getTypes();
    }

    public Signatures getSignatures() {
        return this.getLanguage().getSignatures();
    }

    public JniEnv getJNI() {
        if (this.jniEnv == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.jniEnv = JniEnv.create(this);
        }
        return this.jniEnv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeContext() {
        EspressoContext espressoContext = this;
        synchronized (espressoContext) {
            if (this.disposeCalled) {
                this.getLogger().warning("Context is being disposed multiple times");
                return;
            }
            this.disposeCalled = true;
        }
    }

    public void cleanupNativeEnv() {
        if (this.initialized) {
            this.getVM().dispose();
            this.getJNI().dispose();
        }
    }

    public Substitutions getSubstitutions() {
        return this.substitutions;
    }

    public void setBootstrapMeta(Meta meta) {
        this.meta = meta;
    }

    public Names getNames() {
        return this.getLanguage().getNames();
    }

    public MethodHandleIntrinsics getMethodHandleIntrinsics() {
        return this.methodHandleIntrinsics;
    }

    public EspressoException getStackOverflow() {
        return this.stackOverflow;
    }

    public EspressoException getOutOfMemory() {
        return this.outOfMemory;
    }

    public LazyContextCaches getLazyCaches() {
        LazyContextCaches cache = this.lazyCaches;
        if (cache == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.fatal("Accessing lazy context cache before context initialization");
        }
        return cache;
    }

    public void prepareDispose() {
        if (this.espressoEnv.getJdwpContext() != null) {
            this.espressoEnv.getJdwpContext().finalizeContext();
        }
    }

    public void registerRedefinitionPlugin(InternalRedefinitionPlugin plugin) {
        if (this.redefinitionPlugins == null) {
            this.redefinitionPlugins = Collections.synchronizedMap(new HashMap(2));
        }
        this.redefinitionPlugins.put(plugin.getClass(), plugin);
    }

    @CompilerDirectives.TruffleBoundary
    public <T> T lookup(Class<? extends InternalRedefinitionPlugin> pluginType) {
        if (this.redefinitionPlugins == null) {
            return null;
        }
        return (T)this.redefinitionPlugins.get(pluginType);
    }

    public TruffleObject bindToAgent(Method method, String mangledName) {
        if (this.espressoEnv.EnableAgents) {
            return this.agents.bind(method, mangledName);
        }
        return null;
    }

    public ThreadsAccess getThreadAccess() {
        return this.threads;
    }

    public BlockingSupport<StaticObject> getBlockingSupport() {
        return this.blockingSupport;
    }

    public StaticObject createThread(Thread hostThread) {
        return this.createThread(hostThread, this.getMainThreadGroup(), null, false);
    }

    public StaticObject createThread(Thread hostThread, StaticObject group, String name) {
        return this.createThread(hostThread, group, name, true);
    }

    public StaticObject createThread(Thread hostThread, StaticObject group, String name, boolean managedByEspresso) {
        return this.espressoEnv.getThreadRegistry().createGuestThreadFromHost(hostThread, this.meta, this.vm, name, group, managedByEspresso);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeThread(Thread hostThread) {
        StaticObject guestThread = this.getGuestThreadFromHost(hostThread);
        if (guestThread == null) {
            return;
        }
        try {
            if (this.isFinalized()) {
                return;
            }
            if (hostThread != Thread.currentThread()) {
                String guestName = this.threads.getThreadName(guestThread);
                this.getLogger().warning("unimplemented: disposeThread for non-current thread: " + String.valueOf(hostThread) + " / " + guestName + ". Called from thread: " + String.valueOf(Thread.currentThread()));
                return;
            }
            if (this.vm.DetachCurrentThread(this) != 0) {
                throw new RuntimeException("Could not detach thread correctly");
            }
        }
        finally {
            this.unregisterThread(guestThread);
        }
    }

    public StaticObject getGuestThreadFromHost(Thread host) {
        return this.espressoEnv.getThreadRegistry().getGuestThreadFromHost(host);
    }

    public void registerCurrentThread(StaticObject guestThread) {
        this.getLanguage().getThreadLocalState().initializeCurrentThread(guestThread);
    }

    public StaticObject getCurrentPlatformThread() {
        return this.getLanguage().getThreadLocalState().getCurrentPlatformThread(this);
    }

    public long getPeakThreadCount() {
        return this.espressoEnv.getThreadRegistry().peakThreadCount.get();
    }

    public void resetPeakThreadCount() {
        this.espressoEnv.getThreadRegistry().resetPeakThreadCount();
    }

    public long getCreatedThreadCount() {
        return this.espressoEnv.getThreadRegistry().createdThreadCount.get();
    }

    public StaticObject[] getActiveThreads() {
        return this.espressoEnv.getThreadRegistry().activeThreads();
    }

    public void registerThread(Thread host, StaticObject self) {
        this.espressoEnv.getThreadRegistry().registerThread(host, self);
        if (this.shouldReportVMEvents()) {
            this.espressoEnv.getEventListener().threadStarted(self);
        }
    }

    public void unregisterThread(StaticObject self) {
        boolean unregistered = this.getEspressoEnv().getThreadRegistry().unregisterThread(self);
        if (this.shouldReportVMEvents() && unregistered) {
            this.getEspressoEnv().getEventListener().threadDied(self);
        }
    }

    public void interruptThread(StaticObject guestThread) {
        this.threads.callInterrupt(guestThread);
    }

    public boolean isMainThreadCreated() {
        return this.espressoEnv.getThreadRegistry().isMainThreadCreated();
    }

    public StaticObject getMainThread() {
        return this.espressoEnv.getThreadRegistry().getMainThread();
    }

    public StaticObject getMainThreadGroup() {
        return this.espressoEnv.getThreadRegistry().getMainThreadGroup();
    }

    public void notifyShutdownSynchronizer() {
        EspressoLock lock = this.shutdownManager.getShutdownSynchronizer();
        lock.lock();
        try {
            lock.signalAll();
        }
        finally {
            lock.unlock();
        }
    }

    public void truffleExit(Node location, int exitCode) {
        this.getEnv().getContext().closeExited(location, exitCode);
    }

    public void doExit(int code) {
        this.shutdownManager.doExit(code);
    }

    public void destroyVM() {
        this.shutdownManager.destroyVM();
    }

    public void ensureThreadsJoined() {
        if (this.shutdownManager != null) {
            this.shutdownManager.ensureThreadsJoined();
        }
    }

    public boolean isClosing() {
        return this.shutdownManager.isClosing();
    }

    public boolean isTruffleClosed() {
        return this.getEnv().getContext().isClosed();
    }

    public int getExitStatus() {
        return this.shutdownManager.getExitStatus();
    }

    public EspressoError abort(String message) {
        this.getLogger().severe(message);
        throw new EspressoExitException(1);
    }

    public ReferenceQueue<StaticObject> getReferenceQueue() {
        return this.espressoEnv.getReferenceDrainer().getReferenceQueue();
    }

    public StaticObject getAndClearReferencePendingList() {
        return this.espressoEnv.getReferenceDrainer().getAndClearReferencePendingList();
    }

    public boolean hasReferencePendingList() {
        return this.espressoEnv.getReferenceDrainer().hasReferencePendingList();
    }

    public void waitForReferencePendingList() {
        this.espressoEnv.getReferenceDrainer().waitForReferencePendingList();
    }

    public void triggerDrain() {
        this.espressoEnv.getReferenceDrainer().triggerDrain();
    }

    public TimerCollection getTimers() {
        return this.espressoEnv.getTimers();
    }

    public EspressoBindings getBindings() {
        return this.topBindings;
    }

    public StaticObject getBindingsLoader() {
        return this.bindingsLoader;
    }

    public WeakHashMap<StaticObject, SignalHandler> getHostSignalHandlers() {
        return this.hostSignalHandlers;
    }

    public boolean shouldReportVMEvents() {
        return this.espressoEnv.shouldReportVMEvents();
    }

    public void reportMonitorWait(StaticObject monitor, long timeout) {
        assert (this.shouldReportVMEvents());
        this.espressoEnv.getEventListener().monitorWait(monitor, timeout);
    }

    public void reportMonitorWaited(StaticObject monitor, boolean timedOut) {
        assert (this.shouldReportVMEvents());
        this.espressoEnv.getEventListener().monitorWaited(monitor, timedOut);
    }

    public void reportClassPrepared(ObjectKlass objectKlass, Object prepareThread) {
        assert (this.shouldReportVMEvents());
        this.espressoEnv.getEventListener().classPrepared(objectKlass, prepareThread);
    }

    public void reportOnContendedMonitorEnter(StaticObject obj) {
        assert (this.shouldReportVMEvents());
        this.espressoEnv.getEventListener().onContendedMonitorEnter(obj);
    }

    public void reportOnContendedMonitorEntered(StaticObject obj) {
        assert (this.shouldReportVMEvents());
        this.espressoEnv.getEventListener().onContendedMonitorEntered(obj);
    }

    public boolean reportOnMethodEntry(Method.MethodVersion method, Object scope) {
        assert (this.shouldReportVMEvents());
        return this.espressoEnv.getEventListener().onMethodEntry(method, scope);
    }

    public boolean reportOnMethodReturn(Method.MethodVersion method, Object returnValue) {
        assert (this.shouldReportVMEvents());
        return this.espressoEnv.getEventListener().onMethodReturn(method, returnValue);
    }

    public boolean reportOnFieldModification(Field field, StaticObject receiver, Object value) {
        assert (this.shouldReportVMEvents());
        return this.espressoEnv.getEventListener().onFieldModification(field, receiver, value);
    }

    public boolean reportOnFieldAccess(Field field, StaticObject receiver) {
        assert (this.shouldReportVMEvents());
        return this.espressoEnv.getEventListener().onFieldAccess(field, receiver);
    }

    public void registerExternalHotSwapHandler(StaticObject handler) {
        this.espressoEnv.getJdwpContext().registerExternalHotSwapHandler(handler);
    }

    public void rerunclinit(ObjectKlass oldKlass) {
        this.espressoEnv.getJdwpContext().rerunclinit(oldKlass);
    }

    public static EspressoContext get(Node node) {
        return (EspressoContext)REFERENCE.get(node);
    }

    public synchronized ClassRedefinition createClassRedefinition(Ids<Object> ids, RedefinitionPluginHandler redefinitionPluginHandler, DebuggerController controller) {
        if (this.classRedefinition == null) {
            this.classRedefinition = new ClassRedefinition(this, ids, redefinitionPluginHandler, controller);
        }
        return this.classRedefinition;
    }

    public ClassRedefinition getClassRedefinition() {
        return this.classRedefinition;
    }

    public boolean anyHierarchyChanged() {
        return !this.anyHierarchyChanges.isValid();
    }

    public void markChangedHierarchy() {
        this.anyHierarchyChanges.invalidate();
    }

    public ClassHierarchyOracle getClassHierarchyOracle() {
        return this.espressoEnv.getClassHierarchyOracle();
    }

    public boolean isFinalized() {
        return this.isFinalized;
    }

    public void setFinalized() {
        this.isFinalized = true;
    }

    public boolean explicitTypeMappingsEnabled() {
        return this.getEspressoEnv().getPolyglotTypeMappings().hasMappings();
    }

    public boolean interfaceMappingsEnabled() {
        return this.getEspressoEnv().getPolyglotTypeMappings().hasInterfaceMappings();
    }

    @Idempotent
    public boolean regexSubstitutionsEnabled() {
        return this.getEspressoEnv().RegexSubstitutions && this.getJavaVersion().java21OrLater();
    }

    public PolyglotTypeMappings getPolyglotTypeMappings() {
        return this.getEspressoEnv().getPolyglotTypeMappings();
    }

    public EspressoForeignProxyGenerator.GeneratedProxyBytes getProxyBytesOrNull(String metaName) {
        if (this.getEspressoEnv().getProxyCache() != null) {
            return this.getEspressoEnv().getProxyCache().get(metaName);
        }
        return null;
    }

    public void registerProxyBytes(String metaName, EspressoForeignProxyGenerator.GeneratedProxyBytes generatedProxyBytes) {
        if (this.getEspressoEnv().getProxyCache() == null) {
            throw EspressoError.shouldNotReachHere();
        }
        this.getEspressoEnv().getProxyCache().put(metaName, generatedProxyBytes);
    }

    public long nextThreadId() {
        return this.espressoEnv.getThreadRegistry().nextThreadId();
    }

    public DowncallStubs getDowncallStubs() {
        return this.downcallStubs;
    }

    public UpcallStubs getUpcallStubs() {
        return this.upcallStubs;
    }

    public Path getEspressoLibs() {
        return EspressoLanguage.getEspressoLibs(this.getEnv());
    }

    public Path getEspressoRuntime() {
        return EspressoLanguage.getEspressoRuntime(this.getEnv());
    }
}

