/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.impl.ClassRegistry;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.vm.VM;

public class EspressoThreadLocalState {
    private EspressoException pendingJniException;
    private final ClassRegistry.TypeStack typeStack = new ClassRegistry.TypeStack();
    private final VM.PrivilegedStack privilegedStack;
    private StaticObject currentPlatformThread;
    private StaticObject currentVirtualThread;
    private int suspensionBlocks;
    private boolean inContinuation;
    private int singleSteppingDisabledCounter;

    public EspressoThreadLocalState(EspressoContext context) {
        this.privilegedStack = new VM.PrivilegedStack(context);
    }

    public StaticObject getPendingExceptionObject() {
        EspressoException espressoException = this.getPendingException();
        if (espressoException == null) {
            return null;
        }
        return espressoException.getGuestException();
    }

    public EspressoException getPendingException() {
        return this.pendingJniException;
    }

    public void setPendingException(EspressoException t) {
        this.pendingJniException = t;
    }

    public void clearPendingException() {
        this.setPendingException(null);
    }

    public void setCurrentPlatformThread(StaticObject t) {
        assert (t != null && StaticObject.notNull(t));
        assert (t.getKlass().getContext().getThreadAccess().getHost(t) == Thread.currentThread()) : "Current thread fast access set by non-current thread";
        assert (this.currentPlatformThread == null || this.currentPlatformThread == t) : String.valueOf(this.currentPlatformThread) + " vs " + String.valueOf(t);
        this.currentPlatformThread = t;
    }

    public void setCurrentVirtualThread(StaticObject t) {
        assert (t != null && StaticObject.notNull(t));
        this.currentVirtualThread = t;
    }

    public void initializeCurrentThread(StaticObject t) {
        this.setCurrentPlatformThread(t);
        this.setCurrentVirtualThread(t);
    }

    public void clearCurrentThread(StaticObject expectedGuest) {
        if (this.currentPlatformThread == expectedGuest) {
            this.currentPlatformThread = null;
            this.currentVirtualThread = null;
        } else {
            expectedGuest.getKlass().getContext().getLogger().warning("clearCurrentThread: unexpected currentPlatformThread");
        }
    }

    public StaticObject getCurrentPlatformThread(EspressoContext context) {
        StaticObject result = this.currentPlatformThread;
        if (result == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            context.getLogger().warning("Uninitialized fast current thread lookup for " + String.valueOf(Thread.currentThread()));
            result = context.getGuestThreadFromHost(Thread.currentThread());
            if (result != null) {
                this.setCurrentPlatformThread(result);
            }
            return result;
        }
        return result;
    }

    public StaticObject getCurrentVirtualThread() {
        assert (this.currentVirtualThread != null);
        return this.currentVirtualThread;
    }

    public ClassRegistry.TypeStack getTypeStack() {
        return this.typeStack;
    }

    public VM.PrivilegedStack getPrivilegedStack() {
        return this.privilegedStack;
    }

    public void disableSingleStepping() {
        ++this.singleSteppingDisabledCounter;
    }

    public void enableSingleStepping() {
        assert (this.singleSteppingDisabledCounter > 0);
        --this.singleSteppingDisabledCounter;
    }

    public boolean isSteppingDisabled() {
        return this.singleSteppingDisabledCounter > 0;
    }

    public void blockContinuationSuspension() {
        assert (this.suspensionBlocks < Integer.MAX_VALUE);
        ++this.suspensionBlocks;
    }

    public void unblockContinuationSuspension() {
        assert (this.suspensionBlocks > 0);
        --this.suspensionBlocks;
    }

    public ContinuationScope continuationScope() {
        return new ContinuationScope();
    }

    public boolean isInContinuation() {
        return this.inContinuation;
    }

    public boolean isContinuationSuspensionBlocked() {
        return this.suspensionBlocks > 1;
    }

    public final class ContinuationScope
    implements AutoCloseable {
        private final int startBlocks;

        private ContinuationScope() {
            this.startBlocks = EspressoThreadLocalState.this.suspensionBlocks;
            EspressoThreadLocalState.this.suspensionBlocks = 0;
            assert (!EspressoThreadLocalState.this.inContinuation);
            EspressoThreadLocalState.this.inContinuation = true;
        }

        @Override
        public void close() {
            EspressoThreadLocalState.this.suspensionBlocks = this.startBlocks;
            EspressoThreadLocalState.this.inContinuation = false;
        }
    }
}

