/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.dispatch.staticobject;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidBufferOffsetException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.interop.LookupAndInvokeKnownMethodNode;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.dispatch.messages.GenerateInteropNodes;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.JavaType;
import com.oracle.truffle.espresso.vm.InterpreterToVM;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;

@ExportLibrary(value=InteropLibrary.class, receiverType=StaticObject.class)
@GenerateInteropNodes
public class ByteBufferInterop
extends EspressoInterop {
    @ExportMessage
    static boolean hasBufferElements(StaticObject receiver) {
        receiver.checkNotForeign();
        return true;
    }

    @ExportMessage
    static boolean isBufferWritable(StaticObject receiver, @Bind(value="getMeta().java_nio_Buffer_isReadOnly") Method isReadOnlyMethod, @Cached LookupAndInvokeKnownMethodNode lookup) {
        receiver.checkNotForeign();
        return (Boolean)lookup.execute(receiver, isReadOnlyMethod) == false;
    }

    @ExportMessage
    static long getBufferSize(StaticObject receiver, @Bind(value="getMeta().java_nio_Buffer_limit") Method limitMethod, @Cached LookupAndInvokeKnownMethodNode size) {
        return ((Integer)size.execute(receiver, limitMethod)).intValue();
    }

    @ExportMessage
    static byte readBufferByte(StaticObject receiver, long byteOffset, @Bind(value="getMeta().java_nio_ByteBuffer_getByte") Method getByteMethod, @Cached LookupAndInvokeKnownMethodNode get, @Cached.Shared(value="error") @Cached BranchProfile error) throws InvalidBufferOffsetException {
        if (byteOffset < 0L || Integer.MAX_VALUE < byteOffset) {
            error.enter();
            throw InvalidBufferOffsetException.create((long)byteOffset, (long)1L);
        }
        try {
            return (Byte)get.execute(receiver, getByteMethod, new Object[]{byteOffset});
        }
        catch (EspressoException ex) {
            error.enter();
            if (InterpreterToVM.instanceOf(ex.getGuestException(), receiver.getKlass().getMeta().java_lang_IndexOutOfBoundsException)) {
                throw InvalidBufferOffsetException.create((long)byteOffset, (long)1L);
            }
            throw ex;
        }
    }

    @ExportMessage
    static void writeBufferByte(StaticObject receiver, long byteOffset, byte value, @Bind(value="getMeta().java_nio_Buffer_isReadOnly") Method isReadOnlyMethod, @Cached LookupAndInvokeKnownMethodNode lookup, @Bind(value="getMeta().java_nio_ByteBuffer_putByte") Method putByteAtMethod, @Cached LookupAndInvokeKnownMethodNode put, @Cached.Shared(value="error") @Cached BranchProfile error) throws UnsupportedMessageException, InvalidBufferOffsetException {
        if (byteOffset < 0L || Integer.MAX_VALUE < byteOffset) {
            error.enter();
            throw InvalidBufferOffsetException.create((long)byteOffset, (long)1L);
        }
        if (((Boolean)lookup.execute(receiver, isReadOnlyMethod)).booleanValue()) {
            error.enter();
            throw UnsupportedMessageException.create((Throwable)new ReadOnlyBufferException());
        }
        try {
            put.execute(receiver, putByteAtMethod, new Object[]{byteOffset, value});
        }
        catch (EspressoException ex) {
            error.enter();
            if (InterpreterToVM.instanceOf(ex.getGuestException(), receiver.getKlass().getMeta().java_lang_IndexOutOfBoundsException)) {
                throw InvalidBufferOffsetException.create((long)byteOffset, (long)1L);
            }
            throw ex;
        }
    }

    @ExportMessage
    static short readBufferShort(StaticObject receiver, ByteOrder order, long byteOffset, @Bind(value="getMeta().java_nio_ByteBuffer_getShort") Method getShortMethod, @Cached LookupAndInvokeKnownMethodNode get, @Bind(value="getMeta().java_nio_ByteBuffer_order") Method orderMethod, @Cached LookupAndInvokeKnownMethodNode orderNode, @Bind(value="getMeta().java_nio_ByteBuffer_setOrder") Method setOrderMethod, @Cached LookupAndInvokeKnownMethodNode setOrderNode, @Cached.Shared(value="error") @Cached BranchProfile error) throws InvalidBufferOffsetException {
        if (byteOffset < 0L || Integer.MAX_VALUE < byteOffset) {
            error.enter();
            throw InvalidBufferOffsetException.create((long)byteOffset, (long)2L);
        }
        try {
            return (Short)ByteBufferInterop.get(receiver, byteOffset, order, get, getShortMethod, orderNode, orderMethod, setOrderNode, setOrderMethod);
        }
        catch (EspressoException ex) {
            error.enter();
            if (InterpreterToVM.instanceOf(ex.getGuestException(), receiver.getKlass().getMeta().java_lang_IndexOutOfBoundsException)) {
                throw InvalidBufferOffsetException.create((long)byteOffset, (long)2L);
            }
            throw ex;
        }
    }

    @ExportMessage
    static void writeBufferShort(StaticObject receiver, ByteOrder order, long byteOffset, short value, @Bind(value="getMeta().java_nio_Buffer_isReadOnly") Method isReadOnlyMethod, @Cached LookupAndInvokeKnownMethodNode lookup, @Bind(value="getMeta().java_nio_ByteBuffer_putShort") Method putShortMethod, @Cached LookupAndInvokeKnownMethodNode put, @Bind(value="getMeta().java_nio_ByteBuffer_order") Method orderMethod, @Cached LookupAndInvokeKnownMethodNode orderNode, @Bind(value="getMeta().java_nio_ByteBuffer_setOrder") Method setOrderMethod, @Cached LookupAndInvokeKnownMethodNode setOrderNode, @Cached.Shared(value="error") @Cached BranchProfile error) throws UnsupportedMessageException, InvalidBufferOffsetException {
        if (byteOffset < 0L || Integer.MAX_VALUE < byteOffset) {
            error.enter();
            throw InvalidBufferOffsetException.create((long)byteOffset, (long)2L);
        }
        if (((Boolean)lookup.execute(receiver, isReadOnlyMethod)).booleanValue()) {
            error.enter();
            throw UnsupportedMessageException.create((Throwable)new ReadOnlyBufferException());
        }
        try {
            ByteBufferInterop.put(receiver, byteOffset, value, order, put, putShortMethod, orderNode, orderMethod, setOrderNode, setOrderMethod);
        }
        catch (EspressoException ex) {
            error.enter();
            if (InterpreterToVM.instanceOf(ex.getGuestException(), receiver.getKlass().getMeta().java_lang_IndexOutOfBoundsException)) {
                throw InvalidBufferOffsetException.create((long)byteOffset, (long)2L);
            }
            throw ex;
        }
    }

    @ExportMessage
    static int readBufferInt(StaticObject receiver, ByteOrder order, long byteOffset, @Bind(value="getMeta().java_nio_ByteBuffer_getInt") Method getIntMethod, @Cached LookupAndInvokeKnownMethodNode get, @Bind(value="getMeta().java_nio_ByteBuffer_order") Method orderMethod, @Cached LookupAndInvokeKnownMethodNode orderNode, @Bind(value="getMeta().java_nio_ByteBuffer_setOrder") Method setOrderMethod, @Cached LookupAndInvokeKnownMethodNode setOrderNode, @Cached.Shared(value="error") @Cached BranchProfile error) throws InvalidBufferOffsetException {
        if (byteOffset < 0L || Integer.MAX_VALUE < byteOffset) {
            error.enter();
            throw InvalidBufferOffsetException.create((long)byteOffset, (long)4L);
        }
        try {
            return (Integer)ByteBufferInterop.get(receiver, byteOffset, order, get, getIntMethod, orderNode, orderMethod, setOrderNode, setOrderMethod);
        }
        catch (EspressoException ex) {
            error.enter();
            if (InterpreterToVM.instanceOf(ex.getGuestException(), receiver.getKlass().getMeta().java_lang_IndexOutOfBoundsException)) {
                throw InvalidBufferOffsetException.create((long)byteOffset, (long)4L);
            }
            throw ex;
        }
    }

    @ExportMessage
    static void writeBufferInt(StaticObject receiver, ByteOrder order, long byteOffset, int value, @Bind(value="getMeta().java_nio_Buffer_isReadOnly") Method isReadOnlyMethod, @Cached LookupAndInvokeKnownMethodNode lookup, @Bind(value="getMeta().java_nio_ByteBuffer_putInt") Method putIntMethod, @Cached LookupAndInvokeKnownMethodNode put, @Bind(value="getMeta().java_nio_ByteBuffer_order") Method orderMethod, @Cached LookupAndInvokeKnownMethodNode orderNode, @Bind(value="getMeta().java_nio_ByteBuffer_setOrder") Method setOrderMethod, @Cached LookupAndInvokeKnownMethodNode setOrderNode, @Cached.Shared(value="error") @Cached BranchProfile error) throws UnsupportedMessageException, InvalidBufferOffsetException {
        if (byteOffset < 0L || Integer.MAX_VALUE < byteOffset) {
            error.enter();
            throw InvalidBufferOffsetException.create((long)byteOffset, (long)4L);
        }
        if (((Boolean)lookup.execute(receiver, isReadOnlyMethod)).booleanValue()) {
            error.enter();
            throw UnsupportedMessageException.create((Throwable)new ReadOnlyBufferException());
        }
        try {
            ByteBufferInterop.put(receiver, byteOffset, value, order, put, putIntMethod, orderNode, orderMethod, setOrderNode, setOrderMethod);
        }
        catch (EspressoException ex) {
            error.enter();
            if (InterpreterToVM.instanceOf(ex.getGuestException(), receiver.getKlass().getMeta().java_lang_IndexOutOfBoundsException)) {
                throw InvalidBufferOffsetException.create((long)byteOffset, (long)4L);
            }
            throw ex;
        }
    }

    @ExportMessage
    static long readBufferLong(StaticObject receiver, ByteOrder order, long byteOffset, @Bind(value="getMeta().java_nio_ByteBuffer_getLong") Method getLongMethod, @Cached LookupAndInvokeKnownMethodNode get, @Bind(value="getMeta().java_nio_ByteBuffer_order") Method orderMethod, @Cached LookupAndInvokeKnownMethodNode orderNode, @Bind(value="getMeta().java_nio_ByteBuffer_setOrder") Method setOrderMethod, @Cached LookupAndInvokeKnownMethodNode setOrderNode, @Cached.Shared(value="error") @Cached BranchProfile error) throws InvalidBufferOffsetException {
        if (byteOffset < 0L || Integer.MAX_VALUE < byteOffset) {
            error.enter();
            throw InvalidBufferOffsetException.create((long)byteOffset, (long)8L);
        }
        try {
            return (Long)ByteBufferInterop.get(receiver, byteOffset, order, get, getLongMethod, orderNode, orderMethod, setOrderNode, setOrderMethod);
        }
        catch (EspressoException ex) {
            error.enter();
            if (InterpreterToVM.instanceOf(ex.getGuestException(), receiver.getKlass().getMeta().java_lang_IndexOutOfBoundsException)) {
                throw InvalidBufferOffsetException.create((long)byteOffset, (long)8L);
            }
            throw ex;
        }
    }

    @ExportMessage
    static void writeBufferLong(StaticObject receiver, ByteOrder order, long byteOffset, long value, @Bind(value="getMeta().java_nio_Buffer_isReadOnly") Method isReadOnlyMethod, @Cached LookupAndInvokeKnownMethodNode lookup, @Bind(value="getMeta().java_nio_ByteBuffer_putLong") Method putLongMethod, @Cached LookupAndInvokeKnownMethodNode put, @Bind(value="getMeta().java_nio_ByteBuffer_order") Method orderMethod, @Cached LookupAndInvokeKnownMethodNode orderNode, @Bind(value="getMeta().java_nio_ByteBuffer_setOrder") Method setOrderMethod, @Cached LookupAndInvokeKnownMethodNode setOrderNode, @Cached.Shared(value="error") @Cached BranchProfile error) throws UnsupportedMessageException, InvalidBufferOffsetException {
        if (byteOffset < 0L || Integer.MAX_VALUE < byteOffset) {
            error.enter();
            throw InvalidBufferOffsetException.create((long)byteOffset, (long)8L);
        }
        if (((Boolean)lookup.execute(receiver, isReadOnlyMethod)).booleanValue()) {
            error.enter();
            throw UnsupportedMessageException.create((Throwable)new ReadOnlyBufferException());
        }
        try {
            ByteBufferInterop.put(receiver, byteOffset, value, order, put, putLongMethod, orderNode, orderMethod, setOrderNode, setOrderMethod);
        }
        catch (EspressoException ex) {
            error.enter();
            if (InterpreterToVM.instanceOf(ex.getGuestException(), receiver.getKlass().getMeta().java_lang_IndexOutOfBoundsException)) {
                throw InvalidBufferOffsetException.create((long)byteOffset, (long)8L);
            }
            throw ex;
        }
    }

    @ExportMessage
    static float readBufferFloat(StaticObject receiver, ByteOrder order, long byteOffset, @Bind(value="getMeta().java_nio_ByteBuffer_getFloat") Method getFloatMethod, @Cached LookupAndInvokeKnownMethodNode get, @Bind(value="getMeta().java_nio_ByteBuffer_order") Method orderMethod, @Cached LookupAndInvokeKnownMethodNode orderNode, @Bind(value="getMeta().java_nio_ByteBuffer_setOrder") Method setOrderMethod, @Cached LookupAndInvokeKnownMethodNode setOrderNode, @Cached.Shared(value="error") @Cached BranchProfile error) throws InvalidBufferOffsetException {
        if (byteOffset < 0L || Integer.MAX_VALUE < byteOffset) {
            error.enter();
            throw InvalidBufferOffsetException.create((long)byteOffset, (long)4L);
        }
        try {
            return ((Float)ByteBufferInterop.get(receiver, byteOffset, order, get, getFloatMethod, orderNode, orderMethod, setOrderNode, setOrderMethod)).floatValue();
        }
        catch (EspressoException ex) {
            error.enter();
            if (InterpreterToVM.instanceOf(ex.getGuestException(), receiver.getKlass().getMeta().java_lang_IndexOutOfBoundsException)) {
                throw InvalidBufferOffsetException.create((long)byteOffset, (long)4L);
            }
            throw ex;
        }
    }

    @ExportMessage
    static void writeBufferFloat(StaticObject receiver, ByteOrder order, long byteOffset, float value, @Bind(value="getMeta().java_nio_Buffer_isReadOnly") Method isReadOnlyMethod, @Cached LookupAndInvokeKnownMethodNode lookup, @Bind(value="getMeta().java_nio_ByteBuffer_putFloat") Method putFloatMethod, @Cached LookupAndInvokeKnownMethodNode put, @Bind(value="getMeta().java_nio_ByteBuffer_order") Method orderMethod, @Cached LookupAndInvokeKnownMethodNode orderNode, @Bind(value="getMeta().java_nio_ByteBuffer_setOrder") Method setOrderMethod, @Cached LookupAndInvokeKnownMethodNode setOrderNode, @Cached.Shared(value="error") @Cached BranchProfile error) throws UnsupportedMessageException, InvalidBufferOffsetException {
        if (byteOffset < 0L || Integer.MAX_VALUE < byteOffset) {
            error.enter();
            throw InvalidBufferOffsetException.create((long)byteOffset, (long)4L);
        }
        if (((Boolean)lookup.execute(receiver, isReadOnlyMethod)).booleanValue()) {
            error.enter();
            throw UnsupportedMessageException.create((Throwable)new ReadOnlyBufferException());
        }
        try {
            ByteBufferInterop.put(receiver, byteOffset, Float.valueOf(value), order, put, putFloatMethod, orderNode, orderMethod, setOrderNode, setOrderMethod);
        }
        catch (EspressoException ex) {
            error.enter();
            if (InterpreterToVM.instanceOf(ex.getGuestException(), receiver.getKlass().getMeta().java_lang_IndexOutOfBoundsException)) {
                throw InvalidBufferOffsetException.create((long)byteOffset, (long)4L);
            }
            throw ex;
        }
    }

    @ExportMessage
    static double readBufferDouble(StaticObject receiver, ByteOrder order, long byteOffset, @Bind(value="getMeta().java_nio_ByteBuffer_getDouble") Method getDoubleMethod, @Cached LookupAndInvokeKnownMethodNode get, @Bind(value="getMeta().java_nio_ByteBuffer_order") Method orderMethod, @Cached LookupAndInvokeKnownMethodNode orderNode, @Bind(value="getMeta().java_nio_ByteBuffer_setOrder") Method setOrderMethod, @Cached LookupAndInvokeKnownMethodNode setOrderNode, @Cached.Shared(value="error") @Cached BranchProfile error) throws InvalidBufferOffsetException {
        if (byteOffset < 0L || Integer.MAX_VALUE < byteOffset) {
            error.enter();
            throw InvalidBufferOffsetException.create((long)byteOffset, (long)8L);
        }
        try {
            return (Double)ByteBufferInterop.get(receiver, byteOffset, order, get, getDoubleMethod, orderNode, orderMethod, setOrderNode, setOrderMethod);
        }
        catch (EspressoException ex) {
            error.enter();
            if (InterpreterToVM.instanceOf(ex.getGuestException(), receiver.getKlass().getMeta().java_lang_IndexOutOfBoundsException)) {
                throw InvalidBufferOffsetException.create((long)byteOffset, (long)8L);
            }
            throw ex;
        }
    }

    @ExportMessage
    static void writeBufferDouble(StaticObject receiver, ByteOrder order, long byteOffset, double value, @Bind(value="getMeta().java_nio_Buffer_isReadOnly") Method isReadOnlyMethod, @Cached LookupAndInvokeKnownMethodNode lookup, @Bind(value="getMeta().java_nio_ByteBuffer_putDouble") Method putDoubleMethod, @Cached LookupAndInvokeKnownMethodNode put, @Bind(value="getMeta().java_nio_ByteBuffer_order") Method orderMethod, @Cached LookupAndInvokeKnownMethodNode orderNode, @Bind(value="getMeta().java_nio_ByteBuffer_setOrder") Method setOrderMethod, @Cached LookupAndInvokeKnownMethodNode setOrderNode, @Cached.Shared(value="error") @Cached BranchProfile error) throws UnsupportedMessageException, InvalidBufferOffsetException {
        if (byteOffset < 0L || Integer.MAX_VALUE < byteOffset) {
            error.enter();
            throw InvalidBufferOffsetException.create((long)byteOffset, (long)8L);
        }
        if (((Boolean)lookup.execute(receiver, isReadOnlyMethod)).booleanValue()) {
            error.enter();
            throw UnsupportedMessageException.create((Throwable)new ReadOnlyBufferException());
        }
        try {
            ByteBufferInterop.put(receiver, byteOffset, value, order, put, putDoubleMethod, orderNode, orderMethod, setOrderNode, setOrderMethod);
        }
        catch (EspressoException ex) {
            error.enter();
            if (InterpreterToVM.instanceOf(ex.getGuestException(), receiver.getKlass().getMeta().java_lang_IndexOutOfBoundsException)) {
                throw InvalidBufferOffsetException.create((long)byteOffset, (long)8L);
            }
            throw ex;
        }
    }

    @ExportMessage
    static void readBuffer(StaticObject receiver, long byteOffset, byte[] destination, int destinationOffset, int length, @Bind(value="getMeta()") Meta meta, @Cached LookupAndInvokeKnownMethodNode readBuffer, @Cached.Shared(value="error") @Cached BranchProfile error) throws InvalidBufferOffsetException {
        if (byteOffset < 0L || Integer.MAX_VALUE < byteOffset + (long)length) {
            error.enter();
            throw InvalidBufferOffsetException.create((long)byteOffset, (long)length);
        }
        try {
            if (meta.getJavaVersion().java13OrLater()) {
                readBuffer.execute(receiver, meta.java_nio_ByteBuffer_get, new Object[]{byteOffset, StaticObject.wrap(destination, ByteBufferInterop.getMeta()), destinationOffset, length});
            } else {
                byte[] copy = new byte[destination.length];
                for (int i = 0; i < length; ++i) {
                    copy[i + destinationOffset] = (Byte)readBuffer.execute(receiver, meta.java_nio_ByteBuffer_getByte, new Object[]{byteOffset + (long)i});
                }
                System.arraycopy(copy, 0, destination, 0, copy.length);
            }
        }
        catch (EspressoException ex) {
            error.enter();
            if (InterpreterToVM.instanceOf(ex.getGuestException(), receiver.getKlass().getMeta().java_lang_IndexOutOfBoundsException)) {
                throw InvalidBufferOffsetException.create((long)byteOffset, (long)length);
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object get(StaticObject receiver, long byteOffset, ByteOrder order, LookupAndInvokeKnownMethodNode get, Method getMethod, LookupAndInvokeKnownMethodNode orderNode, Method orderMethod, LookupAndInvokeKnownMethodNode setOrderNode, Method setOrderMethod) {
        Object object;
        StaticObject desiredOrder;
        StaticObject originalOrder = (StaticObject)orderNode.execute(receiver, orderMethod);
        if (originalOrder == (desiredOrder = ByteBufferInterop.toGuestEndian(order, ByteBufferInterop.getMeta()))) {
            return get.execute(receiver, getMethod, new Object[]{byteOffset});
        }
        try {
            setOrderNode.execute(receiver, setOrderMethod, new Object[]{desiredOrder});
            object = get.execute(receiver, getMethod, new Object[]{byteOffset});
        }
        catch (Throwable throwable) {
            setOrderNode.execute(receiver, setOrderMethod, new Object[]{originalOrder});
            throw throwable;
        }
        setOrderNode.execute(receiver, setOrderMethod, new Object[]{originalOrder});
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void put(StaticObject receiver, long byteOffset, Object value, ByteOrder order, LookupAndInvokeKnownMethodNode put, Method putMethod, LookupAndInvokeKnownMethodNode orderNode, Method orderMethod, LookupAndInvokeKnownMethodNode setOrderNode, Method setOrderMethod) {
        StaticObject desiredOrder;
        StaticObject originalOrder = (StaticObject)orderNode.execute(receiver, orderMethod);
        if (originalOrder == (desiredOrder = ByteBufferInterop.toGuestEndian(order, ByteBufferInterop.getMeta()))) {
            put.execute(receiver, putMethod, new Object[]{byteOffset, value});
            return;
        }
        try {
            setOrderNode.execute(receiver, setOrderMethod, new Object[]{desiredOrder});
            put.execute(receiver, putMethod, new Object[]{byteOffset, value});
        }
        catch (Throwable throwable) {
            setOrderNode.execute(receiver, setOrderMethod, new Object[]{originalOrder});
            throw throwable;
        }
        setOrderNode.execute(receiver, setOrderMethod, new Object[]{originalOrder});
    }

    private static @JavaType(value=ByteOrder.class) StaticObject toGuestEndian(ByteOrder order, Meta meta) {
        StaticObject staticStorage = meta.java_nio_ByteOrder.tryInitializeAndGetStatics();
        if (order == ByteOrder.LITTLE_ENDIAN) {
            return meta.java_nio_ByteOrder_LITTLE_ENDIAN.getObject(staticStorage);
        }
        return meta.java_nio_ByteOrder_BIG_ENDIAN.getObject(staticStorage);
    }
}

