/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.dispatch.staticobject;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.nodes.interop.LookupAndInvokeKnownMethodNode;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactory;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropNodes;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInteropInteropNodes;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.IterableInterop;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.IterableInteropInteropNodesFactory;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.Collect;

@Collect(getter="getInstance", value={InteropNodes.class})
public final class IterableInteropInteropNodes
extends InteropNodes {
    private static final Factory factory = new Factory(InteropMessageFactories.dispatchToId(IterableInterop.class));
    private static final InteropNodes INSTANCE = new IterableInteropInteropNodes();

    private IterableInteropInteropNodes() {
        super(IterableInterop.class, EspressoInteropInteropNodes.getInstance());
    }

    public static InteropNodes getInstance() {
        return INSTANCE;
    }

    @Override
    protected void registerMessages(Class<?> cls) {
        InteropMessageFactories.register(cls, InteropMessage.Message.HasIterator, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.GetIterator, factory, false);
    }

    static final class Factory
    implements InteropMessageFactory {
        private final int sourceDispatch;

        Factory(int sourceDispatch) {
            this.sourceDispatch = sourceDispatch;
        }

        @Override
        public final int sourceDispatch() {
            return this.sourceDispatch;
        }

        @Override
        public final InteropMessage create(InteropMessage.Message message) {
            switch (message) {
                case HasIterator: {
                    return IterableInteropInteropNodesFactory.HasIteratorNodeGen.create();
                }
                case GetIterator: {
                    return IterableInteropInteropNodesFactory.GetIteratorNodeGen.create();
                }
            }
            return null;
        }
    }

    static abstract class GetIteratorNode
    extends InteropMessage.GetIterator {
        GetIteratorNode() {
        }

        @Specialization
        static Object getIterator(StaticObject receiver, @Bind(value="getMeta().java_lang_Iterable_iterator") Method iteratorMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode lookupAndInvoke) {
            return IterableInterop.getIterator(receiver, iteratorMethod, lookupAndInvoke);
        }
    }

    static abstract class HasIteratorNode
    extends InteropMessage.HasIterator {
        HasIteratorNode() {
        }

        @Specialization
        static boolean hasIterator(StaticObject receiver) {
            return IterableInterop.hasIterator(receiver);
        }
    }
}

