/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.jimage;

import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.espresso.descriptors.ByteSequence;
import com.oracle.truffle.espresso.runtime.jimage.ImageHeader;
import com.oracle.truffle.espresso.runtime.jimage.ImageLocation;
import com.oracle.truffle.espresso.runtime.jimage.ImageStringsReader;
import com.oracle.truffle.espresso.runtime.jimage.decompressor.Decompressor;
import com.oracle.truffle.espresso.runtime.jimage.decompressor.ResourceDecompressor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;

public class BasicImageReader
implements AutoCloseable,
ResourceDecompressor.StringsProvider {
    public static final TruffleLogger LOGGER = TruffleLogger.getLogger((String)"java", BasicImageReader.class);
    private final ByteOrder byteOrder;
    private final String name;
    private final ByteBuffer memoryMap;
    private final FileChannel channel;
    private final ImageHeader header;
    private final long indexSize;
    private final IntBuffer redirect;
    private final IntBuffer offsets;
    private final ByteBuffer locations;
    private final ByteBuffer strings;
    private final ImageStringsReader stringsReader;
    private final Decompressor decompressor;

    protected BasicImageReader(Path path, ByteOrder byteOrder) throws IOException {
        Path imagePath = Objects.requireNonNull(path);
        this.byteOrder = Objects.requireNonNull(byteOrder);
        this.name = imagePath.toString();
        this.channel = FileChannel.open(imagePath, StandardOpenOption.READ);
        MappedByteBuffer map = this.channel.map(FileChannel.MapMode.READ_ONLY, 0L, this.channel.size());
        int headerSize = ImageHeader.getHeaderSize();
        if (map.capacity() < headerSize) {
            throw new NotAnImageFile();
        }
        this.header = this.readHeader(this.intBuffer(map, 0, headerSize));
        this.indexSize = this.header.getIndexSize();
        this.memoryMap = map.asReadOnlyBuffer();
        if ((long)this.memoryMap.capacity() < this.indexSize) {
            throw new IOException("The image file \"" + this.name + "\" is corrupted");
        }
        this.redirect = this.intBuffer(this.memoryMap, this.header.getRedirectOffset(), this.header.getRedirectSize());
        this.offsets = this.intBuffer(this.memoryMap, this.header.getOffsetsOffset(), this.header.getOffsetsSize());
        this.locations = BasicImageReader.slice(this.memoryMap, this.header.getLocationsOffset(), this.header.getLocationsSize());
        this.strings = BasicImageReader.slice(this.memoryMap, this.header.getStringsOffset(), this.header.getStringsSize());
        this.stringsReader = new ImageStringsReader(this.strings);
        this.decompressor = new Decompressor();
    }

    public static BasicImageReader open(Path path) throws IOException {
        return new BasicImageReader(path, ByteOrder.nativeOrder());
    }

    private ImageHeader readHeader(IntBuffer buffer) throws IOException {
        ImageHeader result = ImageHeader.readFrom(buffer);
        if (result.getMagic() != -889267494) {
            throw new NotAnImageFile();
        }
        if (result.getMajorVersion() != 1 || result.getMinorVersion() != 0) {
            throw new IOException("The image file \"" + this.name + "\" is not the correct version. Major: " + result.getMajorVersion() + ". Minor: " + result.getMinorVersion());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuffer slice(ByteBuffer buffer, int position, int capacity) {
        ByteBuffer byteBuffer = buffer;
        synchronized (byteBuffer) {
            buffer.limit(position + capacity);
            buffer.position(position);
            return buffer.slice();
        }
    }

    private IntBuffer intBuffer(ByteBuffer buffer, int offset, int size) {
        return BasicImageReader.slice(buffer, offset, size).order(this.byteOrder).asIntBuffer();
    }

    @Override
    public void close() throws IOException {
        if (this.channel != null) {
            this.channel.close();
        }
    }

    public ImageLocation findLocation(ByteSequence module, ByteSequence path) {
        int index = this.getLocationIndex(module, path);
        if (index < 0) {
            return null;
        }
        ImageLocation attributes = this.getAttributes(this.offsets.get(index));
        if (!attributes.verify(module, path, this.stringsReader)) {
            return null;
        }
        return attributes;
    }

    public ImageLocation findLocation(ByteSequence path) {
        int index = this.getLocationIndex(path);
        if (index < 0) {
            return null;
        }
        ImageLocation attributes = this.getAttributes(this.offsets.get(index));
        if (!attributes.verify(path, this.stringsReader)) {
            return null;
        }
        return attributes;
    }

    public int getLocationIndex(ByteSequence path) {
        int count = this.header.getTableLength();
        int index = this.redirect.get(ImageStringsReader.hashCode(path) % count);
        if (index < 0) {
            return -index - 1;
        }
        if (index > 0) {
            return ImageStringsReader.hashCode(path, index) % count;
        }
        return -1;
    }

    private int getLocationIndex(ByteSequence module, ByteSequence path) {
        int count = this.header.getTableLength();
        int index = this.redirect.get(ImageStringsReader.hashCode(module, path) % count);
        if (index < 0) {
            return -index - 1;
        }
        if (index > 0) {
            return ImageStringsReader.hashCode(module, path, index) % count;
        }
        return -1;
    }

    public ImageLocation getAttributes(int offset) {
        if (offset < 0 || offset >= this.locations.limit()) {
            throw new IndexOutOfBoundsException(String.format("offset out of bounds: %d not in [0, %d[", offset, this.locations.limit()));
        }
        return ImageLocation.decompress(this.locations, offset);
    }

    @Override
    public String getString(int offset) {
        if (offset < 0 || offset >= this.strings.limit()) {
            throw new IndexOutOfBoundsException(String.format("offset out of bounds: %d not in [0, %d[", offset, this.strings.limit()));
        }
        return ImageStringsReader.stringFromByteBuffer(this.strings, offset);
    }

    @Override
    public ByteBuffer getRawString(int offset) {
        if (offset < 0 || offset >= this.strings.limit()) {
            throw new IndexOutOfBoundsException(String.format("offset out of bounds: %d not in [0, %d[", offset, this.strings.limit()));
        }
        return ImageStringsReader.rawStringFromByteBuffer(this.strings, offset);
    }

    private static byte[] getBufferBytes(ByteBuffer buffer) {
        Objects.requireNonNull(buffer);
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return bytes;
    }

    private ByteBuffer readBuffer(long offset, long size) {
        if (offset < 0L || offset >= Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException("Bad offset: " + offset);
        }
        if (size < 0L || size >= Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException("Bad size: " + size);
        }
        ByteBuffer buffer = BasicImageReader.slice(this.memoryMap, (int)offset, (int)size);
        buffer.order(this.byteOrder);
        return buffer;
    }

    public byte[] getResource(ImageLocation loc) {
        ByteBuffer buffer = this.getResourceBuffer(loc);
        if (buffer != null) {
            return BasicImageReader.getBufferBytes(buffer);
        }
        return null;
    }

    public ByteBuffer getResourceBuffer(ImageLocation loc) {
        Objects.requireNonNull(loc);
        long offset = loc.getContentOffset() + this.indexSize;
        long compressedSize = loc.getCompressedSize();
        long uncompressedSize = loc.getUncompressedSize();
        if (compressedSize < 0L || compressedSize > Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException("Bad compressed size: " + compressedSize);
        }
        if (uncompressedSize < 0L || uncompressedSize > Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException("Bad uncompressed size: " + uncompressedSize);
        }
        if (compressedSize == 0L) {
            return this.readBuffer(offset, uncompressedSize);
        }
        ByteBuffer buffer = this.readBuffer(offset, compressedSize);
        return this.decompressor.decompressResource(this.byteOrder, this, buffer);
    }

    public static final class NotAnImageFile
    extends IOException {
        static final long serialVersionUID = -3240111096036918189L;
    }
}

