/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.nodes.EspressoNode;

public class SubstitutionProfiler
extends EspressoNode {
    @CompilerDirectives.CompilationFinal
    private long profiles = 0L;

    public final void profile(int branch) {
        assert (branch < 64);
        long mask = 1L << branch;
        if ((this.profiles & mask) == 0L) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.reportPolymorphicSpecialize();
            this.profiles |= mask;
        }
    }

    public boolean canSplit() {
        return false;
    }

    public SubstitutionProfiler split() {
        throw EspressoError.shouldNotReachHere();
    }

    public boolean uninitialized() {
        return this.profiles == 0L;
    }

    public boolean isTrivial() {
        return false;
    }
}

