/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.ExceptionType;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.InvalidBufferOffsetException;
import com.oracle.truffle.api.interop.StopIterationException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnknownKeyException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.PrimitiveKlass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.interop.LookupInternalTypeConverterNode;
import com.oracle.truffle.espresso.nodes.interop.LookupTypeConverterNode;
import com.oracle.truffle.espresso.nodes.interop.MethodArgsUtils;
import com.oracle.truffle.espresso.nodes.interop.PolyglotTypeMappings;
import com.oracle.truffle.espresso.nodes.interop.ToEspressoNode;
import com.oracle.truffle.espresso.nodes.interop.ToReference;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.EspressoSubstitutions;
import com.oracle.truffle.espresso.substitutions.JavaType;
import com.oracle.truffle.espresso.substitutions.Substitution;
import com.oracle.truffle.espresso.substitutions.SubstitutionNode;
import com.oracle.truffle.espresso.vm.VM;
import java.math.BigInteger;
import java.nio.ByteOrder;

@EspressoSubstitutions
public final class Target_com_oracle_truffle_espresso_polyglot_Interop {
    private static EspressoException handleAbstractTruffleException(InteropLibrary exceptionInterop, EspressoContext context, LookupTypeConverterNode lookupTypeConverterNode, LookupInternalTypeConverterNode internalTypeConverterNode, BranchProfile exceptionProfile, AbstractTruffleException ex) {
        exceptionProfile.enter();
        Meta meta = context.getMeta();
        StaticObject foreignException = context.getAllocator().createForeignException(context, (Object)ex, exceptionInterop);
        try {
            Object metaObject = exceptionInterop.getMetaObject((Object)ex);
            String metaName = ToEspressoNode.getMetaName(metaObject, exceptionInterop);
            PolyglotTypeMappings.InternalTypeConverter internalTypeConverter = internalTypeConverterNode.execute(metaName);
            if (internalTypeConverter != null) {
                StaticObject convertedGuestException = internalTypeConverter.convertInternal(exceptionInterop, foreignException, meta, null);
                return EspressoException.wrap(convertedGuestException, meta);
            }
            PolyglotTypeMappings.TypeConverter converter = lookupTypeConverterNode.execute(metaName);
            if (converter != null) {
                StaticObject converted = (StaticObject)converter.convert(foreignException);
                meta.java_lang_Throwable_backtrace.setObject(converted, meta.java_lang_Throwable_backtrace.getObject(foreignException));
                if (meta.getJavaVersion().java9OrLater()) {
                    meta.java_lang_Throwable_depth.setInt(converted, meta.java_lang_Throwable_depth.getInt(foreignException));
                }
                meta.java_lang_Throwable_stackTrace.setObject(converted, StaticObject.NULL);
                meta.HIDDEN_FRAMES.setHiddenObject(converted, VM.StackTrace.FOREIGN_MARKER_STACK_TRACE);
                throw EspressoException.wrap(converted, meta);
            }
        }
        catch (UnsupportedMessageException | UnsupportedTypeException e) {
            throw ex;
        }
        throw EspressoException.wrap(foreignException, meta);
    }

    static abstract class ThrowInteropExceptionAsGuest
    extends SubstitutionNode {
        static final int LIMIT = 2;

        ThrowInteropExceptionAsGuest() {
        }

        abstract RuntimeException execute(InteropException var1);

        @Specialization
        RuntimeException doUnsupportedMessageException(UnsupportedMessageException e, @CachedLibrary(limit="LIMIT") InteropLibrary causeInterop, @Cached ConditionProfile noCauseProfile, @Cached(value="create(getMeta().polyglot.UnsupportedMessageException_create.getCallTargetForceInit())") DirectCallNode create, @Cached(value="create(getMeta().polyglot.UnsupportedMessageException_create_Throwable.getCallTargetForceInit())") DirectCallNode createWithCause) {
            Throwable cause = e.getCause();
            assert (cause == null || cause instanceof AbstractTruffleException);
            StaticObject exception = noCauseProfile.profile(cause == null) ? (StaticObject)create.call(new Object[0]) : (StaticObject)createWithCause.call(new Object[]{InteropUtils.maybeWrapAsForeignException(cause, causeInterop, this.getContext())});
            throw EspressoException.wrap(exception, this.getMeta());
        }

        @Specialization
        RuntimeException doUnknownIdentifierException(UnknownIdentifierException e, @CachedLibrary(limit="LIMIT") InteropLibrary causeInterop, @Cached ConditionProfile noCauseProfile, @Cached(value="create(getMeta().polyglot.UnknownIdentifierException_create_String.getCallTargetForceInit())") DirectCallNode createWithIdentifier, @Cached(value="create(getMeta().polyglot.UnknownIdentifierException_create_String_Throwable.getCallTargetForceInit())") DirectCallNode createWithIdentifierAndCause) {
            StaticObject unknownIdentifier = this.getMeta().toGuestString(e.getUnknownIdentifier());
            Throwable cause = e.getCause();
            StaticObject exception = noCauseProfile.profile(cause == null || !(cause instanceof AbstractTruffleException)) ? (StaticObject)createWithIdentifier.call(new Object[]{unknownIdentifier}) : (StaticObject)createWithIdentifierAndCause.call(new Object[]{unknownIdentifier, InteropUtils.maybeWrapAsForeignException(cause, causeInterop, this.getContext())});
            throw EspressoException.wrap(exception, this.getMeta());
        }

        @Specialization
        RuntimeException doArityException(ArityException e, @CachedLibrary(limit="LIMIT") InteropLibrary causeInterop, @Cached ConditionProfile noCauseProfile, @Cached(value="create(getMeta().polyglot.ArityException_create_int_int_int.getCallTargetForceInit())") DirectCallNode createWithArityRange, @Cached(value="create(getMeta().polyglot.ArityException_create_int_int_int_Throwable.getCallTargetForceInit())") DirectCallNode createWithArityRangeAndCause) {
            int expectedMinArity = e.getExpectedMinArity();
            int expectedMaxArity = e.getExpectedMaxArity();
            int actualArity = e.getActualArity();
            Throwable cause = e.getCause();
            StaticObject exception = noCauseProfile.profile(cause == null || !(cause instanceof AbstractTruffleException)) ? (StaticObject)createWithArityRange.call(new Object[]{expectedMinArity, expectedMaxArity, actualArity}) : (StaticObject)createWithArityRangeAndCause.call(new Object[]{expectedMinArity, expectedMinArity, actualArity, InteropUtils.maybeWrapAsForeignException(cause, causeInterop, this.getContext())});
            throw EspressoException.wrap(exception, this.getMeta());
        }

        @Specialization
        RuntimeException doUnsupportedTypeException(UnsupportedTypeException e, @CachedLibrary(limit="LIMIT") InteropLibrary causeInterop, @Cached ConditionProfile noCauseProfile, @Cached(value="create(getMeta().polyglot.UnsupportedTypeException_create_Object_array_String.getCallTargetForceInit())") DirectCallNode createWithValuesHint, @Cached(value="create(getMeta().polyglot.UnsupportedTypeException_create_Object_array_String_Throwable.getCallTargetForceInit())") DirectCallNode createWithValuesHintAndCause) {
            Object[] hostValues = e.getSuppliedValues();
            StaticObject[] backingArray = new StaticObject[hostValues.length];
            for (int i = 0; i < backingArray.length; ++i) {
                backingArray[i] = InteropUtils.maybeWrapAsObject(hostValues[i], InteropLibrary.getUncached(), this.getContext());
            }
            StaticObject suppliedValues = StaticObject.wrap(backingArray, this.getMeta());
            StaticObject hint = this.getMeta().toGuestString(e.getMessage());
            Throwable cause = e.getCause();
            StaticObject exception = noCauseProfile.profile(cause == null || !(cause instanceof AbstractTruffleException)) ? (StaticObject)createWithValuesHint.call(new Object[]{suppliedValues, hint}) : (StaticObject)createWithValuesHintAndCause.call(new Object[]{suppliedValues, hint, InteropUtils.maybeWrapAsForeignException(cause, causeInterop, this.getContext())});
            throw EspressoException.wrap(exception, this.getMeta());
        }

        @Specialization
        RuntimeException doInvalidArrayIndexException(InvalidArrayIndexException e, @CachedLibrary(limit="LIMIT") InteropLibrary causeInterop, @Cached ConditionProfile noCauseProfile, @Cached(value="create(getMeta().polyglot.InvalidArrayIndexException_create_long.getCallTargetForceInit())") DirectCallNode createWithIndex, @Cached(value="create(getMeta().polyglot.InvalidArrayIndexException_create_long_Throwable.getCallTargetForceInit())") DirectCallNode createWithIndexAndCause) {
            long invalidIndex = e.getInvalidIndex();
            Throwable cause = e.getCause();
            StaticObject exception = noCauseProfile.profile(cause == null || !(cause instanceof AbstractTruffleException)) ? (StaticObject)createWithIndex.call(new Object[]{invalidIndex}) : (StaticObject)createWithIndexAndCause.call(new Object[]{invalidIndex, InteropUtils.maybeWrapAsObject(cause, causeInterop, this.getContext())});
            throw EspressoException.wrap(exception, this.getMeta());
        }

        @Specialization
        RuntimeException doInvalidBufferOffsetException(InvalidBufferOffsetException e, @CachedLibrary(limit="LIMIT") InteropLibrary causeInterop, @Cached ConditionProfile noCauseProfile, @Cached(value="create(getMeta().polyglot.InvalidBufferOffsetException_create_long_long.getCallTargetForceInit())") DirectCallNode createWithOffsetLength, @Cached(value="create(getMeta().polyglot.InvalidBufferOffsetException_create_long_long_Throwable.getCallTargetForceInit())") DirectCallNode createWithOffsetLengthAndCause) {
            long byteOffset = e.getByteOffset();
            long length = e.getLength();
            Throwable cause = e.getCause();
            StaticObject exception = noCauseProfile.profile(cause == null || !(cause instanceof AbstractTruffleException)) ? (StaticObject)createWithOffsetLength.call(new Object[]{byteOffset, length}) : (StaticObject)createWithOffsetLengthAndCause.call(new Object[]{byteOffset, length, InteropUtils.maybeWrapAsForeignException(cause, causeInterop, this.getContext())});
            throw EspressoException.wrap(exception, this.getMeta());
        }

        @Specialization
        RuntimeException doStopIterationException(StopIterationException e, @CachedLibrary(limit="LIMIT") InteropLibrary causeInterop, @Cached ConditionProfile noCauseProfile, @Cached(value="create(getMeta().polyglot.StopIterationException_create.getCallTargetForceInit())") DirectCallNode create, @Cached(value="create(getMeta().polyglot.StopIterationException_create_Throwable.getCallTargetForceInit())") DirectCallNode createWithCause) {
            Throwable cause = e.getCause();
            StaticObject exception = noCauseProfile.profile(cause == null || !(cause instanceof AbstractTruffleException)) ? (StaticObject)create.call(new Object[0]) : (StaticObject)createWithCause.call(new Object[]{InteropUtils.maybeWrapAsForeignException(cause, causeInterop, this.getContext())});
            throw EspressoException.wrap(exception, this.getMeta());
        }

        @Specialization
        RuntimeException doUnknownKeyException(UnknownKeyException e, @CachedLibrary(limit="LIMIT") InteropLibrary keyInterop, @CachedLibrary(limit="LIMIT") InteropLibrary causeInterop, @Cached ConditionProfile noCauseProfile, @Cached(value="create(getMeta().polyglot.UnknownKeyException_create_Object.getCallTargetForceInit())") DirectCallNode createWithKey, @Cached(value="create(getMeta().polyglot.UnknownKeyException_create_Object_Throwable.getCallTargetForceInit())") DirectCallNode createWithKeyAndCause) {
            StaticObject unknownKey = InteropUtils.maybeWrapAsObject(e.getUnknownKey(), keyInterop, this.getContext());
            Throwable cause = e.getCause();
            StaticObject exception = noCauseProfile.profile(cause == null || !(cause instanceof AbstractTruffleException)) ? (StaticObject)createWithKey.call(new Object[]{unknownKey}) : (StaticObject)createWithKeyAndCause.call(new Object[]{unknownKey, InteropUtils.maybeWrapAsObject(cause, causeInterop, this.getContext())});
            throw EspressoException.wrap(exception, this.getMeta());
        }

        @CompilerDirectives.TruffleBoundary
        @Fallback
        RuntimeException shouldNotReachHere(InteropException e) {
            throw EspressoError.shouldNotReachHere("Unexpected host interop exception", e);
        }
    }

    static abstract class ToHostArguments
    extends SubstitutionNode {
        private static final Object[] EMPTY_ARRAY = new Object[0];

        ToHostArguments() {
        }

        abstract Object[] execute(boolean var1, @JavaType(value=Object[].class) StaticObject var2);

        @Specialization(guards={"!unwrapArguments", "arguments.isEspressoObject()"})
        Object[] doEspressoNoUnwrap(boolean unwrapArguments, @JavaType(value=Object[].class) StaticObject arguments) {
            return (Object[])arguments.unwrap(this.getLanguage());
        }

        @Specialization(guards={"unwrapArguments", "arguments.isEspressoObject()"})
        Object[] doEspressoUnwrap(boolean unwrapArguments, @JavaType(value=Object[].class) StaticObject arguments) {
            EspressoLanguage language = this.getLanguage();
            Object[] rawArgs = (Object[])arguments.unwrap(language);
            if (rawArgs.length == 0) {
                return EMPTY_ARRAY;
            }
            Object[] hostArgs = new Object[rawArgs.length];
            for (int i = 0; i < rawArgs.length; ++i) {
                hostArgs[i] = InteropUtils.unwrap(language, (StaticObject)rawArgs[i], this.getMeta());
            }
            return hostArgs;
        }

        @Specialization(guards={"arguments.isForeignObject()"})
        Object[] doForeign(boolean unwrapArguments, @JavaType(value=Object[].class) StaticObject arguments, @Cached GetArraySize getArraySize, @Cached ReadArrayElement readArrayElement) {
            EspressoLanguage language = this.getLanguage();
            int argsLength = Math.toIntExact(getArraySize.execute(arguments));
            if (argsLength == 0) {
                return EMPTY_ARRAY;
            }
            Object[] hostArgs = new Object[argsLength];
            for (int i = 0; i < argsLength; ++i) {
                StaticObject elem = readArrayElement.execute(arguments, i);
                hostArgs[i] = unwrapArguments ? InteropUtils.unwrap(language, elem, this.getMeta()) : elem;
            }
            return hostArgs;
        }
    }

    @Substitution
    static abstract class GetHashValuesIterator
    extends SubstitutionNode {
        static final int LIMIT = 2;

        GetHashValuesIterator() {
        }

        abstract @JavaType(value=Object.class) StaticObject execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        @JavaType(value=Object.class) StaticObject doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @CachedLibrary(limit="LIMIT") InteropLibrary iteratorInterop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile) {
            try {
                Object iterator = interop.getHashValuesIterator(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
                assert (InteropLibrary.getUncached().isIterator(iterator));
                return InteropUtils.maybeWrapAsObject(iterator, iteratorInterop, this.getContext());
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    static abstract class GetHashKeysIterator
    extends SubstitutionNode {
        static final int LIMIT = 2;

        GetHashKeysIterator() {
        }

        abstract @JavaType(value=Object.class) StaticObject execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        @JavaType(value=Object.class) StaticObject doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @CachedLibrary(limit="LIMIT") InteropLibrary iteratorInterop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile) {
            try {
                Object iterator = interop.getHashKeysIterator(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
                assert (InteropLibrary.getUncached().isIterator(iterator));
                return InteropUtils.maybeWrapAsObject(iterator, iteratorInterop, this.getContext());
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    static abstract class GetHashEntriesIterator
    extends SubstitutionNode {
        static final int LIMIT = 2;

        GetHashEntriesIterator() {
        }

        abstract @JavaType(value=Object.class) StaticObject execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        @JavaType(value=Object.class) StaticObject doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @CachedLibrary(limit="LIMIT") InteropLibrary iteratorInterop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile) {
            try {
                Object iterator = interop.getHashEntriesIterator(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
                assert (InteropLibrary.getUncached().isIterator(iterator));
                return InteropUtils.maybeWrapAsObject(iterator, iteratorInterop, this.getContext());
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    static abstract class IsHashEntryExisting
    extends SubstitutionNode {
        static final int LIMIT = 2;

        IsHashEntryExisting() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, @JavaType(value=Object.class) StaticObject key, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ConditionProfile isForeignProfile) {
            if (isForeignProfile.profile(receiver.isForeignObject())) {
                EspressoLanguage language = this.getLanguage();
                return interop.isHashEntryExisting(InteropUtils.unwrapForeign(language, receiver), InteropUtils.unwrap(language, key, this.getMeta()));
            }
            return interop.isHashEntryExisting((Object)receiver, (Object)key);
        }
    }

    @Substitution
    static abstract class RemoveHashEntry
    extends SubstitutionNode {
        static final int LIMIT = 2;

        RemoveHashEntry() {
        }

        abstract void execute(@JavaType(value=Object.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2);

        @Specialization
        void doCached(@JavaType(value=Object.class) StaticObject receiver, @JavaType(value=Object.class) StaticObject key, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @CachedLibrary(limit="LIMIT") InteropLibrary exceptionInterop, @Cached LookupTypeConverterNode lookupTypeConverterNode, @Cached LookupInternalTypeConverterNode lookupInternalTypeConverterNode, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile, @Cached ConditionProfile isForeignProfile) {
            try {
                if (isForeignProfile.profile(receiver.isForeignObject())) {
                    EspressoLanguage language = this.getLanguage();
                    interop.removeHashEntry(InteropUtils.unwrapForeign(language, receiver), InteropUtils.unwrap(language, key, this.getMeta()));
                } else {
                    interop.removeHashEntry((Object)receiver, (Object)key);
                }
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
            catch (AbstractTruffleException ex) {
                throw Target_com_oracle_truffle_espresso_polyglot_Interop.handleAbstractTruffleException(exceptionInterop, this.getContext(), lookupTypeConverterNode, lookupInternalTypeConverterNode, exceptionProfile, ex);
            }
        }
    }

    @Substitution
    static abstract class IsHashEntryRemovable
    extends SubstitutionNode {
        static final int LIMIT = 2;

        IsHashEntryRemovable() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, @JavaType(value=Object.class) StaticObject key, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ConditionProfile isForeignProfile) {
            if (isForeignProfile.profile(receiver.isForeignObject())) {
                EspressoLanguage language = this.getLanguage();
                return interop.isHashEntryRemovable(InteropUtils.unwrapForeign(language, receiver), InteropUtils.unwrap(language, key, this.getMeta()));
            }
            return interop.isHashEntryRemovable((Object)receiver, (Object)key);
        }
    }

    @Substitution
    static abstract class WriteHashEntry
    extends SubstitutionNode {
        static final int LIMIT = 2;

        WriteHashEntry() {
        }

        abstract void execute(@JavaType(value=Object.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, @JavaType(value=Object.class) StaticObject var3);

        @Specialization
        void doCached(@JavaType(value=Object.class) StaticObject receiver, @JavaType(value=Object.class) StaticObject key, @JavaType(value=Object.class) StaticObject value, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @CachedLibrary(limit="LIMIT") InteropLibrary exceptionInterop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached LookupTypeConverterNode lookupTypeConverterNode, @Cached LookupInternalTypeConverterNode lookupInternalTypeConverterNode, @Cached BranchProfile exceptionProfile, @Cached ConditionProfile isForeignProfile) {
            try {
                if (isForeignProfile.profile(receiver.isForeignObject())) {
                    EspressoLanguage language = this.getLanguage();
                    interop.writeHashEntry(InteropUtils.unwrapForeign(language, receiver), InteropUtils.unwrap(language, key, this.getMeta()), InteropUtils.unwrap(language, value, this.getMeta()));
                } else {
                    interop.writeHashEntry((Object)receiver, (Object)key, (Object)value);
                }
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
            catch (AbstractTruffleException ex) {
                throw Target_com_oracle_truffle_espresso_polyglot_Interop.handleAbstractTruffleException(exceptionInterop, this.getContext(), lookupTypeConverterNode, lookupInternalTypeConverterNode, exceptionProfile, ex);
            }
        }
    }

    @Substitution
    static abstract class IsHashEntryWritable
    extends SubstitutionNode {
        static final int LIMIT = 2;

        IsHashEntryWritable() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, @JavaType(value=Object.class) StaticObject key, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ConditionProfile isForeignProfile) {
            if (isForeignProfile.profile(receiver.isForeignObject())) {
                EspressoLanguage language = this.getLanguage();
                return interop.isHashEntryWritable(InteropUtils.unwrapForeign(language, receiver), InteropUtils.unwrap(language, key, this.getMeta()));
            }
            return interop.isHashEntryWritable((Object)receiver, (Object)key);
        }
    }

    @Substitution
    static abstract class IsHashEntryInsertable
    extends SubstitutionNode {
        static final int LIMIT = 2;

        IsHashEntryInsertable() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, @JavaType(value=Object.class) StaticObject key, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ConditionProfile isForeignProfile) {
            if (isForeignProfile.profile(receiver.isForeignObject())) {
                EspressoLanguage language = this.getLanguage();
                return interop.isHashEntryInsertable(InteropUtils.unwrapForeign(language, receiver), InteropUtils.unwrap(language, key, this.getMeta()));
            }
            return interop.isHashEntryInsertable((Object)receiver, (Object)key);
        }
    }

    @Substitution
    static abstract class IsHashEntryModifiable
    extends SubstitutionNode {
        static final int LIMIT = 2;

        IsHashEntryModifiable() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, @JavaType(value=Object.class) StaticObject key, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ConditionProfile isForeignProfile) {
            if (isForeignProfile.profile(receiver.isForeignObject())) {
                EspressoLanguage language = this.getLanguage();
                return interop.isHashEntryModifiable(InteropUtils.unwrapForeign(language, receiver), InteropUtils.unwrap(language, key, this.getMeta()));
            }
            return interop.isHashEntryModifiable((Object)receiver, (Object)key);
        }
    }

    @Substitution
    static abstract class ReadHashValueOrDefault
    extends SubstitutionNode {
        static final int LIMIT = 2;

        ReadHashValueOrDefault() {
        }

        abstract @JavaType(value=Object.class) StaticObject execute(@JavaType(value=Object.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, @JavaType(value=Object.class) StaticObject var3);

        @Specialization
        @JavaType(value=Object.class) StaticObject doCached(@JavaType(value=Object.class) StaticObject receiver, @JavaType(value=Object.class) StaticObject key, @JavaType(value=Object.class) StaticObject defaultValue, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @CachedLibrary(limit="LIMIT") InteropLibrary valueInterop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile, @Cached ConditionProfile isForeignProfile) {
            try {
                if (isForeignProfile.profile(receiver.isForeignObject())) {
                    EspressoLanguage language = this.getLanguage();
                    Object unwrappedDefaultValue = InteropUtils.unwrap(language, defaultValue, this.getMeta());
                    Object result = interop.readHashValueOrDefault(InteropUtils.unwrapForeign(language, receiver), InteropUtils.unwrap(language, key, this.getMeta()), unwrappedDefaultValue);
                    if (result == unwrappedDefaultValue) {
                        return defaultValue;
                    }
                    return InteropUtils.maybeWrapAsObject(result, valueInterop, this.getContext());
                }
                Object result = interop.readHashValueOrDefault((Object)receiver, (Object)key, (Object)defaultValue);
                return InteropUtils.maybeWrapAsObject(result, valueInterop, this.getContext());
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    static abstract class ReadHashValue
    extends SubstitutionNode {
        static final int LIMIT = 2;

        ReadHashValue() {
        }

        abstract @JavaType(value=Object.class) StaticObject execute(@JavaType(value=Object.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2);

        @Specialization
        @JavaType(value=Object.class) StaticObject doCached(@JavaType(value=Object.class) StaticObject receiver, @JavaType(value=Object.class) StaticObject key, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @CachedLibrary(limit="LIMIT") InteropLibrary valueInterop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile, @Cached ConditionProfile isForeignProfile) {
            try {
                Object result;
                if (isForeignProfile.profile(receiver.isForeignObject())) {
                    EspressoLanguage language = this.getLanguage();
                    result = interop.readHashValue(InteropUtils.unwrapForeign(language, receiver), InteropUtils.unwrap(language, key, this.getMeta()));
                } else {
                    result = interop.readHashValue((Object)receiver, (Object)key);
                }
                return InteropUtils.maybeWrapAsObject(result, valueInterop, this.getContext());
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    static abstract class IsHashEntryReadable
    extends SubstitutionNode {
        static final int LIMIT = 2;

        IsHashEntryReadable() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, @JavaType(value=Object.class) StaticObject key, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ConditionProfile isForeignProfile) {
            if (isForeignProfile.profile(receiver.isForeignObject())) {
                EspressoLanguage language = this.getLanguage();
                return interop.isHashEntryReadable(InteropUtils.unwrapForeign(language, receiver), InteropUtils.unwrap(language, key, this.getMeta()));
            }
            return interop.isHashEntryReadable((Object)receiver, (Object)key);
        }
    }

    @Substitution
    static abstract class GetHashSize
    extends SubstitutionNode {
        static final int LIMIT = 2;

        GetHashSize() {
        }

        abstract long execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        long doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile) {
            try {
                return interop.getHashSize(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    static abstract class HasHashEntries
    extends SubstitutionNode {
        static final int LIMIT = 2;

        HasHashEntries() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return interop.hasHashEntries(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
        }
    }

    @Substitution
    static abstract class GetIteratorNextElement
    extends SubstitutionNode {
        static final int LIMIT = 2;

        GetIteratorNextElement() {
        }

        abstract @JavaType(value=Object.class) StaticObject execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        @JavaType(value=Object.class) StaticObject doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @CachedLibrary(limit="LIMIT") InteropLibrary valueInterop, @CachedLibrary(limit="LIMIT") InteropLibrary exceptionInterop, @Cached LookupTypeConverterNode lookupTypeConverterNode, @Cached LookupInternalTypeConverterNode lookupInternalTypeConverterNode, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile) {
            try {
                Object element = interop.getIteratorNextElement(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
                return InteropUtils.maybeWrapAsObject(element, valueInterop, this.getContext());
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
            catch (AbstractTruffleException ex) {
                throw Target_com_oracle_truffle_espresso_polyglot_Interop.handleAbstractTruffleException(exceptionInterop, this.getContext(), lookupTypeConverterNode, lookupInternalTypeConverterNode, exceptionProfile, ex);
            }
        }
    }

    @Substitution
    static abstract class HasIteratorNextElement
    extends SubstitutionNode {
        static final int LIMIT = 2;

        HasIteratorNextElement() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile) {
            try {
                return interop.hasIteratorNextElement(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    static abstract class IsIterator
    extends SubstitutionNode {
        static final int LIMIT = 2;

        IsIterator() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return interop.isIterator(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
        }
    }

    @Substitution
    static abstract class GetIterator
    extends SubstitutionNode {
        static final int LIMIT = 2;

        GetIterator() {
        }

        abstract @JavaType(value=Object.class) StaticObject execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        @JavaType(value=Object.class) StaticObject doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @CachedLibrary(limit="LIMIT") InteropLibrary iteratorInterop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile) {
            try {
                Object iterator = interop.getIterator(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
                assert (InteropLibrary.getUncached().isIterator(iterator));
                return InteropUtils.maybeWrapAsObject(iterator, iteratorInterop, this.getContext());
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    static abstract class HasIterator
    extends SubstitutionNode {
        static final int LIMIT = 2;

        HasIterator() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return interop.hasIterator(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
        }
    }

    @Substitution
    @ImportStatic(value={InteropUtils.class})
    static abstract class WriteBufferDouble
    extends SubstitutionNode {
        static final int LIMIT = 2;

        WriteBufferDouble() {
        }

        abstract void execute(@JavaType(value=Object.class) StaticObject var1, @JavaType(value=ByteOrder.class) StaticObject var2, long var3, double var5);

        @Specialization
        void doCached(@JavaType(value=Object.class) StaticObject receiver, @JavaType(value=ByteOrder.class) StaticObject order, long byteOffset, double value, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile, @Cached(value="getLittleEndian(getContext())") @JavaType(value=ByteOrder.class) StaticObject littleEndian) {
            try {
                interop.writeBufferDouble(InteropUtils.unwrapForeign(this.getLanguage(), receiver), order == littleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN, byteOffset, value);
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    @ImportStatic(value={InteropUtils.class})
    static abstract class ReadBufferDouble
    extends SubstitutionNode {
        static final int LIMIT = 2;

        ReadBufferDouble() {
        }

        abstract double execute(@JavaType(value=Object.class) StaticObject var1, @JavaType(value=ByteOrder.class) StaticObject var2, long var3);

        @Specialization
        double doCached(@JavaType(value=Object.class) StaticObject receiver, @JavaType(value=ByteOrder.class) StaticObject order, long byteOffset, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile, @Cached(value="getLittleEndian(getContext())") @JavaType(value=ByteOrder.class) StaticObject littleEndian) {
            try {
                return interop.readBufferDouble(InteropUtils.unwrapForeign(this.getLanguage(), receiver), order == littleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN, byteOffset);
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    @ImportStatic(value={InteropUtils.class})
    static abstract class WriteBufferFloat
    extends SubstitutionNode {
        static final int LIMIT = 2;

        WriteBufferFloat() {
        }

        abstract void execute(@JavaType(value=Object.class) StaticObject var1, @JavaType(value=ByteOrder.class) StaticObject var2, long var3, float var5);

        @Specialization
        void doCached(@JavaType(value=Object.class) StaticObject receiver, @JavaType(value=ByteOrder.class) StaticObject order, long byteOffset, float value, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile, @Cached(value="getLittleEndian(getContext())") @JavaType(value=ByteOrder.class) StaticObject littleEndian) {
            try {
                interop.writeBufferFloat(InteropUtils.unwrapForeign(this.getLanguage(), receiver), order == littleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN, byteOffset, value);
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    @ImportStatic(value={InteropUtils.class})
    static abstract class ReadBufferFloat
    extends SubstitutionNode {
        static final int LIMIT = 2;

        ReadBufferFloat() {
        }

        abstract float execute(@JavaType(value=Object.class) StaticObject var1, @JavaType(value=ByteOrder.class) StaticObject var2, long var3);

        @Specialization
        float doCached(@JavaType(value=Object.class) StaticObject receiver, @JavaType(value=ByteOrder.class) StaticObject order, long byteOffset, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile, @Cached(value="getLittleEndian(getContext())") @JavaType(value=ByteOrder.class) StaticObject littleEndian) {
            try {
                return interop.readBufferFloat(InteropUtils.unwrapForeign(this.getLanguage(), receiver), order == littleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN, byteOffset);
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    @ImportStatic(value={InteropUtils.class})
    static abstract class WriteBufferLong
    extends SubstitutionNode {
        static final int LIMIT = 2;

        WriteBufferLong() {
        }

        abstract void execute(@JavaType(value=Object.class) StaticObject var1, @JavaType(value=ByteOrder.class) StaticObject var2, long var3, long var5);

        @Specialization
        void doCached(@JavaType(value=Object.class) StaticObject receiver, @JavaType(value=ByteOrder.class) StaticObject order, long byteOffset, long value, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile, @Cached(value="getLittleEndian(getContext())") @JavaType(value=ByteOrder.class) StaticObject littleEndian) {
            try {
                interop.writeBufferLong(InteropUtils.unwrapForeign(this.getLanguage(), receiver), order == littleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN, byteOffset, value);
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    @ImportStatic(value={InteropUtils.class})
    static abstract class ReadBufferLong
    extends SubstitutionNode {
        static final int LIMIT = 2;

        ReadBufferLong() {
        }

        abstract long execute(@JavaType(value=Object.class) StaticObject var1, @JavaType(value=ByteOrder.class) StaticObject var2, long var3);

        @Specialization
        long doCached(@JavaType(value=Object.class) StaticObject receiver, @JavaType(value=ByteOrder.class) StaticObject order, long byteOffset, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile, @Cached(value="getLittleEndian(getContext())") @JavaType(value=ByteOrder.class) StaticObject littleEndian) {
            try {
                return interop.readBufferLong(InteropUtils.unwrapForeign(this.getLanguage(), receiver), order == littleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN, byteOffset);
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    @ImportStatic(value={InteropUtils.class})
    static abstract class WriteBufferInt
    extends SubstitutionNode {
        static final int LIMIT = 2;

        WriteBufferInt() {
        }

        abstract void execute(@JavaType(value=Object.class) StaticObject var1, @JavaType(value=ByteOrder.class) StaticObject var2, long var3, int var5);

        @Specialization
        void doCached(@JavaType(value=Object.class) StaticObject receiver, @JavaType(value=ByteOrder.class) StaticObject order, long byteOffset, int value, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile, @Cached(value="getLittleEndian(getContext())") @JavaType(value=ByteOrder.class) StaticObject littleEndian) {
            try {
                interop.writeBufferInt(InteropUtils.unwrapForeign(this.getLanguage(), receiver), order == littleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN, byteOffset, value);
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    @ImportStatic(value={InteropUtils.class})
    static abstract class ReadBufferInt
    extends SubstitutionNode {
        static final int LIMIT = 2;

        ReadBufferInt() {
        }

        abstract int execute(@JavaType(value=Object.class) StaticObject var1, @JavaType(value=ByteOrder.class) StaticObject var2, long var3);

        @Specialization
        int doCached(@JavaType(value=Object.class) StaticObject receiver, @JavaType(value=ByteOrder.class) StaticObject order, long byteOffset, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile, @Cached(value="getLittleEndian(getContext())") @JavaType(value=ByteOrder.class) StaticObject littleEndian) {
            try {
                return interop.readBufferInt(InteropUtils.unwrapForeign(this.getLanguage(), receiver), order == littleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN, byteOffset);
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    @ImportStatic(value={InteropUtils.class})
    static abstract class WriteBufferShort
    extends SubstitutionNode {
        static final int LIMIT = 2;

        WriteBufferShort() {
        }

        abstract void execute(@JavaType(value=Object.class) StaticObject var1, @JavaType(value=ByteOrder.class) StaticObject var2, long var3, short var5);

        @Specialization
        void doCached(@JavaType(value=Object.class) StaticObject receiver, @JavaType(value=ByteOrder.class) StaticObject order, long byteOffset, short value, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile, @Cached(value="getLittleEndian(getContext())") @JavaType(value=ByteOrder.class) StaticObject littleEndian) {
            try {
                interop.writeBufferShort(InteropUtils.unwrapForeign(this.getLanguage(), receiver), order == littleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN, byteOffset, value);
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    @ImportStatic(value={InteropUtils.class})
    static abstract class ReadBufferShort
    extends SubstitutionNode {
        static final int LIMIT = 2;

        ReadBufferShort() {
        }

        abstract short execute(@JavaType(value=Object.class) StaticObject var1, @JavaType(value=ByteOrder.class) StaticObject var2, long var3);

        @Specialization
        short doCached(@JavaType(value=Object.class) StaticObject receiver, @JavaType(value=ByteOrder.class) StaticObject order, long byteOffset, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile, @Cached(value="getLittleEndian(getContext())") @JavaType(value=ByteOrder.class) StaticObject littleEndian) {
            try {
                return interop.readBufferShort(InteropUtils.unwrapForeign(this.getLanguage(), receiver), order == littleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN, byteOffset);
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    static abstract class WriteBufferByte
    extends SubstitutionNode {
        static final int LIMIT = 2;

        WriteBufferByte() {
        }

        abstract void execute(@JavaType(value=Object.class) StaticObject var1, long var2, byte var4);

        @Specialization
        void doCached(@JavaType(value=Object.class) StaticObject receiver, long byteOffset, byte value, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile) {
            try {
                interop.writeBufferByte(InteropUtils.unwrapForeign(this.getLanguage(), receiver), byteOffset, value);
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    static abstract class ReadBufferByte
    extends SubstitutionNode {
        static final int LIMIT = 2;

        ReadBufferByte() {
        }

        abstract byte execute(@JavaType(value=Object.class) StaticObject var1, long var2);

        @Specialization
        byte doCached(@JavaType(value=Object.class) StaticObject receiver, long byteOffset, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile) {
            try {
                return interop.readBufferByte(InteropUtils.unwrapForeign(this.getLanguage(), receiver), byteOffset);
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    static abstract class ReadBuffer
    extends SubstitutionNode {
        static final int LIMIT = 2;

        ReadBuffer() {
        }

        abstract void execute(@JavaType(value=Object.class) StaticObject var1, long var2, @JavaType(value=byte[].class) StaticObject var4, int var5, int var6);

        @Specialization
        void doCached(@JavaType(value=Object.class) StaticObject receiver, long byteOffset, @JavaType(value=byte[].class) StaticObject destination, int destinationOffset, int length, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached InlinedBranchProfile unexpectedExceptionProfile, @Cached InlinedBranchProfile exceptionProfile) {
            byte[] dest = (byte[])destination.unwrap(this.getLanguage());
            if (destinationOffset < 0 || destinationOffset + length > dest.length) {
                unexpectedExceptionProfile.enter((Node)this);
                throw this.getMeta().throwExceptionWithMessage(this.getMeta().java_lang_ArrayIndexOutOfBoundsException, "destination array is not able to hold the bytes");
            }
            try {
                interop.readBuffer(InteropUtils.unwrapForeign(this.getLanguage(), receiver), byteOffset, (byte[])destination.unwrap(this.getLanguage()), destinationOffset, length);
            }
            catch (InteropException e) {
                exceptionProfile.enter((Node)this);
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    static abstract class IsBufferWritable
    extends SubstitutionNode {
        static final int LIMIT = 2;

        IsBufferWritable() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile) {
            try {
                return interop.isBufferWritable(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    static abstract class GetBufferSize
    extends SubstitutionNode {
        static final int LIMIT = 2;

        GetBufferSize() {
        }

        abstract long execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        long doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile) {
            try {
                return interop.getBufferSize(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    @ReportPolymorphism
    static abstract class HasBufferElements
    extends SubstitutionNode {
        static final int LIMIT = 2;

        HasBufferElements() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return interop.hasBufferElements(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
        }
    }

    @Substitution
    static abstract class GetDeclaringMetaObject
    extends SubstitutionNode {
        static final int LIMIT = 2;

        GetDeclaringMetaObject() {
        }

        abstract @JavaType(value=Object.class) StaticObject execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        @JavaType(value=Object.class) StaticObject doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @CachedLibrary(limit="LIMIT") InteropLibrary declaringMetaObjectInterop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile) {
            try {
                Object declaringMetaObject = interop.getDeclaringMetaObject(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
                assert (InteropLibrary.getUncached().isMetaObject(declaringMetaObject));
                return InteropUtils.maybeWrapAsObject(declaringMetaObject, declaringMetaObjectInterop, this.getContext());
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    static abstract class HasDeclaringMetaObject
    extends SubstitutionNode {
        static final int LIMIT = 2;

        HasDeclaringMetaObject() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return interop.hasDeclaringMetaObject(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
        }
    }

    @Substitution
    static abstract class GetExecutableName
    extends SubstitutionNode {
        static final int LIMIT = 2;

        GetExecutableName() {
        }

        abstract @JavaType(value=Object.class) StaticObject execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        @JavaType(value=Object.class) StaticObject doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @CachedLibrary(limit="LIMIT") InteropLibrary executableNameInterop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile) {
            try {
                Object executableName = interop.getExecutableName(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
                assert (InteropLibrary.getUncached().isString(executableName));
                return InteropUtils.maybeWrapAsObject(executableName, executableNameInterop, this.getContext());
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    static abstract class HasExecutableName
    extends SubstitutionNode {
        static final int LIMIT = 2;

        HasExecutableName() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return interop.hasExecutableName(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
        }
    }

    @Substitution
    static abstract class Instantiate
    extends SubstitutionNode {
        static final int LIMIT = 2;

        Instantiate() {
        }

        abstract @JavaType(value=Object.class) StaticObject execute(@JavaType(value=Object.class) StaticObject var1, @JavaType(value=Object[].class) StaticObject var2);

        @Specialization
        @JavaType(value=Object.class) StaticObject doCached(@JavaType(value=Object.class) StaticObject receiver, @JavaType(value=Object[].class) StaticObject arguments, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @CachedLibrary(limit="LIMIT") InteropLibrary resultInterop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached ToHostArguments toHostArguments, @Cached BranchProfile exceptionProfile) {
            try {
                Object[] hostArguments = toHostArguments.execute(receiver.isForeignObject(), arguments);
                Object result = interop.instantiate(InteropUtils.unwrapForeign(this.getLanguage(), receiver), hostArguments);
                return InteropUtils.maybeWrapAsObject(result, resultInterop, this.getContext());
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    static abstract class IsInstantiable
    extends SubstitutionNode {
        static final int LIMIT = 2;

        IsInstantiable() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return interop.isInstantiable(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
        }
    }

    @Substitution
    static abstract class Execute
    extends SubstitutionNode {
        static final int LIMIT = 2;

        Execute() {
        }

        abstract @JavaType(value=Object.class) StaticObject execute(@JavaType(value=Object.class) StaticObject var1, @JavaType(value=Object[].class) StaticObject var2);

        @Specialization
        @JavaType(value=Object.class) StaticObject doCached(@JavaType(value=Object.class) StaticObject receiver, @JavaType(value=Object[].class) StaticObject arguments, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @CachedLibrary(limit="LIMIT") InteropLibrary resultInterop, @CachedLibrary(limit="LIMIT") InteropLibrary exceptionInterop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached LookupTypeConverterNode lookupTypeConverterNode, @Cached LookupInternalTypeConverterNode lookupInternalTypeConverterNode, @Cached ToHostArguments toHostArguments, @Cached BranchProfile exceptionProfile) {
            try {
                Object[] hostArguments = toHostArguments.execute(receiver.isForeignObject(), arguments);
                Object result = interop.execute(InteropUtils.unwrapForeign(this.getLanguage(), receiver), hostArguments);
                return InteropUtils.maybeWrapAsObject(result, resultInterop, this.getContext());
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
            catch (AbstractTruffleException ex) {
                throw Target_com_oracle_truffle_espresso_polyglot_Interop.handleAbstractTruffleException(exceptionInterop, this.getContext(), lookupTypeConverterNode, lookupInternalTypeConverterNode, exceptionProfile, ex);
            }
        }
    }

    @Substitution
    static abstract class IsExecutable
    extends SubstitutionNode {
        static final int LIMIT = 2;

        IsExecutable() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return interop.isExecutable(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
        }
    }

    @Substitution
    static abstract class ToNative
    extends SubstitutionNode {
        static final int LIMIT = 2;

        ToNative() {
        }

        abstract void execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        void doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            interop.toNative(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
        }
    }

    @Substitution
    static abstract class AsPointer
    extends SubstitutionNode {
        static final int LIMIT = 2;

        AsPointer() {
        }

        abstract long execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        long doCached(@JavaType(value=Object.class) StaticObject receiver, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached BranchProfile exceptionProfile) {
            try {
                return interop.asPointer(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    static abstract class IsPointer
    extends SubstitutionNode {
        static final int LIMIT = 2;

        IsPointer() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return interop.isPointer(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
        }
    }

    @Substitution
    static abstract class HasMemberWriteSideEffects
    extends SubstitutionNode {
        static final int LIMIT = 2;

        HasMemberWriteSideEffects() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1, @JavaType(value=String.class) StaticObject var2);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, @JavaType(value=String.class) StaticObject member, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @CachedLibrary(limit="LIMIT") InteropLibrary memberInterop) {
            assert (InteropLibrary.getUncached().isString((Object)member));
            String hostMember = InteropUtils.toHostString(member, memberInterop);
            return interop.hasMemberWriteSideEffects(InteropUtils.unwrapForeign(this.getLanguage(), receiver), hostMember);
        }
    }

    @Substitution
    static abstract class HasMemberReadSideEffects
    extends SubstitutionNode {
        static final int LIMIT = 2;

        HasMemberReadSideEffects() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1, @JavaType(value=String.class) StaticObject var2);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, @JavaType(value=String.class) StaticObject member, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @CachedLibrary(limit="LIMIT") InteropLibrary memberInterop) {
            assert (InteropLibrary.getUncached().isString((Object)member));
            String hostMember = InteropUtils.toHostString(member, memberInterop);
            return interop.hasMemberReadSideEffects(InteropUtils.unwrapForeign(this.getLanguage(), receiver), hostMember);
        }
    }

    @Substitution
    static abstract class InvokeMemberWithCast
    extends SubstitutionNode {
        static final int LIMIT = 2;

        InvokeMemberWithCast() {
        }

        abstract @JavaType(value=Object.class) StaticObject execute(@JavaType(value=Class.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, @JavaType(value=String.class) StaticObject var3, @JavaType(value=Object[].class) StaticObject var4);

        @Specialization
        @JavaType(value=Object.class) StaticObject doCached(@JavaType(value=Class.class) StaticObject targetClass, @JavaType(value=Object.class) StaticObject receiver, @JavaType(value=String.class) StaticObject member, @JavaType(value=Object[].class) StaticObject arguments, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @CachedLibrary(limit="LIMIT") InteropLibrary exceptionInterop, @Bind(value="getMeta()") Meta meta, @Cached ToReference.DynamicToReference toEspressoNode, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached ToHostArguments toHostArguments, @Cached LookupTypeConverterNode lookupTypeConverterNode, @Cached LookupInternalTypeConverterNode lookupInternalTypeConverterNode, @Cached BranchProfile exceptionProfile) {
            if (StaticObject.isNull(targetClass)) {
                exceptionProfile.enter();
                throw meta.throwNullPointerException();
            }
            assert (InteropLibrary.getUncached().isString((Object)member));
            String hostMember = this.getMeta().toHostString(member);
            try {
                Object[] hostArguments = toHostArguments.execute(receiver.isForeignObject(), arguments);
                Object result = interop.invokeMember(InteropUtils.unwrapForeign(this.getLanguage(), receiver), hostMember, hostArguments);
                Klass targetKlass = targetClass.getMirrorKlass(meta);
                if (targetKlass.isPrimitive()) {
                    targetKlass = MethodArgsUtils.primitiveTypeToBoxedType((PrimitiveKlass)targetKlass);
                }
                return toEspressoNode.execute(result, targetKlass);
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
            catch (EspressoException e) {
                throw e;
            }
            catch (AbstractTruffleException ex) {
                throw Target_com_oracle_truffle_espresso_polyglot_Interop.handleAbstractTruffleException(exceptionInterop, this.getContext(), lookupTypeConverterNode, lookupInternalTypeConverterNode, exceptionProfile, ex);
            }
        }
    }

    @Substitution
    static abstract class InvokeMember
    extends SubstitutionNode {
        static final int LIMIT = 2;

        InvokeMember() {
        }

        abstract @JavaType(value=Object.class) StaticObject execute(@JavaType(value=Object.class) StaticObject var1, @JavaType(value=String.class) StaticObject var2, @JavaType(value=Object[].class) StaticObject var3);

        @Specialization
        @JavaType(value=Object.class) StaticObject doCached(@JavaType(value=Object.class) StaticObject receiver, @JavaType(value=String.class) StaticObject member, @JavaType(value=Object[].class) StaticObject arguments, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @CachedLibrary(limit="LIMIT") InteropLibrary valueInterop, @CachedLibrary(limit="LIMIT") InteropLibrary exceptionInterop, @Bind(value="getMeta()") Meta meta, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached ToHostArguments toHostArguments, @Cached LookupTypeConverterNode lookupTypeConverterNode, @Cached LookupInternalTypeConverterNode lookupInternalTypeConverterNode, @Cached BranchProfile exceptionProfile) {
            assert (InteropLibrary.getUncached().isString((Object)member));
            String hostMember = meta.toHostString(member);
            try {
                Object[] hostArguments = toHostArguments.execute(receiver.isForeignObject(), arguments);
                Object result = interop.invokeMember(InteropUtils.unwrapForeign(this.getLanguage(), receiver), hostMember, hostArguments);
                return InteropUtils.maybeWrapAsObject(result, valueInterop, this.getContext());
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
            catch (EspressoException e) {
                throw e;
            }
            catch (AbstractTruffleException ex) {
                throw Target_com_oracle_truffle_espresso_polyglot_Interop.handleAbstractTruffleException(exceptionInterop, this.getContext(), lookupTypeConverterNode, lookupInternalTypeConverterNode, exceptionProfile, ex);
            }
        }
    }

    @Substitution
    static abstract class IsMemberInvocable
    extends SubstitutionNode {
        static final int LIMIT = 2;

        IsMemberInvocable() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1, @JavaType(value=String.class) StaticObject var2);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, @JavaType(value=String.class) StaticObject member, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @CachedLibrary(limit="LIMIT") InteropLibrary memberInterop) {
            assert (InteropLibrary.getUncached().isString((Object)member));
            String hostMember = InteropUtils.toHostString(member, memberInterop);
            return interop.isMemberInvocable(InteropUtils.unwrapForeign(this.getLanguage(), receiver), hostMember);
        }
    }

    @Substitution
    static abstract class RemoveMember
    extends SubstitutionNode {
        static final int LIMIT = 2;

        RemoveMember() {
        }

        abstract void execute(@JavaType(value=Object.class) StaticObject var1, @JavaType(value=String.class) StaticObject var2);

        @Specialization
        void doCached(@JavaType(value=Object.class) StaticObject receiver, @JavaType(value=String.class) StaticObject member, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @CachedLibrary(limit="LIMIT") InteropLibrary memberInterop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile) {
            assert (InteropLibrary.getUncached().isString((Object)member));
            String hostMember = InteropUtils.toHostString(member, memberInterop);
            try {
                interop.removeMember(InteropUtils.unwrapForeign(this.getLanguage(), receiver), hostMember);
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    static abstract class IsMemberRemovable
    extends SubstitutionNode {
        static final int LIMIT = 2;

        IsMemberRemovable() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1, @JavaType(value=String.class) StaticObject var2);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, @JavaType(value=String.class) StaticObject member, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @CachedLibrary(limit="LIMIT") InteropLibrary memberInterop) {
            assert (InteropLibrary.getUncached().isString((Object)member));
            String hostMember = InteropUtils.toHostString(member, memberInterop);
            return interop.isMemberRemovable(InteropUtils.unwrapForeign(this.getLanguage(), receiver), hostMember);
        }
    }

    @Substitution
    static abstract class WriteMember
    extends SubstitutionNode {
        static final int LIMIT = 2;

        WriteMember() {
        }

        abstract void execute(@JavaType(value=Object.class) StaticObject var1, @JavaType(value=String.class) StaticObject var2, @JavaType(value=Object.class) StaticObject var3);

        @Specialization
        void doCached(@JavaType(value=Object.class) StaticObject receiver, @JavaType(value=String.class) StaticObject member, @JavaType(value=Object.class) StaticObject value, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @CachedLibrary(limit="LIMIT") InteropLibrary memberInterop, @Cached BranchProfile exceptionProfile, @Cached ConditionProfile isForeignProfile) {
            assert (InteropLibrary.getUncached().isString((Object)member));
            String hostMember = InteropUtils.toHostString(member, memberInterop);
            try {
                if (isForeignProfile.profile(receiver.isForeignObject())) {
                    interop.writeMember(InteropUtils.unwrapForeign(this.getLanguage(), receiver), hostMember, InteropUtils.unwrap(this.getLanguage(), value, this.getMeta()));
                } else {
                    interop.writeMember((Object)receiver, hostMember, (Object)value);
                }
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    static abstract class IsMemberInsertable
    extends SubstitutionNode {
        static final int LIMIT = 2;

        IsMemberInsertable() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1, @JavaType(value=String.class) StaticObject var2);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, @JavaType(value=String.class) StaticObject member, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @CachedLibrary(limit="LIMIT") InteropLibrary memberInterop) {
            assert (InteropLibrary.getUncached().isString((Object)member));
            String hostMember = InteropUtils.toHostString(member, memberInterop);
            return interop.isMemberInsertable(InteropUtils.unwrapForeign(this.getLanguage(), receiver), hostMember);
        }
    }

    @Substitution
    static abstract class IsMemberModifiable
    extends SubstitutionNode {
        static final int LIMIT = 2;

        IsMemberModifiable() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1, @JavaType(value=String.class) StaticObject var2);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, @JavaType(value=String.class) StaticObject member, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @CachedLibrary(limit="LIMIT") InteropLibrary memberInterop) {
            assert (InteropLibrary.getUncached().isString((Object)member));
            String hostMember = InteropUtils.toHostString(member, memberInterop);
            return interop.isMemberModifiable(InteropUtils.unwrapForeign(this.getLanguage(), receiver), hostMember);
        }
    }

    @Substitution
    static abstract class ReadMember
    extends SubstitutionNode {
        static final int LIMIT = 2;

        ReadMember() {
        }

        abstract @JavaType(value=Object.class) StaticObject execute(@JavaType(value=Object.class) StaticObject var1, @JavaType(value=String.class) StaticObject var2);

        @Specialization
        @JavaType(value=Object.class) StaticObject doCached(@JavaType(value=Object.class) StaticObject receiver, @JavaType(value=String.class) StaticObject member, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @CachedLibrary(limit="LIMIT") InteropLibrary memberInterop, @CachedLibrary(limit="LIMIT") InteropLibrary memberValueInterop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile) {
            assert (InteropLibrary.getUncached().isString((Object)member));
            String hostMember = InteropUtils.toHostString(member, memberInterop);
            try {
                Object memberValue = interop.readMember(InteropUtils.unwrapForeign(this.getLanguage(), receiver), hostMember);
                return InteropUtils.maybeWrapAsObject(memberValue, memberValueInterop, this.getContext());
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    static abstract class IsMemberReadable
    extends SubstitutionNode {
        static final int LIMIT = 2;

        IsMemberReadable() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1, @JavaType(value=String.class) StaticObject var2);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, @JavaType(value=String.class) StaticObject member, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @CachedLibrary(limit="LIMIT") InteropLibrary memberInterop) {
            assert (InteropLibrary.getUncached().isString((Object)member));
            String hostMember = InteropUtils.toHostString(member, memberInterop);
            return interop.isMemberReadable(InteropUtils.unwrapForeign(this.getLanguage(), receiver), hostMember);
        }
    }

    @Substitution
    static abstract class GetMembers
    extends SubstitutionNode {
        static final int LIMIT = 2;

        GetMembers() {
        }

        abstract @JavaType(value=Object.class) StaticObject execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        @JavaType(value=Object.class) StaticObject doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @CachedLibrary(limit="LIMIT") InteropLibrary membersInterop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile) {
            try {
                Object members = interop.getMembers(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
                assert (InteropLibrary.getUncached().hasArrayElements(members));
                return InteropUtils.maybeWrapAsObject(members, membersInterop, this.getContext());
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    static abstract class HasMembers
    extends SubstitutionNode {
        static final int LIMIT = 2;

        HasMembers() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return interop.hasMembers(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
        }
    }

    @Substitution
    static abstract class IdentityHashCode
    extends SubstitutionNode {
        static final int LIMIT = 2;

        IdentityHashCode() {
        }

        abstract int execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        int doCached(@JavaType(value=Object.class) StaticObject receiver, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached BranchProfile exceptionProfile) {
            try {
                return interop.identityHashCode(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    static abstract class IsIdentical
    extends SubstitutionNode {
        static final int LIMIT = 2;

        IsIdentical() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, @JavaType(value=Object.class) StaticObject other, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @CachedLibrary(limit="LIMIT") InteropLibrary otherInterop) {
            return interop.isIdentical(InteropUtils.unwrapForeign(this.getLanguage(), receiver), InteropUtils.unwrapForeign(this.getLanguage(), other), otherInterop);
        }
    }

    @Substitution
    static abstract class IsMetaInstance
    extends SubstitutionNode {
        static final int LIMIT = 2;

        IsMetaInstance() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, @JavaType(value=Object.class) StaticObject instance, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached BranchProfile exceptionProfile) {
            try {
                return interop.isMetaInstance(InteropUtils.unwrapForeign(this.getLanguage(), receiver), InteropUtils.unwrapForeign(this.getLanguage(), instance));
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    static abstract class GetMetaSimpleName
    extends SubstitutionNode {
        static final int LIMIT = 2;

        GetMetaSimpleName() {
        }

        abstract @JavaType(value=Object.class) StaticObject execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        @JavaType(value=Object.class) StaticObject doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @CachedLibrary(limit="LIMIT") InteropLibrary simpleNameInterop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile) {
            try {
                Object simpleName = interop.getMetaSimpleName(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
                assert (InteropLibrary.getUncached().isString(simpleName));
                return InteropUtils.maybeWrapAsObject(simpleName, simpleNameInterop, this.getContext());
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    static abstract class GetMetaQualifiedName
    extends SubstitutionNode {
        static final int LIMIT = 2;

        GetMetaQualifiedName() {
        }

        abstract @JavaType(value=Object.class) StaticObject execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        @JavaType(value=Object.class) StaticObject doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @CachedLibrary(limit="LIMIT") InteropLibrary qualifiedNameInterop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile) {
            try {
                Object qualifiedName = interop.getMetaQualifiedName(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
                assert (InteropLibrary.getUncached().isString(qualifiedName));
                return InteropUtils.maybeWrapAsObject(qualifiedName, qualifiedNameInterop, this.getContext());
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    static abstract class IsMetaObject
    extends SubstitutionNode {
        static final int LIMIT = 2;

        IsMetaObject() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return interop.isMetaObject(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
        }
    }

    @Substitution
    static abstract class ToDisplayString
    extends SubstitutionNode {
        static final int LIMIT = 2;

        ToDisplayString() {
        }

        abstract @JavaType(value=Object.class) StaticObject execute(@JavaType(value=Object.class) StaticObject var1, boolean var2);

        @Specialization
        @JavaType(value=Object.class) StaticObject doCached(@JavaType(value=Object.class) StaticObject receiver, boolean allowSideEffects, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @CachedLibrary(limit="LIMIT") InteropLibrary displayStringInterop) {
            Object displayString = interop.toDisplayString(InteropUtils.unwrapForeign(this.getLanguage(), receiver), allowSideEffects);
            assert (InteropLibrary.getUncached().isString(displayString));
            return InteropUtils.maybeWrapAsObject(displayString, displayStringInterop, this.getContext());
        }
    }

    @Substitution
    static abstract class GetMetaObject
    extends SubstitutionNode {
        static final int LIMIT = 2;

        GetMetaObject() {
        }

        abstract @JavaType(value=Object.class) StaticObject execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        @JavaType(value=Object.class) StaticObject doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @CachedLibrary(limit="LIMIT") InteropLibrary metaObjectInterop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile) {
            try {
                Object metaObject = interop.getMetaObject(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
                assert (InteropLibrary.getUncached().isMetaObject(metaObject));
                return InteropUtils.maybeWrapAsObject(metaObject, metaObjectInterop, this.getContext());
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    static abstract class HasMetaObject
    extends SubstitutionNode {
        static final int LIMIT = 2;

        HasMetaObject() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return interop.hasMetaObject(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
        }
    }

    @Substitution
    static abstract class IsArrayElementRemovable
    extends SubstitutionNode {
        static final int LIMIT = 2;

        IsArrayElementRemovable() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1, long var2);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, long index, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return interop.isArrayElementRemovable(InteropUtils.unwrapForeign(this.getLanguage(), receiver), index);
        }
    }

    @Substitution
    static abstract class IsArrayElementInsertable
    extends SubstitutionNode {
        static final int LIMIT = 2;

        IsArrayElementInsertable() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1, long var2);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, long index, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return interop.isArrayElementInsertable(InteropUtils.unwrapForeign(this.getLanguage(), receiver), index);
        }
    }

    @Substitution
    static abstract class IsArrayElementModifiable
    extends SubstitutionNode {
        static final int LIMIT = 2;

        IsArrayElementModifiable() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1, long var2);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, long index, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return interop.isArrayElementModifiable(InteropUtils.unwrapForeign(this.getLanguage(), receiver), index);
        }
    }

    @Substitution
    static abstract class RemoveArrayElement
    extends SubstitutionNode {
        static final int LIMIT = 2;

        RemoveArrayElement() {
        }

        abstract void execute(@JavaType(value=Object.class) StaticObject var1, long var2);

        @Specialization
        void doCached(@JavaType(value=Object.class) StaticObject receiver, long index, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile) {
            try {
                interop.removeArrayElement(InteropUtils.unwrapForeign(this.getLanguage(), receiver), index);
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    static abstract class WriteArrayElement
    extends SubstitutionNode {
        static final int LIMIT = 2;

        WriteArrayElement() {
        }

        abstract void execute(@JavaType(value=Object.class) StaticObject var1, long var2, @JavaType(value=Object.class) StaticObject var4);

        @Specialization
        void doCached(@JavaType(value=Object.class) StaticObject receiver, long index, @JavaType(value=Object.class) StaticObject value, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @CachedLibrary(limit="LIMIT") InteropLibrary exceptionInterop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached LookupTypeConverterNode lookupTypeConverterNode, @Cached LookupInternalTypeConverterNode lookupInternalTypeConverterNode, @Cached BranchProfile exceptionProfile, @Cached ConditionProfile isForeignProfile) {
            try {
                if (isForeignProfile.profile(receiver.isForeignObject())) {
                    interop.writeArrayElement(InteropUtils.unwrapForeign(this.getLanguage(), receiver), index, InteropUtils.unwrap(this.getLanguage(), value, this.getMeta()));
                } else {
                    interop.writeArrayElement((Object)receiver, index, (Object)value);
                }
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
            catch (AbstractTruffleException ex) {
                throw Target_com_oracle_truffle_espresso_polyglot_Interop.handleAbstractTruffleException(exceptionInterop, this.getContext(), lookupTypeConverterNode, lookupInternalTypeConverterNode, exceptionProfile, ex);
            }
        }
    }

    @Substitution
    static abstract class IsArrayElementReadable
    extends SubstitutionNode {
        static final int LIMIT = 2;

        IsArrayElementReadable() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1, long var2);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, long index, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return interop.isArrayElementReadable(InteropUtils.unwrapForeign(this.getLanguage(), receiver), index);
        }
    }

    @Substitution
    static abstract class GetArraySize
    extends SubstitutionNode {
        static final int LIMIT = 2;

        GetArraySize() {
        }

        abstract long execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        long doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile) {
            try {
                return interop.getArraySize(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    static abstract class ReadArrayElement
    extends SubstitutionNode {
        static final int LIMIT = 2;

        ReadArrayElement() {
        }

        abstract @JavaType(value=Object.class) StaticObject execute(@JavaType(value=Object.class) StaticObject var1, long var2);

        @Specialization
        @JavaType(value=Object.class) StaticObject doCached(@JavaType(value=Object.class) StaticObject receiver, long index, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @CachedLibrary(limit="LIMIT") InteropLibrary valueInterop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile) {
            try {
                Object value = interop.readArrayElement(InteropUtils.unwrapForeign(this.getLanguage(), receiver), index);
                return InteropUtils.maybeWrapAsObject(value, valueInterop, this.getContext());
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    static abstract class HasArrayElements
    extends SubstitutionNode {
        static final int LIMIT = 2;

        HasArrayElements() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return interop.hasArrayElements(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
        }
    }

    @Substitution
    static abstract class GetExceptionStackTrace
    extends SubstitutionNode {
        static final int LIMIT = 2;

        GetExceptionStackTrace() {
        }

        abstract @JavaType(value=Object.class) StaticObject execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        @JavaType(value=Object.class) StaticObject doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @CachedLibrary(limit="LIMIT") InteropLibrary stackTraceInterop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile) {
            try {
                Object stackTrace = interop.getExceptionStackTrace(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
                assert (InteropLibrary.getUncached().hasArrayElements(stackTrace));
                return InteropUtils.maybeWrapAsObject(stackTrace, stackTraceInterop, this.getContext());
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    static abstract class HasExceptionStackTrace
    extends SubstitutionNode {
        static final int LIMIT = 2;

        HasExceptionStackTrace() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return interop.hasExceptionStackTrace(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
        }
    }

    @Substitution
    static abstract class GetExceptionMessage
    extends SubstitutionNode {
        static final int LIMIT = 2;

        GetExceptionMessage() {
        }

        abstract @JavaType(value=Object.class) StaticObject execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        @JavaType(value=Object.class) StaticObject doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @CachedLibrary(limit="LIMIT") InteropLibrary messageInterop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile) {
            try {
                Object message = interop.getExceptionMessage(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
                assert (InteropLibrary.getUncached().isString(message));
                return InteropUtils.maybeWrapAsObject(message, messageInterop, this.getContext());
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    static abstract class HasExceptionMessage
    extends SubstitutionNode {
        static final int LIMIT = 2;

        HasExceptionMessage() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return interop.hasExceptionMessage(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
        }
    }

    @Substitution
    static abstract class GetExceptionCause
    extends SubstitutionNode {
        static final int LIMIT = 2;

        GetExceptionCause() {
        }

        abstract @JavaType(value=Object.class) StaticObject execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        @JavaType(value=Object.class) StaticObject doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @CachedLibrary(limit="LIMIT") InteropLibrary causeInterop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile error) {
            try {
                Object cause = interop.getExceptionCause(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
                assert (InteropLibrary.getUncached().isException(cause));
                assert (!InteropLibrary.getUncached().isNull(cause));
                return InteropUtils.maybeWrapAsForeignException(cause, causeInterop, this.getContext());
            }
            catch (InteropException e) {
                error.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    static abstract class HasExceptionCause
    extends SubstitutionNode {
        static final int LIMIT = 2;

        HasExceptionCause() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return interop.hasExceptionCause(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
        }
    }

    @Substitution
    static abstract class GetExceptionExitStatus
    extends SubstitutionNode {
        static final int LIMIT = 2;

        GetExceptionExitStatus() {
        }

        abstract int execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        int doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile error) {
            try {
                return interop.getExceptionExitStatus(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
            }
            catch (InteropException e) {
                error.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    static abstract class IsExceptionIncompleteSource
    extends SubstitutionNode {
        static final int LIMIT = 2;

        IsExceptionIncompleteSource() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile error) {
            try {
                return interop.isExceptionIncompleteSource(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
            }
            catch (InteropException e) {
                error.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    static abstract class GetExceptionType
    extends SubstitutionNode {
        static final int LIMIT = 2;

        GetExceptionType() {
        }

        abstract @JavaType(internalName="Lcom/oracle/truffle/espresso/polyglot/ExceptionType;") StaticObject execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        @JavaType(internalName="Lcom/oracle/truffle/espresso/polyglot/ExceptionType;") StaticObject doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile) {
            try {
                ExceptionType exceptionType = interop.getExceptionType(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
                Meta meta = this.getMeta();
                StaticObject staticStorage = meta.polyglot.ExceptionType.tryInitializeAndGetStatics();
                switch (exceptionType) {
                    case EXIT: {
                        return meta.polyglot.ExceptionType_EXIT.getObject(staticStorage);
                    }
                    case INTERRUPT: {
                        return meta.polyglot.ExceptionType_INTERRUPT.getObject(staticStorage);
                    }
                    case RUNTIME_ERROR: {
                        return meta.polyglot.ExceptionType_RUNTIME_ERROR.getObject(staticStorage);
                    }
                    case PARSE_ERROR: {
                        return meta.polyglot.ExceptionType_PARSE_ERROR.getObject(staticStorage);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere("Unexpected ExceptionType: " + String.valueOf(exceptionType));
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    static abstract class ThrowException
    extends SubstitutionNode {
        static final int LIMIT = 2;

        ThrowException() {
        }

        abstract @JavaType(value=RuntimeException.class) StaticObject execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        @JavaType(value=RuntimeException.class) StaticObject doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile) {
            try {
                throw interop.throwException(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    static abstract class IsException
    extends SubstitutionNode {
        static final int LIMIT = 2;

        IsException() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return interop.isException(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
        }
    }

    @Substitution
    static abstract class AsBigInteger
    extends SubstitutionNode {
        static final int LIMIT = 2;

        AsBigInteger() {
        }

        abstract @JavaType(value=BigInteger.class) StaticObject execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        @JavaType(value=BigInteger.class) StaticObject doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile) {
            try {
                BigInteger bigInteger = interop.asBigInteger(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
                return this.toGuestBigInteger(this.getMeta(), bigInteger);
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private StaticObject toGuestBigInteger(Meta meta, BigInteger bigInteger) {
            byte[] bytes = bigInteger.toByteArray();
            StaticObject guestBigInteger = this.getAllocator().createNew(meta.java_math_BigInteger);
            meta.java_math_BigInteger_init.invokeDirect(guestBigInteger, StaticObject.wrap(bytes, meta));
            return guestBigInteger;
        }
    }

    @Substitution
    static abstract class AsDouble
    extends SubstitutionNode {
        static final int LIMIT = 2;

        AsDouble() {
        }

        abstract double execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        double doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile) {
            try {
                return interop.asDouble(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    static abstract class AsFloat
    extends SubstitutionNode {
        static final int LIMIT = 2;

        AsFloat() {
        }

        abstract float execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        float doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile) {
            try {
                return interop.asFloat(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    static abstract class AsLong
    extends SubstitutionNode {
        static final int LIMIT = 2;

        AsLong() {
        }

        abstract long execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        long doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile) {
            try {
                return interop.asLong(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    static abstract class AsInt
    extends SubstitutionNode {
        static final int LIMIT = 2;

        AsInt() {
        }

        abstract int execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        int doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile) {
            try {
                return interop.asInt(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    static abstract class AsShort
    extends SubstitutionNode {
        static final int LIMIT = 2;

        AsShort() {
        }

        abstract short execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        short doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile) {
            try {
                return interop.asShort(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    static abstract class AsByte
    extends SubstitutionNode {
        static final int LIMIT = 2;

        AsByte() {
        }

        abstract byte execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        byte doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile) {
            try {
                return interop.asByte(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    static abstract class FitsInBigInteger
    extends SubstitutionNode {
        static final int LIMIT = 2;

        FitsInBigInteger() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return interop.fitsInBigInteger(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
        }
    }

    @Substitution
    static abstract class FitsInDouble
    extends SubstitutionNode {
        static final int LIMIT = 2;

        FitsInDouble() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return interop.fitsInDouble(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
        }
    }

    @Substitution
    static abstract class FitsInFloat
    extends SubstitutionNode {
        static final int LIMIT = 2;

        FitsInFloat() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return interop.fitsInFloat(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
        }
    }

    @Substitution
    static abstract class FitsInLong
    extends SubstitutionNode {
        static final int LIMIT = 2;

        FitsInLong() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return interop.fitsInLong(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
        }
    }

    @Substitution
    static abstract class FitsInInt
    extends SubstitutionNode {
        static final int LIMIT = 2;

        FitsInInt() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return interop.fitsInInt(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
        }
    }

    @Substitution
    static abstract class FitsInShort
    extends SubstitutionNode {
        static final int LIMIT = 2;

        FitsInShort() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return interop.fitsInShort(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
        }
    }

    @Substitution
    static abstract class FitsInByte
    extends SubstitutionNode {
        static final int LIMIT = 2;

        FitsInByte() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return interop.fitsInByte(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
        }
    }

    @Substitution
    static abstract class IsNumber
    extends SubstitutionNode {
        static final int LIMIT = 2;

        IsNumber() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return interop.isNumber(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
        }
    }

    @Substitution
    static abstract class AsString
    extends SubstitutionNode {
        static final int LIMIT = 2;

        AsString() {
        }

        abstract @JavaType(value=String.class) StaticObject execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        @JavaType(value=String.class) StaticObject doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile) {
            try {
                return this.getMeta().toGuestString(interop.asString(InteropUtils.unwrapForeign(this.getLanguage(), receiver)));
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    static abstract class IsString
    extends SubstitutionNode {
        static final int LIMIT = 2;

        IsString() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return interop.isString(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
        }
    }

    @Substitution
    static abstract class AsBoolean
    extends SubstitutionNode {
        static final int LIMIT = 4;

        AsBoolean() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ThrowInteropExceptionAsGuest throwInteropExceptionAsGuest, @Cached BranchProfile exceptionProfile) {
            try {
                return interop.asBoolean(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
            }
            catch (InteropException e) {
                exceptionProfile.enter();
                throw throwInteropExceptionAsGuest.execute(e);
            }
        }
    }

    @Substitution
    static abstract class IsBoolean
    extends SubstitutionNode {
        static final int LIMIT = 4;

        IsBoolean() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return interop.isBoolean(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
        }
    }

    @Substitution
    @ImportStatic(value={InteropUtils.class})
    static abstract class IsNull
    extends SubstitutionNode {
        static final int LIMIT = 4;

        IsNull() {
        }

        abstract boolean execute(@JavaType(value=Object.class) StaticObject var1);

        @Specialization
        boolean doCached(@JavaType(value=Object.class) StaticObject receiver, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return interop.isNull(InteropUtils.unwrapForeign(this.getLanguage(), receiver));
        }
    }

    static final class InteropUtils {
        InteropUtils() {
        }

        static @JavaType(value=Object.class) StaticObject maybeWrapAsObject(Object value, InteropLibrary valueInterop, EspressoContext context) {
            if (value instanceof StaticObject) {
                return (StaticObject)value;
            }
            return StaticObject.createForeign(context.getLanguage(), context.getMeta().java_lang_Object, value, valueInterop);
        }

        static @JavaType(value=Throwable.class) StaticObject maybeWrapAsForeignException(Object value, InteropLibrary valueInterop, EspressoContext context) {
            assert (InteropLibrary.getUncached().isException(value));
            if (value instanceof StaticObject) {
                return (StaticObject)value;
            }
            return StaticObject.createForeignException(context, value, valueInterop);
        }

        static String toHostString(Object value, InteropLibrary valueInterop) {
            assert (InteropLibrary.getUncached().isString(value));
            try {
                return valueInterop.asString(value);
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere(e);
            }
        }

        static Object unwrap(EspressoLanguage language, StaticObject object, Meta meta) {
            return com.oracle.truffle.espresso.runtime.InteropUtils.unwrap(language, object, meta);
        }

        static Object unwrapForeign(EspressoLanguage language, StaticObject object) {
            if (object.isForeignObject()) {
                return object.rawForeignObject(language);
            }
            return object;
        }

        @CompilerDirectives.TruffleBoundary
        static @JavaType(value=ByteOrder.class) StaticObject getLittleEndian(EspressoContext context) {
            Meta meta = context.getMeta();
            StaticObject staticStorage = meta.java_nio_ByteOrder.tryInitializeAndGetStatics();
            return meta.java_nio_ByteOrder_LITTLE_ENDIAN.getObject(staticStorage);
        }
    }
}

