/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.ThreadLocalAction;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.blocking.GuestInterruptedException;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.EspressoSubstitutions;
import com.oracle.truffle.espresso.substitutions.Inject;
import com.oracle.truffle.espresso.substitutions.JavaType;
import com.oracle.truffle.espresso.substitutions.Substitution;
import com.oracle.truffle.espresso.substitutions.SubstitutionNode;
import com.oracle.truffle.espresso.substitutions.SubstitutionProfiler;
import com.oracle.truffle.espresso.substitutions.VersionFilter;
import com.oracle.truffle.espresso.threads.EspressoThreadRegistry;
import com.oracle.truffle.espresso.threads.State;
import com.oracle.truffle.espresso.threads.ThreadsAccess;
import com.oracle.truffle.espresso.threads.Transition;
import com.oracle.truffle.espresso.vm.InterpreterToVM;
import com.oracle.truffle.espresso.vm.VM;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

@EspressoSubstitutions
public final class Target_java_lang_Thread {
    public static void incrementThreadCounter(StaticObject thread, Field hiddenField) {
        assert (hiddenField.isHidden());
        AtomicLong atomicCounter = (AtomicLong)hiddenField.getHiddenObject(thread);
        if (atomicCounter == null) {
            atomicCounter = new AtomicLong();
            hiddenField.setHiddenObject(thread, atomicCounter);
        }
        atomicCounter.incrementAndGet();
    }

    public static long getThreadCounter(StaticObject thread, Field hiddenField) {
        assert (hiddenField.isHidden());
        AtomicLong atomicCounter = (AtomicLong)hiddenField.getHiddenObject(thread);
        if (atomicCounter == null) {
            return 0L;
        }
        return atomicCounter.get();
    }

    @Substitution(isTrivial=true)
    public static @JavaType(value=Thread.class) StaticObject currentThread(@Inject EspressoLanguage language) {
        return language.getCurrentVirtualThread();
    }

    @Substitution(hasReceiver=true, versionFilter=VersionFilter.Java19OrLater.class)
    public static void setCurrentThread(@JavaType(value=Thread.class) StaticObject self, @JavaType(value=Thread.class) StaticObject thread, @Inject EspressoLanguage language) {
        assert (self == EspressoContext.get(null).getCurrentPlatformThread());
        assert (self == thread);
        language.setCurrentVirtualThread(thread);
    }

    @Substitution
    public static @JavaType(value=Thread[].class) StaticObject getThreads(@Inject EspressoContext context) {
        return context.getVM().JVM_GetAllThreads(null);
    }

    @Substitution
    public static @JavaType(value=StackTraceElement[][].class) StaticObject dumpThreads(@JavaType(value=Thread[].class) StaticObject threads, @Inject EspressoLanguage language, @Inject Meta meta) {
        if (StaticObject.isNull(threads)) {
            throw meta.throwNullPointerException();
        }
        if (threads.length(language) == 0) {
            throw meta.throwException(meta.java_lang_IllegalArgumentException);
        }
        EspressoContext context = meta.getContext();
        StaticObject trace = StaticObject.createArray(meta.java_lang_StackTraceElement.array(), StaticObject.EMPTY_ARRAY, context);
        Object[] toWrap = new StaticObject[threads.length(language)];
        Arrays.fill(toWrap, trace);
        return StaticObject.createArray(meta.java_lang_StackTraceElement.array().array(), toWrap, context);
    }

    private static boolean isSystemInnocuousThread(StaticObject thread, Meta meta) {
        if (!meta.misc_InnocuousThread.isAssignableFrom(thread.getKlass())) {
            return false;
        }
        return StaticObject.isNull(meta.java_lang_Thread_contextClassLoader.getObject(thread));
    }

    @CompilerDirectives.TruffleBoundary
    @Substitution(isTrivial=true, versionFilter=VersionFilter.Java18OrEarlier.class)
    public static void yield() {
        Thread.yield();
    }

    @CompilerDirectives.TruffleBoundary
    @Substitution(isTrivial=true)
    public static void yield0() {
        Thread.yield();
    }

    @CompilerDirectives.TruffleBoundary
    @Substitution(hasReceiver=true)
    public static void setPriority0(@JavaType(value=Thread.class) StaticObject self, int newPriority, @Inject EspressoContext context) {
        Thread hostThread = context.getThreadAccess().getHost(self);
        if (hostThread == null) {
            return;
        }
        hostThread.setPriority(newPriority);
    }

    @Substitution(hasReceiver=true, versionFilter=VersionFilter.Java18OrEarlier.class)
    public static boolean isAlive(@JavaType(value=Thread.class) StaticObject self, @Inject EspressoContext context) {
        return context.getThreadAccess().isAlive(self);
    }

    @Substitution
    public static void registerNatives() {
    }

    @CompilerDirectives.TruffleBoundary
    @Substitution
    public static boolean holdsLock(@JavaType(value=Object.class) StaticObject object, @Inject Meta meta) {
        if (StaticObject.isNull(object)) {
            throw meta.throwNullPointerException();
        }
        return object.getLock(meta.getContext()).isHeldByCurrentThread();
    }

    @CompilerDirectives.TruffleBoundary
    @Substitution(versionFilter=VersionFilter.Java18OrEarlier.class)
    public static void sleep(long amount, @Inject Meta meta, @Inject SubstitutionProfiler location) {
        Target_java_lang_Thread.sleep0(amount, meta, location);
    }

    @CompilerDirectives.TruffleBoundary
    @Substitution(versionFilter=VersionFilter.Java19OrLater.class)
    public static void sleep0(long amount, @Inject Meta meta, @Inject SubstitutionProfiler location) {
        if (amount < 0L) {
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, "timeout value is negative");
        }
        TimeUnit unit = meta.getJavaVersion().java21OrLater() ? TimeUnit.NANOSECONDS : TimeUnit.MILLISECONDS;
        StaticObject thread = meta.getContext().getCurrentPlatformThread();
        try (Transition transition = Transition.transition(meta.getContext(), State.TIMED_WAITING);){
            meta.getContext().getBlockingSupport().sleep(unit.toNanos(amount), location);
        }
        catch (GuestInterruptedException e) {
            if (meta.getThreadAccess().isInterrupted(thread, true)) {
                throw meta.throwExceptionWithMessage(meta.java_lang_InterruptedException, e.getMessage());
            }
            meta.getThreadAccess().fullSafePoint(thread);
        }
        catch (IllegalArgumentException e) {
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, e.getMessage());
        }
    }

    @Substitution
    public static long getNextThreadIdOffset() {
        return 0x13371337L;
    }

    @Substitution
    public static @JavaType(value=Thread.class) StaticObject currentCarrierThread(@Inject EspressoContext context) {
        return context.getCurrentPlatformThread();
    }

    @CompilerDirectives.TruffleBoundary
    @Substitution(hasReceiver=true)
    public static void interrupt0(@JavaType(value=Object.class) StaticObject self, @Inject EspressoContext context) {
        context.getThreadAccess().interrupt(self);
    }

    @Substitution
    public static void clearInterruptEvent(@Inject EspressoContext context) {
        context.getThreadAccess().clearInterruptEvent();
    }

    @CompilerDirectives.TruffleBoundary
    @Substitution(hasReceiver=true, versionFilter=VersionFilter.Java13OrEarlier.class)
    public static boolean isInterrupted(@JavaType(value=Thread.class) StaticObject self, boolean clear, @Inject EspressoContext context) {
        return context.getThreadAccess().isInterrupted(self, clear);
    }

    @CompilerDirectives.TruffleBoundary
    @Substitution(hasReceiver=true)
    public static void resume0(@JavaType(value=Thread.class) StaticObject self, @Inject EspressoContext context) {
        context.getThreadAccess().resume(self);
    }

    @CompilerDirectives.TruffleBoundary
    @Substitution(hasReceiver=true)
    public static void suspend0(@JavaType(value=Thread.class) StaticObject self, @Inject EspressoContext context) {
        context.getThreadAccess().suspend(self);
    }

    @CompilerDirectives.TruffleBoundary
    @Substitution(hasReceiver=true)
    public static void stop0(@JavaType(value=Thread.class) StaticObject self, @JavaType(value=Object.class) StaticObject throwable, @Inject EspressoContext context) {
        context.getThreadAccess().stop(self, throwable);
    }

    @CompilerDirectives.TruffleBoundary
    @Substitution(hasReceiver=true)
    public static void setNativeName(@JavaType(value=Thread.class) StaticObject self, @JavaType(value=String.class) StaticObject name, @Inject Meta meta) {
        Thread hostThread = meta.getThreadAccess().getHost(self);
        if (hostThread == null) {
            return;
        }
        hostThread.setName(meta.toHostString(name));
    }

    public static StaticObject getStackTrace(StaticObject thread, int maxDepth, EspressoContext context, Node node) {
        VM.StackTrace stackTrace;
        Thread hostThread = context.getThreadAccess().getHost(thread);
        if (hostThread == null) {
            return StaticObject.NULL;
        }
        if (hostThread == Thread.currentThread()) {
            stackTrace = InterpreterToVM.getStackTrace(InterpreterToVM.DefaultHiddenFramesFilter.INSTANCE, maxDepth);
        } else {
            stackTrace = Target_java_lang_Thread.asyncGetStackTrace(hostThread, maxDepth, context, node);
            if (stackTrace == null) {
                return StaticObject.NULL;
            }
        }
        return context.getMeta().java_lang_StackTraceElement.allocateReferenceArray(stackTrace.size, i -> {
            StaticObject ste = context.getMeta().java_lang_StackTraceElement.allocateInstance(context);
            VM.fillInElement(ste, stackTrace.trace[i], context.getMeta());
            return ste;
        });
    }

    @CompilerDirectives.TruffleBoundary
    private static VM.StackTrace asyncGetStackTrace(Thread thread, int maxDepth, EspressoContext context, Node node) {
        assert (maxDepth >= 0);
        CollectStackTraceAction action = new CollectStackTraceAction(maxDepth);
        Future future = context.getEnv().submitThreadLocal(new Thread[]{thread}, (ThreadLocalAction)action);
        TruffleSafepoint.setBlockedThreadInterruptible((Node)node, f -> {
            try {
                future.get();
            }
            catch (ExecutionException e) {
                throw EspressoError.shouldNotReachHere(e);
            }
        }, (Object)future);
        return action.result;
    }

    @Substitution(versionFilter=VersionFilter.Java20OrLater.class)
    public static @JavaType(value=Object[].class) StaticObject scopedValueCache(@Inject EspressoContext context) {
        StaticObject platformThread = context.getCurrentPlatformThread();
        return context.getThreadAccess().getScopedValueCache(platformThread);
    }

    @Substitution(versionFilter=VersionFilter.Java20OrLater.class)
    public static void setScopedValueCache(@JavaType(value=Object[].class) StaticObject cache, @Inject EspressoContext context) {
        StaticObject platformThread = context.getCurrentPlatformThread();
        context.getThreadAccess().setScopedValueCache(platformThread, cache);
    }

    @Substitution(versionFilter=VersionFilter.Java20OrLater.class, isTrivial=true)
    public static void ensureMaterializedForStackWalk(@JavaType(value=Object.class) StaticObject obj) {
        CompilerDirectives.blackhole((Object)obj);
    }

    private static final class CollectStackTraceAction
    extends ThreadLocalAction {
        private final int maxDepth;
        VM.StackTrace result;

        protected CollectStackTraceAction(int maxDepth) {
            super(false, false);
            this.maxDepth = maxDepth;
        }

        protected void perform(ThreadLocalAction.Access access) {
            assert (access.getThread() == Thread.currentThread());
            this.result = InterpreterToVM.getStackTrace(InterpreterToVM.DefaultHiddenFramesFilter.INSTANCE, this.maxDepth);
        }
    }

    @Substitution(versionFilter=VersionFilter.Java19OrLater.class, hasReceiver=true)
    static abstract class GetStackTrace0
    extends SubstitutionNode {
        GetStackTrace0() {
        }

        abstract @JavaType(value=Object.class) StaticObject execute(@JavaType(value=Thread.class) StaticObject var1);

        @Specialization
        public @JavaType(value=Object.class) StaticObject doGetStackTrace(@JavaType(value=Thread.class) StaticObject self) {
            EspressoContext context = EspressoContext.get(this);
            return Target_java_lang_Thread.getStackTrace(self, Integer.MAX_VALUE, context, this);
        }
    }

    @Substitution(hasReceiver=true)
    static abstract class Start0
    extends SubstitutionNode {
        Start0() {
        }

        abstract void execute(@JavaType(value=Thread.class) StaticObject var1);

        @Specialization
        @CompilerDirectives.TruffleBoundary
        void doCached(@JavaType(value=Thread.class) StaticObject self, @Bind(value="getContext()") EspressoContext context, @Cached(value="create(context.getMeta().java_lang_Thread_exit.getCallTarget())") DirectCallNode threadExit, @Cached(value="create(context.getMeta().java_lang_Thread_dispatchUncaughtException.getCallTarget())") DirectCallNode dispatchUncaught) {
            ThreadsAccess threadAccess = context.getThreadAccess();
            if (context.multiThreadingEnabled()) {
                if (threadAccess.terminateIfStillborn(self)) {
                    return;
                }
                Thread hostThread = threadAccess.createJavaThread(self, threadExit, dispatchUncaught);
                context.getLogger().fine(() -> {
                    String guestName = threadAccess.getThreadName(self);
                    long guestId = threadAccess.getThreadId(self);
                    return String.format("Thread.start0: [HOST:%s, %d], [GUEST:%s, %d]", hostThread.getName(), EspressoThreadRegistry.getThreadId(hostThread), guestName, guestId);
                });
                hostThread.start();
            } else {
                String reason = context.getMultiThreadingDisabledReason();
                Klass threadKlass = self.getKlass();
                EspressoContext.get(null).getLogger().warning(() -> {
                    String guestName = threadAccess.getThreadName(self);
                    String className = threadKlass.getExternalName();
                    return "Thread.start() called on " + className + " / " + guestName + " but thread support is disabled: " + reason;
                });
                Meta meta = context.getMeta();
                if (threadKlass != meta.java_lang_ref_Finalizer$FinalizerThread && threadKlass != meta.java_lang_ref_Reference$ReferenceHandler && !Target_java_lang_Thread.isSystemInnocuousThread(self, meta)) {
                    meta.throwExceptionWithMessage(meta.java_lang_OutOfMemoryError, "Thread support is disabled: " + reason);
                }
            }
        }
    }
}

