/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.bytecodes.InvokeInterface;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.JavaVersion;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.EspressoSubstitutions;
import com.oracle.truffle.espresso.substitutions.Inject;
import com.oracle.truffle.espresso.substitutions.JavaType;
import com.oracle.truffle.espresso.substitutions.Substitution;
import com.oracle.truffle.espresso.substitutions.SubstitutionNode;
import com.oracle.truffle.espresso.substitutions.Target_java_util_regex_Pattern;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@EspressoSubstitutions
public final class Target_java_util_regex_Matcher {
    private static final int NOANCHOR = 0;
    private static final int ENDANCHOR = 1;

    private Target_java_util_regex_Matcher() {
    }

    @Substitution(hasReceiver=true)
    public static boolean hitEnd(StaticObject self, @Inject EspressoContext context) {
        Meta meta = context.getMeta();
        if (context.regexSubstitutionsEnabled()) {
            Target_java_util_regex_Matcher.executeLastWithFallback(self, meta);
        }
        return meta.java_util_regex_Matcher_hitEnd.getBoolean(self);
    }

    @Substitution(hasReceiver=true)
    public static boolean requireEnd(StaticObject self, @Inject EspressoContext context) {
        Meta meta = context.getMeta();
        if (context.regexSubstitutionsEnabled()) {
            Target_java_util_regex_Matcher.executeLastWithFallback(self, meta);
        }
        return meta.java_util_regex_Matcher_requireEnd.getBoolean(self);
    }

    private static Object getValue(Object map, String key, InteropLibrary mapInterop) {
        try {
            return mapInterop.readMember(map, key);
        }
        catch (UnknownIdentifierException | UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere(e);
        }
    }

    private static String getKey(Object keys, long i, InteropLibrary stringInterop, InteropLibrary arrayInterop) {
        try {
            return stringInterop.asString(arrayInterop.readArrayElement(keys, i));
        }
        catch (InvalidArrayIndexException | UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere(e);
        }
    }

    private static long getArraySize(Object keys, InteropLibrary arrayInterop) {
        try {
            return arrayInterop.getArraySize(keys);
        }
        catch (UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere(e);
        }
    }

    private static Object getMembers(Object map, InteropLibrary mapInterop) {
        try {
            return mapInterop.getMembers(map);
        }
        catch (UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere(e);
        }
    }

    private static Object getGroups(Object regexObject, InteropLibrary regexObjectInterop) {
        try {
            return regexObjectInterop.readMember(regexObject, "groups");
        }
        catch (UnknownIdentifierException | UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere(e);
        }
    }

    private static int getGroupCount(Object regexObject, InteropLibrary regexObjectInterop, InteropLibrary integerInterop) {
        try {
            return integerInterop.asInt(regexObjectInterop.readMember(regexObject, "groupCount"));
        }
        catch (UnknownIdentifierException | UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    @CompilerDirectives.TruffleBoundary
    static Source getSource(RegexAction action, String pattern, int flags, JavaVersion javaVersion) {
        String actionString = switch (action.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> "Validate=true";
            case 1 -> "MatchingMode=match";
            case 2 -> "MatchingMode=fullmatch";
            case 3 -> "MatchingMode=search";
        };
        String combined = "Encoding=UTF-16,Flavor=JavaUtilPattern," + actionString + ",JavaJDKVersion=" + String.valueOf(javaVersion);
        String sourceStr = combined + "/" + pattern + "/" + Target_java_util_regex_Pattern.convertFlags(flags);
        return Source.newBuilder((String)"regex", (CharSequence)sourceStr, (String)"patternExpr").build();
    }

    @CompilerDirectives.TruffleBoundary
    private static void executeSearch(StaticObject self, int from, Meta meta) {
        meta.java_util_regex_Matcher_search.getCallTargetNoSubstitution().call(new Object[]{self, from});
    }

    @CompilerDirectives.TruffleBoundary
    private static void executeMatch(StaticObject self, int from, int anchor, Meta meta) {
        meta.java_util_regex_Matcher_match.getCallTargetNoSubstitution().call(new Object[]{self, from, anchor});
    }

    private static void reallocateGroupsArrayIfNecessary(StaticObject self, StaticObject parentPattern, Meta meta) {
        int parentGroupCount = Math.max(meta.java_util_regex_Pattern_capturingGroupCount.getInt(parentPattern), 10);
        StaticObject groups = meta.java_util_regex_Matcher_groups.getObject(self);
        if (groups.length(meta.getLanguage()) != parentGroupCount * 2) {
            StaticObject newGroups = meta._int.allocatePrimitiveArray(parentGroupCount * 2);
            meta.java_util_regex_Matcher_groups.setObject(self, newGroups);
        }
    }

    private static void compileFallBackIfRequired(StaticObject self, Meta meta) {
        StaticObject parentPattern = meta.java_util_regex_Matcher_parentPattern.getObject(self);
        if (StaticObject.isNull(meta.java_util_regex_Pattern_root.getObject(parentPattern))) {
            meta.java_util_regex_Pattern_compile.invokeDirect(parentPattern, new Object[0]);
            Target_java_util_regex_Matcher.reallocateGroupsArrayIfNecessary(self, parentPattern, meta);
            int localCount = meta.java_util_regex_Pattern_localCount.getInt(parentPattern);
            int localsTCNCount = meta.java_util_regex_Pattern_localTCNCount.getInt(parentPattern);
            StaticObject locals = meta._int.allocatePrimitiveArray(localCount);
            StaticObject localsPos = meta.java_util_regex_IntHashSet.allocateReferenceArray(localsTCNCount);
            meta.java_util_regex_Matcher_locals.setObject(self, locals);
            meta.java_util_regex_Matcher_localsPos.setObject(self, localsPos);
        }
    }

    private static void executeLastWithFallback(StaticObject self, Meta meta) {
        if (meta.java_util_regex_Matcher_HIDDEN_matchingModeBackup.getHiddenObject(self) != StaticObject.NULL) {
            int from = (Integer)meta.java_util_regex_Matcher_HIDDEN_searchFromBackup.getHiddenObject(self);
            RegexAction action = (RegexAction)((Object)meta.java_util_regex_Matcher_HIDDEN_matchingModeBackup.getHiddenObject(self));
            assert (action != RegexAction.Validate);
            Target_java_util_regex_Matcher.compileFallBackIfRequired(self, meta);
            Target_java_util_regex_Matcher.applyBackup(self, meta);
            meta.java_util_regex_Matcher_HIDDEN_matchingModeBackup.setHiddenObject(self, StaticObject.NULL);
            switch (action.ordinal()) {
                case 1: {
                    Target_java_util_regex_Matcher.executeMatch(self, from, 0, meta);
                    break;
                }
                case 2: {
                    Target_java_util_regex_Matcher.executeMatch(self, from, 1, meta);
                    break;
                }
                case 3: {
                    Target_java_util_regex_Matcher.executeSearch(self, from, meta);
                }
            }
        }
    }

    private static void saveBackup(StaticObject self, Meta meta) {
        meta.java_util_regex_Matcher_HIDDEN_oldLastBackup.setHiddenObject(self, meta.java_util_regex_Matcher_oldLast.getValue(self));
        meta.java_util_regex_Matcher_HIDDEN_modCountBackup.setHiddenObject(self, meta.java_util_regex_Matcher_modCount.getValue(self));
        meta.java_util_regex_Matcher_HIDDEN_transparentBoundsBackup.setHiddenObject(self, meta.java_util_regex_Matcher_transparentBounds.getValue(self));
        meta.java_util_regex_Matcher_HIDDEN_anchoringBoundsBackup.setHiddenObject(self, meta.java_util_regex_Matcher_anchoringBounds.getValue(self));
        meta.java_util_regex_Matcher_HIDDEN_fromBackup.setHiddenObject(self, meta.java_util_regex_Matcher_from.getValue(self));
        meta.java_util_regex_Matcher_HIDDEN_toBackup.setHiddenObject(self, meta.java_util_regex_Matcher_to.getValue(self));
    }

    private static void applyBackup(StaticObject self, Meta meta) {
        meta.java_util_regex_Matcher_oldLast.setValue(self, meta.java_util_regex_Matcher_HIDDEN_oldLastBackup.getHiddenObject(self));
        meta.java_util_regex_Matcher_modCount.setValue(self, meta.java_util_regex_Matcher_HIDDEN_modCountBackup.getHiddenObject(self));
        meta.java_util_regex_Matcher_transparentBounds.setValue(self, meta.java_util_regex_Matcher_HIDDEN_transparentBoundsBackup.getHiddenObject(self));
        meta.java_util_regex_Matcher_anchoringBounds.setValue(self, meta.java_util_regex_Matcher_HIDDEN_anchoringBoundsBackup.getHiddenObject(self));
        meta.java_util_regex_Matcher_from.setValue(self, meta.java_util_regex_Matcher_HIDDEN_fromBackup.getHiddenObject(self));
        meta.java_util_regex_Matcher_to.setValue(self, meta.java_util_regex_Matcher_HIDDEN_toBackup.getHiddenObject(self));
    }

    static boolean isUnsupportedMatcher(StaticObject self, Meta meta) {
        if (meta.java_util_regex_Matcher_parentPattern == null) {
            return true;
        }
        StaticObject parentPattern = meta.java_util_regex_Matcher_parentPattern.getObject(self);
        if (Target_java_util_regex_Pattern.isUnsupportedPattern(parentPattern, meta)) {
            return true;
        }
        return !meta.java_util_regex_Matcher_anchoringBounds.getBoolean(self) || meta.java_util_regex_Matcher_transparentBounds.getBoolean(self);
    }

    static boolean isString(StaticObject obj, Meta meta) {
        return obj.getKlass() == meta.java_lang_String;
    }

    private static void saveTruffleString(StaticObject self, TruffleString.FromJavaStringNode fromJavaStringNode, StaticObject espressoString, Meta meta) {
        TruffleString truffleString = fromJavaStringNode.execute(meta.toHostString(espressoString), TruffleString.Encoding.UTF_16);
        meta.java_util_regex_Matcher_HIDDEN_tstring.setHiddenObject(self, truffleString);
    }

    static enum RegexAction {
        Validate,
        Match,
        FullMatch,
        Search;

    }

    @GenerateInline
    @GenerateUncached
    public static abstract class JavaRegexExecNode
    extends Node {
        public abstract boolean execute(Node var1, Object var2, StaticObject var3, int var4, Meta var5);

        @Specialization
        static boolean doDefault(Node node, Object regexObject, StaticObject self, int from, Meta meta, @CachedLibrary(limit="3") InteropLibrary regexObjectInterop, @CachedLibrary(limit="3") InteropLibrary integerInterop, @CachedLibrary(limit="3") InteropLibrary booleanInterop, @CachedLibrary(limit="3") InteropLibrary execResInterop, @Cached InlinedBranchProfile ioobeProfile) {
            try {
                TruffleString truffleString = (TruffleString)meta.java_util_regex_Matcher_HIDDEN_tstring.getHiddenObject(self);
                int fromClipped = Math.max(from, 0);
                meta.java_util_regex_Matcher_first.setInt(self, fromClipped);
                int regionFrom = meta.java_util_regex_Matcher_from.getInt(self);
                int regionTo = meta.java_util_regex_Matcher_to.getInt(self);
                int truffleStringLength = truffleString.byteLength(TruffleString.Encoding.UTF_16) >> 1;
                if (regionFrom < 0 || regionTo < regionFrom || regionTo > truffleStringLength) {
                    ioobeProfile.enter(node);
                    meta.throwException(meta.java_lang_IndexOutOfBoundsException);
                }
                Object execRes = regexObjectInterop.invokeMember(regexObject, "exec", new Object[]{truffleString, fromClipped, regionTo, regionFrom, regionTo});
                boolean isMatch = booleanInterop.asBoolean(execResInterop.readMember(execRes, "isMatch"));
                int modCount = meta.java_util_regex_Matcher_modCount.getInt(self);
                meta.java_util_regex_Matcher_modCount.setInt(self, modCount + 1);
                if (isMatch) {
                    int first = integerInterop.asInt(execResInterop.invokeMember(execRes, "getStart", new Object[]{0}));
                    int last = integerInterop.asInt(execResInterop.invokeMember(execRes, "getEnd", new Object[]{0}));
                    meta.java_util_regex_Matcher_first.setInt(self, first);
                    meta.java_util_regex_Matcher_last.setInt(self, last);
                    int groupCount = integerInterop.asInt(regexObjectInterop.readMember(regexObject, "groupCount"));
                    StaticObject array = meta.java_util_regex_Matcher_groups.getObject(self);
                    int[] unwrapped = (int[])array.unwrap(meta.getLanguage());
                    for (int i = 0; i < groupCount; ++i) {
                        int start = integerInterop.asInt(execResInterop.invokeMember(execRes, "getStart", new Object[]{i}));
                        int end = integerInterop.asInt(execResInterop.invokeMember(execRes, "getEnd", new Object[]{i}));
                        unwrapped[i * 2] = start;
                        unwrapped[i * 2 + 1] = end;
                    }
                }
                return isMatch;
            }
            catch (ArityException | UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }
    }

    @GenerateInline
    @GenerateUncached
    static abstract class JavaRegexCompileNode
    extends Node {
        JavaRegexCompileNode() {
        }

        public abstract Object execute(Node var1, StaticObject var2, RegexAction var3, Field var4, EspressoContext var5);

        @Specialization
        static Object doDefault(StaticObject self, RegexAction action, Field destination, EspressoContext context, @CachedLibrary(limit="3") InteropLibrary regexObjectInterop, @CachedLibrary(limit="3") InteropLibrary integerInterop, @CachedLibrary(limit="3") InteropLibrary mapInterop, @CachedLibrary(limit="3") InteropLibrary stringInterop, @CachedLibrary(limit="3") InteropLibrary arrayInterop) {
            Meta meta = context.getMeta();
            StaticObject patternObject = meta.java_util_regex_Matcher_parentPattern.getObject(self);
            String pattern = meta.toHostString(meta.java_util_regex_Pattern_pattern.getObject(patternObject));
            Source src = Target_java_util_regex_Matcher.getSource(action, pattern, meta.java_util_regex_Pattern_flags0.getInt(patternObject), meta.getJavaVersion());
            Object regexObject = context.getEnv().parseInternal(src, new String[0]).call(new Object[0]);
            Target_java_util_regex_Pattern.LOGGER.log(Level.FINEST, () -> "Compiled Pattern: " + pattern);
            destination.setHiddenObject(patternObject, regexObject);
            int groupCount = Target_java_util_regex_Matcher.getGroupCount(regexObject, regexObjectInterop, integerInterop);
            meta.java_util_regex_Pattern_capturingGroupCount.setInt(patternObject, groupCount);
            Target_java_util_regex_Matcher.reallocateGroupsArrayIfNecessary(self, patternObject, meta);
            if (meta.java_util_regex_Pattern_namedGroups_field.getObject(patternObject) == null) {
                Object map = Target_java_util_regex_Matcher.getGroups(regexObject, regexObjectInterop);
                Object keys = Target_java_util_regex_Matcher.getMembers(map, mapInterop);
                long size = Target_java_util_regex_Matcher.getArraySize(keys, arrayInterop);
                StaticObject guestMap = meta.java_util_HashMap.allocateInstance();
                meta.java_util_HashMap_init.invokeDirect(guestMap, (int)size);
                for (long i = 0L; i < size; ++i) {
                    String key = Target_java_util_regex_Matcher.getKey(keys, i, stringInterop, arrayInterop);
                    Object value = Target_java_util_regex_Matcher.getValue(map, key, mapInterop);
                    StaticObject guestKey = meta.toGuestString(key);
                    Object integerValue = meta.java_lang_Integer_valueOf.invokeDirect(value, new Object[0]);
                    meta.java_util_HashMap_put.invokeDirect(guestMap, guestKey, integerValue);
                }
                meta.java_util_regex_Pattern_namedGroups_field.setObject(patternObject, guestMap);
            }
            return regexObject;
        }
    }

    @Substitution(hasReceiver=true)
    static abstract class GroupCount
    extends SubstitutionNode {
        GroupCount() {
        }

        abstract int execute(@JavaType(value=Matcher.class) StaticObject var1);

        @Specialization
        static int doDefault(StaticObject self, @Bind(value="getContext()") EspressoContext context, @Cached(value="create(context.getMeta().java_util_regex_Matcher_groupCount.getCallTargetNoSubstitution())") DirectCallNode original) {
            if (context.regexSubstitutionsEnabled()) {
                Meta meta = context.getMeta();
                StaticObject parentPattern = meta.java_util_regex_Matcher_parentPattern.getObject(self);
                if (meta.java_util_regex_Pattern_capturingGroupCount.getInt(parentPattern) == -1) {
                    meta.java_util_regex_Pattern_capturingGroupCount.setInt(parentPattern, 1);
                    Target_java_util_regex_Matcher.compileFallBackIfRequired(self, meta);
                }
            }
            return (Integer)original.call(new Object[]{self});
        }
    }

    @ImportStatic(value={Target_java_util_regex_Matcher.class})
    @Substitution(hasReceiver=true)
    static abstract class Search
    extends SubstitutionNode {
        Search() {
        }

        abstract boolean execute(@JavaType(value=Matcher.class) StaticObject var1, int var2);

        @Specialization(guards={"!isUnsupportedMatcher(self, meta)", "regexObject != null"})
        boolean doLazy(StaticObject self, int from, @Bind(value="getMeta()") Meta meta, @Bind(value="getRegexSearchObject(self, meta)") Object regexObject, @Cached.Shared(value="exec") @Cached JavaRegexExecNode javaRegexExecNode, @Bind(value="this") Node node) {
            assert (this.getContext().regexSubstitutionsEnabled());
            meta.java_util_regex_Matcher_HIDDEN_searchFromBackup.setHiddenObject(self, from);
            meta.java_util_regex_Matcher_HIDDEN_matchingModeBackup.setHiddenObject(self, (Object)RegexAction.Search);
            Target_java_util_regex_Matcher.saveBackup(self, meta);
            boolean isMatch = javaRegexExecNode.execute(node, regexObject, self, from, meta);
            if (!isMatch) {
                meta.java_util_regex_Matcher_first.setInt(self, -1);
            }
            return isMatch;
        }

        @Specialization(guards={"!isUnsupportedMatcher(self, meta)", "getRegexSearchObject(self, meta) == null"})
        static boolean doCompile(StaticObject self, int from, @Bind(value="getContext()") EspressoContext context, @Bind(value="context.getMeta()") Meta meta, @Cached.Shared(value="exec") @Cached JavaRegexExecNode javaRegexExecNode, @Cached JavaRegexCompileNode javaRegexCompileNode, @Bind(value="this") Node node) {
            assert (context.regexSubstitutionsEnabled());
            meta.java_util_regex_Matcher_HIDDEN_searchFromBackup.setHiddenObject(self, from);
            meta.java_util_regex_Matcher_HIDDEN_matchingModeBackup.setHiddenObject(self, (Object)RegexAction.Search);
            Object regexObject = javaRegexCompileNode.execute(node, self, RegexAction.Search, meta.java_util_regex_Pattern_HIDDEN_tregexSearch, context);
            Target_java_util_regex_Matcher.saveBackup(self, meta);
            boolean isMatch = javaRegexExecNode.execute(node, regexObject, self, from, meta);
            if (!isMatch) {
                meta.java_util_regex_Matcher_first.setInt(self, -1);
            }
            return isMatch;
        }

        @Specialization(guards={"isUnsupportedMatcher(self, meta)"})
        static boolean doFallback(StaticObject self, int from, @Bind(value="getContext()") EspressoContext context, @Bind(value="context.getMeta()") Meta meta, @Cached(value="create(meta.java_util_regex_Matcher_search.getCallTargetNoSubstitution())") DirectCallNode original) {
            if (context.regexSubstitutionsEnabled()) {
                meta.java_util_regex_Matcher_HIDDEN_matchingModeBackup.setHiddenObject(self, StaticObject.NULL);
                Target_java_util_regex_Matcher.compileFallBackIfRequired(self, meta);
            }
            return (Boolean)original.call(new Object[]{self, from});
        }

        public static Object getRegexSearchObject(StaticObject self, Meta meta) {
            StaticObject parentPattern = meta.java_util_regex_Matcher_parentPattern.getObject(self);
            return meta.java_util_regex_Pattern_HIDDEN_tregexSearch.getHiddenObject(parentPattern);
        }
    }

    @ImportStatic(value={Target_java_util_regex_Matcher.class})
    @Substitution(hasReceiver=true)
    static abstract class Match
    extends SubstitutionNode {
        Match() {
        }

        abstract boolean execute(@JavaType(value=Matcher.class) StaticObject var1, int var2, int var3);

        @Specialization(guards={"!isUnsupportedMatcher(self, meta)", "regexObject != null"})
        boolean doLazy(StaticObject self, int from, int anchor, @Bind(value="getMeta()") Meta meta, @Bind(value="getRegexObject(self, anchor, meta)") Object regexObject, @Cached.Shared(value="exec") @Cached JavaRegexExecNode javaRegexExecNode, @Bind(value="this") Node node) {
            assert (this.getContext().regexSubstitutionsEnabled());
            meta.java_util_regex_Matcher_HIDDEN_searchFromBackup.setHiddenObject(self, from);
            meta.java_util_regex_Matcher_HIDDEN_matchingModeBackup.setHiddenObject(self, (Object)Match.getMatchAction(anchor));
            return Match.checkResult(self, from, anchor, regexObject, javaRegexExecNode, node, meta);
        }

        @Specialization(guards={"getRegexObject(self, anchor, meta) == null", "!isUnsupportedMatcher(self, meta)"})
        static boolean doCompile(StaticObject self, int from, int anchor, @Bind(value="getContext()") EspressoContext context, @Bind(value="context.getMeta()") Meta meta, @Cached.Shared(value="exec") @Cached JavaRegexExecNode javaRegexExecNode, @Cached JavaRegexCompileNode javaRegexCompileNode, @Bind(value="this") Node node) {
            Field destination;
            assert (context.regexSubstitutionsEnabled());
            RegexAction action = Match.getMatchAction(anchor);
            meta.java_util_regex_Matcher_HIDDEN_searchFromBackup.setHiddenObject(self, from);
            meta.java_util_regex_Matcher_HIDDEN_matchingModeBackup.setHiddenObject(self, (Object)action);
            if (anchor == 1) {
                destination = meta.java_util_regex_Pattern_HIDDEN_tregexFullmatch;
            } else {
                assert (anchor == 0);
                destination = meta.java_util_regex_Pattern_HIDDEN_tregexMatch;
            }
            Object regexObject = javaRegexCompileNode.execute(node, self, action, destination, context);
            return Match.checkResult(self, from, anchor, regexObject, javaRegexExecNode, node, meta);
        }

        @Specialization(guards={"isUnsupportedMatcher(self, context.getMeta())"})
        static boolean doFallback(StaticObject self, int from, int anchor, @Bind(value="getContext()") EspressoContext context, @Cached(value="create(context.getMeta().java_util_regex_Matcher_match.getCallTargetNoSubstitution())") DirectCallNode original) {
            if (context.regexSubstitutionsEnabled()) {
                Meta meta = context.getMeta();
                meta.java_util_regex_Matcher_HIDDEN_matchingModeBackup.setHiddenObject(self, StaticObject.NULL);
                Target_java_util_regex_Matcher.compileFallBackIfRequired(self, meta);
            }
            return (Boolean)original.call(new Object[]{self, from, anchor});
        }

        private static RegexAction getMatchAction(int anchor) {
            if (anchor == 0) {
                return RegexAction.Match;
            }
            assert (anchor == 1);
            return RegexAction.FullMatch;
        }

        public static Object getRegexObject(StaticObject self, int anchor, Meta meta) {
            if (meta.java_util_regex_Matcher_parentPattern == null || meta.java_util_regex_Pattern_HIDDEN_tregexMatch == null) {
                return null;
            }
            StaticObject parentPattern = meta.java_util_regex_Matcher_parentPattern.getObject(self);
            if (anchor == 1) {
                return meta.java_util_regex_Pattern_HIDDEN_tregexFullmatch.getHiddenObject(parentPattern);
            }
            assert (anchor == 0);
            return meta.java_util_regex_Pattern_HIDDEN_tregexMatch.getHiddenObject(parentPattern);
        }

        private static boolean checkResult(StaticObject self, int from, int anchor, Object regexObject, JavaRegexExecNode javaRegexExecNode, Node node, Meta meta) {
            Target_java_util_regex_Matcher.saveBackup(self, meta);
            if (javaRegexExecNode.execute(node, regexObject, self, from, meta)) {
                if (anchor == 1) {
                    int to;
                    int last = meta.java_util_regex_Matcher_last.getInt(self);
                    if (last == (to = meta.java_util_regex_Matcher_to.getInt(self))) {
                        return true;
                    }
                } else {
                    assert (anchor == 0);
                    return true;
                }
            }
            meta.java_util_regex_Matcher_first.setInt(self, -1);
            return false;
        }
    }

    @ImportStatic(value={Target_java_util_regex_Matcher.class})
    @Substitution(hasReceiver=true)
    static abstract class Reset
    extends SubstitutionNode {
        Reset() {
        }

        abstract @JavaType(value=Matcher.class) StaticObject execute(@JavaType(value=Matcher.class) StaticObject var1, @JavaType(value=CharSequence.class) StaticObject var2);

        @Specialization(guards={"!isUnsupportedMatcher(self, meta)", "isString(text, meta)"})
        StaticObject doStringConversion(StaticObject self, StaticObject text, @Bind(value="getMeta()") Meta meta, @Cached.Shared(value="fromJavaString") @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached.Shared(value="original") @Cached(value="create(getMeta().java_util_regex_Matcher_reset.getCallTargetNoSubstitution())") DirectCallNode original) {
            assert (this.getContext().regexSubstitutionsEnabled());
            Target_java_util_regex_Matcher.saveTruffleString(self, fromJavaStringNode, text, meta);
            return (StaticObject)original.call(new Object[]{self, text});
        }

        @Specialization(guards={"!isUnsupportedMatcher(self, meta)", "!isString(text, meta)"})
        StaticObject doCharSeqConversion(StaticObject self, StaticObject text, @Bind(value="getMeta()") Meta meta, @Cached.Shared(value="fromJavaString") @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached.Shared(value="original") @Cached(value="create(getMeta().java_util_regex_Matcher_reset.getCallTargetNoSubstitution())") DirectCallNode original, @Cached(value="create(meta.java_lang_CharSequence_toString)") InvokeInterface toStringCall) {
            assert (this.getContext().regexSubstitutionsEnabled());
            StaticObject espressoString = (StaticObject)toStringCall.execute(new Object[]{text});
            Target_java_util_regex_Matcher.saveTruffleString(self, fromJavaStringNode, espressoString, meta);
            return (StaticObject)original.call(new Object[]{self, text});
        }

        @Specialization(guards={"isUnsupportedMatcher(self, meta)"})
        static StaticObject doFallback(StaticObject self, StaticObject text, @Bind(value="getMeta()") Meta meta, @Cached.Shared(value="original") @Cached(value="create(getMeta().java_util_regex_Matcher_reset.getCallTargetNoSubstitution())") DirectCallNode original) {
            return (StaticObject)original.call(new Object[]{self, text});
        }
    }

    @ImportStatic(value={Target_java_util_regex_Pattern.class, Target_java_util_regex_Matcher.class})
    @Substitution(hasReceiver=true, methodName="<init>")
    static abstract class Init
    extends SubstitutionNode {
        Init() {
        }

        abstract void execute(@JavaType(value=Matcher.class) StaticObject var1, @JavaType(value=Pattern.class) StaticObject var2, @JavaType(value=CharSequence.class) StaticObject var3);

        @Specialization(guards={"!isUnsupportedPattern(parent, meta)", "isString(text, meta)"})
        void doStringConversion(StaticObject self, StaticObject parent, StaticObject text, @Bind(value="getMeta()") Meta meta, @Cached.Shared(value="fromJavaString") @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached.Shared(value="original") @Cached(value="create(getMeta().java_util_regex_Matcher_init.getCallTargetNoSubstitution())") DirectCallNode original) {
            assert (this.getContext().regexSubstitutionsEnabled());
            Target_java_util_regex_Matcher.saveTruffleString(self, fromJavaStringNode, text, meta);
            original.call(new Object[]{self, parent, text});
        }

        @Specialization(guards={"!isUnsupportedPattern(parent, meta)", "!isString(text, meta)"})
        void doCharSeqConversion(StaticObject self, StaticObject parent, StaticObject text, @Bind(value="getMeta()") Meta meta, @Cached.Shared(value="fromJavaString") @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached.Shared(value="original") @Cached(value="create(getMeta().java_util_regex_Matcher_init.getCallTargetNoSubstitution())") DirectCallNode original, @Cached(value="create(meta.java_lang_CharSequence_toString)") InvokeInterface toStringCall) {
            assert (this.getContext().regexSubstitutionsEnabled());
            StaticObject espressoString = (StaticObject)toStringCall.execute(new Object[]{text});
            Target_java_util_regex_Matcher.saveTruffleString(self, fromJavaStringNode, espressoString, meta);
            original.call(new Object[]{self, parent, text});
        }

        @Specialization(guards={"isUnsupportedPattern(parent, meta)"})
        static void doFallback(StaticObject self, StaticObject parent, StaticObject text, @Bind(value="getMeta()") Meta meta, @Cached.Shared(value="original") @Cached(value="create(getMeta().java_util_regex_Matcher_init.getCallTargetNoSubstitution())") DirectCallNode original) {
            original.call(new Object[]{self, parent, text});
        }
    }
}

