/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.EspressoSubstitutions;
import com.oracle.truffle.espresso.substitutions.Inject;
import com.oracle.truffle.espresso.substitutions.JavaType;
import com.oracle.truffle.espresso.substitutions.Substitution;
import com.oracle.truffle.espresso.substitutions.SubstitutionNamesProvider;
import com.oracle.truffle.espresso.vm.UnsafeAccess;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.EnumSet;
import java.util.List;

@EspressoSubstitutions(nameProvider=WhiteBoxNameProvider.class)
public final class Target_jdk_test_whitebox_WhiteBox {
    @Substitution
    public static void registerNatives() {
    }

    @Substitution(hasReceiver=true)
    public static boolean isJVMTIIncluded(StaticObject self, @Inject Meta meta, @Inject EspressoLanguage language) {
        Target_jdk_test_whitebox_WhiteBox.checkWhiteBox(meta, language);
        return false;
    }

    private static void checkWhiteBox(Meta meta, EspressoLanguage language) {
        if (!language.isWhiteBoxEnabled()) {
            throw meta.throwException(meta.java_lang_UnsatisfiedLinkError);
        }
    }

    @Substitution(hasReceiver=true)
    public static @JavaType(value=Boolean.class) StaticObject getBooleanVMFlag(StaticObject self, @JavaType(value=String.class) StaticObject guestName, @Inject Meta meta, @Inject EspressoLanguage language, @Inject EspressoContext context) {
        String name;
        Target_jdk_test_whitebox_WhiteBox.checkWhiteBox(meta, language);
        return switch (name = meta.toHostString(guestName)) {
            case "VMContinuations" -> meta.boxBoolean(false);
            case "UseCompiler", "ProfileInterpreter" -> meta.boxBoolean(Target_jdk_test_whitebox_WhiteBox.useCompiler());
            case "UseJVMCICompiler" -> meta.boxBoolean(Target_jdk_test_whitebox_WhiteBox.useGraal());
            case "TieredCompilation", "FlightRecorder", "EnableJVMCI", "ClassUnloading", "ClassUnloadingWithConcurrentMark", "UseCompressedOops", "UseVectorizedMismatchIntrinsic", "EliminateAllocations", "UseVtableBasedCHA" -> StaticObject.NULL;
            default -> {
                context.getLogger().warning(() -> "WhiteBox.getBooleanVMFlag(" + name + "): unknown flag");
                yield StaticObject.NULL;
            }
        };
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean useCompiler() {
        return !Truffle.getRuntime().getName().equals("Interpreted");
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean useGraal() {
        return Truffle.getRuntime().getName().contains("Graal");
    }

    @Substitution(hasReceiver=true)
    public static @JavaType(value=String.class) StaticObject getStringVMFlag(StaticObject self, @JavaType(value=String.class) StaticObject guestName, @Inject Meta meta, @Inject EspressoLanguage language, @Inject EspressoContext context) {
        String name;
        Target_jdk_test_whitebox_WhiteBox.checkWhiteBox(meta, language);
        return switch (name = meta.toHostString(guestName)) {
            case "StartFlightRecording" -> StaticObject.NULL;
            default -> {
                context.getLogger().warning(() -> "WhiteBox.getStringVMFlag(" + name + "): unknown flag");
                yield StaticObject.NULL;
            }
        };
    }

    @Substitution(hasReceiver=true)
    public static @JavaType(value=Long.class) StaticObject getIntxVMFlag(StaticObject self, @JavaType(value=String.class) StaticObject guestName, @Inject Meta meta, @Inject EspressoLanguage language, @Inject EspressoContext context) {
        String name;
        Target_jdk_test_whitebox_WhiteBox.checkWhiteBox(meta, language);
        return switch (name = meta.toHostString(guestName)) {
            case "TieredStopAtLevel" -> StaticObject.NULL;
            default -> {
                context.getLogger().warning(() -> "WhiteBox.getIntxVMFlag(" + name + "): unknown flag");
                yield StaticObject.NULL;
            }
        };
    }

    @Substitution(hasReceiver=true)
    public static @JavaType(value=String.class) StaticObject getLibcName(StaticObject self, @Inject Meta meta, @Inject EspressoLanguage language) {
        Target_jdk_test_whitebox_WhiteBox.checkWhiteBox(meta, language);
        return meta.toGuestString("unknown");
    }

    @Substitution(hasReceiver=true)
    public static boolean isJFRIncluded(StaticObject self, @Inject Meta meta, @Inject EspressoLanguage language) {
        Target_jdk_test_whitebox_WhiteBox.checkWhiteBox(meta, language);
        return false;
    }

    @Substitution(hasReceiver=true)
    public static boolean isDTraceIncluded(StaticObject self, @Inject Meta meta, @Inject EspressoLanguage language) {
        Target_jdk_test_whitebox_WhiteBox.checkWhiteBox(meta, language);
        return false;
    }

    @Substitution(hasReceiver=true)
    public static boolean isCDSIncluded(StaticObject self, @Inject Meta meta, @Inject EspressoLanguage language) {
        Target_jdk_test_whitebox_WhiteBox.checkWhiteBox(meta, language);
        return false;
    }

    @Substitution(hasReceiver=true)
    public static boolean isJVMCISupportedByGC(StaticObject self, @Inject Meta meta, @Inject EspressoLanguage language) {
        Target_jdk_test_whitebox_WhiteBox.checkWhiteBox(meta, language);
        return false;
    }

    @Substitution(hasReceiver=true)
    public static boolean canWriteJavaHeapArchive(StaticObject self, @Inject Meta meta, @Inject EspressoLanguage language) {
        Target_jdk_test_whitebox_WhiteBox.checkWhiteBox(meta, language);
        return false;
    }

    @Substitution(hasReceiver=true)
    public static int getVMPageSize(StaticObject self, @Inject Meta meta, @Inject EspressoLanguage language) {
        Target_jdk_test_whitebox_WhiteBox.checkWhiteBox(meta, language);
        return UnsafeAccess.getIfAllowed(meta).pageSize();
    }

    @Substitution(hasReceiver=true)
    public static @JavaType(value=String.class) StaticObject getCPUFeatures(StaticObject self, @Inject Meta meta, @Inject EspressoLanguage language, @Inject EspressoContext context) {
        Target_jdk_test_whitebox_WhiteBox.checkWhiteBox(meta, language);
        context.getLogger().warning(() -> "WhiteBox.getCPUFeatures(): returning an empty string");
        return meta.toGuestString("");
    }

    @Substitution(hasReceiver=true)
    public static boolean isGCSupported(StaticObject self, int gcId, @Inject Meta meta, @Inject EspressoLanguage language, @Inject EspressoContext context) {
        Target_jdk_test_whitebox_WhiteBox.checkWhiteBox(meta, language);
        GC gc = GC.fromId(gcId);
        if (gc == null) {
            context.getLogger().warning(() -> "WhiteBox.isGCSupported(): unknown GC ID: " + gcId);
            return false;
        }
        return gc == GC.Serial;
    }

    @Substitution(hasReceiver=true)
    public static boolean isGCSelected(StaticObject self, int gcId, @Inject Meta meta, @Inject EspressoLanguage language, @Inject EspressoContext context) {
        Target_jdk_test_whitebox_WhiteBox.checkWhiteBox(meta, language);
        GC gc = GC.fromId(gcId);
        if (gc == null) {
            context.getLogger().warning(() -> "WhiteBox.isGCSelected(): unknown GC ID: " + gcId);
            return false;
        }
        return Target_jdk_test_whitebox_WhiteBox.isGCSelected(gc, context);
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean isGCSelected(GC gc, EspressoContext context) {
        List<GarbageCollectorMXBean> gcMxBeans = ManagementFactory.getGarbageCollectorMXBeans();
        EnumSet<GC> found = EnumSet.noneOf(GC.class);
        for (GarbageCollectorMXBean gcMxBean : gcMxBeans) {
            String name = gcMxBean.getName();
            if (name.startsWith("G1 ")) {
                found.add(GC.G1);
                continue;
            }
            if (name.startsWith("Epsilon")) {
                found.add(GC.Epsilon);
                continue;
            }
            if (name.startsWith("PS ")) {
                found.add(GC.Parallel);
                continue;
            }
            if (name.startsWith("ZGC ")) {
                found.add(GC.Z);
                continue;
            }
            if (name.startsWith("Shenandoah ")) {
                found.add(GC.Shenandoah);
                continue;
            }
            if (name.equals("Copy") || name.equals("MarkSweepCompact")) {
                found.add(GC.Serial);
                continue;
            }
            if (name.equals("young generation scavenger") || name.equals("complete scavenger")) {
                found.add(GC.Serial);
                continue;
            }
            context.getLogger().warning("Unknown GC MX bean: " + name);
        }
        if (found.size() != 1) {
            context.getLogger().warning("Cannot determine current GC: found " + String.valueOf(found));
        }
        return found.contains((Object)gc);
    }

    @Substitution(hasReceiver=true)
    public static boolean isGCSelectedErgonomically(StaticObject self, @Inject Meta meta, @Inject EspressoLanguage language) {
        Target_jdk_test_whitebox_WhiteBox.checkWhiteBox(meta, language);
        return true;
    }

    static enum GC {
        None,
        Serial,
        Parallel,
        G1,
        Epsilon,
        Z,
        Shenandoah;


        static GC fromId(int id) {
            GC[] values = GC.values();
            if (id < 0 || id >= values.length) {
                return null;
            }
            return values[id];
        }
    }

    public static class WhiteBoxNameProvider
    extends SubstitutionNamesProvider {
        private static final String[] NAMES = new String[]{"Target_jdk_test_whitebox_WhiteBox", "Target_sun_hotspot_WhiteBox"};
        public static SubstitutionNamesProvider INSTANCE = new WhiteBoxNameProvider();

        @Override
        public String[] substitutionClassNames() {
            return NAMES;
        }
    }
}

