/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.verifier;

import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.JavaKind;
import com.oracle.truffle.espresso.verifier.MethodVerifier;

abstract class Operand {
    public static final Operand[] EMPTY_ARRAY = new Operand[0];
    protected final JavaKind kind;

    Operand(JavaKind kind) {
        this.kind = kind;
    }

    final boolean isTopOperand() {
        return this == MethodVerifier.Invalid;
    }

    final JavaKind getKind() {
        return this.kind;
    }

    final int slots() {
        return MethodVerifier.isType2(this) ? 2 : 1;
    }

    boolean isArrayType() {
        return false;
    }

    boolean isReference() {
        return false;
    }

    boolean isPrimitive() {
        return false;
    }

    boolean isReturnAddress() {
        return false;
    }

    Operand getComponent() {
        throw EspressoError.shouldNotReachHere("Calling getComponent of a non-array Operand");
    }

    Operand getElemental() {
        throw EspressoError.shouldNotReachHere("Calling getElemental of a non-array Operand");
    }

    int getDimensions() {
        throw EspressoError.shouldNotReachHere("Calling getDimensions of a non-array Operand");
    }

    Symbol<Symbol.Type> getType() {
        return null;
    }

    Klass getKlass() {
        return null;
    }

    boolean isUninit() {
        return false;
    }

    boolean isUninitThis() {
        return false;
    }

    boolean isNull() {
        return false;
    }

    abstract boolean compliesWith(Operand var1);

    boolean compliesWithInMerge(Operand other) {
        return this.compliesWith(other);
    }

    abstract Operand mergeWith(Operand var1);
}

