/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.verifier;

import com.oracle.truffle.espresso.bytecode.BytecodeStream;
import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.descriptors.Types;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.verifier.VerificationTypeInfo;

final class UninitializedVariable
extends VerificationTypeInfo {
    private final int newOffset;

    UninitializedVariable(int newOffset) {
        this.newOffset = newOffset;
    }

    @Override
    public int getTag() {
        return 8;
    }

    @Override
    public int getNewOffset() {
        return this.newOffset;
    }

    @Override
    protected String fromCP(Klass klass) {
        return "new " + String.valueOf(klass.getConstantPool().classAt(this.newOffset).getName(klass.getConstantPool()));
    }

    @Override
    public Symbol<Symbol.Type> getType(ConstantPool pool, ObjectKlass thisKlass, BytecodeStream bs) {
        Types types = thisKlass.getMeta().getTypes();
        return types.fromName(pool.classAt(bs.readCPI(this.getNewOffset())).getName(pool));
    }
}

