/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.vm.continuation;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.analysis.frame.EspressoFrameDescriptor;
import com.oracle.truffle.espresso.bytecode.BytecodeStream;
import com.oracle.truffle.espresso.bytecode.Bytecodes;
import com.oracle.truffle.espresso.classfile.RuntimeConstantPool;
import com.oracle.truffle.espresso.classfile.constantpool.MethodRefConstant;
import com.oracle.truffle.espresso.descriptors.Signatures;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.EspressoFrame;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.JavaType;

public final class HostFrameRecord {
    public final EspressoFrameDescriptor frameDescriptor;
    public final StaticObject[] objects;
    public final long[] primitives;
    public final int top;
    public final Method.MethodVersion methodVersion;
    public HostFrameRecord next;
    private boolean tainted = false;

    public int bci() {
        assert (this.primitives.length > 0);
        return EspressoFrame.decodeBCI(EspressoFrameDescriptor.narrow(this.primitives[0]));
    }

    private void setBci(int bci) {
        this.primitives[0] = EspressoFrameDescriptor.zeroExtend(EspressoFrame.encodeBCI(bci));
    }

    public void taint() {
        this.tainted = true;
    }

    public void untaint() {
        this.tainted = false;
    }

    public boolean isTainted() {
        return this.tainted;
    }

    public static HostFrameRecord recordFrame(VirtualFrame frame, Method.MethodVersion m, int bci, int top, HostFrameRecord next) {
        CompilerAsserts.partialEvaluationConstant((Object)m);
        CompilerAsserts.partialEvaluationConstant((int)bci);
        EspressoFrameDescriptor fd = m.getFrameDescriptor(bci);
        CompilerAsserts.partialEvaluationConstant((Object)fd);
        StaticObject[] objects = new StaticObject[fd.size()];
        long[] primitives = new long[fd.size()];
        fd.importFromFrame(frame, objects, primitives);
        HostFrameRecord hfr = new HostFrameRecord(fd, objects, primitives, bci, top, m, next);
        assert (hfr.bci() == bci);
        assert (top == fd.top()) : "Mismatched tops: " + top + ", " + fd.top();
        assert (hfr.verify(m.getMethod().getMeta(), true));
        return hfr;
    }

    private HostFrameRecord(EspressoFrameDescriptor frameDescriptor, StaticObject[] objects, long[] primitives, int bci, int top, Method.MethodVersion methodVersion, HostFrameRecord next) {
        this.frameDescriptor = frameDescriptor;
        this.objects = objects;
        this.primitives = primitives;
        this.top = top;
        this.methodVersion = methodVersion;
        this.next = next;
        this.setBci(bci);
    }

    @CompilerDirectives.TruffleBoundary
    public boolean verify(Meta meta, boolean single) {
        HostFrameRecord current = this;
        while (current != null) {
            this.methodVersion.getDeclaringKlass().safeInitialize();
            this.frameDescriptor.validateImport(this.objects, this.primitives, this.methodVersion.getDeclaringKlass(), meta);
            BytecodeStream bs = new BytecodeStream(this.methodVersion.getOriginalCode());
            EspressoFrameDescriptor.guarantee(Bytecodes.isInvoke(bs.opcode(this.bci())) && bs.opcode(this.bci()) != 186, EspressoError.cat("Frame record would re-wind at a non-invoke bytecode."), meta);
            if (this.next != null) {
                RuntimeConstantPool pool = this.methodVersion.getPool();
                MethodRefConstant ref = pool.methodAt(bs.readCPI(this.bci()));
                Symbol<Symbol.Name> name = ref.getName(pool);
                Symbol<Symbol.Signature> signature = ref.getSignature(pool);
                EspressoFrameDescriptor.guarantee(this.next.methodVersion.getName() == name && this.next.methodVersion.getRawSignature() == signature, "Wrong method on the recorded frames", meta);
                Symbol<Symbol.Type> returnType = Signatures.returnType(this.next.methodVersion.getMethod().getParsedSignature());
                meta.getContext().getRegistries().checkLoadingConstraint(returnType, this.methodVersion.getDeclaringKlass().getDefiningClassLoader(), this.next.methodVersion.getDeclaringKlass().getDefiningClassLoader());
            } else {
                EspressoFrameDescriptor.guarantee(this.methodVersion.getMethod() == meta.continuum.org_graalvm_continuations_ContinuationImpl_suspend, "Last method on the record is not 'Continuation.suspend'", meta);
            }
            if (single) {
                return true;
            }
            current = current.next;
        }
        return true;
    }

    public StaticObject copyToGuest(Meta meta) {
        HostFrameRecord cursor = this;
        StaticObject guestHead = null;
        StaticObject guestCursor = null;
        while (cursor != null) {
            StaticObject guestNext = cursor.copyToGuestSingle(meta);
            if (guestHead == null) {
                guestHead = guestNext;
            }
            if (guestCursor != null) {
                meta.continuum.org_graalvm_continuations_ContinuationImpl_FrameRecord_next.setObject(guestCursor, guestNext);
            }
            guestCursor = guestNext;
            cursor = cursor.next;
        }
        return guestHead;
    }

    public @JavaType(internalName="Lorg/graalvm/continuations/Continuation$FrameRecord;") StaticObject copyToGuestSingle(Meta meta) {
        StaticObject guestRecord = meta.getAllocator().createNew(meta.continuum.org_graalvm_continuations_ContinuationImpl_FrameRecord);
        meta.continuum.org_graalvm_continuations_ContinuationImpl_FrameRecord_pointers.setObject(guestRecord, StaticObject.wrap(this.objects, meta));
        meta.continuum.org_graalvm_continuations_ContinuationImpl_FrameRecord_primitives.setObject(guestRecord, StaticObject.wrap(this.primitives, meta));
        meta.continuum.org_graalvm_continuations_ContinuationImpl_FrameRecord_method.setObject(guestRecord, this.methodVersion.getMethod().makeMirror(meta));
        meta.continuum.org_graalvm_continuations_ContinuationImpl_FrameRecord_bci.setInt(guestRecord, this.bci());
        return guestRecord;
    }

    @CompilerDirectives.TruffleBoundary
    public static HostFrameRecord copyFromGuest(@JavaType(internalName="Lorg/graalvm/continuations/Continuation;") StaticObject self, Meta meta, EspressoContext context) {
        HostFrameRecord hostCursor = null;
        HostFrameRecord hostHead = null;
        StaticObject cursor = meta.continuum.org_graalvm_continuations_ContinuationImpl_stackFrameHead.getObject(self);
        while (StaticObject.notNull(cursor)) {
            StaticObject pointersGuest = meta.continuum.org_graalvm_continuations_ContinuationImpl_FrameRecord_pointers.getObject(cursor);
            StaticObject primitivesGuest = meta.continuum.org_graalvm_continuations_ContinuationImpl_FrameRecord_primitives.getObject(cursor);
            StaticObject methodGuest = meta.continuum.org_graalvm_continuations_ContinuationImpl_FrameRecord_method.getObject(cursor);
            int bci = meta.continuum.org_graalvm_continuations_ContinuationImpl_FrameRecord_bci.getInt(cursor);
            EspressoLanguage language = context.getLanguage();
            EspressoFrameDescriptor.guarantee(!StaticObject.isNull(pointersGuest), "null array in the frame records.", meta);
            EspressoFrameDescriptor.guarantee(!StaticObject.isNull(primitivesGuest), "null array in the frame records.", meta);
            EspressoFrameDescriptor.guarantee(!StaticObject.isNull(methodGuest), "null method in the frame records.", meta);
            StaticObject[] pointers = (StaticObject[])pointersGuest.unwrap(language);
            long[] primitives = (long[])primitivesGuest.unwrap(language);
            Method method = Method.getHostReflectiveMethodRoot(methodGuest, meta);
            EspressoFrameDescriptor fd = method.getMethodVersion().getFrameDescriptor(bci);
            HostFrameRecord next = new HostFrameRecord(fd, (StaticObject[])pointers.clone(), (long[])primitives.clone(), bci, fd.top(), method.getMethodVersion(), null);
            if (hostCursor != null) {
                hostCursor.next = next;
            }
            if (hostHead == null) {
                hostHead = next;
            }
            hostCursor = next;
            cursor = meta.continuum.org_graalvm_continuations_ContinuationImpl_FrameRecord_next.getObject(cursor);
        }
        if (hostHead != null) {
            hostHead.verify(meta, false);
        }
        return hostHead;
    }
}

