/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.impl.KeysArray;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.commands.AddPathToBindingsNode;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.vm.InterpreterToVM;
import java.util.ArrayList;

@ExportLibrary(value=InteropLibrary.class)
public final class EspressoBindings
implements TruffleObject {
    public static final String JAVA_VM = "<JavaVM>";
    public static final String ADD_PATH = "addPath";
    final boolean useBindingsLoader;
    boolean withNativeJavaVM;

    public EspressoBindings(boolean withNativeJavaVM, boolean useBindingsLoader) {
        this.withNativeJavaVM = withNativeJavaVM;
        this.useBindingsLoader = useBindingsLoader;
    }

    @ExportMessage
    Object getMembers(boolean includeInternal) {
        ArrayList<String> members = new ArrayList<String>(2);
        if (this.withNativeJavaVM) {
            members.add(JAVA_VM);
        }
        if (this.useBindingsLoader) {
            members.add(ADD_PATH);
        }
        return new KeysArray<String>(members.toArray(new String[0]));
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage.Repeat(value={@ExportMessage, @ExportMessage(name="hasMemberReadSideEffects")})
    boolean isMemberReadable(String member) {
        if (JAVA_VM.equals(member)) {
            return this.withNativeJavaVM;
        }
        if (ADD_PATH.equals(member)) {
            return this.useBindingsLoader;
        }
        return true;
    }

    @ExportMessage
    boolean isMemberInvocable(String member) {
        if (ADD_PATH.equals(member)) {
            return this.useBindingsLoader;
        }
        return false;
    }

    @ExportMessage
    Object readMember(String member, @CachedLibrary(value="this") InteropLibrary self, @Cached.Exclusive @Cached BranchProfile error) throws UnknownIdentifierException {
        if (!this.isMemberReadable(member)) {
            error.enter();
            throw UnknownIdentifierException.create((String)member);
        }
        EspressoContext context = EspressoContext.get((Node)self);
        if (this.withNativeJavaVM && JAVA_VM.equals(member)) {
            return context.getVM().getJavaVM();
        }
        if (this.useBindingsLoader && ADD_PATH.equals(member)) {
            return new AddPathToBindingsNode.InvocableAddToBindings();
        }
        Meta meta = context.getMeta();
        try {
            StaticObject clazz = (StaticObject)meta.java_lang_Class_forName_String_boolean_ClassLoader.invokeDirectStatic(meta.toGuestString(member), false, context.getBindingsLoader());
            return clazz.getMirrorKlass(meta);
        }
        catch (EspressoException e) {
            error.enter();
            if (InterpreterToVM.instanceOf(e.getGuestException(), meta.java_lang_ClassNotFoundException)) {
                throw UnknownIdentifierException.create((String)member, (Throwable)((Object)e));
            }
            throw e;
        }
    }

    @ExportMessage
    Object invokeMember(String member, Object[] arguments, @Cached AddPathToBindingsNode addPathToBindingsNode, @Cached.Exclusive @Cached BranchProfile error) throws UnknownIdentifierException, ArityException, UnsupportedTypeException {
        if (!this.isMemberInvocable(member)) {
            error.enter();
            throw UnknownIdentifierException.create((String)member);
        }
        if (this.useBindingsLoader && ADD_PATH.equals(member)) {
            addPathToBindingsNode.execute(arguments);
            return StaticObject.NULL;
        }
        error.enter();
        throw UnknownIdentifierException.create((String)member);
    }

    @ExportMessage
    boolean isMemberRemovable(String member) {
        return this.withNativeJavaVM && JAVA_VM.equals(member);
    }

    @ExportMessage
    void removeMember(String member, @Cached.Exclusive @Cached BranchProfile error) throws UnknownIdentifierException {
        if (!this.isMemberRemovable(member)) {
            error.enter();
            throw UnknownIdentifierException.create((String)member);
        }
        if (this.withNativeJavaVM && JAVA_VM.equals(member)) {
            this.withNativeJavaVM = false;
        }
    }

    @ExportMessage
    boolean isScope() {
        return true;
    }

    @ExportMessage
    boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    Class<? extends TruffleLanguage<?>> getLanguage() {
        return EspressoLanguage.class;
    }

    @ExportMessage
    Object toDisplayString(boolean allowSideEffects) {
        if (this.useBindingsLoader) {
            return "espresso-bindings-classloader";
        }
        return "espresso-system-classloader";
    }
}

