/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.analysis.liveness;

import com.oracle.truffle.espresso.analysis.AnalysisProcessor;
import com.oracle.truffle.espresso.analysis.BlockIterator;
import com.oracle.truffle.espresso.analysis.BlockIteratorClosure;
import com.oracle.truffle.espresso.analysis.BlockLogger;
import com.oracle.truffle.espresso.analysis.Util;
import com.oracle.truffle.espresso.analysis.graph.LinkedBlock;
import com.oracle.truffle.espresso.analysis.liveness.BlockBoundaryResult;
import com.oracle.truffle.espresso.analysis.liveness.History;
import com.oracle.truffle.espresso.analysis.liveness.Record;
import com.oracle.truffle.espresso.classfile.bytecode.BytecodeStream;
import com.oracle.truffle.espresso.impl.Method;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class BlockBoundaryFinder
extends BlockIteratorClosure
implements BlockBoundaryResult,
BlockLogger {
    private final int maxLocals;
    private final int totalBlocks;
    private final Map<Integer, List<Integer>> loops;
    private final BitSet[] blockEntryLiveSet;
    private final History[] blockHistory;
    private final BitSet[] blockEndLiveSet;
    private final BitSet emptyBitSet;

    BlockBoundaryFinder(Method.MethodVersion m, History[] blockHistory) {
        this.blockHistory = blockHistory;
        this.totalBlocks = blockHistory.length;
        this.maxLocals = m.getMaxLocals();
        this.blockEntryLiveSet = new BitSet[this.totalBlocks];
        this.blockEndLiveSet = new BitSet[this.totalBlocks];
        this.loops = new HashMap<Integer, List<Integer>>();
        this.emptyBitSet = new BitSet(this.maxLocals);
    }

    @Override
    public BlockIterator.BlockProcessResult processBlock(LinkedBlock b, BytecodeStream bs, AnalysisProcessor processor) {
        if (b.isLeaf() || Util.successorsAreDoneOrLoops(processor, b)) {
            this.identifyLoops(b, processor);
            this.getEntryLiveSet(b.id(), processor);
            return BlockIterator.BlockProcessResult.DONE;
        }
        return BlockIterator.BlockProcessResult.SKIP;
    }

    @Override
    public BitSet entryFor(int blockID) {
        return this.blockEntryLiveSet[blockID];
    }

    @Override
    public History historyFor(int blockID) {
        return this.blockHistory[blockID];
    }

    @Override
    public BitSet endFor(int blockID) {
        return this.blockEndLiveSet[blockID];
    }

    @Override
    public Map<Integer, List<Integer>> getLoops() {
        return this.loops;
    }

    @Override
    public int maxLocals() {
        return this.maxLocals;
    }

    public BlockBoundaryResult result() {
        return this;
    }

    private void identifyLoops(LinkedBlock b, AnalysisProcessor processor) {
        for (int s : b.successorsID()) {
            if (!processor.isInProcess(s)) continue;
            this.registerLoopEnd(s, s, b.id());
        }
    }

    private void registerLoopEnd(int loopEntry, int successor, int curBlock) {
        List<Integer> registered = this.loops.get(loopEntry);
        if (registered == null) {
            registered = new ArrayList<Integer>();
            this.loops.put(loopEntry, registered);
        }
        if (loopEntry == successor) {
            assert (!registered.contains(curBlock));
            registered.add(curBlock);
        }
    }

    private BitSet getEntryLiveSet(int blockID, AnalysisProcessor processor) {
        if (this.blockEntryLiveSet[blockID] != null) {
            return this.blockEntryLiveSet[blockID];
        }
        BitSet treated = new BitSet(this.maxLocals);
        BitSet entryLiveSet = new BitSet(this.maxLocals);
        for (Record record : this.blockHistory[blockID]) {
            if (treated.get(record.local)) continue;
            switch (record.type) {
                case LOAD: 
                case IINC: {
                    entryLiveSet.set(record.local);
                    break;
                }
            }
            treated.set(record.local);
        }
        BitSet endState = this.getEndState(processor.idToBlock(blockID), processor);
        for (int i : Util.bitSetSetIterator(endState)) {
            if (treated.get(i)) continue;
            entryLiveSet.set(i);
        }
        this.blockEntryLiveSet[blockID] = entryLiveSet;
        return entryLiveSet;
    }

    private BitSet getEndState(LinkedBlock b, AnalysisProcessor processor) {
        BitSet endState;
        if (this.blockEndLiveSet[b.id()] != null) {
            return this.blockEndLiveSet[b.id()];
        }
        BitSet[] successorsLiveset = new BitSet[b.successorsID().length];
        for (int i = 0; i < b.successorsID().length; ++i) {
            int succ = b.successorsID()[i];
            successorsLiveset[i] = processor.isInProcess(succ) ? this.emptyBitSet : this.getEntryLiveSet(succ, processor);
        }
        this.blockEndLiveSet[b.id()] = endState = Util.mergeBitSets(successorsLiveset, this.maxLocals);
        return endState;
    }

    @Override
    public void log(int block, String tab, PrintStream err) {
        err.println(tab + String.valueOf(this.entryFor(block)));
        for (Record r : this.historyFor(block)) {
            err.println(tab + tab + String.valueOf((Object)r.type) + " " + r.local);
        }
        err.println(tab + String.valueOf(this.endFor(block)));
    }
}

