/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.analysis.liveness;

import com.oracle.truffle.espresso.analysis.graph.Graph;
import com.oracle.truffle.espresso.analysis.graph.LinkedBlock;
import com.oracle.truffle.espresso.analysis.liveness.History;
import com.oracle.truffle.espresso.analysis.liveness.Record;
import com.oracle.truffle.espresso.classfile.bytecode.BytecodeStream;
import com.oracle.truffle.espresso.classfile.bytecode.Bytecodes;
import com.oracle.truffle.espresso.impl.Method;

public final class LoadStoreFinder {
    private final Graph<? extends LinkedBlock> graph;
    private final History[] blockHistory;
    private final BytecodeStream bs;
    private final boolean doNotClearThis;

    public LoadStoreFinder(Graph<? extends LinkedBlock> graph, Method method, boolean doNotClearThis) {
        this.graph = graph;
        this.blockHistory = new History[graph.totalBlocks()];
        this.bs = new BytecodeStream(method.getOriginalCode());
        this.doNotClearThis = doNotClearThis;
    }

    public void analyze() {
        for (int i = 0; i < this.graph.totalBlocks(); ++i) {
            this.processBlock(this.graph.get(i));
        }
    }

    public void processBlock(LinkedBlock b) {
        History history = new History();
        int bci = b.start();
        while (bci <= b.end()) {
            int opcode = this.bs.currentBC(bci);
            Record record = null;
            boolean needsTwoLocals = false;
            if (opcode == 132) {
                record = new Record(bci, LoadStoreFinder.findLocalIndex(this.bs, bci, opcode), TYPE.IINC);
            } else if (Bytecodes.isLoad(opcode) || opcode == 169) {
                record = new Record(bci, LoadStoreFinder.findLocalIndex(this.bs, bci, opcode), TYPE.LOAD);
                needsTwoLocals = Bytecodes.stackEffectOf(opcode) == 2;
            } else if (Bytecodes.isStore(opcode)) {
                record = new Record(bci, LoadStoreFinder.findLocalIndex(this.bs, bci, opcode), TYPE.STORE);
                needsTwoLocals = Bytecodes.stackEffectOf(opcode) == -2;
            } else if (this.doNotClearThis && Bytecodes.isControlSink(opcode)) {
                record = new Record(bci, 0, TYPE.LOAD);
            }
            if (record != null) {
                history.add(record);
                if (needsTwoLocals) {
                    history.add(record.second());
                }
            }
            bci = this.bs.nextBCI(bci);
        }
        this.blockHistory[b.id()] = history;
    }

    private static int findLocalIndex(BytecodeStream bs, int bci, int opcode) {
        switch (opcode) {
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                return opcode - 26;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                return opcode - 30;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                return opcode - 34;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                return opcode - 38;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                return opcode - 42;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                return opcode - 59;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                return opcode - 63;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                return opcode - 67;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                return opcode - 71;
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                return opcode - 75;
            }
        }
        return bs.readLocalIndex(bci);
    }

    public History[] result() {
        return this.blockHistory;
    }

    static enum TYPE {
        LOAD,
        STORE,
        IINC;

    }
}

