/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.analysis.liveness;

import com.oracle.truffle.espresso.analysis.AnalysisProcessor;
import com.oracle.truffle.espresso.analysis.BlockIterator;
import com.oracle.truffle.espresso.analysis.BlockIteratorClosure;
import com.oracle.truffle.espresso.analysis.DepthFirstBlockIterator;
import com.oracle.truffle.espresso.analysis.Util;
import com.oracle.truffle.espresso.analysis.graph.Graph;
import com.oracle.truffle.espresso.analysis.graph.LinkedBlock;
import com.oracle.truffle.espresso.analysis.liveness.BlockBoundaryResult;
import com.oracle.truffle.espresso.analysis.liveness.Record;
import com.oracle.truffle.espresso.classfile.bytecode.BytecodeStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;

public final class LoopPropagatorClosure
extends BlockIteratorClosure {
    private final BlockBoundaryResult boundaries;
    private final BitSet[] toPropagateToBlocks;
    private boolean meaningfulChange = false;
    private final BitSet changedBlocks;

    public LoopPropagatorClosure(Graph<? extends LinkedBlock> graph, BlockBoundaryResult boundaries) {
        this.boundaries = boundaries;
        this.changedBlocks = new BitSet(graph.totalBlocks());
        this.toPropagateToBlocks = new BitSet[graph.totalBlocks()];
    }

    public boolean process(Graph<? extends LinkedBlock> graph) {
        this.init();
        if (!this.meaningfulChange) {
            return false;
        }
        this.meaningfulChange = false;
        DepthFirstBlockIterator.analyze(graph, this);
        this.detectMeaningfulChange();
        this.changedBlocks.clear();
        return this.meaningfulChange;
    }

    private void detectMeaningfulChange() {
        for (int loopEntry : this.boundaries.getLoops().keySet()) {
            if (!this.changedBlocks.get(loopEntry)) continue;
            this.meaningfulChange = true;
            return;
        }
    }

    @Override
    public BlockIterator.BlockProcessResult processBlock(LinkedBlock b, BytecodeStream bs, AnalysisProcessor processor) {
        if (b.isLeaf() || Util.successorsAreDoneOrLoops(processor, b)) {
            this.doPropagate(b);
            return BlockIterator.BlockProcessResult.DONE;
        }
        return BlockIterator.BlockProcessResult.SKIP;
    }

    private void doPropagate(LinkedBlock b) {
        int currentID = b.id();
        BitSet endState = this.boundaries.endFor(currentID);
        BitSet toPropagate = this.toPropagateToBlocks[currentID];
        if (toPropagate != null || this.changedSuccessor(b)) {
            ArrayList<BitSet> lives = new ArrayList<BitSet>();
            for (int s : b.successorsID()) {
                if (!this.changedBlocks.get(s)) continue;
                lives.add(this.boundaries.entryFor(s));
            }
            BitSet merged = Util.mergeBitSets(lives, this.boundaries.maxLocals());
            if (toPropagate == null) {
                toPropagate = merged;
            } else {
                toPropagate.or(merged);
                this.toPropagateToBlocks[currentID] = null;
            }
            toPropagate.andNot(endState);
        }
        if (toPropagate == null || toPropagate.isEmpty()) {
            return;
        }
        BitSet entryState = this.boundaries.entryFor(currentID);
        this.propagateLoop(endState, entryState, toPropagate, currentID);
    }

    private boolean changedSuccessor(LinkedBlock b) {
        for (int s : b.successorsID()) {
            if (!this.changedBlocks.get(s)) continue;
            return true;
        }
        return false;
    }

    private void propagateLoop(BitSet endState, BitSet entryState, BitSet toPropagate, int current) {
        endState.or(toPropagate);
        for (Record record : this.boundaries.historyFor(current).reverse()) {
            if (!toPropagate.get(record.local)) continue;
            toPropagate.clear(record.local);
        }
        toPropagate.andNot(entryState);
        if (!toPropagate.isEmpty()) {
            entryState.or(toPropagate);
            this.changedBlocks.set(current);
        }
    }

    private void init() {
        for (Map.Entry<Integer, List<Integer>> entry : this.boundaries.getLoops().entrySet()) {
            int loopEntry = entry.getKey();
            List<Integer> loopEnds = entry.getValue();
            for (int end : loopEnds) {
                BitSet toPropagate = (BitSet)this.boundaries.entryFor(loopEntry).clone();
                BitSet endState = this.boundaries.endFor(end);
                toPropagate.andNot(endState);
                if (toPropagate.isEmpty()) continue;
                this.toPropagateToBlocks[end] = toPropagate;
                this.meaningfulChange = true;
            }
        }
    }
}

