/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.analysis.liveness.actions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.espresso.analysis.frame.EspressoFrameDescriptor;
import com.oracle.truffle.espresso.analysis.liveness.LocalVariableAction;
import com.oracle.truffle.espresso.analysis.liveness.actions.NullOutAction;
import com.oracle.truffle.espresso.nodes.EspressoFrame;
import java.util.Arrays;

public final class MultiAction
extends LocalVariableAction {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final int[] actions;

    public MultiAction(int[] actions) {
        this.actions = actions;
    }

    @Override
    @ExplodeLoop
    public void execute(VirtualFrame frame) {
        for (int local : this.actions) {
            EspressoFrame.clearLocal((Frame)frame, local);
        }
    }

    @Override
    public void execute(EspressoFrameDescriptor.Builder frame) {
        for (int local : this.actions) {
            frame.clear(local);
        }
    }

    public String toString() {
        return Arrays.toString(this.actions);
    }

    @Override
    public LocalVariableAction merge(LocalVariableAction other) {
        if (other instanceof MultiAction) {
            MultiAction multi = (MultiAction)other;
            int[] locals = new int[this.actions.length + multi.actions.length];
            System.arraycopy(this.actions, 0, locals, 0, this.actions.length);
            System.arraycopy(multi.actions, 0, locals, this.actions.length, multi.actions.length);
            return new MultiAction(locals);
        }
        assert (other instanceof NullOutAction);
        int[] locals = new int[this.actions.length + 1];
        System.arraycopy(this.actions, 0, locals, 0, this.actions.length);
        locals[locals.length - 1] = ((NullOutAction)other).local();
        return new MultiAction(locals);
    }
}

