/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.analysis.liveness.actions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.espresso.analysis.frame.EspressoFrameDescriptor;
import com.oracle.truffle.espresso.analysis.liveness.EdgeAction;
import com.oracle.truffle.espresso.analysis.liveness.LocalVariableAction;

public final class SelectEdgeAction
implements EdgeAction {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final int[] from;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final LocalVariableAction[] actions;

    public SelectEdgeAction(int[] from, LocalVariableAction[] actions) {
        this.from = from;
        this.actions = actions;
    }

    @Override
    @ExplodeLoop
    public void onEdge(VirtualFrame frame, int fromBCI) {
        for (int i = 0; i < this.from.length; ++i) {
            if (this.from[i] != fromBCI) continue;
            this.actions[i].execute(frame);
        }
    }

    @Override
    public void onEdge(EspressoFrameDescriptor.Builder frame, int fromBCI) {
        for (int i = 0; i < this.from.length; ++i) {
            if (this.from[i] != fromBCI) continue;
            this.actions[i].execute(frame);
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < this.from.length; ++i) {
            str.append("\tfrom " + this.from[i] + ": " + this.actions[i].toString() + "\n");
        }
        return str.toString();
    }
}

