/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.bytecode;

import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.classfile.bytecode.BytecodeLookupSwitch;
import com.oracle.truffle.espresso.classfile.bytecode.BytecodeStream;
import com.oracle.truffle.espresso.classfile.bytecode.BytecodeTableSwitch;
import com.oracle.truffle.espresso.classfile.bytecode.Bytecodes;
import com.oracle.truffle.espresso.classfile.constantpool.ClassConstant;
import com.oracle.truffle.espresso.classfile.constantpool.InvokeDynamicConstant;
import com.oracle.truffle.espresso.classfile.constantpool.MethodRefConstant;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.meta.EspressoError;
import java.io.PrintStream;
import java.util.Arrays;

public class BytecodePrinter {
    public static void printBytecode(Klass klass, PrintStream out, byte[] code) {
        BytecodeStream stream = new BytecodeStream(code);
        try {
            ConstantPool pool = klass.getConstantPool();
            int bci = 0;
            int nextBCI = 0;
            StringBuilder str = new StringBuilder();
            while (nextBCI < stream.endBCI()) {
                str.setLength(0);
                bci = nextBCI;
                int opcode = stream.currentBC(bci);
                str.append(bci).append(": ").append(Bytecodes.nameOf(opcode)).append(" ");
                nextBCI = stream.nextBCI(bci);
                if (Bytecodes.isBranch(opcode)) {
                    str.append(stream.readBranchDest(bci));
                } else if (opcode == 187) {
                    char cpi = stream.readCPI(bci);
                    ClassConstant cc = (ClassConstant)pool.at(cpi);
                    str.append(cc.getName(pool));
                } else if (opcode == 186) {
                    char cpi = stream.readCPI(bci);
                    InvokeDynamicConstant idc = (InvokeDynamicConstant)pool.at(cpi);
                    str.append("#").append(idc.getBootstrapMethodAttrIndex()).append(" -> ").append(idc.getName(pool)).append(":").append(idc.getSignature(pool));
                } else if (Bytecodes.isInvoke(opcode)) {
                    char cpi = stream.readCPI(bci);
                    MethodRefConstant mrc = (MethodRefConstant)pool.at(cpi);
                    str.append(mrc.getHolderKlassName(pool)).append(".").append(mrc.getName(pool)).append(":").append(mrc.getDescriptor(pool));
                } else if (opcode == 170) {
                    str.append('\n');
                    BytecodeTableSwitch helper = BytecodeTableSwitch.INSTANCE;
                    int low = helper.lowKey(stream, bci);
                    high = helper.highKey(stream, bci);
                    for (i = low; i != high + 1; ++i) {
                        str.append('\t').append(i).append(": ").append(helper.targetAt(stream, bci, i)).append('\n');
                    }
                    str.append("\tdefault: ").append(helper.defaultTarget(stream, bci));
                } else if (opcode == 171) {
                    str.append('\n');
                    BytecodeLookupSwitch helper = BytecodeLookupSwitch.INSTANCE;
                    int low = 0;
                    high = helper.numberOfCases(stream, bci) - 1;
                    for (i = low; i <= high; ++i) {
                        str.append('\t').append(helper.keyAt(stream, bci, i)).append(": ").append(helper.targetAt(stream, bci, i));
                    }
                    str.append("\tdefault: ").append(helper.defaultTarget(stream, bci));
                } else if (opcode == 132) {
                    str.append(" ").append(stream.readLocalIndex(bci)).append(" ").append(stream.readIncrement(bci));
                } else {
                    if (nextBCI - bci == 2) {
                        str.append(stream.readUByte(bci + 1));
                    }
                    if (nextBCI - bci == 3) {
                        str.append(stream.readShort(bci));
                    }
                    if (nextBCI - bci == 5) {
                        str.append(stream.readInt(bci + 1));
                    }
                }
                out.println(str.toString());
            }
        }
        catch (Throwable e) {
            throw EspressoError.shouldNotReachHere("Exception thrown during bytecode printing, aborting...", e);
        }
    }

    public static void printRawBytecode(PrintStream out, byte[] code) {
        out.println(Arrays.toString(code));
    }

    public static void print(Klass klass, byte[] code, PrintStream out) {
        try {
            BytecodePrinter.printBytecode(klass, out, code);
        }
        catch (Throwable e) {
            throw EspressoError.shouldNotReachHere("Throw during printing. Aborting...", e);
        }
    }
}

