/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.bytecode;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.espresso.classfile.attributes.LineNumberTableAttribute;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.nodes.EspressoNode;
import java.util.Arrays;

public class MapperBCI
extends EspressoNode {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final int[] bcis;
    private final int length;
    private final boolean wasSorted;

    public MapperBCI(LineNumberTableAttribute lineNumberTable) {
        this.length = lineNumberTable.getEntries().size();
        this.bcis = new int[this.length];
        int i = 0;
        int prev = 0;
        boolean sort = false;
        for (LineNumberTableAttribute.Entry entry : lineNumberTable.getEntries()) {
            int bci = entry.getBCI();
            if (i > 0 && bci < prev) {
                sort = true;
            }
            prev = bci;
            this.bcis[i++] = bci;
        }
        if (sort) {
            Arrays.sort(this.bcis);
        }
        this.wasSorted = !sort;
    }

    public int[] getBcis() {
        return this.bcis;
    }

    public int getLength() {
        return this.length;
    }

    public int initIndex(int curIndex, int bci) {
        if (this.wasSorted) {
            return curIndex;
        }
        return this.lookup(bci);
    }

    private int lookup(int targetBCI) {
        int res = this.slowLookup(targetBCI, 0, this.length);
        if (res >= 0) {
            return res;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw EspressoError.shouldNotReachHere();
    }

    public int lookupBucket(int targetBCI) {
        int res = this.slowLookup(targetBCI, 0, this.length);
        if (res >= 0) {
            return res;
        }
        return -res - 1;
    }

    public int lookup(int curIndex, int curBCI, int targetBCI) {
        int end;
        int start;
        if (curBCI < targetBCI) {
            start = curIndex;
            end = this.length;
        } else {
            start = 0;
            end = curIndex + 1;
        }
        int res = this.slowLookup(targetBCI, start, end);
        if (res >= 0) {
            return res;
        }
        return -res - 1;
    }

    public int checkNext(int curIndex, int targetBCI) {
        if (curIndex < this.length - 1 && targetBCI >= this.bcis[curIndex + 1]) {
            return curIndex + 1;
        }
        return curIndex;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE)
    private int slowLookup(int targetBCI, int start, int end) {
        int low = start;
        int high = end - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = this.bcis[mid];
            if (midVal < targetBCI) {
                low = mid + 1;
                continue;
            }
            if (midVal > targetBCI) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -low;
    }
}

