/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile;

import com.oracle.truffle.espresso.classfile.ClassfileStream;
import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.classfile.ExceptionHandler;
import com.oracle.truffle.espresso.classfile.ImmutableConstantPool;
import com.oracle.truffle.espresso.classfile.JavaKind;
import com.oracle.truffle.espresso.classfile.ParserException;
import com.oracle.truffle.espresso.classfile.ParserField;
import com.oracle.truffle.espresso.classfile.ParserKlass;
import com.oracle.truffle.espresso.classfile.ParserMethod;
import com.oracle.truffle.espresso.classfile.ParsingContext;
import com.oracle.truffle.espresso.classfile.attributes.Attribute;
import com.oracle.truffle.espresso.classfile.attributes.BootstrapMethodsAttribute;
import com.oracle.truffle.espresso.classfile.attributes.CodeAttribute;
import com.oracle.truffle.espresso.classfile.attributes.ConstantValueAttribute;
import com.oracle.truffle.espresso.classfile.attributes.EnclosingMethodAttribute;
import com.oracle.truffle.espresso.classfile.attributes.ExceptionsAttribute;
import com.oracle.truffle.espresso.classfile.attributes.InnerClassesAttribute;
import com.oracle.truffle.espresso.classfile.attributes.LineNumberTableAttribute;
import com.oracle.truffle.espresso.classfile.attributes.Local;
import com.oracle.truffle.espresso.classfile.attributes.LocalVariableTable;
import com.oracle.truffle.espresso.classfile.attributes.MethodParametersAttribute;
import com.oracle.truffle.espresso.classfile.attributes.NestHostAttribute;
import com.oracle.truffle.espresso.classfile.attributes.NestMembersAttribute;
import com.oracle.truffle.espresso.classfile.attributes.PermittedSubclassesAttribute;
import com.oracle.truffle.espresso.classfile.attributes.RecordAttribute;
import com.oracle.truffle.espresso.classfile.attributes.SignatureAttribute;
import com.oracle.truffle.espresso.classfile.attributes.SourceDebugExtensionAttribute;
import com.oracle.truffle.espresso.classfile.attributes.SourceFileAttribute;
import com.oracle.truffle.espresso.classfile.attributes.StackMapTableAttribute;
import com.oracle.truffle.espresso.classfile.constantpool.ClassConstant;
import com.oracle.truffle.espresso.classfile.constantpool.ClassMethodRefConstant;
import com.oracle.truffle.espresso.classfile.constantpool.DoubleConstant;
import com.oracle.truffle.espresso.classfile.constantpool.DynamicConstant;
import com.oracle.truffle.espresso.classfile.constantpool.FieldRefConstant;
import com.oracle.truffle.espresso.classfile.constantpool.FloatConstant;
import com.oracle.truffle.espresso.classfile.constantpool.IntegerConstant;
import com.oracle.truffle.espresso.classfile.constantpool.InterfaceMethodRefConstant;
import com.oracle.truffle.espresso.classfile.constantpool.InvalidConstant;
import com.oracle.truffle.espresso.classfile.constantpool.InvokeDynamicConstant;
import com.oracle.truffle.espresso.classfile.constantpool.LongConstant;
import com.oracle.truffle.espresso.classfile.constantpool.MethodHandleConstant;
import com.oracle.truffle.espresso.classfile.constantpool.MethodTypeConstant;
import com.oracle.truffle.espresso.classfile.constantpool.NameAndTypeConstant;
import com.oracle.truffle.espresso.classfile.constantpool.PoolConstant;
import com.oracle.truffle.espresso.classfile.constantpool.StringConstant;
import com.oracle.truffle.espresso.classfile.constantpool.Utf8Constant;
import com.oracle.truffle.espresso.classfile.descriptors.ByteSequence;
import com.oracle.truffle.espresso.classfile.descriptors.ModifiedUtf8;
import com.oracle.truffle.espresso.classfile.descriptors.Signatures;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.classfile.descriptors.Types;
import com.oracle.truffle.espresso.classfile.descriptors.ValidationException;
import com.oracle.truffle.espresso.classfile.perf.DebugCloseable;
import com.oracle.truffle.espresso.classfile.perf.DebugCounter;
import com.oracle.truffle.espresso.classfile.perf.DebugTimer;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;

public final class ClassfileParser {
    private static final DebugTimer KLASS_PARSE = DebugTimer.create("klass parsing");
    private static final DebugTimer CONSTANT_POOL = DebugTimer.create("constant pool", KLASS_PARSE);
    private static final DebugTimer PARSE_INTERFACES = DebugTimer.create("interfaces", KLASS_PARSE);
    private static final DebugTimer PARSE_FIELD = DebugTimer.create("fields", KLASS_PARSE);
    private static final DebugTimer PARSE_CLASSATTR = DebugTimer.create("class attr", KLASS_PARSE);
    private static final DebugTimer PARSE_METHODS = DebugTimer.create("methods", KLASS_PARSE);
    private static final DebugTimer NO_DUP_CHECK = DebugTimer.create("method dup", PARSE_METHODS);
    private static final DebugTimer PARSE_SINGLE_METHOD = DebugTimer.create("single method", PARSE_METHODS);
    private static final DebugTimer METHOD_INIT = DebugTimer.create("method parse init", PARSE_SINGLE_METHOD);
    private static final DebugTimer NAME_CHECK = DebugTimer.create("name check", METHOD_INIT);
    private static final DebugTimer SIGNATURE_CHECK = DebugTimer.create("signature check", METHOD_INIT);
    private static final DebugTimer CODE_PARSE = DebugTimer.create("code parsing", PARSE_SINGLE_METHOD);
    private static final DebugTimer CODE_READ = DebugTimer.create("code read", CODE_PARSE);
    private static final DebugTimer EXCEPTION_HANDLERS = DebugTimer.create("exception handlers", CODE_PARSE);
    private static final DebugCounter UTF8_ENTRY_COUNT = DebugCounter.create("UTF8 Constant Pool entries");
    public static final int MAGIC = -889275714;
    public static final int JAVA_1_1_VERSION = 45;
    public static final int JAVA_1_2_VERSION = 46;
    public static final int JAVA_1_3_VERSION = 47;
    public static final int JAVA_1_4_VERSION = 48;
    public static final int JAVA_1_5_VERSION = 49;
    public static final int JAVA_6_VERSION = 50;
    public static final int JAVA_7_VERSION = 51;
    public static final int JAVA_8_VERSION = 52;
    public static final int JAVA_9_VERSION = 53;
    public static final int JAVA_10_VERSION = 54;
    public static final int JAVA_11_VERSION = 55;
    public static final int JAVA_12_VERSION = 56;
    public static final int JAVA_13_VERSION = 57;
    public static final int JAVA_14_VERSION = 58;
    public static final int JAVA_15_VERSION = 59;
    public static final int JAVA_16_VERSION = 60;
    public static final int JAVA_17_VERSION = 61;
    public static final int JAVA_18_VERSION = 62;
    public static final int JAVA_19_VERSION = 63;
    public static final int JAVA_20_VERSION = 64;
    public static final int JAVA_21_VERSION = 65;
    public static final int JAVA_22_VERSION = 66;
    public static final int JAVA_23_VERSION = 67;
    public static final int JAVA_24_VERSION = 68;
    public static final int JAVA_25_VERSION = 69;
    public static final int STRICTER_ACCESS_CTRL_CHECK_VERSION = 49;
    public static final int STACKMAP_ATTRIBUTE_MAJOR_VERSION = 50;
    public static final int INVOKEDYNAMIC_MAJOR_VERSION = 51;
    public static final int NO_RELAX_ACCESS_CTRL_CHECK_VERSION = 52;
    public static final int DYNAMICCONSTANT_MAJOR_VERSION = 55;
    public static final char JAVA_MIN_SUPPORTED_VERSION = '-';
    public static final char JAVA_MAX_SUPPORTED_MINOR_VERSION = '\u0000';
    public static final char JAVA_PREVIEW_MINOR_VERSION = '\uffff';
    private final Symbol<Symbol.Type> requestedClassType;
    private final ParsingContext parsingContext;
    private final ClassfileStream stream;
    private final boolean loaderIsBootOrPlatform;
    private final boolean isHidden;
    private final boolean forceAllowVMAnnotations;
    private Symbol<Symbol.Type> classType;
    private int minorVersion = -1;
    private int majorVersion = -1;
    private int classFlags;
    private int maxBootstrapMethodAttrIndex = -1;
    private ConstantPool.Tag badConstantSeen;
    private final boolean verifiable;
    private ImmutableConstantPool pool;
    private final boolean validate;
    private static final int RUNTIME_VISIBLE_ANNOTATIONS = 1;
    private static final int RUNTIME_INVISIBLE_ANNOTATIONS = 2;
    private static final int RUNTIME_VISIBLE_TYPE_ANNOTATIONS = 4;
    private static final int RUNTIME_INVISIBLE_TYPE_ANNOTATIONS = 8;
    private static final int RUNTIME_VISIBLE_PARAMETER_ANNOTATIONS = 16;
    private static final int RUNTIME_INVISIBLE_PARAMETER_ANNOTATIONS = 32;
    private static final int ANNOTATION_DEFAULT = 64;
    private static final int SIGNATURE = 128;
    private static final int classAnnotations = 143;
    private static final int methodAnnotations = 255;
    private static final int fieldAnnotations = 143;
    private static final int codeAnnotations = 140;
    private static final int recordAnnotations = 143;

    private ClassfileParser(ParsingContext parsingContext, ClassfileStream stream, boolean verifiable, boolean loaderIsBootOrPlatform, Symbol<Symbol.Type> requestedClassType, boolean isHidden, boolean forceAllowVMAnnotations) {
        this.requestedClassType = requestedClassType;
        this.parsingContext = parsingContext;
        this.stream = Objects.requireNonNull(stream);
        this.verifiable = verifiable;
        this.loaderIsBootOrPlatform = loaderIsBootOrPlatform;
        this.isHidden = isHidden;
        this.forceAllowVMAnnotations = forceAllowVMAnnotations;
        this.validate = true;
    }

    private ClassfileParser(ParsingContext parsingContext, ClassfileStream stream) {
        this(parsingContext, stream, false, false, null, false, false);
    }

    void handleBadConstant(ConstantPool.Tag tag, ClassfileStream s) {
        if (tag == ConstantPool.Tag.MODULE || tag == ConstantPool.Tag.PACKAGE) {
            if (this.majorVersion >= 53) {
                s.readU2();
                this.badConstantSeen = tag;
            }
        } else {
            throw ClassfileParser.classFormatError("Unknown constant tag " + tag.getValue());
        }
    }

    private static ParserException classFormatError(String message) {
        throw new ParserException.ClassFormatError(message);
    }

    private static ParserException noClassDefFoundError(String message) {
        throw new ParserException.NoClassDefFoundError(message);
    }

    void updateMaxBootstrapMethodAttrIndex(int bsmAttrIndex) {
        if (this.maxBootstrapMethodAttrIndex < bsmAttrIndex) {
            this.maxBootstrapMethodAttrIndex = bsmAttrIndex;
        }
    }

    void checkInvokeDynamicSupport(ConstantPool.Tag tag) {
        if (this.majorVersion < 51) {
            throw ClassfileParser.classFormatError("Class file version does not support constant tag " + tag.getValue());
        }
    }

    void checkDynamicConstantSupport(ConstantPool.Tag tag) {
        if (this.majorVersion < 55) {
            throw ClassfileParser.classFormatError("Class file version does not support constant tag " + tag.getValue());
        }
    }

    public static ParserKlass parse(ParsingContext parsingContext, ClassfileStream stream, boolean verifiable, boolean loaderIsBootOrPlatform, Symbol<Symbol.Type> requestedClassType, boolean isHidden, boolean forceAllowVMAnnotations) throws ValidationException {
        return new ClassfileParser(parsingContext, stream, verifiable, loaderIsBootOrPlatform, requestedClassType, isHidden, forceAllowVMAnnotations).parseClass();
    }

    private ParserKlass parseClass() throws ValidationException {
        DebugCloseable parse = KLASS_PARSE.scope(this.parsingContext.getTimers());
        try {
            ParserKlass parserKlass = this.parseClassImpl();
            if (parse != null) {
                parse.close();
            }
            return parserKlass;
        }
        catch (Throwable throwable) {
            try {
                if (parse != null) {
                    try {
                        parse.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (ParserException | ValidationException e) {
                throw e;
            }
            catch (Throwable e) {
                this.parsingContext.getLogger().log("Unexpected host exception thrown during class parsing", e);
                throw e;
            }
        }
    }

    private void readMagic() {
        int magic = this.stream.readS4();
        if (magic != -889275714) {
            throw ClassfileParser.classFormatError("Invalid magic number 0x" + Integer.toHexString(magic));
        }
    }

    private void verifyVersion(int major, int minor) {
        if (this.parsingContext.getJavaVersion().java8OrEarlier()) {
            ClassfileParser.versionCheck8OrEarlier(this.parsingContext.getJavaVersion().classFileVersion(), major, minor);
        } else if (this.parsingContext.getJavaVersion().java11OrEarlier()) {
            ClassfileParser.versionCheck11OrEarlier(this.parsingContext.getJavaVersion().classFileVersion(), major, minor);
        } else {
            ClassfileParser.versionCheck12OrLater(this.parsingContext.getJavaVersion().classFileVersion(), major, minor, this.parsingContext.isPreviewEnabled());
        }
    }

    private static void versionCheck8OrEarlier(int maxMajor, int major, int minor) {
        if (major == maxMajor && minor <= 0) {
            return;
        }
        if (major >= 45 && major < maxMajor) {
            return;
        }
        throw ClassfileParser.unsupportedClassVersionError("Unsupported major.minor version " + major + "." + minor);
    }

    private static void versionCheck11OrEarlier(int maxMajor, int major, int minor) {
        if (major == maxMajor && (minor <= 0 || minor == 65535)) {
            return;
        }
        if (major < maxMajor && major > 45 && minor == 0) {
            return;
        }
        if (major == 45) {
            return;
        }
        throw ClassfileParser.unsupportedClassVersionError("Unsupported major.minor version " + major + "." + minor);
    }

    private static void versionCheck12OrLater(int maxMajor, int major, int minor, boolean previewEnabled) {
        if (major >= 56 && major <= maxMajor && minor == 0) {
            return;
        }
        if (major >= 45 && major < 56) {
            return;
        }
        if (major == maxMajor && minor == 65535 && previewEnabled) {
            return;
        }
        throw ClassfileParser.unsupportedClassVersionError("Unsupported major.minor version " + major + "." + minor);
    }

    private static ParserException unsupportedClassVersionError(String message) {
        return new ParserException.UnsupportedClassVersionError(message);
    }

    private static void verifyClassFlags(int flags, int majorVersion) {
        boolean majorGte15;
        boolean isInterface = (flags & 0x200) != 0;
        boolean isAbstract = (flags & 0x400) != 0;
        boolean isFinal = (flags & 0x10) != 0;
        boolean isSuper = (flags & 0x20) != 0;
        boolean isEnum = (flags & 0x4000) != 0;
        boolean isAnnotation = (flags & 0x2000) != 0;
        boolean bl = majorGte15 = majorVersion >= 49;
        if (isAbstract && isFinal || isInterface && !isAbstract || isInterface && majorGte15 && (isSuper || isEnum) || !isInterface && majorGte15 && isAnnotation) {
            throw ClassfileParser.classFormatError("Invalid class flags 0x" + Integer.toHexString(flags));
        }
    }

    boolean hasSeenBadConstant() {
        return this.badConstantSeen != null;
    }

    private ImmutableConstantPool parseConstantPool() throws ValidationException {
        int length = this.stream.readU2();
        if (length < 1) {
            throw ClassfileParser.classFormatError("Invalid constant pool size (" + length + ")");
        }
        int rawPoolStartPosition = this.stream.getPosition();
        PoolConstant[] entries = new PoolConstant[length];
        entries[0] = InvalidConstant.VALUE;
        block21: for (int i = 1; i < length; ++i) {
            int tagByte = this.stream.readU1();
            ConstantPool.Tag tag = ConstantPool.Tag.fromValue(tagByte);
            if (tag == null) {
                throw ValidationException.raise("Invalid constant pool entry type at index " + i);
            }
            if (!tag.isValidForVersion(this.getMajorVersion()) && tag != ConstantPool.Tag.MODULE && tag != ConstantPool.Tag.PACKAGE) {
                throw ValidationException.raise("Class file version does not support constant tag " + tagByte + " in class file");
            }
            switch (tag) {
                case CLASS: {
                    int classNameIndex = this.stream.readU2();
                    entries[i] = ClassConstant.create(classNameIndex);
                    continue block21;
                }
                case STRING: {
                    int index = this.stream.readU2();
                    if (index == 0 || index >= length) {
                        throw ValidationException.raise("Invalid String constant index " + (i - 1));
                    }
                    entries[i] = StringConstant.create(index);
                    continue block21;
                }
                case FIELD_REF: {
                    int classIndex = this.stream.readU2();
                    int nameAndTypeIndex = this.stream.readU2();
                    entries[i] = FieldRefConstant.create(classIndex, nameAndTypeIndex);
                    continue block21;
                }
                case METHOD_REF: {
                    int classIndex = this.stream.readU2();
                    int nameAndTypeIndex = this.stream.readU2();
                    entries[i] = ClassMethodRefConstant.create(classIndex, nameAndTypeIndex);
                    continue block21;
                }
                case INTERFACE_METHOD_REF: {
                    int classIndex = this.stream.readU2();
                    int nameAndTypeIndex = this.stream.readU2();
                    entries[i] = InterfaceMethodRefConstant.create(classIndex, nameAndTypeIndex);
                    continue block21;
                }
                case NAME_AND_TYPE: {
                    int nameIndex = this.stream.readU2();
                    int typeIndex = this.stream.readU2();
                    entries[i] = NameAndTypeConstant.create(nameIndex, typeIndex);
                    continue block21;
                }
                case INTEGER: {
                    entries[i] = IntegerConstant.create(this.stream.readS4());
                    continue block21;
                }
                case FLOAT: {
                    entries[i] = FloatConstant.create(this.stream.readFloat());
                    continue block21;
                }
                case LONG: {
                    entries[i] = LongConstant.create(this.stream.readS8());
                    ++i;
                    try {
                        entries[i] = InvalidConstant.VALUE;
                        continue block21;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw ValidationException.raise("Invalid long constant index " + (i - 1));
                    }
                }
                case DOUBLE: {
                    entries[i] = DoubleConstant.create(this.stream.readDouble());
                    ++i;
                    try {
                        entries[i] = InvalidConstant.VALUE;
                        continue block21;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw ValidationException.raise("Invalid double constant index " + (i - 1));
                    }
                }
                case UTF8: {
                    UTF8_ENTRY_COUNT.inc();
                    ByteSequence bytes = this.stream.readByteSequenceUTF();
                    entries[i] = this.parsingContext.getOrCreateUtf8Constant(bytes);
                    continue block21;
                }
                case METHODHANDLE: {
                    this.checkInvokeDynamicSupport(tag);
                    int refKind = this.stream.readU1();
                    int refIndex = this.stream.readU2();
                    entries[i] = MethodHandleConstant.create(refKind, refIndex);
                    continue block21;
                }
                case METHODTYPE: {
                    this.checkInvokeDynamicSupport(tag);
                    entries[i] = MethodTypeConstant.create(this.stream.readU2());
                    continue block21;
                }
                case DYNAMIC: {
                    this.checkDynamicConstantSupport(tag);
                    int bootstrapMethodAttrIndex = this.stream.readU2();
                    int nameAndTypeIndex = this.stream.readU2();
                    entries[i] = DynamicConstant.create(bootstrapMethodAttrIndex, nameAndTypeIndex);
                    this.updateMaxBootstrapMethodAttrIndex(bootstrapMethodAttrIndex);
                    continue block21;
                }
                case INVOKEDYNAMIC: {
                    this.checkInvokeDynamicSupport(tag);
                    int bootstrapMethodAttrIndex = this.stream.readU2();
                    int nameAndTypeIndex = this.stream.readU2();
                    entries[i] = InvokeDynamicConstant.create(bootstrapMethodAttrIndex, nameAndTypeIndex);
                    this.updateMaxBootstrapMethodAttrIndex(bootstrapMethodAttrIndex);
                    continue block21;
                }
                default: {
                    this.handleBadConstant(tag, this.stream);
                }
            }
        }
        int rawPoolLength = this.stream.getPosition() - rawPoolStartPosition;
        ImmutableConstantPool constantPool = new ImmutableConstantPool(entries, this.majorVersion, this.minorVersion, rawPoolLength);
        if (this.hasSeenBadConstant()) {
            return constantPool;
        }
        assert (ClassfileParser.sameRawPool(constantPool, this.stream, rawPoolStartPosition, rawPoolLength));
        if (this.validate) {
            for (int j = 1; j < constantPool.length(); ++j) {
                entries[j].validate(constantPool);
            }
        }
        return constantPool;
    }

    private static boolean sameRawPool(ConstantPool constantPool, ClassfileStream stream, int rawPoolStartPosition, int rawPoolLength) {
        return Arrays.equals(constantPool.getRawBytes(), stream.getByteRange(rawPoolStartPosition, rawPoolLength));
    }

    private ParserKlass parseClassImpl() throws ValidationException {
        Attribute[] attributes;
        ParserMethod[] methods;
        ParserField[] fields;
        Symbol<Symbol.Type>[] superInterfaces;
        boolean isModule;
        this.readMagic();
        this.minorVersion = this.stream.readU2();
        this.majorVersion = this.stream.readU2();
        this.verifyVersion(this.majorVersion, this.minorVersion);
        try (DebugCloseable closeable = CONSTANT_POOL.scope(this.parsingContext.getTimers());){
            this.pool = this.parseConstantPool();
        }
        this.classFlags = this.majorVersion >= 53 ? this.stream.readU2() & 0xF631 : this.stream.readU2() & 0x7631;
        if ((this.classFlags & 0x200) != 0 && this.majorVersion < 50) {
            this.classFlags |= 0x400;
        }
        boolean bl = isModule = (this.classFlags & 0x8000) != 0;
        if (isModule) {
            throw ClassfileParser.noClassDefFoundError(String.valueOf(this.classType) + " is not a class because access_flag ACC_MODULE is set");
        }
        if (this.hasSeenBadConstant()) {
            throw this.stream.classFormatError("Unknown constant tag " + String.valueOf((Object)this.badConstantSeen));
        }
        ClassfileParser.verifyClassFlags(this.classFlags, this.majorVersion);
        int thisKlassIndex = this.stream.readU2();
        Symbol<Symbol.Name> thisKlassName = this.pool.classAt(thisKlassIndex).getName(this.pool);
        boolean isInterface = Modifier.isInterface(this.classFlags);
        Symbol<Symbol.Type> thisKlassType = this.parsingContext.getOrCreateTypeFromName(thisKlassName);
        if (Types.isPrimitive(thisKlassType) || Types.isArray(thisKlassType)) {
            throw ClassfileParser.classFormatError(".this_class cannot be array nor primitive " + String.valueOf(this.classType));
        }
        this.classType = thisKlassType;
        if (this.requestedClassType != null && !this.isHidden && !this.requestedClassType.equals(this.classType)) {
            throw ClassfileParser.noClassDefFoundError(String.valueOf(this.classType) + " (wrong name: " + String.valueOf(this.requestedClassType) + ")");
        }
        Symbol<Symbol.Type> superKlass = this.parseSuperKlass();
        if (!Symbol.Type.java_lang_Object.equals(this.classType) && superKlass == null) {
            throw ClassfileParser.classFormatError("Class " + String.valueOf(this.classType) + " must have a superclass");
        }
        if (isInterface && !Symbol.Type.java_lang_Object.equals(superKlass)) {
            throw ClassfileParser.classFormatError("Interface " + String.valueOf(this.classType) + " must extend java.lang.Object");
        }
        try (DebugCloseable closeable = PARSE_INTERFACES.scope(this.parsingContext.getTimers());){
            superInterfaces = this.parseInterfaces();
        }
        try (DebugCloseable closeable = PARSE_FIELD.scope(this.parsingContext.getTimers());){
            fields = this.parseFields(isInterface);
        }
        try (DebugCloseable closeable = PARSE_METHODS.scope(this.parsingContext.getTimers());){
            methods = this.parseMethods(isInterface);
        }
        try (DebugCloseable closeable = PARSE_CLASSATTR.scope(this.parsingContext.getTimers());){
            attributes = this.parseClassAttributes();
        }
        this.stream.checkEndOfFile();
        long hiddenKlassId = -1L;
        if (this.isHidden) {
            assert (this.requestedClassType != null);
            hiddenKlassId = this.parsingContext.getNewKlassId();
            thisKlassName = this.parsingContext.getOrCreateName(Types.hiddenClassName(this.requestedClassType, hiddenKlassId));
            thisKlassType = this.parsingContext.getOrCreateTypeFromName(thisKlassName);
            this.pool = this.pool.patchForHiddenClass(thisKlassIndex, thisKlassName);
            this.classFlags |= 0x4000000;
        }
        return new ParserKlass(this.pool, this.classFlags, thisKlassName, thisKlassType, superKlass, superInterfaces, methods, fields, attributes, thisKlassIndex, hiddenKlassId);
    }

    public static Symbol<Symbol.Name> getClassName(ParsingContext parsingContext, byte[] bytes) throws ValidationException {
        return new ClassfileParser(parsingContext, new ClassfileStream(bytes, null)).getClassName();
    }

    private Symbol<Symbol.Name> getClassName() throws ValidationException {
        this.readMagic();
        this.minorVersion = this.stream.readU2();
        this.majorVersion = this.stream.readU2();
        this.verifyVersion(this.majorVersion, this.minorVersion);
        try (DebugCloseable closeable = CONSTANT_POOL.scope(this.parsingContext.getTimers());){
            this.pool = this.parseConstantPool();
        }
        this.stream.readU2();
        int thisKlassIndex = this.stream.readU2();
        return this.pool.classAt(thisKlassIndex).getName(this.pool);
    }

    private ParserMethod[] parseMethods(boolean isInterface) throws ValidationException {
        int methodCount = this.stream.readU2();
        if (methodCount == 0) {
            return ParserMethod.EMPTY_ARRAY;
        }
        ParserMethod[] methods = new ParserMethod[methodCount];
        HashSet<MethodKey> dup = new HashSet<MethodKey>(methodCount);
        for (int i = 0; i < methodCount; ++i) {
            ParserMethod method;
            try (DebugCloseable closeable = PARSE_SINGLE_METHOD.scope(this.parsingContext.getTimers());){
                method = this.parseMethod(isInterface);
            }
            methods[i] = method;
            closeable = NO_DUP_CHECK.scope(this.parsingContext.getTimers());
            try {
                if (dup.add(new MethodKey(method))) continue;
                throw ClassfileParser.classFormatError("Duplicate method name and signature: " + String.valueOf(method.getName()) + " " + String.valueOf(method.getSignature()));
            }
            finally {
                if (closeable != null) {
                    closeable.close();
                }
            }
        }
        return methods;
    }

    private static void verifyMethodFlags(int flags, boolean isInterface, boolean isInit, boolean isClinit, int majorVersion) {
        if (isClinit) {
            return;
        }
        boolean valid = true;
        if ((flags & 0x400) != 0) {
            valid &= (flags & 0x11A) == 0;
            if (majorVersion >= 49) {
                valid &= (flags & 0x820) == 0;
            }
        }
        if (valid) {
            if (!isInterface) {
                int maskedFlags = flags & 7;
                valid &= maskedFlags == 0 || (maskedFlags & ~(maskedFlags - 1)) == maskedFlags;
            } else {
                valid &= (flags & 0x134) == 0;
                if (majorVersion < 52) {
                    int publicAndAbstract = 1025;
                    valid &= (flags & 0x401) == 1025;
                    valid &= (flags & 2) == 0;
                } else {
                    int maskedFlags = flags & 3;
                    valid &= maskedFlags != 0 & (maskedFlags & ~(maskedFlags - 1)) == maskedFlags;
                }
            }
            if (valid && isInit) {
                valid &= (flags & 0x1DFF & 0xFFFFE778) == 0;
            }
        }
        if (!valid) {
            throw ClassfileParser.classFormatError("Invalid method flags 0x" + Integer.toHexString(flags));
        }
    }

    private ParserMethod parseMethod(boolean isInterface) throws ValidationException {
        Attribute[] methodAttributes;
        int attributeCount;
        Symbol<Symbol.Signature> signature;
        Symbol<Symbol.Name> name;
        int methodFlags = this.stream.readU2();
        int nameIndex = this.stream.readU2();
        int signatureIndex = this.stream.readU2();
        int extraFlags = methodFlags;
        boolean isClinit = false;
        boolean isInit = false;
        try (DebugCloseable closeable = METHOD_INIT.scope(this.parsingContext.getTimers());){
            try (DebugCloseable nameCheck = NAME_CHECK.scope(this.parsingContext.getTimers());){
                name = this.validateMethodName(this.pool.utf8At(nameIndex, "method name"), true);
                if (name.equals(Symbol.Name._clinit_)) {
                    if (this.majorVersion < 51) {
                        methodFlags = 8;
                    } else if ((methodFlags & 8) == 8) {
                        methodFlags &= 0x808;
                    } else if (this.parsingContext.getJavaVersion().java9OrLater()) {
                        throw ClassfileParser.classFormatError("Method <clinit> is not static.");
                    }
                    isClinit = true;
                } else if (name.equals(Symbol.Name._init_)) {
                    if (isInterface) {
                        throw ClassfileParser.classFormatError("Method <init> is not valid in an interface.");
                    }
                    isInit = true;
                }
            }
            boolean isStatic = Modifier.isStatic(extraFlags);
            ClassfileParser.verifyMethodFlags(methodFlags, isInterface, isInit, isClinit, this.majorVersion);
            try (DebugCloseable signatureCheck = SIGNATURE_CHECK.scope(this.parsingContext.getTimers());){
                int slots = this.pool.utf8At(signatureIndex).validateSignatureGetSlots(isInit || isClinit);
                signature = Signatures.check(this.pool.symbolAt(signatureIndex, "method descriptor"));
                if (isClinit && this.majorVersion >= 51 && !signature.equals(Symbol.Signature._void)) {
                    throw ClassfileParser.classFormatError("Method <clinit> has invalid signature: " + String.valueOf(signature));
                }
                if (slots + (isStatic ? 0 : 1) > 255) {
                    throw ClassfileParser.classFormatError("Too many arguments in method signature: " + String.valueOf(signature));
                }
                if (name.equals(Symbol.Name.finalize) && signature.equals(Symbol.Signature._void) && !Modifier.isStatic(methodFlags) && !Symbol.Type.java_lang_Object.equals(this.classType)) {
                    this.classFlags |= 0x10000;
                }
            }
            attributeCount = this.stream.readU2();
            methodAttributes = ClassfileParser.spawnAttributesArray(attributeCount);
        }
        CodeAttribute codeAttribute = null;
        Attribute checkedExceptions = null;
        CommonAttributeParser commonAttributeParser = new CommonAttributeParser(InfoType.Method);
        MethodParametersAttribute methodParameters = null;
        for (int i = 0; i < attributeCount; ++i) {
            int attributeNameIndex = this.stream.readU2();
            Symbol<Symbol.Name> attributeName = this.pool.symbolAt(attributeNameIndex, "attribute name");
            int attributeSize = this.stream.readS4();
            int startPosition = this.stream.getPosition();
            if (attributeName.equals(Symbol.Name.Code)) {
                if (codeAttribute != null) {
                    throw ClassfileParser.classFormatError("Duplicate Code attribute");
                }
                try (DebugCloseable code = CODE_PARSE.scope(this.parsingContext.getTimers());){
                    codeAttribute = this.parseCodeAttribute(attributeName);
                    methodAttributes[i] = codeAttribute;
                }
            } else if (attributeName.equals(Symbol.Name.Exceptions)) {
                if (checkedExceptions != null) {
                    throw ClassfileParser.classFormatError("Duplicate Exceptions attribute");
                }
                checkedExceptions = this.parseExceptions(attributeName);
                methodAttributes[i] = checkedExceptions;
            } else if (attributeName.equals(Symbol.Name.Synthetic)) {
                methodFlags |= 0x1000;
                checkedExceptions = new Attribute(attributeName, null);
                methodAttributes[i] = checkedExceptions;
            } else if (this.majorVersion >= 49) {
                if (attributeName.equals(Symbol.Name.RuntimeVisibleAnnotations)) {
                    RuntimeVisibleAnnotationsAttribute annotations = commonAttributeParser.parseRuntimeVisibleAnnotations(attributeSize, AnnotationLocation.Method);
                    methodFlags |= annotations.flags;
                    methodAttributes[i] = annotations.attribute;
                } else if (attributeName.equals(Symbol.Name.MethodParameters)) {
                    if (methodParameters != null) {
                        throw ClassfileParser.classFormatError("Duplicate MethodParameters attribute");
                    }
                    methodParameters = this.parseMethodParameters(attributeName);
                    methodAttributes[i] = methodParameters;
                } else {
                    Attribute attr = commonAttributeParser.parseCommonAttribute(attributeName, attributeSize);
                    methodAttributes[i] = attr == null ? new Attribute(attributeName, this.stream.readByteArray(attributeSize)) : attr;
                }
            } else {
                methodAttributes[i] = new Attribute(attributeName, this.stream.readByteArray(attributeSize));
            }
            int distance = this.stream.getPosition() - startPosition;
            if (attributeSize == distance) continue;
            String message = "Invalid attribute_length for " + String.valueOf(attributeName) + " attribute (reported " + attributeSize + " != parsed " + distance + ")";
            throw ClassfileParser.classFormatError(message);
        }
        if (Modifier.isAbstract(methodFlags) || Modifier.isNative(methodFlags)) {
            if (codeAttribute != null) {
                throw ClassfileParser.classFormatError("Code attribute supplied for native or abstract method");
            }
        } else if (codeAttribute == null) {
            throw ClassfileParser.classFormatError("Missing Code attribute");
        }
        if (this.isHidden) {
            methodFlags |= 0x100000;
        }
        return ParserMethod.create(methodFlags, name, signature, methodAttributes);
    }

    private static Attribute[] spawnAttributesArray(int attributeCount) {
        return attributeCount == 0 ? Attribute.EMPTY_ARRAY : new Attribute[attributeCount];
    }

    private static int parseAnnotation(ClassfileStream subStream) {
        int typeIndex = subStream.readU2();
        int numElementValuePairs = subStream.readU2();
        for (int k = 0; k < numElementValuePairs; ++k) {
            subStream.readU2();
            ClassfileParser.skipElementValue(subStream);
        }
        return typeIndex;
    }

    private static void skipElementValue(ClassfileStream subStream) {
        char tag = (char)subStream.readU1();
        switch (tag) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': 
            case 's': {
                subStream.readU2();
                break;
            }
            case 'e': {
                subStream.readU2();
                subStream.readU2();
                break;
            }
            case 'c': {
                subStream.readU2();
                break;
            }
            case '@': {
                ClassfileParser.parseAnnotation(subStream);
                break;
            }
            case '[': {
                int numValues = subStream.readU2();
                for (int i = 0; i < numValues; ++i) {
                    ClassfileParser.skipElementValue(subStream);
                }
                break;
            }
            default: {
                throw ClassfileParser.classFormatError("Invalid annotation tag: " + tag);
            }
        }
    }

    private Attribute[] parseClassAttributes() throws ValidationException {
        int attributeCount = this.stream.readU2();
        if (attributeCount == 0) {
            if (this.maxBootstrapMethodAttrIndex >= 0) {
                throw ClassfileParser.classFormatError("BootstrapMethods attribute is missing");
            }
            return Attribute.EMPTY_ARRAY;
        }
        SourceFileAttribute sourceFileName = null;
        SourceDebugExtensionAttribute sourceDebugExtensionAttribute = null;
        NestHostAttribute nestHost = null;
        NestMembersAttribute nestMembers = null;
        EnclosingMethodAttribute enclosingMethod = null;
        BootstrapMethodsAttribute bootstrapMethods = null;
        InnerClassesAttribute innerClasses = null;
        PermittedSubclassesAttribute permittedSubclasses = null;
        RecordAttribute record = null;
        CommonAttributeParser commonAttributeParser = new CommonAttributeParser(InfoType.Class);
        Attribute[] classAttributes = ClassfileParser.spawnAttributesArray(attributeCount);
        for (int i = 0; i < attributeCount; ++i) {
            int attributeNameIndex = this.stream.readU2();
            Symbol<Symbol.Name> attributeName = this.pool.symbolAt(attributeNameIndex, "attribute name");
            int attributeSize = this.stream.readS4();
            int startPosition = this.stream.getPosition();
            if (attributeName.equals(Symbol.Name.SourceFile)) {
                if (sourceFileName != null) {
                    throw ClassfileParser.classFormatError("Duplicate SourceFile attribute");
                }
                sourceFileName = this.parseSourceFileAttribute(attributeName);
                classAttributes[i] = sourceFileName;
            } else if (attributeName.equals(Symbol.Name.SourceDebugExtension)) {
                if (sourceDebugExtensionAttribute != null) {
                    throw ClassfileParser.classFormatError("Duplicate SourceDebugExtension attribute");
                }
                sourceDebugExtensionAttribute = this.parseSourceDebugExtensionAttribute(attributeName, attributeSize);
                classAttributes[i] = sourceDebugExtensionAttribute;
            } else if (attributeName.equals(Symbol.Name.Synthetic)) {
                this.classFlags |= 0x1000;
                classAttributes[i] = new Attribute(attributeName, null);
            } else if (attributeName.equals(Symbol.Name.InnerClasses)) {
                if (innerClasses != null) {
                    throw ClassfileParser.classFormatError("Duplicate InnerClasses attribute");
                }
                innerClasses = this.parseInnerClasses(attributeName);
                classAttributes[i] = innerClasses;
            } else if (this.majorVersion >= 49) {
                if (this.majorVersion >= 51 && attributeName.equals(Symbol.Name.BootstrapMethods)) {
                    if (bootstrapMethods != null) {
                        throw ClassfileParser.classFormatError("Duplicate BootstrapMethods attribute");
                    }
                    bootstrapMethods = this.parseBootstrapMethods(attributeName);
                    classAttributes[i] = bootstrapMethods;
                } else if (attributeName.equals(Symbol.Name.EnclosingMethod)) {
                    if (enclosingMethod != null) {
                        throw ClassfileParser.classFormatError("Duplicate EnclosingMethod attribute");
                    }
                    enclosingMethod = this.parseEnclosingMethodAttribute(attributeName);
                    classAttributes[i] = enclosingMethod;
                } else if (this.majorVersion >= 55 && attributeName.equals(Symbol.Name.NestHost)) {
                    if (nestHost != null) {
                        throw ClassfileParser.classFormatError("Duplicate NestHost attribute");
                    }
                    if (nestMembers != null) {
                        throw ClassfileParser.classFormatError("Classfile cannot have both a nest members and a nest host attribute.");
                    }
                    if (attributeSize != 2) {
                        throw ClassfileParser.classFormatError("Attribute length of NestHost must be 2");
                    }
                    nestHost = this.parseNestHostAttribute(attributeName);
                    classAttributes[i] = nestHost;
                } else if (this.majorVersion >= 55 && attributeName.equals(Symbol.Name.NestMembers)) {
                    if (nestMembers != null) {
                        throw ClassfileParser.classFormatError("Duplicate NestMembers attribute");
                    }
                    if (nestHost != null) {
                        throw ClassfileParser.classFormatError("Classfile cannot have both a nest members and a nest host attribute.");
                    }
                    nestMembers = this.parseNestMembers(attributeName);
                    classAttributes[i] = nestMembers;
                } else if (this.majorVersion >= 58 && attributeName.equals(Symbol.Name.Record)) {
                    if (record != null) {
                        throw ClassfileParser.classFormatError("Duplicate Record attribute");
                    }
                    record = this.parseRecord(attributeName);
                    classAttributes[i] = record;
                } else if (this.majorVersion >= 61 && attributeName.equals(Symbol.Name.PermittedSubclasses)) {
                    if (permittedSubclasses != null) {
                        throw ClassfileParser.classFormatError("Duplicate PermittedSubclasses attribute");
                    }
                    permittedSubclasses = this.parsePermittedSubclasses(attributeName);
                    classAttributes[i] = permittedSubclasses;
                } else {
                    Attribute attr = commonAttributeParser.parseCommonAttribute(attributeName, attributeSize);
                    classAttributes[i] = attr == null ? new Attribute(attributeName, this.stream.readByteArray(attributeSize)) : attr;
                }
            } else {
                classAttributes[i] = new Attribute(attributeName, this.stream.readByteArray(attributeSize));
            }
            if (attributeSize == this.stream.getPosition() - startPosition) continue;
            throw ClassfileParser.classFormatError("Invalid attribute length for " + String.valueOf(attributeName) + " attribute");
        }
        if (this.maxBootstrapMethodAttrIndex >= 0 && bootstrapMethods == null) {
            throw ClassfileParser.classFormatError("BootstrapMethods attribute is missing");
        }
        return classAttributes;
    }

    private SourceFileAttribute parseSourceFileAttribute(Symbol<Symbol.Name> name) {
        assert (Symbol.Name.SourceFile.equals(name));
        int sourceFileIndex = this.stream.readU2();
        return new SourceFileAttribute(name, sourceFileIndex);
    }

    private SourceDebugExtensionAttribute parseSourceDebugExtensionAttribute(Symbol<Symbol.Name> name, int attributeLength) {
        assert (Symbol.Name.SourceDebugExtension.equals(name));
        byte[] debugExBytes = this.stream.readByteArray(attributeLength);
        String debugExtension = null;
        try {
            debugExtension = ModifiedUtf8.toJavaString(debugExBytes);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new SourceDebugExtensionAttribute(name, debugExtension);
    }

    private LineNumberTableAttribute parseLineNumberTable(Symbol<Symbol.Name> name) {
        assert (Symbol.Name.LineNumberTable.equals(name));
        int entryCount = this.stream.readU2();
        if (entryCount == 0) {
            return LineNumberTableAttribute.EMPTY;
        }
        char[] entries = new char[entryCount << 1];
        for (int i = 0; i < entryCount; ++i) {
            int idx = i << 1;
            char bci = (char)this.stream.readU2();
            char lineNumber = (char)this.stream.readU2();
            entries[idx] = bci;
            entries[idx + 1] = lineNumber;
        }
        return new LineNumberTableAttribute(name, entries);
    }

    private LocalVariableTable parseLocalVariableAttribute(Symbol<Symbol.Name> name, int codeLength, int maxLocals) throws ValidationException {
        assert (Symbol.Name.LocalVariableTable.equals(name));
        return this.parseLocalVariableTable(name, codeLength, maxLocals);
    }

    private LocalVariableTable parseLocalVariableTypeAttribute(Symbol<Symbol.Name> name, int codeLength, int maxLocals) throws ValidationException {
        assert (Symbol.Name.LocalVariableTypeTable.equals(name));
        return this.parseLocalVariableTable(name, codeLength, maxLocals);
    }

    private LocalVariableTable parseLocalVariableTable(Symbol<Symbol.Name> name, int codeLength, int maxLocals) throws ValidationException {
        boolean isLVTT = Symbol.Name.LocalVariableTypeTable.equals(name);
        int entryCount = this.stream.readU2();
        if (entryCount == 0) {
            return isLVTT ? LocalVariableTable.EMPTY_LVTT : LocalVariableTable.EMPTY_LVT;
        }
        Local[] locals = new Local[entryCount];
        for (int i = 0; i < entryCount; ++i) {
            Symbol<Symbol.Type> type;
            int bci = this.stream.readU2();
            int length = this.stream.readU2();
            int nameIndex = this.stream.readU2();
            int descIndex = this.stream.readU2();
            int slot = this.stream.readU2();
            if (bci < 0 || bci >= codeLength) {
                throw ClassfileParser.classFormatError("Invalid local variable table attribute entry: start_pc out of bounds: " + bci);
            }
            if (bci + length > codeLength) {
                throw ClassfileParser.classFormatError("Invalid local variable table attribute entry: start_pc + length out of bounds: " + (bci + length));
            }
            Utf8Constant poolName = this.pool.utf8At(nameIndex);
            Utf8Constant typeNameOrSignature = this.pool.utf8At(descIndex);
            int extraSlot = 0;
            if (!(isLVTT || (type = this.validateType(typeNameOrSignature, false)) != Symbol.Type._long && type != Symbol.Type._double)) {
                extraSlot = 1;
            }
            if (slot + extraSlot >= maxLocals) {
                throw ClassfileParser.classFormatError("Invalid local variable table attribute entry: index points to an invalid frame slot: " + slot);
            }
            locals[i] = new Local(this.validateFieldName(poolName), isLVTT ? null : this.validateType(typeNameOrSignature, false), isLVTT ? typeNameOrSignature.unsafeSymbolValue() : null, bci, bci + length - 1, slot);
        }
        return new LocalVariableTable(name, locals);
    }

    private SignatureAttribute parseSignatureAttribute(Symbol<Symbol.Name> name) throws ValidationException {
        assert (Symbol.Name.Signature.equals(name));
        int signatureIndex = this.stream.readU2();
        this.validateEncoding(this.pool.utf8At(signatureIndex, "signature attribute"));
        return new SignatureAttribute(name, signatureIndex);
    }

    private MethodParametersAttribute parseMethodParameters(Symbol<Symbol.Name> name) {
        int entryCount = this.stream.readU1();
        if (entryCount == 0) {
            return MethodParametersAttribute.EMPTY;
        }
        MethodParametersAttribute.Entry[] entries = new MethodParametersAttribute.Entry[entryCount];
        for (int i = 0; i < entryCount; ++i) {
            int nameIndex = this.stream.readU2();
            int accessFlags = this.stream.readU2();
            entries[i] = new MethodParametersAttribute.Entry(nameIndex, accessFlags);
        }
        return new MethodParametersAttribute(name, entries);
    }

    private ExceptionsAttribute parseExceptions(Symbol<Symbol.Name> name) {
        assert (Symbol.Name.Exceptions.equals(name));
        int entryCount = this.stream.readU2();
        int[] entries = new int[entryCount];
        for (int i = 0; i < entryCount; ++i) {
            int index = this.stream.readU2();
            if (index >= this.pool.length()) {
                throw ClassfileParser.classFormatError("Invalid exception_index_table: out of bounds.");
            }
            if (index == 0) {
                throw ClassfileParser.classFormatError("Invalid exception_index_table: 0.");
            }
            if (this.pool.tagAt(index) != ConstantPool.Tag.CLASS) {
                throw ClassfileParser.classFormatError("Invalid exception_index_table: not a CONSTANT_Class_info structure.");
            }
            entries[i] = index;
        }
        return new ExceptionsAttribute(name, entries);
    }

    private BootstrapMethodsAttribute parseBootstrapMethods(Symbol<Symbol.Name> name) {
        int entryCount = this.stream.readU2();
        if (this.maxBootstrapMethodAttrIndex >= entryCount) {
            throw ClassfileParser.classFormatError("Invalid bootstrapMethod index: " + this.maxBootstrapMethodAttrIndex + ", actual bootstrap methods size: " + entryCount);
        }
        BootstrapMethodsAttribute.Entry[] entries = new BootstrapMethodsAttribute.Entry[entryCount];
        for (int i = 0; i < entryCount; ++i) {
            int bootstrapMethodRef = this.stream.readU2();
            if (bootstrapMethodRef == 0) {
                throw ClassfileParser.classFormatError("Invalid bootstrapMethodRefIndex: 0");
            }
            if (bootstrapMethodRef >= this.pool.length()) {
                throw ClassfileParser.classFormatError("Invalid bootstrapMethodRefIndex: out of bounds.");
            }
            if (this.pool.tagAt(bootstrapMethodRef) != ConstantPool.Tag.METHODHANDLE) {
                throw ClassfileParser.classFormatError("Invalid bootstrapMethodRefIndex: not a CONSTANT_MethodHandle_info structure.");
            }
            if (this.maxBootstrapMethodAttrIndex >= entryCount) {
                throw ClassfileParser.classFormatError("bootstrap_method_attr_index is greater than maximum valid index in the BootstrapMethods attribute.");
            }
            int numBootstrapArguments = this.stream.readU2();
            char[] bootstrapArguments = new char[numBootstrapArguments];
            for (int j = 0; j < numBootstrapArguments; ++j) {
                char cpIndex = (char)this.stream.readU2();
                if (!this.pool.tagAt(cpIndex).isLoadable()) {
                    throw ClassfileParser.classFormatError("Invalid constant pool constant for BootstrapMethodAttribute. Not a loadable constant");
                }
                bootstrapArguments[j] = cpIndex;
            }
            entries[i] = new BootstrapMethodsAttribute.Entry((char)bootstrapMethodRef, bootstrapArguments);
        }
        return new BootstrapMethodsAttribute(name, entries);
    }

    private InnerClassesAttribute parseInnerClasses(Symbol<Symbol.Name> name) throws ValidationException {
        assert (Symbol.Name.InnerClasses.equals(name));
        int entryCount = this.stream.readU2();
        boolean duplicateInnerClass = false;
        InnerClassesAttribute.Entry[] innerClassInfos = new InnerClassesAttribute.Entry[entryCount];
        for (int i = 0; i < entryCount; ++i) {
            InnerClassesAttribute.Entry innerClassInfo = this.parseInnerClassEntry();
            int innerClassIndex = innerClassInfo.innerClassIndex;
            int outerClassIndex = innerClassInfo.outerClassIndex;
            innerClassInfos[i] = innerClassInfo;
            if (this.parsingContext.isStrictJavaCompliance() && this.majorVersion >= 51 && innerClassInfo.innerNameIndex == 0 && outerClassIndex != 0) {
                throw ClassfileParser.classFormatError("InnerClassesAttribute: the value of the outer_class_info_index item must be zero if the value of the inner_name_index item is zero.");
            }
            if (innerClassIndex == outerClassIndex) {
                throw ClassfileParser.classFormatError("Class is both outer and inner class");
            }
            Symbol<Symbol.Name> innerClassName = null;
            if (innerClassIndex != 0) {
                innerClassName = this.pool.classAt(innerClassIndex).getName(this.pool);
            }
            for (int j = 0; j < i; ++j) {
                InnerClassesAttribute.Entry otherInnerClassInfo = innerClassInfos[j];
                if (otherInnerClassInfo == null) continue;
                if (innerClassIndex == otherInnerClassInfo.innerClassIndex && outerClassIndex == otherInnerClassInfo.outerClassIndex) {
                    throw ClassfileParser.classFormatError("Duplicate entry in InnerClasses attribute");
                }
                if (innerClassIndex != otherInnerClassInfo.innerClassIndex && (innerClassIndex == 0 || otherInnerClassInfo.innerClassIndex == 0 || !innerClassName.equals(this.pool.classAt(otherInnerClassInfo.innerClassIndex).getName(this.pool)))) continue;
                duplicateInnerClass = true;
            }
        }
        if (duplicateInnerClass || this.hasCycles(innerClassInfos)) {
            String cause = duplicateInnerClass ? "Duplicate inner_class_info_index (class names)" : "Cycle detected";
            this.parsingContext.getLogger().log(() -> cause + " in InnerClassesAttribute, in class " + String.valueOf(this.classType));
            return new InnerClassesAttribute(name, new InnerClassesAttribute.Entry[0]);
        }
        return new InnerClassesAttribute(name, innerClassInfos);
    }

    int findInnerClassIndexEntry(InnerClassesAttribute.Entry[] entries, Symbol<Symbol.Name> innerClassName) {
        for (int i = 0; i < entries.length; ++i) {
            InnerClassesAttribute.Entry entry = entries[i];
            if (entry.innerClassIndex == 0 || innerClassName != this.pool.classAt(entry.innerClassIndex).getName(this.pool)) continue;
            return i;
        }
        return -1;
    }

    boolean hasCycles(InnerClassesAttribute.Entry[] entries) {
        int curMark = 0;
        int[] mark = new int[entries.length];
        block0: for (int i = 0; i < entries.length; ++i) {
            int index;
            if (mark[i] != 0) continue;
            mark[i] = ++curMark;
            int v = entries[i].outerClassIndex;
            while (v != 0 && (index = this.findInnerClassIndexEntry(entries, this.pool.classAt(v).getName(this.pool))) >= 0) {
                if (mark[index] == curMark) {
                    return true;
                }
                if (mark[index] != 0) continue block0;
                mark[index] = curMark;
                v = entries[index].outerClassIndex;
            }
        }
        return false;
    }

    private StackMapTableAttribute parseStackMapTableAttribute(Symbol<Symbol.Name> attributeName, int attributeSize) {
        if (this.verifiable) {
            return new StackMapTableAttribute(attributeName, this.stream.readByteArray(attributeSize));
        }
        this.stream.skip(attributeSize);
        return StackMapTableAttribute.EMPTY;
    }

    private NestHostAttribute parseNestHostAttribute(Symbol<Symbol.Name> attributeName) throws ValidationException {
        int hostClassIndex = this.stream.readU2();
        this.pool.classAt(hostClassIndex).validate(this.pool);
        return new NestHostAttribute(attributeName, hostClassIndex);
    }

    private NestMembersAttribute parseNestMembers(Symbol<Symbol.Name> attributeName) throws ValidationException {
        assert (NestMembersAttribute.NAME.equals(attributeName));
        int numberOfClasses = this.stream.readU2();
        int[] classes = new int[numberOfClasses];
        for (int i = 0; i < numberOfClasses; ++i) {
            int pos = this.stream.readU2();
            this.pool.classAt(pos).validate(this.pool);
            classes[i] = pos;
        }
        return new NestMembersAttribute(attributeName, classes);
    }

    private PermittedSubclassesAttribute parsePermittedSubclasses(Symbol<Symbol.Name> attributeName) throws ValidationException {
        assert (PermittedSubclassesAttribute.NAME.equals(attributeName));
        if ((this.classFlags & 0x10) != 0) {
            throw ClassfileParser.classFormatError("A final class may not declare a permitted subclasses attribute.");
        }
        int numberOfClasses = this.stream.readU2();
        if (numberOfClasses == 0) {
            return PermittedSubclassesAttribute.EMPTY;
        }
        char[] classes = new char[numberOfClasses];
        for (int i = 0; i < numberOfClasses; ++i) {
            int pos = this.stream.readU2();
            this.pool.classAt(pos).validate(this.pool);
            classes[i] = (char)pos;
        }
        return new PermittedSubclassesAttribute(attributeName, classes);
    }

    private RecordAttribute parseRecord(Symbol<Symbol.Name> recordAttributeName) throws ValidationException {
        assert (RecordAttribute.NAME.equals(recordAttributeName));
        int count = this.stream.readU2();
        RecordAttribute.RecordComponentInfo[] components = new RecordAttribute.RecordComponentInfo[count];
        for (int i = 0; i < count; ++i) {
            int nameIndex = this.stream.readU2();
            int descriptorIndex = this.stream.readU2();
            this.pool.utf8At(nameIndex).validateUTF8();
            this.pool.utf8At(descriptorIndex).validateType(false);
            Attribute[] componentAttributes = this.parseRecordComponentAttributes();
            components[i] = new RecordAttribute.RecordComponentInfo(nameIndex, descriptorIndex, componentAttributes);
        }
        return new RecordAttribute(recordAttributeName, components);
    }

    private Attribute[] parseRecordComponentAttributes() throws ValidationException {
        int size = this.stream.readU2();
        Attribute[] componentAttributes = new Attribute[size];
        CommonAttributeParser commonAttributeParser = new CommonAttributeParser(InfoType.Record);
        for (int j = 0; j < size; ++j) {
            int attributeSize;
            Symbol<Symbol.Name> attributeName = this.pool.symbolAt(this.stream.readU2(), "attribute name");
            Attribute attr = commonAttributeParser.parseCommonAttribute(attributeName, attributeSize = this.stream.readS4());
            componentAttributes[j] = attr == null ? new Attribute(attributeName, this.stream.readByteArray(attributeSize)) : attr;
        }
        return componentAttributes;
    }

    private InnerClassesAttribute.Entry parseInnerClassEntry() throws ValidationException {
        int innerClassIndex = this.stream.readU2();
        int outerClassIndex = this.stream.readU2();
        int innerNameIndex = this.stream.readU2();
        int innerClassAccessFlags = this.stream.readU2();
        if ((innerClassAccessFlags & 0x200) != 0 && this.majorVersion < 50) {
            innerClassAccessFlags |= 0x400;
        }
        if (innerClassIndex != 0 || this.parsingContext.getJavaVersion().java9OrLater()) {
            this.pool.classAt(innerClassIndex).validate(this.pool);
        }
        if (outerClassIndex != 0) {
            this.pool.classAt(outerClassIndex).validate(this.pool);
        }
        if (innerNameIndex != 0) {
            this.pool.utf8At(innerNameIndex).validate(this.pool);
        }
        return new InnerClassesAttribute.Entry(innerClassIndex, outerClassIndex, innerNameIndex, innerClassAccessFlags);
    }

    private EnclosingMethodAttribute parseEnclosingMethodAttribute(Symbol<Symbol.Name> name) {
        int classIndex = this.stream.readU2();
        int methodIndex = this.stream.readU2();
        return new EnclosingMethodAttribute(name, classIndex, methodIndex);
    }

    private CodeAttribute parseCodeAttribute(Symbol<Symbol.Name> name) throws ValidationException {
        ExceptionHandler[] entries;
        byte[] code;
        int maxStack = this.stream.readU2();
        int maxLocals = this.stream.readU2();
        int codeLength = this.stream.readS4();
        if (codeLength <= 0) {
            throw ClassfileParser.classFormatError("code_length must be > than 0");
        }
        if (codeLength > 65535) {
            throw ClassfileParser.classFormatError("code_length > than 64 KB");
        }
        try (DebugCloseable codeRead = CODE_READ.scope(this.parsingContext.getTimers());){
            code = this.stream.readByteArray(codeLength);
        }
        try (DebugCloseable handlers = EXCEPTION_HANDLERS.scope(this.parsingContext.getTimers());){
            entries = this.parseExceptionHandlerEntries();
        }
        int attributeCount = this.stream.readU2();
        Attribute[] codeAttributes = ClassfileParser.spawnAttributesArray(attributeCount);
        int totalLocalTableCount = 0;
        CommonAttributeParser commonAttributeParser = new CommonAttributeParser(InfoType.Code);
        StackMapTableAttribute stackMapTable = null;
        for (int i = 0; i < attributeCount; ++i) {
            int attributeNameIndex = this.stream.readU2();
            Symbol<Symbol.Name> attributeName = this.pool.symbolAt(attributeNameIndex, "attribute name");
            int attributeSize = this.stream.readS4();
            int startPosition = this.stream.getPosition();
            if (attributeName.equals(Symbol.Name.LineNumberTable)) {
                codeAttributes[i] = this.parseLineNumberTable(attributeName);
            } else if (attributeName.equals(Symbol.Name.LocalVariableTable)) {
                codeAttributes[i] = this.parseLocalVariableAttribute(attributeName, codeLength, maxLocals);
                ++totalLocalTableCount;
            } else if (attributeName.equals(Symbol.Name.LocalVariableTypeTable)) {
                codeAttributes[i] = this.parseLocalVariableTypeAttribute(attributeName, codeLength, maxLocals);
            } else if (attributeName.equals(Symbol.Name.StackMapTable)) {
                if (stackMapTable != null) {
                    throw ClassfileParser.classFormatError("Duplicate StackMapTable attribute");
                }
                stackMapTable = this.parseStackMapTableAttribute(attributeName, attributeSize);
                codeAttributes[i] = stackMapTable;
            } else {
                Attribute attr = commonAttributeParser.parseCommonAttribute(attributeName, attributeSize);
                Attribute attribute = codeAttributes[i] = attr == null ? new Attribute(attributeName, this.stream.readByteArray(attributeSize)) : attr;
            }
            if (attributeSize == this.stream.getPosition() - startPosition) continue;
            throw ClassfileParser.classFormatError("Invalid attribute length for " + String.valueOf(attributeName) + " attribute");
        }
        if (totalLocalTableCount > 0) {
            this.validateLocalTables(codeAttributes);
        }
        return new CodeAttribute(name, maxStack, maxLocals, code, entries, codeAttributes, this.majorVersion);
    }

    private void validateLocalTables(Attribute[] codeAttributes) {
        if (this.getMajorVersion() < 49) {
            return;
        }
        EconomicMap table = EconomicMap.create((Equivalence)Local.localEquivalence);
        ArrayList<LocalVariableTable> typeTables = new ArrayList<LocalVariableTable>();
        for (Attribute attr : codeAttributes) {
            if (attr.getName() == Symbol.Name.LocalVariableTable) {
                LocalVariableTable localTable = (LocalVariableTable)attr;
                for (Local local : localTable.getLocals()) {
                    if (table.put((Object)local, (Object)false) == null) continue;
                    throw ClassfileParser.classFormatError("Duplicate local in local variable table: " + String.valueOf(local));
                }
                continue;
            }
            if (attr.getName() != Symbol.Name.LocalVariableTypeTable) continue;
            typeTables.add((LocalVariableTable)attr);
        }
        for (LocalVariableTable typeTable : typeTables) {
            for (Local local : typeTable.getLocals()) {
                Boolean present = (Boolean)table.put((Object)local, (Object)true);
                if (present == null) {
                    throw ClassfileParser.classFormatError("Local in local variable type table does not match any local variable table entry: " + String.valueOf(local));
                }
                if (!present.booleanValue()) continue;
                throw ClassfileParser.classFormatError("Duplicate local in local variable type table: " + String.valueOf(local));
            }
        }
    }

    private ExceptionHandler[] parseExceptionHandlerEntries() {
        int count = this.stream.readU2();
        if (count == 0) {
            return ExceptionHandler.EMPTY_ARRAY;
        }
        ExceptionHandler[] entries = new ExceptionHandler[count];
        for (int i = 0; i < count; ++i) {
            int startPc = this.stream.readU2();
            int endPc = this.stream.readU2();
            int handlerPc = this.stream.readU2();
            int catchTypeIndex = this.stream.readU2();
            Symbol<Symbol.Type> catchType = null;
            if (catchTypeIndex != 0) {
                catchType = this.parsingContext.getOrCreateTypeFromName(this.pool.classAt(catchTypeIndex).getName(this.pool));
            }
            entries[i] = new ExceptionHandler(startPc, endPc, handlerPc, catchTypeIndex, catchType);
        }
        return entries;
    }

    private static void verifyFieldFlags(Symbol<Symbol.Name> name, int flags, boolean isInterface) {
        boolean valid;
        if (!isInterface) {
            int maskedFlags = flags & 7;
            valid = maskedFlags == 0 || (maskedFlags & ~(maskedFlags - 1)) == maskedFlags;
            int finalAndVolatile = 80;
            valid = valid && (flags & 0x50) != 80;
        } else {
            boolean bl = valid = (flags & 0xFFFFEFFF) == 25;
        }
        if (!valid) {
            throw ClassfileParser.classFormatError(String.valueOf(name) + ": invalid field flags 0x" + Integer.toHexString(flags));
        }
    }

    private ParserField parseField(boolean isInterface) throws ValidationException {
        int fieldFlags = this.stream.readU2();
        int nameIndex = this.stream.readU2();
        int typeIndex = this.stream.readU2();
        Symbol<Symbol.Name> name = this.validateFieldName(this.pool.utf8At(nameIndex, "field name"));
        ClassfileParser.verifyFieldFlags(name, fieldFlags, isInterface);
        boolean isStatic = Modifier.isStatic(fieldFlags);
        Symbol<Symbol.Type> descriptor = this.validateType(this.pool.utf8At(typeIndex, "field descriptor"), false);
        int attributeCount = this.stream.readU2();
        Attribute[] fieldAttributes = ClassfileParser.spawnAttributesArray(attributeCount);
        ConstantValueAttribute constantValue = null;
        CommonAttributeParser commonAttributeParser = new CommonAttributeParser(InfoType.Field);
        for (int i = 0; i < attributeCount; ++i) {
            int attributeNameIndex = this.stream.readU2();
            Symbol<Symbol.Name> attributeName = this.pool.symbolAt(attributeNameIndex, "attribute name");
            int attributeSize = this.stream.readS4();
            int startPosition = this.stream.getPosition();
            if (isStatic && attributeName.equals(Symbol.Name.ConstantValue)) {
                if (constantValue != null) {
                    throw ClassfileParser.classFormatError("Duplicate ConstantValue attribute");
                }
                constantValue = new ConstantValueAttribute(this.stream.readU2());
                fieldAttributes[i] = constantValue;
                if (constantValue.getConstantValueIndex() == 0) {
                    throw ClassfileParser.classFormatError("Invalid ConstantValue index");
                }
            } else if (attributeName.equals(Symbol.Name.Synthetic)) {
                fieldFlags |= 0x1000;
                fieldAttributes[i] = new Attribute(attributeName, null);
            } else if (this.majorVersion >= 49) {
                if (attributeName.equals(Symbol.Name.RuntimeVisibleAnnotations)) {
                    RuntimeVisibleAnnotationsAttribute annotations = commonAttributeParser.parseRuntimeVisibleAnnotations(attributeSize, AnnotationLocation.Field);
                    fieldFlags |= annotations.flags;
                    fieldAttributes[i] = annotations.attribute;
                } else {
                    Attribute attr = commonAttributeParser.parseCommonAttribute(attributeName, attributeSize);
                    fieldAttributes[i] = attr == null ? new Attribute(attributeName, this.stream.readByteArray(attributeSize)) : attr;
                }
            } else {
                fieldAttributes[i] = new Attribute(attributeName, this.stream.readByteArray(attributeSize));
            }
            if (attributeSize == this.stream.getPosition() - startPosition) continue;
            throw ClassfileParser.classFormatError("Invalid attribute_length for " + String.valueOf(attributeName) + " attribute");
        }
        JavaKind kind = Types.getJavaKind(descriptor);
        if (kind == JavaKind.Void) {
            throw ClassfileParser.classFormatError("Fields cannot be of type void");
        }
        if (constantValue != null) {
            ConstantPool.Tag tag = this.pool.tagAt(constantValue.getConstantValueIndex());
            boolean valid = false;
            switch (kind) {
                case Boolean: 
                case Byte: 
                case Short: 
                case Char: 
                case Int: {
                    valid = tag == ConstantPool.Tag.INTEGER;
                    break;
                }
                case Float: {
                    valid = tag == ConstantPool.Tag.FLOAT;
                    break;
                }
                case Long: {
                    valid = tag == ConstantPool.Tag.LONG;
                    break;
                }
                case Double: {
                    valid = tag == ConstantPool.Tag.DOUBLE;
                    break;
                }
                case Object: {
                    valid = tag == ConstantPool.Tag.STRING && descriptor.equals(Symbol.Type.java_lang_String);
                    break;
                }
                default: {
                    throw ClassfileParser.classFormatError("Cannot have ConstantValue for fields of type " + String.valueOf((Object)kind));
                }
            }
            if (!valid) {
                throw ClassfileParser.classFormatError("ConstantValue attribute does not match field type");
            }
        }
        return new ParserField(fieldFlags, name, descriptor, fieldAttributes);
    }

    private ParserField[] parseFields(boolean isInterface) throws ValidationException {
        int fieldCount = this.stream.readU2();
        if (fieldCount == 0) {
            return ParserField.EMPTY_ARRAY;
        }
        ParserField[] fields = new ParserField[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            fields[i] = this.parseField(isInterface);
            for (int j = 0; j < i; ++j) {
                if (!fields[j].getName().equals(fields[i].getName()) || !fields[j].getType().equals(fields[i].getType())) continue;
                throw ClassfileParser.classFormatError("Duplicate field name and signature: " + String.valueOf(fields[j].getName()) + " " + String.valueOf(fields[j].getType()));
            }
        }
        return fields;
    }

    private Symbol<Symbol.Type> parseSuperKlass() {
        int index = this.stream.readU2();
        if (index == 0) {
            if (!this.classType.equals(Symbol.Type.java_lang_Object)) {
                throw ClassfileParser.classFormatError("Invalid superclass index 0");
            }
            return null;
        }
        return this.parsingContext.getOrCreateTypeFromName(this.pool.classAt(index).getName(this.pool));
    }

    private Symbol<Symbol.Type>[] parseInterfaces() {
        int interfaceCount = this.stream.readU2();
        if (interfaceCount == 0) {
            return Symbol.emptyArray();
        }
        Symbol[] interfaces = new Symbol[interfaceCount];
        for (int i = 0; i < interfaceCount; ++i) {
            int interfaceIndex = this.stream.readU2();
            Symbol<Symbol.Name> interfaceName = this.pool.classAt(interfaceIndex).getName(this.pool);
            Symbol<Symbol.Type> interfaceType = this.parsingContext.getOrCreateTypeFromName(interfaceName);
            if (interfaceType == null) {
                throw ClassfileParser.classFormatError(String.valueOf(this.classType) + " contains invalid superinterface name: " + String.valueOf(interfaceName));
            }
            if (Types.isPrimitive(interfaceType) || Types.isArray(interfaceType)) {
                throw ClassfileParser.classFormatError(String.valueOf(this.classType) + " superinterfaces cannot contain arrays nor primitives");
            }
            interfaces[i] = interfaceType;
        }
        HashSet<Symbol> present = new HashSet<Symbol>(interfaces.length);
        for (Symbol t : interfaces) {
            if (present.add(t)) continue;
            throw ClassfileParser.classFormatError("Duplicate interface name in classfile: " + String.valueOf(t));
        }
        return interfaces;
    }

    int getMajorVersion() {
        assert (this.majorVersion != -1);
        return this.majorVersion;
    }

    private Symbol<? extends ModifiedUtf8> validateEncoding(Utf8Constant utf8Constant) throws ValidationException {
        if (!this.validate) {
            return utf8Constant.unsafeSymbolValue();
        }
        return utf8Constant.validateUTF8();
    }

    private Symbol<Symbol.Name> validateFieldName(Utf8Constant utf8Constant) throws ValidationException {
        if (!this.validate) {
            return utf8Constant.unsafeSymbolValue();
        }
        return utf8Constant.validateFieldName();
    }

    private Symbol<Symbol.Name> validateMethodName(Utf8Constant utf8Constant, boolean allowClinit) throws ValidationException {
        if (!this.validate) {
            return utf8Constant.unsafeSymbolValue();
        }
        return utf8Constant.validateMethodName(allowClinit);
    }

    private Symbol<Symbol.Name> validateClassName(Utf8Constant utf8Constant) throws ValidationException {
        if (!this.validate) {
            return utf8Constant.unsafeSymbolValue();
        }
        return utf8Constant.validateClassName();
    }

    private Symbol<Symbol.Type> validateType(Utf8Constant utf8Constant, boolean allowVoid) throws ValidationException {
        if (!this.validate) {
            return utf8Constant.unsafeSymbolValue();
        }
        return utf8Constant.validateType(allowVoid);
    }

    private static class MethodKey {
        private final Symbol<Symbol.Name> methodName;
        private final Symbol<Symbol.Signature> signature;
        private final int hash;

        MethodKey(ParserMethod method) {
            this.methodName = method.getName();
            this.signature = method.getSignature();
            this.hash = Objects.hash(this.methodName, this.signature);
        }

        public boolean equals(Object obj) {
            if (obj instanceof MethodKey) {
                MethodKey other = (MethodKey)obj;
                return this.methodName.equals(other.methodName) && this.signature.equals(other.signature);
            }
            return false;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private class CommonAttributeParser {
        final InfoType infoType;
        Attribute runtimeVisibleAnnotations = null;
        Attribute runtimeInvisibleAnnotations = null;
        Attribute runtimeVisibleTypeAnnotations = null;
        Attribute runtimeInvisibleTypeAnnotations = null;
        Attribute runtimeVisibleParameterAnnotations = null;
        Attribute runtimeInvisibleParameterAnnotations = null;
        Attribute annotationDefault = null;
        Attribute signature = null;

        CommonAttributeParser(InfoType infoType) {
            this.infoType = infoType;
        }

        Attribute parseCommonAttribute(Symbol<Symbol.Name> attributeName, int attributeSize) throws ValidationException {
            if (this.infoType.supports(1) && attributeName.equals(Symbol.Name.RuntimeVisibleAnnotations)) {
                if (this.runtimeVisibleAnnotations != null) {
                    throw ClassfileParser.classFormatError("Duplicate RuntimeVisibleAnnotations attribute");
                }
                this.runtimeVisibleAnnotations = new Attribute(attributeName, ClassfileParser.this.stream.readByteArray(attributeSize));
                return this.runtimeVisibleAnnotations;
            }
            if (this.infoType.supports(4) && attributeName.equals(Symbol.Name.RuntimeVisibleTypeAnnotations)) {
                if (this.runtimeVisibleTypeAnnotations != null) {
                    throw ClassfileParser.classFormatError("Duplicate RuntimeVisibleTypeAnnotations attribute");
                }
                this.runtimeVisibleTypeAnnotations = new Attribute(attributeName, ClassfileParser.this.stream.readByteArray(attributeSize));
                return this.runtimeVisibleTypeAnnotations;
            }
            if (this.infoType.supports(2) && attributeName.equals(Symbol.Name.RuntimeInvisibleAnnotations)) {
                if (this.runtimeInvisibleAnnotations != null) {
                    throw ClassfileParser.classFormatError("Duplicate RuntimeVisibleTypeAnnotations attribute");
                }
                this.runtimeInvisibleAnnotations = new Attribute(attributeName, ClassfileParser.this.stream.readByteArray(attributeSize));
                return this.runtimeInvisibleAnnotations;
            }
            if (this.infoType.supports(8) && attributeName.equals(Symbol.Name.RuntimeInvisibleTypeAnnotations)) {
                if (this.runtimeInvisibleTypeAnnotations != null) {
                    throw ClassfileParser.classFormatError("Duplicate RuntimeInvisibleTypeAnnotations attribute");
                }
                this.runtimeInvisibleTypeAnnotations = new Attribute(attributeName, ClassfileParser.this.stream.readByteArray(attributeSize));
                return this.runtimeInvisibleTypeAnnotations;
            }
            if (this.infoType.supports(32) && attributeName.equals(Symbol.Name.RuntimeVisibleParameterAnnotations)) {
                if (this.runtimeVisibleParameterAnnotations != null) {
                    throw ClassfileParser.classFormatError("Duplicate RuntimeVisibleParameterAnnotations attribute");
                }
                this.runtimeVisibleParameterAnnotations = new Attribute(attributeName, ClassfileParser.this.stream.readByteArray(attributeSize));
                return this.runtimeVisibleParameterAnnotations;
            }
            if (this.infoType.supports(32) && attributeName.equals(Symbol.Name.RuntimeInvisibleParameterAnnotations)) {
                if (this.runtimeInvisibleParameterAnnotations != null) {
                    throw ClassfileParser.classFormatError("Duplicate RuntimeVisibleParameterAnnotations attribute");
                }
                this.runtimeInvisibleParameterAnnotations = new Attribute(attributeName, ClassfileParser.this.stream.readByteArray(attributeSize));
                return this.runtimeInvisibleParameterAnnotations;
            }
            if (this.infoType.supports(64) && attributeName.equals(Symbol.Name.AnnotationDefault)) {
                if (this.annotationDefault != null) {
                    throw ClassfileParser.classFormatError("Duplicate AnnotationDefault attribute");
                }
                this.annotationDefault = new Attribute(attributeName, ClassfileParser.this.stream.readByteArray(attributeSize));
                return this.annotationDefault;
            }
            if (this.infoType.supports(128) && attributeName.equals(Symbol.Name.Signature)) {
                if (ClassfileParser.this.parsingContext.getJavaVersion().java9OrLater() && this.signature != null) {
                    throw ClassfileParser.classFormatError("Duplicate AnnotationDefault attribute");
                }
                if (attributeSize != 2) {
                    throw ClassfileParser.classFormatError("Invalid attribute_length value for signature attribute: " + attributeSize + " != 2");
                }
                this.signature = ClassfileParser.this.parseSignatureAttribute(attributeName);
                return this.signature;
            }
            return null;
        }

        RuntimeVisibleAnnotationsAttribute parseRuntimeVisibleAnnotations(int attributeSize, AnnotationLocation location) {
            Attribute attribute;
            assert (this.infoType.supports(1));
            if (this.runtimeVisibleAnnotations != null) {
                throw ClassfileParser.classFormatError("Duplicate RuntimeVisibleAnnotations attribute");
            }
            byte[] data = ClassfileParser.this.stream.readByteArray(attributeSize);
            ClassfileStream subStream = new ClassfileStream(data, ClassfileParser.this.stream.getClasspathFile());
            int flags = 0;
            if (ClassfileParser.this.loaderIsBootOrPlatform || ClassfileParser.this.forceAllowVMAnnotations) {
                flags = switch (location.ordinal()) {
                    default -> throw new IncompatibleClassChangeError();
                    case 0 -> this.parseMethodVMAnnotations(subStream);
                    case 1 -> this.parseFieldVMAnnotations(subStream);
                    case 2 -> 0;
                };
            }
            this.runtimeVisibleAnnotations = attribute = new Attribute(Symbol.Name.RuntimeVisibleAnnotations, data);
            return new RuntimeVisibleAnnotationsAttribute(attribute, flags);
        }

        private int parseMethodVMAnnotations(ClassfileStream subStream) {
            int flags = 0;
            int count = subStream.readU2();
            for (int j = 0; j < count; ++j) {
                int typeIndex = ClassfileParser.parseAnnotation(subStream);
                Utf8Constant constant = ClassfileParser.this.pool.utf8At(typeIndex, "annotation type");
                Symbol annotType = constant.unsafeSymbolValue();
                if (Symbol.Type.java_lang_invoke_LambdaForm$Compiled.equals(annotType)) {
                    flags |= 0x40000;
                    continue;
                }
                if (Symbol.Type.java_lang_invoke_LambdaForm$Hidden.equals(annotType) || Symbol.Type.jdk_internal_vm_annotation_Hidden.equals(annotType)) {
                    flags |= 0x100000;
                    continue;
                }
                if (Symbol.Type.sun_reflect_CallerSensitive.equals(annotType) || Symbol.Type.jdk_internal_reflect_CallerSensitive.equals(annotType)) {
                    flags |= 0x80000;
                    continue;
                }
                if (Symbol.Type.java_lang_invoke_ForceInline.equals(annotType) || Symbol.Type.jdk_internal_vm_annotation_ForceInline.equals(annotType)) {
                    flags |= 0x20000;
                    continue;
                }
                if (Symbol.Type.java_lang_invoke_DontInline.equals(annotType) || Symbol.Type.jdk_internal_vm_annotation_DontInline.equals(annotType)) {
                    flags |= 0x400000;
                    continue;
                }
                if (!Symbol.Type.jdk_internal_misc_ScopedMemoryAccess$Scoped.equals(annotType)) continue;
                flags |= 0x200000;
            }
            return flags;
        }

        private int parseFieldVMAnnotations(ClassfileStream subStream) {
            int flags = 0;
            int count = subStream.readU2();
            for (int j = 0; j < count; ++j) {
                int typeIndex = ClassfileParser.parseAnnotation(subStream);
                Utf8Constant constant = ClassfileParser.this.pool.utf8At(typeIndex, "annotation type");
                Symbol annotType = constant.unsafeSymbolValue();
                if (!Symbol.Type.jdk_internal_vm_annotation_Stable.equals(annotType)) continue;
                flags |= 0x10000;
            }
            return flags;
        }
    }

    public static enum InfoType {
        Class(143),
        Method(255),
        Field(143),
        Code(140),
        Record(143);

        final int annotations;

        private InfoType(int annotations) {
            this.annotations = annotations;
        }

        boolean supports(int annotation) {
            return (this.annotations & annotation) != 0;
        }
    }

    private static enum AnnotationLocation {
        Method,
        Field,
        Class;

    }

    private record RuntimeVisibleAnnotationsAttribute(Attribute attribute, int flags) {
        private RuntimeVisibleAnnotationsAttribute {
            Objects.requireNonNull(attribute);
        }
    }
}

