/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.classfile.constantpool.ClassConstant;
import com.oracle.truffle.espresso.classfile.constantpool.ClassMethodRefConstant;
import com.oracle.truffle.espresso.classfile.constantpool.DoubleConstant;
import com.oracle.truffle.espresso.classfile.constantpool.FieldRefConstant;
import com.oracle.truffle.espresso.classfile.constantpool.FloatConstant;
import com.oracle.truffle.espresso.classfile.constantpool.IntegerConstant;
import com.oracle.truffle.espresso.classfile.constantpool.InterfaceMethodRefConstant;
import com.oracle.truffle.espresso.classfile.constantpool.InvokeDynamicConstant;
import com.oracle.truffle.espresso.classfile.constantpool.LongConstant;
import com.oracle.truffle.espresso.classfile.constantpool.MemberRefConstant;
import com.oracle.truffle.espresso.classfile.constantpool.MethodRefConstant;
import com.oracle.truffle.espresso.classfile.constantpool.NameAndTypeConstant;
import com.oracle.truffle.espresso.classfile.constantpool.PoolConstant;
import com.oracle.truffle.espresso.classfile.constantpool.StringConstant;
import com.oracle.truffle.espresso.classfile.constantpool.Utf8Constant;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import java.util.Arrays;
import java.util.Formatter;

public abstract class ConstantPool {
    public static final byte CONSTANT_Utf8 = 1;
    public static final byte CONSTANT_Integer = 3;
    public static final byte CONSTANT_Float = 4;
    public static final byte CONSTANT_Long = 5;
    public static final byte CONSTANT_Double = 6;
    public static final byte CONSTANT_Class = 7;
    public static final byte CONSTANT_String = 8;
    public static final byte CONSTANT_Fieldref = 9;
    public static final byte CONSTANT_Methodref = 10;
    public static final byte CONSTANT_InterfaceMethodref = 11;
    public static final byte CONSTANT_NameAndType = 12;
    public static final byte CONSTANT_MethodHandle = 15;
    public static final byte CONSTANT_MethodType = 16;
    public static final byte CONSTANT_Dynamic = 17;
    public static final byte CONSTANT_InvokeDynamic = 18;
    public static final byte CONSTANT_Module = 19;
    public static final byte CONSTANT_Package = 20;

    public abstract int getMajorVersion();

    public abstract int getMinorVersion();

    public abstract int length();

    public abstract PoolConstant at(int var1, String var2);

    public final PoolConstant at(int index) {
        return this.at(index, null);
    }

    public abstract byte[] getRawBytes();

    @CompilerDirectives.TruffleBoundary
    RuntimeException unexpectedEntry(int index, Tag tag, String description, Tag ... expected) {
        throw this.classFormatError("Constant pool entry" + (String)(description == null ? "" : " for " + description) + " at " + index + " is a " + String.valueOf((Object)tag) + ", expected " + Arrays.toString((Object[])expected));
    }

    @CompilerDirectives.TruffleBoundary
    RuntimeException unexpectedEntry(int index, String description, Tag ... expected) {
        throw this.unexpectedEntry(index, this.tagAt(index), description, expected);
    }

    @CompilerDirectives.TruffleBoundary
    public abstract RuntimeException classFormatError(String var1);

    public final Tag tagAt(int index) {
        return this.at(index).tag();
    }

    public final int intAt(int index) {
        return this.intAt(index, null);
    }

    public final int intAt(int index, String description) {
        try {
            IntegerConstant constant = (IntegerConstant)this.at(index);
            return constant.value();
        }
        catch (ClassCastException e) {
            throw this.unexpectedEntry(index, description, Tag.INTEGER);
        }
    }

    public final long longAt(int index) {
        return this.longAt(index, null);
    }

    public final long longAt(int index, String description) {
        try {
            LongConstant constant = (LongConstant)this.at(index);
            return constant.value();
        }
        catch (ClassCastException e) {
            throw this.unexpectedEntry(index, description, Tag.LONG);
        }
    }

    public final float floatAt(int index) {
        return this.floatAt(index, null);
    }

    public final float floatAt(int index, String description) {
        try {
            FloatConstant constant = (FloatConstant)this.at(index);
            return constant.value();
        }
        catch (ClassCastException e) {
            throw this.unexpectedEntry(index, description, Tag.FLOAT);
        }
    }

    public final double doubleAt(int index) {
        return this.doubleAt(index, null);
    }

    public final double doubleAt(int index, String description) {
        try {
            DoubleConstant constant = (DoubleConstant)this.at(index);
            return constant.value();
        }
        catch (ClassCastException e) {
            throw this.unexpectedEntry(index, description, Tag.DOUBLE);
        }
    }

    public final <T> Symbol<T> symbolAt(int index) {
        return this.symbolAt(index, null);
    }

    public final <T> Symbol<T> symbolAt(int index, String description) {
        try {
            Utf8Constant constant = (Utf8Constant)this.at(index);
            return constant.unsafeSymbolValue();
        }
        catch (ClassCastException e) {
            throw this.unexpectedEntry(index, description, Tag.UTF8);
        }
    }

    public final Utf8Constant utf8At(int index) {
        return this.utf8At(index, null);
    }

    public final Utf8Constant utf8At(int index, String description) {
        try {
            return (Utf8Constant)this.at(index);
        }
        catch (ClassCastException e) {
            throw this.unexpectedEntry(index, description, Tag.UTF8);
        }
    }

    public final Symbol<Symbol.ModifiedUTF8> stringAt(int index) {
        return this.stringAt(index, null);
    }

    public final Symbol<Symbol.ModifiedUTF8> stringAt(int index, String description) {
        try {
            StringConstant constant = (StringConstant)this.at(index);
            return constant.getSymbol(this);
        }
        catch (ClassCastException e) {
            throw this.unexpectedEntry(index, description, Tag.STRING);
        }
    }

    public final NameAndTypeConstant nameAndTypeAt(int index) {
        return this.nameAndTypeAt(index, null);
    }

    public final NameAndTypeConstant nameAndTypeAt(int index, String description) {
        try {
            return (NameAndTypeConstant)this.at(index);
        }
        catch (ClassCastException e) {
            throw this.unexpectedEntry(index, description, Tag.NAME_AND_TYPE);
        }
    }

    public final ClassConstant classAt(int index) {
        return this.classAt(index, null);
    }

    public final ClassConstant classAt(int index, String description) {
        try {
            return (ClassConstant)this.at(index);
        }
        catch (ClassCastException e) {
            throw this.unexpectedEntry(index, description, Tag.CLASS);
        }
    }

    public final MemberRefConstant memberAt(int index) {
        return this.memberAt(index, null);
    }

    public final MemberRefConstant memberAt(int index, String description) {
        try {
            return (MemberRefConstant)this.at(index);
        }
        catch (ClassCastException e) {
            throw this.unexpectedEntry(index, description, Tag.METHOD_REF, Tag.INTERFACE_METHOD_REF, Tag.FIELD_REF);
        }
    }

    public final MethodRefConstant methodAt(int index) {
        try {
            return (MethodRefConstant)this.at(index);
        }
        catch (ClassCastException e) {
            throw this.unexpectedEntry(index, null, Tag.METHOD_REF, Tag.INTERFACE_METHOD_REF);
        }
    }

    public final ClassMethodRefConstant classMethodAt(int index) {
        try {
            return (ClassMethodRefConstant)this.at(index);
        }
        catch (ClassCastException e) {
            throw this.unexpectedEntry(index, null, Tag.METHOD_REF);
        }
    }

    public final InterfaceMethodRefConstant interfaceMethodAt(int index) {
        try {
            return (InterfaceMethodRefConstant)this.at(index);
        }
        catch (ClassCastException e) {
            throw this.unexpectedEntry(index, null, Tag.INTERFACE_METHOD_REF);
        }
    }

    public final FieldRefConstant fieldAt(int index) {
        try {
            return (FieldRefConstant)this.at(index);
        }
        catch (ClassCastException e) {
            throw this.unexpectedEntry(index, null, Tag.FIELD_REF);
        }
    }

    public final StringConstant stringConstantAt(int index) {
        try {
            return (StringConstant)this.at(index);
        }
        catch (ClassCastException e) {
            throw this.unexpectedEntry(index, null, Tag.STRING);
        }
    }

    public final InvokeDynamicConstant indyAt(int index) {
        try {
            return (InvokeDynamicConstant)this.at(index);
        }
        catch (ClassCastException e) {
            throw this.unexpectedEntry(index, null, Tag.INVOKEDYNAMIC);
        }
    }

    public String toString() {
        Formatter buf = new Formatter();
        for (int i = 0; i < this.length(); ++i) {
            PoolConstant c = this.at(i);
            buf.format("#%d = %-15s // %s%n", new Object[]{i, c.tag(), c.toString(this)});
        }
        return buf.toString();
    }

    public static final class Tag
    extends Enum<Tag> {
        public static final /* enum */ Tag INVALID = new Tag(0);
        public static final /* enum */ Tag UTF8 = new Tag(1);
        public static final /* enum */ Tag INTEGER = new Tag(3, true);
        public static final /* enum */ Tag FLOAT = new Tag(4, true);
        public static final /* enum */ Tag LONG = new Tag(5, true);
        public static final /* enum */ Tag DOUBLE = new Tag(6, true);
        public static final /* enum */ Tag CLASS = new Tag(7, true);
        public static final /* enum */ Tag STRING = new Tag(8, true);
        public static final /* enum */ Tag FIELD_REF = new Tag(9);
        public static final /* enum */ Tag METHOD_REF = new Tag(10);
        public static final /* enum */ Tag INTERFACE_METHOD_REF = new Tag(11);
        public static final /* enum */ Tag NAME_AND_TYPE = new Tag(12);
        public static final /* enum */ Tag METHODHANDLE = new Tag(15, true);
        public static final /* enum */ Tag METHODTYPE = new Tag(16, true);
        public static final /* enum */ Tag DYNAMIC = new Tag(17, true);
        public static final /* enum */ Tag INVOKEDYNAMIC = new Tag(18);
        public static final /* enum */ Tag MODULE = new Tag(19);
        public static final /* enum */ Tag PACKAGE = new Tag(20);
        private final byte value;
        private final boolean loadable;
        private static final /* synthetic */ Tag[] $VALUES;

        public static Tag[] values() {
            return (Tag[])$VALUES.clone();
        }

        public static Tag valueOf(String name) {
            return Enum.valueOf(Tag.class, name);
        }

        private Tag(int value) {
            this(value, false);
        }

        private Tag(int value, boolean isLoadable) {
            assert ((byte)value == value);
            this.value = (byte)value;
            this.loadable = isLoadable;
        }

        public final int getValue() {
            return this.value;
        }

        public final boolean isLoadable() {
            return this.loadable;
        }

        public static Tag fromValue(int value) {
            switch (value) {
                case 1: {
                    return UTF8;
                }
                case 3: {
                    return INTEGER;
                }
                case 4: {
                    return FLOAT;
                }
                case 5: {
                    return LONG;
                }
                case 6: {
                    return DOUBLE;
                }
                case 7: {
                    return CLASS;
                }
                case 8: {
                    return STRING;
                }
                case 9: {
                    return FIELD_REF;
                }
                case 10: {
                    return METHOD_REF;
                }
                case 11: {
                    return INTERFACE_METHOD_REF;
                }
                case 12: {
                    return NAME_AND_TYPE;
                }
                case 15: {
                    return METHODHANDLE;
                }
                case 16: {
                    return METHODTYPE;
                }
                case 17: {
                    return DYNAMIC;
                }
                case 18: {
                    return INVOKEDYNAMIC;
                }
                case 19: {
                    return MODULE;
                }
                case 20: {
                    return PACKAGE;
                }
            }
            return null;
        }

        public boolean isValidForVersion(int major) {
            return switch (this.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> true;
                case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> {
                    if (major >= 45) {
                        yield true;
                    }
                    yield false;
                }
                case 12, 13, 15 -> {
                    if (major >= 51) {
                        yield true;
                    }
                    yield false;
                }
                case 14 -> {
                    if (major >= 55) {
                        yield true;
                    }
                    yield false;
                }
                case 16, 17 -> major >= 53;
            };
        }

        private static /* synthetic */ Tag[] $values() {
            return new Tag[]{INVALID, UTF8, INTEGER, FLOAT, LONG, DOUBLE, CLASS, STRING, FIELD_REF, METHOD_REF, INTERFACE_METHOD_REF, NAME_AND_TYPE, METHODHANDLE, METHODTYPE, DYNAMIC, INVOKEDYNAMIC, MODULE, PACKAGE};
        }

        static {
            $VALUES = Tag.$values();
        }
    }
}

