/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.classfile.JavaKind;
import com.oracle.truffle.espresso.classfile.attributes.Attribute;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.classfile.descriptors.Types;
import java.lang.reflect.Modifier;

public final class ParserField {
    public static final ParserField[] EMPTY_ARRAY = new ParserField[0];
    private final int flags;
    private final Symbol<Symbol.Name> name;
    private final Symbol<Symbol.Type> type;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final Attribute[] attributes;

    public ParserField withFlags(int newFlags) {
        return new ParserField(this.flags | newFlags, this.name, this.type, this.attributes);
    }

    public int getFlags() {
        return this.flags;
    }

    public Symbol<Symbol.Name> getName() {
        return this.name;
    }

    public Symbol<Symbol.Type> getType() {
        return this.type;
    }

    public Attribute[] getAttributes() {
        return this.attributes;
    }

    public ParserField(int flags, Symbol<Symbol.Name> name, Symbol<Symbol.Type> type, Attribute[] attributes) {
        this.flags = flags;
        this.name = name;
        this.type = type;
        this.attributes = attributes;
    }

    public boolean isHidden() {
        return (this.flags & 0x100000) != 0;
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.flags);
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.flags);
    }

    public JavaKind getKind() {
        return Types.getJavaKind(this.type);
    }
}

