/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.classfile.ImmutableConstantPool;
import com.oracle.truffle.espresso.classfile.ParserField;
import com.oracle.truffle.espresso.classfile.ParserMethod;
import com.oracle.truffle.espresso.classfile.attributes.Attribute;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;

public final class ParserKlass {
    private final Symbol<Symbol.Name> name;
    private final Symbol<Symbol.Type> type;
    private final Symbol<Symbol.Type> superKlass;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final Symbol<Symbol.Type>[] superInterfaces;
    private final int flags;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final ParserMethod[] methods;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final ParserField[] fields;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final Attribute[] attributes;
    private final ImmutableConstantPool pool;
    private final int thisKlassIndex;
    private final long hiddenKlassId;

    public ParserKlass(ImmutableConstantPool pool, int flags, Symbol<Symbol.Name> name, Symbol<Symbol.Type> type, Symbol<Symbol.Type> superKlass, Symbol<Symbol.Type>[] superInterfaces, ParserMethod[] methods, ParserField[] fields, Attribute[] attributes, int thisKlassIndex, long hiddenKlassId) {
        this.pool = pool;
        this.flags = flags;
        this.name = name;
        this.type = type;
        this.superKlass = superKlass;
        this.superInterfaces = superInterfaces;
        this.methods = methods;
        this.fields = fields;
        this.attributes = attributes;
        this.thisKlassIndex = thisKlassIndex;
        this.hiddenKlassId = hiddenKlassId;
    }

    public int getFlags() {
        return this.flags;
    }

    public Symbol<Symbol.Name> getName() {
        return this.name;
    }

    public Symbol<Symbol.Type> getType() {
        return this.type;
    }

    public Symbol<Symbol.Type> getSuperKlass() {
        return this.superKlass;
    }

    public Symbol<Symbol.Type>[] getSuperInterfaces() {
        return this.superInterfaces;
    }

    public ImmutableConstantPool getConstantPool() {
        return this.pool;
    }

    public ParserMethod[] getMethods() {
        return this.methods;
    }

    public ParserField[] getFields() {
        return this.fields;
    }

    public Attribute getAttribute(Symbol<Symbol.Name> attributeName) {
        for (Attribute attribute : this.attributes) {
            if (!attributeName.equals(attribute.getName())) continue;
            return attribute;
        }
        return null;
    }

    public int getThisKlassIndex() {
        return this.thisKlassIndex;
    }

    public long getHiddenKlassId() {
        return this.hiddenKlassId;
    }

    public String toString() {
        return "ParserKlass<" + String.valueOf(this.getType()) + ">";
    }
}

