/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile.attributes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.classfile.attributes.Attribute;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;

public final class BootstrapMethodsAttribute
extends Attribute {
    public static final Symbol<Symbol.Name> NAME = Symbol.Name.BootstrapMethods;
    private final Entry[] entries;

    public Entry[] getEntries() {
        return this.entries;
    }

    public BootstrapMethodsAttribute(Symbol<Symbol.Name> name, Entry[] entries) {
        super(name, null);
        this.entries = entries;
    }

    public Entry at(int index) {
        return this.entries[index];
    }

    public static final class Entry {
        final char bootstrapMethodRef;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        final char[] bootstrapArguments;

        public int numBootstrapArguments() {
            return this.bootstrapArguments.length;
        }

        public Entry(char bootstrapMethodRef, char[] bootstrapArguments) {
            this.bootstrapMethodRef = bootstrapMethodRef;
            this.bootstrapArguments = bootstrapArguments;
        }

        public char argAt(int index) {
            return this.bootstrapArguments[index];
        }

        public char getBootstrapMethodRef() {
            return this.bootstrapMethodRef;
        }
    }
}

