/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile.attributes;

import com.oracle.truffle.espresso.classfile.attributes.Attribute;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;

public final class ConstantValueAttribute
extends Attribute {
    public static final Symbol<Symbol.Name> NAME = Symbol.Name.ConstantValue;
    private final int constantValueIndex;

    public ConstantValueAttribute(int constantValueIndex) {
        super(NAME, null);
        this.constantValueIndex = constantValueIndex;
    }

    public int getConstantValueIndex() {
        return this.constantValueIndex;
    }

    @Override
    public boolean sameAs(Attribute other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        if (!super.sameAs(other)) {
            return false;
        }
        ConstantValueAttribute that = (ConstantValueAttribute)other;
        return this.constantValueIndex == that.constantValueIndex;
    }
}

