/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile.attributes;

import com.oracle.truffle.espresso.classfile.JavaKind;
import com.oracle.truffle.espresso.classfile.attributes.LocalRef;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.classfile.descriptors.Types;
import java.util.Objects;
import org.graalvm.collections.Equivalence;

public final class Local
implements LocalRef {
    public static final Equivalence localEquivalence = new Equivalence(){

        public boolean equals(Object a, Object b) {
            if (a instanceof Local && b instanceof Local) {
                return ((Local)a).sameLocal((Local)b);
            }
            return false;
        }

        public int hashCode(Object o) {
            if (o instanceof Local) {
                return ((Local)o).sameLocalHash();
            }
            return o.hashCode();
        }
    };
    public static final Local[] EMPTY_ARRAY = new Local[0];
    private final Symbol<Symbol.Name> name;
    private final Symbol<Symbol.Type> type;
    private final Symbol<?> typeSignature;
    private final int startBci;
    private final int endBci;
    private final int slot;

    public Local(Symbol<Symbol.Name> name, Symbol<Symbol.Type> type, Symbol<?> typeSignature, int startBci, int endBci, int slot) {
        assert (type != null || typeSignature != null);
        this.name = name;
        this.startBci = startBci;
        this.endBci = endBci;
        this.slot = slot;
        this.type = type;
        this.typeSignature = typeSignature;
    }

    @Override
    public int getStartBCI() {
        return this.startBci;
    }

    @Override
    public int getEndBCI() {
        return this.endBci;
    }

    public Symbol<Symbol.Name> getName() {
        return this.name;
    }

    public Symbol<Symbol.Type> getType() {
        return this.type;
    }

    public JavaKind getJavaKind() {
        return this.type == null ? JavaKind.Object : Types.getJavaKind(this.type);
    }

    @Override
    public int getSlot() {
        return this.slot;
    }

    public boolean sameLocal(Local other) {
        return this.startBci == other.startBci && this.endBci == other.endBci && this.slot == other.slot && this.name.equals(other.name);
    }

    public int sameLocalHash() {
        return Objects.hash(this.startBci, this.endBci, this.slot, this.name);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Local)) {
            return false;
        }
        Local that = (Local)obj;
        return this.name.equals(that.name) && this.startBci == that.startBci && this.endBci == that.endBci && this.slot == that.slot && this.type.equals(that.type);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.startBci, this.endBci, this.slot);
    }

    public String toString() {
        return "LocalImpl<name=" + String.valueOf(this.name) + ", type=" + String.valueOf(this.type) + ", startBci=" + this.startBci + ", endBci=" + this.endBci + ", slot=" + this.slot + ">";
    }

    @Override
    public String getNameAsString() {
        return this.name.toString();
    }

    @Override
    public String getTypeAsString() {
        if (this.type == null) {
            return this.typeSignature.toString();
        }
        return this.type.toString();
    }
}

