/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile.attributes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.classfile.attributes.Attribute;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;

public class RecordAttribute
extends Attribute {
    public static final Symbol<Symbol.Name> NAME = Symbol.Name.Record;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final RecordComponentInfo[] components;

    public RecordAttribute(Symbol<Symbol.Name> name, RecordComponentInfo[] components) {
        super(name, null);
        this.components = components;
    }

    public RecordComponentInfo[] getComponents() {
        return this.components;
    }

    public static class RecordComponentInfo {
        final char name;
        final char descriptor;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        final Attribute[] attributes;

        public char getNameIndex() {
            return this.name;
        }

        public char getDescriptorIndex() {
            return this.descriptor;
        }

        public RecordComponentInfo(int name, int descriptor, Attribute[] attributes) {
            this.name = (char)name;
            this.descriptor = (char)descriptor;
            this.attributes = attributes;
        }

        public Attribute getAttribute(Symbol<Symbol.Name> attributeName) {
            for (Attribute attr : this.attributes) {
                if (!attr.getName().equals(attributeName)) continue;
                return attr;
            }
            return null;
        }
    }
}

