/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile.bytecode;

import com.oracle.truffle.espresso.classfile.bytecode.BytecodeLookupSwitch;
import com.oracle.truffle.espresso.classfile.bytecode.BytecodeStream;
import com.oracle.truffle.espresso.classfile.bytecode.BytecodeTableSwitch;
import com.oracle.truffle.espresso.classfile.bytecode.Bytecodes;

public abstract class BytecodeSwitch {
    public static int getAlignedBci(int bci) {
        return bci + 4 & 0xFFFFFFFC;
    }

    public static BytecodeSwitch get(int opcode) {
        if (opcode == 170) {
            return BytecodeTableSwitch.INSTANCE;
        }
        if (opcode == 171) {
            return BytecodeLookupSwitch.INSTANCE;
        }
        throw new IllegalArgumentException("Invalid switch bytecode: " + Bytecodes.nameOf(opcode));
    }

    public int targetAt(BytecodeStream stream, int bci, int i) {
        assert (stream.opcode(bci) == this.getSwitchBytecode());
        return bci + this.offsetAt(stream, bci, i);
    }

    public int defaultTarget(BytecodeStream stream, int bci) {
        assert (stream.opcode(bci) == this.getSwitchBytecode());
        return bci + this.defaultOffset(stream, bci);
    }

    public int defaultOffset(BytecodeStream stream, int bci) {
        assert (stream.opcode(bci) == this.getSwitchBytecode());
        return stream.readInt(BytecodeSwitch.getAlignedBci(bci));
    }

    public abstract int keyAt(BytecodeStream var1, int var2, int var3);

    public abstract int offsetAt(BytecodeStream var1, int var2, int var3);

    public abstract int numberOfCases(BytecodeStream var1, int var2);

    public abstract int size(BytecodeStream var1, int var2);

    protected abstract int getSwitchBytecode();
}

