/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile.bytecode;

import com.oracle.truffle.espresso.classfile.bytecode.BytecodeStream;
import com.oracle.truffle.espresso.classfile.bytecode.BytecodeSwitch;

public final class BytecodeTableSwitch
extends BytecodeSwitch {
    private static final int OFFSET_TO_LOW_KEY = 4;
    private static final int OFFSET_TO_HIGH_KEY = 8;
    private static final int OFFSET_TO_FIRST_JUMP_OFFSET = 12;
    private static final int JUMP_OFFSET_SIZE = 4;
    public static final BytecodeTableSwitch INSTANCE = new BytecodeTableSwitch();

    private BytecodeTableSwitch() {
    }

    public int lowKey(BytecodeStream stream, int bci) {
        assert (stream.opcode(bci) == this.getSwitchBytecode());
        return stream.readInt(BytecodeTableSwitch.getAlignedBci(bci) + 4);
    }

    public int highKey(BytecodeStream stream, int bci) {
        assert (stream.opcode(bci) == this.getSwitchBytecode());
        return stream.readInt(BytecodeTableSwitch.getAlignedBci(bci) + 8);
    }

    @Override
    public int keyAt(BytecodeStream stream, int bci, int i) {
        assert (stream.opcode(bci) == this.getSwitchBytecode());
        return this.lowKey(stream, bci) + i;
    }

    @Override
    public int offsetAt(BytecodeStream stream, int bci, int i) {
        assert (stream.opcode(bci) == this.getSwitchBytecode());
        return stream.readInt(BytecodeTableSwitch.getAlignedBci(bci) + 12 + 4 * i);
    }

    @Override
    public int numberOfCases(BytecodeStream stream, int bci) {
        assert (stream.opcode(bci) == this.getSwitchBytecode());
        return this.highKey(stream, bci) - this.lowKey(stream, bci) + 1;
    }

    @Override
    public int size(BytecodeStream stream, int bci) {
        assert (stream.opcode(bci) == this.getSwitchBytecode());
        return BytecodeTableSwitch.getAlignedBci(bci) + 12 + 4 * this.numberOfCases(stream, bci) - bci;
    }

    @Override
    protected int getSwitchBytecode() {
        return 170;
    }
}

