/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile.bytecode;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;

public class VolatileArrayAccess {
    private static final VarHandle REF_ARRAY_HANDLE = MethodHandles.arrayElementVarHandle(Object[].class);
    private static final VarHandle BYTE_ARRAY_HANDLE = MethodHandles.arrayElementVarHandle(byte[].class);
    private static final VarHandle INT_ARRAY_HANDLE = MethodHandles.arrayElementVarHandle(int[].class);

    public static void volatileWrite(byte[] array, int index, byte value) {
        BYTE_ARRAY_HANDLE.setVolatile(array, index, value);
    }

    public static byte volatileRead(byte[] array, int index) {
        return BYTE_ARRAY_HANDLE.getVolatile(array, index);
    }

    public static void volatileWrite(int[] array, int index, int value) {
        INT_ARRAY_HANDLE.setVolatile(array, index, value);
    }

    public static int volatileRead(int[] array, int index) {
        return INT_ARRAY_HANDLE.getVolatile(array, index);
    }

    public static <T> void volatileWrite(T[] array, int index, T value) {
        REF_ARRAY_HANDLE.setVolatile(array, index, value);
    }

    public static <T> T volatileRead(T[] array, int index) {
        return (T)REF_ARRAY_HANDLE.getVolatile(array, index);
    }

    public static <T> boolean compareAndSet(T[] array, int index, T expected, T value) {
        return REF_ARRAY_HANDLE.compareAndSet(array, index, expected, value);
    }
}

