/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile.constantpool;

import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.classfile.constantpool.PoolConstant;
import com.oracle.truffle.espresso.classfile.constantpool.Resolvable;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.classfile.descriptors.Validation;
import com.oracle.truffle.espresso.classfile.descriptors.ValidationException;
import java.nio.ByteBuffer;

public interface ClassConstant
extends PoolConstant {
    public static ClassConstant create(int classNameIndex) {
        return new Index(classNameIndex);
    }

    public static ClassConstant withString(Symbol<Symbol.Name> name) {
        return new WithString(name);
    }

    @Override
    default public ConstantPool.Tag tag() {
        return ConstantPool.Tag.CLASS;
    }

    public Symbol<Symbol.Name> getName(ConstantPool var1);

    @Override
    default public String toString(ConstantPool pool) {
        return this.getName(pool).toString();
    }

    public static final class Index
    implements ClassConstant,
    Resolvable {
        private final char classNameIndex;

        Index(int classNameIndex) {
            this.classNameIndex = PoolConstant.u2(classNameIndex);
        }

        @Override
        public Symbol<Symbol.Name> getName(ConstantPool pool) {
            return pool.symbolAt(this.classNameIndex);
        }

        @Override
        public void validate(ConstantPool pool) throws ValidationException {
            pool.utf8At(this.classNameIndex).validateClassName();
        }

        @Override
        public void dump(ByteBuffer buf) {
            buf.putChar(this.classNameIndex);
        }
    }

    public static final class WithString
    implements ClassConstant,
    Resolvable {
        private final Symbol<Symbol.Name> name;

        WithString(Symbol<Symbol.Name> name) {
            this.name = name;
        }

        @Override
        public Symbol<Symbol.Name> getName(ConstantPool pool) {
            return this.name;
        }

        @Override
        public void validate(ConstantPool pool) throws ValidationException {
            if (!Validation.validModifiedUTF8(this.name) || !Validation.validClassNameEntry(this.name)) {
                throw ValidationException.raise("Invalid class name entry: " + String.valueOf(this.name));
            }
        }

        @Override
        public void dump(ByteBuffer buf) {
            buf.putChar('\u0000');
        }
    }
}

