/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile.constantpool;

import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.classfile.constantpool.MethodRefConstant;
import com.oracle.truffle.espresso.classfile.constantpool.Resolvable;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.classfile.descriptors.ValidationException;

public interface ClassMethodRefConstant
extends MethodRefConstant {
    public static ClassMethodRefConstant create(int classIndex, int nameAndTypeIndex) {
        return new Indexes(classIndex, nameAndTypeIndex);
    }

    @Override
    default public ConstantPool.Tag tag() {
        return ConstantPool.Tag.METHOD_REF;
    }

    public static final class Indexes
    extends MethodRefConstant.Indexes
    implements ClassMethodRefConstant,
    Resolvable {
        Indexes(int classIndex, int nameAndTypeIndex) {
            super(classIndex, nameAndTypeIndex);
        }

        @Override
        public void validate(ConstantPool pool) throws ValidationException {
            Symbol<? extends Symbol.Descriptor> descriptor;
            int len;
            super.validate(pool);
            pool.nameAndTypeAt(this.nameAndTypeIndex).validateMethod(pool, false, true);
            Symbol<Symbol.Name> name = pool.nameAndTypeAt(this.nameAndTypeIndex).getName(pool);
            if (Symbol.Name._init_.equals(name) && ((len = (descriptor = pool.nameAndTypeAt(this.nameAndTypeIndex).getDescriptor(pool)).length()) <= 2 || descriptor.byteAt(len - 2) != 41 || descriptor.byteAt(len - 1) != 86)) {
                throw ValidationException.raise("<init> method should have ()V signature");
            }
        }
    }
}

