/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile.constantpool;

import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.classfile.constantpool.BootstrapMethodConstant;
import com.oracle.truffle.espresso.classfile.constantpool.Resolvable;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.classfile.descriptors.Types;
import com.oracle.truffle.espresso.classfile.descriptors.ValidationException;
import java.nio.ByteBuffer;

public interface DynamicConstant
extends BootstrapMethodConstant {
    public static DynamicConstant create(int bootstrapMethodAttrIndex, int nameAndTypeIndex) {
        return new Indexes(bootstrapMethodAttrIndex, nameAndTypeIndex);
    }

    @Override
    default public ConstantPool.Tag tag() {
        return ConstantPool.Tag.DYNAMIC;
    }

    public Symbol<Symbol.Type> getTypeSymbol(ConstantPool var1);

    public static final class Indexes
    extends BootstrapMethodConstant.Indexes
    implements DynamicConstant,
    Resolvable {
        Indexes(int bootstrapMethodAttrIndex, int nameAndTypeIndex) {
            super(bootstrapMethodAttrIndex, nameAndTypeIndex);
        }

        @Override
        public Symbol<Symbol.Type> getTypeSymbol(ConstantPool pool) {
            return Types.fromSymbol(pool.nameAndTypeAt(this.nameAndTypeIndex).getDescriptor(pool));
        }

        @Override
        public void validate(ConstantPool pool) throws ValidationException {
            pool.nameAndTypeAt(this.nameAndTypeIndex).validateField(pool);
        }

        @Override
        public void dump(ByteBuffer buf) {
            buf.putChar(this.bootstrapMethodAttrIndex);
            buf.putChar(this.nameAndTypeIndex);
        }
    }
}

