/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile.constantpool;

import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.classfile.constantpool.BootstrapMethodConstant;
import com.oracle.truffle.espresso.classfile.constantpool.Resolvable;
import com.oracle.truffle.espresso.classfile.descriptors.Signatures;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.classfile.descriptors.ValidationException;
import java.nio.ByteBuffer;

public interface InvokeDynamicConstant
extends BootstrapMethodConstant {
    public static InvokeDynamicConstant create(int bootstrapMethodAttrIndex, int nameAndTypeIndex) {
        return new Indexes(bootstrapMethodAttrIndex, nameAndTypeIndex);
    }

    @Override
    default public ConstantPool.Tag tag() {
        return ConstantPool.Tag.INVOKEDYNAMIC;
    }

    public Symbol<Symbol.Signature> getSignature(ConstantPool var1);

    default public Symbol<Symbol.Type>[] getParsedSignature() {
        throw new IllegalStateException("Not resolved yet");
    }

    default public boolean isResolved() {
        return false;
    }

    public static final class Indexes
    extends BootstrapMethodConstant.Indexes
    implements InvokeDynamicConstant,
    Resolvable {
        Indexes(int bootstrapMethodAttrIndex, int nameAndTypeIndex) {
            super(bootstrapMethodAttrIndex, nameAndTypeIndex);
        }

        @Override
        public void dump(ByteBuffer buf) {
            buf.putChar(this.bootstrapMethodAttrIndex);
            buf.putChar(this.nameAndTypeIndex);
        }

        @Override
        public void validate(ConstantPool pool) throws ValidationException {
            pool.nameAndTypeAt(this.nameAndTypeIndex).validateMethod(pool, false);
        }

        @Override
        public Symbol<Symbol.Signature> getSignature(ConstantPool pool) {
            return Signatures.check(pool.nameAndTypeAt(this.nameAndTypeIndex).getDescriptor(pool));
        }

        @Override
        public String toString(ConstantPool pool) {
            return "bsmIndex:" + this.getBootstrapMethodAttrIndex() + " " + String.valueOf(this.getSignature(pool));
        }
    }
}

