/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile.constantpool;

import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.classfile.constantpool.PoolConstant;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.classfile.descriptors.ValidationException;
import java.nio.ByteBuffer;

public interface MemberRefConstant
extends PoolConstant {
    public Symbol<Symbol.Name> getHolderKlassName(ConstantPool var1);

    public Symbol<Symbol.Name> getName(ConstantPool var1);

    public Symbol<? extends Symbol.Descriptor> getDescriptor(ConstantPool var1);

    @Override
    default public String toString(ConstantPool pool) {
        return String.valueOf(this.getHolderKlassName(pool)) + "." + String.valueOf(this.getName(pool)) + String.valueOf(this.getDescriptor(pool));
    }

    public static abstract class Indexes
    implements MemberRefConstant {
        final char classIndex;
        final char nameAndTypeIndex;

        Indexes(int classIndex, int nameAndTypeIndex) {
            this.classIndex = PoolConstant.u2(classIndex);
            this.nameAndTypeIndex = PoolConstant.u2(nameAndTypeIndex);
        }

        public char getClassIndex() {
            return this.classIndex;
        }

        @Override
        public Symbol<Symbol.Name> getHolderKlassName(ConstantPool pool) {
            return pool.classAt(this.classIndex).getName(pool);
        }

        @Override
        public Symbol<Symbol.Name> getName(ConstantPool pool) {
            return pool.nameAndTypeAt(this.nameAndTypeIndex).getName(pool);
        }

        @Override
        public Symbol<? extends Symbol.Descriptor> getDescriptor(ConstantPool pool) {
            return pool.nameAndTypeAt(this.nameAndTypeIndex).getDescriptor(pool);
        }

        @Override
        public void validate(ConstantPool pool) throws ValidationException {
            pool.classAt(this.classIndex).validate(pool);
            pool.nameAndTypeAt(this.nameAndTypeIndex).validate(pool);
        }

        @Override
        public void dump(ByteBuffer buf) {
            buf.putChar(this.classIndex);
            buf.putChar(this.nameAndTypeIndex);
        }
    }
}

