/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile.constantpool;

import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.classfile.constantpool.PoolConstant;
import com.oracle.truffle.espresso.classfile.constantpool.Resolvable;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.classfile.descriptors.ValidationException;
import java.nio.ByteBuffer;

public interface MethodHandleConstant
extends PoolConstant {
    public static final int GETFIELD = 1;
    public static final int GETSTATIC = 2;
    public static final int PUTFIELD = 3;
    public static final int PUTSTATIC = 4;
    public static final int INVOKEVIRTUAL = 5;
    public static final int INVOKESTATIC = 6;
    public static final int INVOKESPECIAL = 7;
    public static final int NEWINVOKESPECIAL = 8;
    public static final int INVOKEINTERFACE = 9;

    public static MethodHandleConstant create(int refKind, int refIndex) {
        return new Index(refKind, refIndex);
    }

    @Override
    default public ConstantPool.Tag tag() {
        return ConstantPool.Tag.METHODHANDLE;
    }

    public int getRefKind();

    public char getRefIndex();

    @Override
    default public String toString(ConstantPool pool) {
        return this.getRefKind() + " " + pool.at(this.getRefIndex()).toString(pool);
    }

    public static final class Index
    implements MethodHandleConstant,
    Resolvable {
        private final byte refKind;
        private final char refIndex;

        Index(int refKind, int refIndex) {
            this.refKind = PoolConstant.u1(refKind);
            this.refIndex = PoolConstant.u2(refIndex);
        }

        @Override
        public int getRefKind() {
            return this.refKind;
        }

        @Override
        public char getRefIndex() {
            return this.refIndex;
        }

        @Override
        public void validate(ConstantPool pool) throws ValidationException {
            pool.memberAt(this.refIndex).validate(pool);
            Symbol<Symbol.Name> memberName = pool.memberAt(this.refIndex).getName(pool);
            if (Symbol.Name._clinit_.equals(memberName)) {
                throw ValidationException.raise("Ill-formed constant: " + String.valueOf((Object)this.tag()));
            }
            if (Symbol.Name._init_.equals(memberName) && this.refKind != 8) {
                throw ValidationException.raise("Ill-formed constant: " + String.valueOf((Object)this.tag()));
            }
            if (1 > this.refKind || this.refKind > 9) {
                throw ValidationException.raise("Ill-formed constant: " + String.valueOf((Object)this.tag()));
            }
            if ((memberName.equals(Symbol.Name._init_) || memberName.equals(Symbol.Name._clinit_)) && (this.refKind == 5 || this.refKind == 6 || this.refKind == 7 || this.refKind == 9)) {
                throw ValidationException.raise("Ill-formed constant: " + String.valueOf((Object)this.tag()));
            }
            boolean valid = false;
            ConstantPool.Tag tag = pool.at(this.refIndex).tag();
            switch (this.getRefKind()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    valid = tag == ConstantPool.Tag.FIELD_REF;
                    break;
                }
                case 5: 
                case 8: {
                    valid = tag == ConstantPool.Tag.METHOD_REF;
                    break;
                }
                case 6: 
                case 7: {
                    valid = tag == ConstantPool.Tag.METHOD_REF || pool.getMajorVersion() >= 52 && tag == ConstantPool.Tag.INTERFACE_METHOD_REF;
                    break;
                }
                case 9: {
                    boolean bl = valid = tag == ConstantPool.Tag.INTERFACE_METHOD_REF;
                }
            }
            if (!valid) {
                throw ValidationException.raise("Ill-formed constant: " + String.valueOf((Object)this.tag()));
            }
        }

        @Override
        public void dump(ByteBuffer buf) {
            buf.put(this.refKind);
            buf.putChar(this.refIndex);
        }
    }
}

