/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile.constantpool;

import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.classfile.constantpool.PoolConstant;
import com.oracle.truffle.espresso.classfile.constantpool.Resolvable;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.classfile.descriptors.ValidationException;
import java.nio.ByteBuffer;

public interface MethodTypeConstant
extends PoolConstant {
    public static MethodTypeConstant create(int descriptorIndex) {
        return new Index(descriptorIndex);
    }

    @Override
    default public ConstantPool.Tag tag() {
        return ConstantPool.Tag.METHODTYPE;
    }

    public Symbol<Symbol.Signature> getSignature(ConstantPool var1);

    @Override
    default public String toString(ConstantPool pool) {
        return this.getSignature(pool).toString();
    }

    public static final class Index
    implements MethodTypeConstant,
    Resolvable {
        private final char descriptorIndex;

        Index(int descriptorIndex) {
            this.descriptorIndex = PoolConstant.u2(descriptorIndex);
        }

        @Override
        public Symbol<Symbol.Signature> getSignature(ConstantPool pool) {
            return pool.symbolAt(this.descriptorIndex);
        }

        @Override
        public void validate(ConstantPool pool) throws ValidationException {
            pool.utf8At(this.descriptorIndex).validateSignature();
        }

        @Override
        public void dump(ByteBuffer buf) {
            buf.putChar(this.descriptorIndex);
        }
    }
}

