/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile.constantpool;

import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.classfile.constantpool.PoolConstant;
import com.oracle.truffle.espresso.classfile.constantpool.Resolvable;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.classfile.descriptors.ValidationException;
import java.nio.ByteBuffer;

public interface StringConstant
extends PoolConstant {
    public static StringConstant create(int utf8Index) {
        return new Index(utf8Index);
    }

    @Override
    default public ConstantPool.Tag tag() {
        return ConstantPool.Tag.STRING;
    }

    @Override
    default public String toString(ConstantPool pool) {
        return this.getSymbol(pool).toString();
    }

    public Symbol<Symbol.ModifiedUTF8> getSymbol(ConstantPool var1);

    public static final class Index
    implements StringConstant,
    Resolvable {
        private final char utf8Index;

        @Override
        public Symbol<Symbol.ModifiedUTF8> getSymbol(ConstantPool pool) {
            return pool.symbolAt(this.utf8Index);
        }

        Index(int utf8Index) {
            this.utf8Index = PoolConstant.u2(utf8Index);
        }

        @Override
        public void validate(ConstantPool pool) throws ValidationException {
            pool.utf8At(this.utf8Index).validateUTF8();
        }

        @Override
        public void dump(ByteBuffer buf) {
            buf.putChar(this.utf8Index);
        }
    }
}

