/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile.constantpool;

import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.classfile.constantpool.PoolConstant;
import com.oracle.truffle.espresso.classfile.descriptors.ModifiedUtf8;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.classfile.descriptors.Validation;
import com.oracle.truffle.espresso.classfile.descriptors.ValidationException;
import java.nio.ByteBuffer;

public final class Utf8Constant
implements PoolConstant {
    private static final short VALID_CLASS_NAME = 1;
    private static final short VALID_METHOD_NAME = 2;
    private static final short VALID_METHOD_NAME_OR_CLINIT = 4;
    private static final short VALID_FIELD_NAME = 8;
    private static final short VALID_SIGNATURE = 16;
    private static final short VALID_UTF8 = 32;
    private static final short VALID_TYPE = 64;
    private static final short VALID_INIT_SIGNATURE = 128;
    private static final short VALID_TYPE_NO_VOID = 256;
    private short validationCache;
    private final Symbol<?> value;

    @Override
    public ConstantPool.Tag tag() {
        return ConstantPool.Tag.UTF8;
    }

    public Utf8Constant(Symbol<?> value) {
        this.value = value;
    }

    public <T> Symbol<T> unsafeSymbolValue() {
        return this.value;
    }

    @Override
    public void validate(ConstantPool pool) throws ValidationException {
        this.validateUTF8();
    }

    public Symbol<? extends ModifiedUtf8> validateUTF8() throws ValidationException {
        if ((this.validationCache & 0x20) == 0) {
            if (!Validation.validModifiedUTF8(this.unsafeSymbolValue())) {
                throw ValidationException.raise("Ill-formed modified-UTF8 entry");
            }
            this.validationCache = (short)(this.validationCache | 0x20);
        }
        return this.unsafeSymbolValue();
    }

    public Symbol<Symbol.Name> validateClassName() throws ValidationException {
        this.validateUTF8();
        if ((this.validationCache & 1) == 0) {
            if (!Validation.validClassNameEntry(this.value)) {
                throw ValidationException.raise("Invalid class name entry: " + String.valueOf(this.value));
            }
            this.validationCache = (short)(this.validationCache | 1);
        }
        return this.unsafeSymbolValue();
    }

    public Symbol<Symbol.Type> validateType(boolean allowVoid) throws ValidationException {
        int mask;
        this.validateUTF8();
        int n = mask = allowVoid ? 64 : 256;
        if ((this.validationCache & mask) == 0) {
            if (!Validation.validTypeDescriptor(this.value, allowVoid)) {
                throw ValidationException.raise("Invalid type descriptor: " + String.valueOf(this.value));
            }
            this.validationCache = (short)(this.validationCache | mask);
        }
        return this.unsafeSymbolValue();
    }

    public Symbol<Symbol.Name> validateMethodName(boolean allowClinit) throws ValidationException {
        int mask;
        this.validateUTF8();
        int n = mask = allowClinit ? 4 : 2;
        if ((this.validationCache & mask) == 0) {
            if (!Validation.validMethodName(this.value, allowClinit)) {
                throw ValidationException.raise("Invalid method name: " + String.valueOf(this.value));
            }
            this.validationCache = (short)(this.validationCache | mask);
        }
        return this.unsafeSymbolValue();
    }

    public Symbol<Symbol.Name> validateFieldName() throws ValidationException {
        this.validateUTF8();
        if ((this.validationCache & 8) == 0) {
            if (!Validation.validUnqualifiedName(this.value)) {
                throw ValidationException.raise("Invalid field name: " + String.valueOf(this.value));
            }
            this.validationCache = (short)(this.validationCache | 8);
        }
        return this.unsafeSymbolValue();
    }

    public void validateSignature() throws ValidationException {
        this.validateSignature(false);
    }

    public Symbol<Symbol.Signature> validateSignature(boolean isInitOrClinit) throws ValidationException {
        this.validateUTF8();
        int mask = isInitOrClinit ? 128 : 16;
        if ((this.validationCache & mask) == 0) {
            if (!Validation.validSignatureDescriptor(this.value, isInitOrClinit)) {
                throw ValidationException.raise("Invalid signature descriptor: " + String.valueOf(this.value));
            }
            this.validationCache = (short)(this.validationCache | (short)(mask | 0x10));
        }
        return this.unsafeSymbolValue();
    }

    public int validateSignatureGetSlots(boolean isInitOrClinit) throws ValidationException {
        this.validateUTF8();
        int mask = isInitOrClinit ? 128 : 16;
        int slots = Validation.validSignatureDescriptorGetSlots(this.value, isInitOrClinit);
        if (slots < 0) {
            throw ValidationException.raise("Invalid signature descriptor: " + String.valueOf(this.value));
        }
        this.validationCache = (short)(this.validationCache | (short)(mask | 0x10));
        return slots;
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    public String toString(ConstantPool pool) {
        return this.value.toString();
    }

    @Override
    public void dump(ByteBuffer buf) {
        buf.putChar((char)this.value.length());
        for (int i = 0; i < this.value.length(); ++i) {
            buf.put(this.value.byteAt(i));
        }
    }
}

