/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile.descriptors;

import com.oracle.truffle.espresso.classfile.descriptors.ByteSequence;
import com.oracle.truffle.espresso.classfile.descriptors.ErrorUtil;
import com.oracle.truffle.espresso.classfile.descriptors.Signatures;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.classfile.descriptors.Symbols;
import com.oracle.truffle.espresso.classfile.descriptors.Types;

public final class StaticSymbols {
    private static boolean frozen = false;
    private static final Symbols symbols = new Symbols();

    private StaticSymbols() {
    }

    public static Symbol<Symbol.Name> putName(String name) {
        ErrorUtil.guarantee(!StaticSymbols.isFrozen(), "static symbols are frozen");
        ErrorUtil.guarantee(!name.isEmpty(), "empty name");
        return symbols.symbolify(ByteSequence.create(name));
    }

    public static Symbol<Symbol.Type> putType(String internalName) {
        ErrorUtil.guarantee(!StaticSymbols.isFrozen(), "static symbols are frozen");
        return symbols.symbolify(ByteSequence.create(Types.checkType(internalName)));
    }

    @SafeVarargs
    public static Symbol<Symbol.Signature> putSignature(Symbol<Symbol.Type> returnType, Symbol<Symbol.Type> ... parameterTypes) {
        ErrorUtil.guarantee(!StaticSymbols.isFrozen(), "static symbols are frozen");
        return symbols.symbolify(ByteSequence.wrap(Signatures.buildSignatureBytes(returnType, parameterTypes)));
    }

    public static boolean isFrozen() {
        return frozen;
    }

    public static Symbols freeze() {
        frozen = true;
        return symbols;
    }
}

