/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile.descriptors;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.classfile.JavaKind;
import com.oracle.truffle.espresso.classfile.ParserException;
import com.oracle.truffle.espresso.classfile.descriptors.ByteSequence;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.classfile.descriptors.Symbols;
import com.oracle.truffle.espresso.classfile.descriptors.Validation;
import java.util.Arrays;

public final class Types {
    private final Symbols symbols;

    public Types(Symbols symbols) {
        this.symbols = symbols;
    }

    public static Symbol<Symbol.Type> fromDescriptor(Symbol<? extends Symbol.Descriptor> descriptor) {
        Symbol<? extends Symbol.Descriptor> type = descriptor;
        if (!Types.isValid(type)) {
            return null;
        }
        return type;
    }

    public Symbol<Symbol.Type> getOrCreate(String name) {
        return this.getOrCreate(ByteSequence.create(name));
    }

    public Symbol<Symbol.Type> getOrCreate(ByteSequence name) {
        if (!Validation.validTypeDescriptor(name, true)) {
            return null;
        }
        return this.symbols.symbolify(name);
    }

    public static String internalFromClassName(String className) {
        if (className.startsWith("[") || className.endsWith(";")) {
            return className.replace('.', '/');
        }
        switch (className) {
            case "boolean": {
                return "" + JavaKind.Boolean.getTypeChar();
            }
            case "byte": {
                return "" + JavaKind.Byte.getTypeChar();
            }
            case "char": {
                return "" + JavaKind.Char.getTypeChar();
            }
            case "short": {
                return "" + JavaKind.Short.getTypeChar();
            }
            case "int": {
                return "" + JavaKind.Int.getTypeChar();
            }
            case "float": {
                return "" + JavaKind.Float.getTypeChar();
            }
            case "double": {
                return "" + JavaKind.Double.getTypeChar();
            }
            case "long": {
                return "" + JavaKind.Long.getTypeChar();
            }
            case "void": {
                return "" + JavaKind.Void.getTypeChar();
            }
        }
        return "L" + className.replace('.', '/') + ";";
    }

    public static ByteSequence hiddenClassName(Symbol<Symbol.Type> type, long id) {
        assert (type.byteAt(0) == 76);
        assert (type.byteAt(type.length() - 1) == 59);
        int idSize = ByteSequence.positiveLongStringSize(id);
        int length = type.length() - 2 + 1 + idSize;
        byte[] newBytes = new byte[length];
        ByteSequence name = type.substring(1, type.length() - 1);
        name.writeTo(newBytes, 0);
        int sepIndex = name.length();
        newBytes[sepIndex] = 43;
        ByteSequence.writePositiveLongString(id, newBytes, sepIndex + 1, idSize);
        ByteSequence result = ByteSequence.wrap(newBytes, 0, length);
        assert (Validation.validModifiedUTF8(result)) : String.format("Not valid anymore: %s + %d -> %s", type.toHexString(), id, result.toHexString());
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    public Symbol<Symbol.Type> fromClassGetName(String className) {
        return this.symbols.symbolify(ByteSequence.create(Types.checkType(Types.internalFromClassName(className))));
    }

    public static Symbol<Symbol.Type> forPrimitive(JavaKind kind) {
        assert (kind.isPrimitive());
        return kind.getType();
    }

    Symbol<Symbol.Type> parse(Symbol<? extends Symbol.Descriptor> descriptor, int beginIndex, boolean slashes) throws ParserException.ClassFormatError {
        int endIndex = Types.skipValidTypeDescriptor(descriptor, beginIndex, slashes);
        if (endIndex == beginIndex + 1) {
            try {
                return Types.forPrimitive(JavaKind.fromPrimitiveOrVoidTypeChar((char)descriptor.byteAt(beginIndex)));
            }
            catch (IllegalArgumentException e) {
                throw new ParserException.ClassFormatError("invalid descriptor: " + String.valueOf(descriptor));
            }
        }
        return this.symbols.symbolify(descriptor.substring(beginIndex, endIndex));
    }

    @CompilerDirectives.TruffleBoundary
    static int skipValidTypeDescriptor(Symbol<? extends Symbol.Descriptor> descriptor, int beginIndex, boolean slashes) throws ParserException.ClassFormatError {
        if (beginIndex >= descriptor.length()) {
            throw new ParserException.ClassFormatError("invalid type descriptor: " + String.valueOf(descriptor));
        }
        char ch = (char)descriptor.byteAt(beginIndex);
        if (ch != '[' && ch != 'L') {
            return beginIndex + 1;
        }
        switch (ch) {
            case 'L': {
                int endIndex = Types.skipClassName(descriptor, beginIndex + 1, slashes ? (char)'/' : '.');
                if (endIndex > beginIndex + 1 && endIndex < descriptor.length() && descriptor.byteAt(endIndex) == 59) {
                    return endIndex + 1;
                }
                throw new ParserException.ClassFormatError("Invalid Java name " + String.valueOf(descriptor.substring(beginIndex)));
            }
            case '[': {
                int index;
                for (index = beginIndex; index < descriptor.length() && descriptor.byteAt(index) == 91; ++index) {
                }
                int dimensions = index - beginIndex;
                if (dimensions > 255) {
                    throw new ParserException.ClassFormatError("Array with more than 255 dimensions " + String.valueOf(descriptor.substring(beginIndex)));
                }
                return Types.skipValidTypeDescriptor(descriptor, index, slashes);
            }
        }
        throw new ParserException.ClassFormatError("Invalid type descriptor " + String.valueOf(descriptor.substring(beginIndex)));
    }

    public Symbol<Symbol.Type> arrayOf(Symbol<Symbol.Type> type, int dimensions) {
        assert (dimensions > 0);
        if (Types.getArrayDimensions(type) + dimensions > 255) {
            throw new ParserException.ClassFormatError("Array type with more than 255 dimensions");
        }
        byte[] bytes = new byte[type.length() + dimensions];
        Arrays.fill(bytes, 0, dimensions, (byte)91);
        type.writeTo(bytes, dimensions);
        return this.symbols.symbolify(ByteSequence.wrap(bytes));
    }

    public Symbol<Symbol.Type> arrayOf(Symbol<Symbol.Type> type) {
        return this.arrayOf(type, 1);
    }

    private static int skipClassName(Symbol<? extends Symbol.Descriptor> descriptor, int from, char separator) throws ParserException.ClassFormatError {
        int index;
        assert (separator == '.' || separator == '/');
        int length = descriptor.length();
        for (index = from; index < length; ++index) {
            char ch = (char)descriptor.byteAt(index);
            if (!(ch == '.' || ch == '/' ? separator != ch : ch == ';' || ch == '[')) continue;
            return index;
        }
        return index;
    }

    public static boolean isReference(ByteSequence type) {
        return type.length() > 1;
    }

    public static boolean isPrimitive(ByteSequence type) {
        if (type.length() != 1) {
            return false;
        }
        switch (type.byteAt(0)) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 86: 
            case 90: {
                return true;
            }
        }
        return false;
    }

    public static JavaKind getJavaKind(Symbol<Symbol.Type> type) {
        if (type.length() == 1) {
            return JavaKind.fromPrimitiveOrVoidTypeChar((char)type.byteAt(0));
        }
        return JavaKind.Object;
    }

    public static int getArrayDimensions(ByteSequence type) {
        int dims;
        for (dims = 0; dims < type.length() && type.byteAt(dims) == 91; ++dims) {
        }
        return dims;
    }

    private static boolean isValid(Symbol<Symbol.Type> type) {
        int endIndex;
        int beginIndex;
        if (type.length() == 0) {
            return false;
        }
        if (type.length() == 1) {
            return Types.isPrimitive(type);
        }
        char first = (char)type.byteAt(0);
        if (first == '[') {
            for (beginIndex = 0; beginIndex < type.length() && type.byteAt(beginIndex) == 91; ++beginIndex) {
            }
        } else if (first == 'L') {
            beginIndex = 0;
        } else {
            return false;
        }
        return (endIndex = Types.skipValidTypeDescriptor(type, beginIndex, true)) == type.length();
    }

    public static boolean isArray(Symbol<Symbol.Type> type) {
        assert (type.length() > 0) : "empty symbol";
        return type.length() > 0 && type.byteAt(0) == 91;
    }

    public Symbol<Symbol.Type> getComponentType(Symbol<Symbol.Type> type) {
        if (Types.isArray(type)) {
            return this.symbols.symbolify(type.substring(1));
        }
        return null;
    }

    public Symbol<Symbol.Type> getElementalType(Symbol<Symbol.Type> type) {
        if (Types.isArray(type)) {
            return this.symbols.symbolify(type.substring(Types.getArrayDimensions(type)));
        }
        return type;
    }

    public Symbol<Symbol.Type> fromClass(Class<?> clazz) {
        ByteSequence descriptor = ByteSequence.create(Types.internalFromClassName(clazz.getName()));
        assert (Validation.validTypeDescriptor(descriptor, true));
        return this.symbols.symbolify(descriptor);
    }

    static ByteSequence checkType(ByteSequence sequence) {
        return Validation.validTypeDescriptor(sequence, true) ? sequence : null;
    }

    public static String checkType(String type) {
        if (type.length() <= 0) {
            throw new IllegalStateException(type);
        }
        return type;
    }

    public static String binaryName(Symbol<Symbol.Type> type) {
        if (Types.isArray(type)) {
            return type.toString().replace('/', '.');
        }
        if (Types.isPrimitive(type)) {
            return Types.getJavaKind(type).getJavaName();
        }
        return type.substring(1, type.length() - 1).toString().replace('/', '.');
    }

    public static Symbol<Symbol.Type> fromSymbol(Symbol<?> symbol) {
        Symbol<Symbol.Type> type = symbol;
        assert (Types.isValid(type)) : "Type validity should have been checked beforehand";
        return type;
    }

    public Symbol<Symbol.Type> fromName(Symbol<Symbol.Name> name) {
        if (name.byteAt(0) == 91) {
            return Types.fromSymbol(name);
        }
        return this.symbols.symbolify(Types.nameToType(name));
    }

    public static ByteSequence nameToType(ByteSequence name) {
        byte[] bytes = new byte[name.length() + 2];
        name.writeTo(bytes, 1);
        bytes[0] = 76;
        bytes[bytes.length - 1] = 59;
        ByteSequence wrap = ByteSequence.wrap(bytes);
        assert (Types.checkType(wrap) != null) : "Type validity should have been checked beforehand";
        return wrap;
    }

    public Symbol<Symbol.Type> lookup(String type) {
        return this.symbols.lookup(Types.checkType(type));
    }

    public Symbol<Symbol.Type> lookup(ByteSequence type) {
        return this.symbols.lookup(type);
    }

    public static ByteSequence getRuntimePackage(ByteSequence symbol) {
        if (symbol.byteAt(0) == 91) {
            int arrayDimensions = Types.getArrayDimensions(symbol);
            return Types.getRuntimePackage(symbol.subSequence(arrayDimensions, symbol.length() - arrayDimensions));
        }
        if (symbol.byteAt(0) != 76) {
            assert (Types.isPrimitive(symbol));
            return ByteSequence.EMPTY;
        }
        int lastSlash = symbol.lastIndexOf((byte)47);
        if (lastSlash < 0) {
            return ByteSequence.EMPTY;
        }
        return symbol.subSequence(1, lastSlash - 1);
    }

    public static int slotCount(Symbol<Symbol.Type> type) {
        switch (type.byteAt(0)) {
            case 86: {
                return 0;
            }
            case 68: 
            case 74: {
                return 2;
            }
        }
        return 1;
    }
}

