/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile.descriptors;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.classfile.constantpool.Utf8Constant;
import com.oracle.truffle.espresso.classfile.descriptors.ByteSequence;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.classfile.descriptors.Symbols;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public final class Utf8ConstantTable {
    private final Symbols symbols;
    private final ConcurrentHashMap<Symbol<?>, Utf8Constant> cache = new ConcurrentHashMap();

    public Utf8ConstantTable(Symbols symbols) {
        this.symbols = symbols;
    }

    @CompilerDirectives.TruffleBoundary
    public Utf8Constant getOrCreate(ByteSequence bytes) {
        return this.cache.computeIfAbsent(this.symbols.symbolify(bytes), new Function<Symbol<?>, Utf8Constant>(){

            @Override
            public Utf8Constant apply(Symbol<?> value) {
                return new Utf8Constant(value);
            }
        });
    }
}

