/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile.perf;

import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.espresso.classfile.perf.DebugCloseable;
import com.oracle.truffle.espresso.classfile.perf.DebugTimer;
import com.oracle.truffle.espresso.classfile.perf.TimerCollection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

class TimerCollectionImpl
extends TimerCollection {
    private Map<DebugTimer, DebugTimer.DebugTimerImpl> mapping = new ConcurrentHashMap<DebugTimer, DebugTimer.DebugTimerImpl>();

    TimerCollectionImpl() {
    }

    @Override
    DebugCloseable scope(DebugTimer timer) {
        DebugTimer.DebugTimerImpl created;
        DebugTimer.DebugTimerImpl impl = this.mapping.get(timer);
        if (impl == null && (impl = this.mapping.putIfAbsent(timer, created = DebugTimer.spawn())) == null) {
            impl = created;
        }
        impl.enter();
        return DebugTimer.AutoTimer.scope(impl);
    }

    @Override
    public void report(TruffleLogger logger) {
        HashSet<DebugTimer> visited = new HashSet<DebugTimer>();
        this.report(this.mapping.keySet(), logger, visited, "");
    }

    private void report(Iterable<DebugTimer> timers, TruffleLogger logger, Set<DebugTimer> visited, String prefix) {
        for (DebugTimer timer : timers) {
            if (!TimerCollectionImpl.shouldProcess(visited, timer)) continue;
            visited.add(timer);
            this.mapping.get(timer).report(logger, prefix + timer.name);
            if (timer.children() == null) continue;
            this.report(timer.children(), logger, visited, prefix + "    ");
        }
    }

    private static boolean shouldProcess(Set<DebugTimer> visited, DebugTimer timer) {
        if (visited.contains(timer)) {
            return false;
        }
        if (timer.parent() == null) {
            return true;
        }
        return visited.contains(timer.parent());
    }

    static final class NoTimer
    extends TimerCollection {
        NoTimer() {
        }

        @Override
        DebugCloseable scope(DebugTimer timer) {
            return DebugTimer.AutoTimer.NO_TIMER;
        }

        @Override
        public void report(TruffleLogger logger) {
        }
    }
}

