/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.constantpool;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

public final class CallSiteLink {
    private final Method method;
    private final int bci;
    final StaticObject memberName;
    final StaticObject unboxedAppendix;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    final Symbol<Symbol.Type>[] parsedSignature;

    public CallSiteLink(Method method, int bci, StaticObject memberName, StaticObject unboxedAppendix, Symbol<Symbol.Type>[] parsedSignature) {
        this.method = method;
        this.bci = bci;
        this.memberName = memberName;
        this.unboxedAppendix = unboxedAppendix;
        this.parsedSignature = parsedSignature;
    }

    public StaticObject getMemberName() {
        return this.memberName;
    }

    public StaticObject getUnboxedAppendix() {
        return this.unboxedAppendix;
    }

    public Symbol<Symbol.Type>[] getParsedSignature() {
        return this.parsedSignature;
    }

    public boolean matchesCallSite(Method siteMethod, int siteBci) {
        return this.bci == siteBci && this.method == siteMethod;
    }
}

